# Copyright 2024 B3711
#
# This program is free software; you can redistribute it and/or modify it
# under the terms and conditions of the GNU General Public License,
# version 2, as published by the Free Software Foundation.
#
# This program is distributed in the hope it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import re

timing_schemas = {
    "T1": {
        "18": "0", "17": "1", "16": "2", "15": "3", "14": "4", "13": "5", "12": "6", "11": "7"
    },
    "T2": {
        "18": "0", "17": "1", "16": "2", "15": "3", "14": "4", "13": "5", "12": "6", "11": "7"
    },
    "T3": {
        "42": "0", "39": "1", "36": "2", "33": "3", "32": "3", "31": "3", "30": "4", "29": "4", "28": "5",
        "27": "5", "26": "6", "25": "6", "24": "7", "23": "7", "22": "8", "21": "8", "20": "9",
        "19": "9", "18": "9", "17": "9"
    },
    "T4": {
        "0": "0", "1": "1", "2": "2", "3": "4", "4": "5", "5": "6"
    },
    "T5": {
        "0": "0", "1": "1", "2": "2", "3": "4", "4": "5", "5": "6"
    },
    "T6": {
        "0": "?", "1": "?", "2": "?", "3": "?", "4": "?", "5": "?"
    },
    "T7": {
        "0": "0", "1": "1", "2": "2", "3": "3", "4": "4", "5": "6"
    },
    "T9": {
        "0": "?", "1": "?", "2": "?", "3": "?", "4": "?", "5": "?", "6": "?"
    }
}


def sanitize_input(input_string):
    return re.sub(r'\D', '', input_string)


def convert_timing(input_string):
    input_string = input_string[:12]

    schema_keys = ["T1", "T2", "T3", "T4", "T5", "T6", "T7"]
    
    result = ""
    idx = 0
    part1 = ""
    part2 = ""
    part3 = ""


    for i in range(3):
        schema_key = schema_keys[i]
        schema = timing_schemas.get(schema_key)
        if schema:
            old_value = input_string[idx:idx + 2]
            new_value = schema.get(old_value, "")
            part1 += new_value
            idx += 2


    for i in range(3, 5):
        schema_key = schema_keys[i]
        schema = timing_schemas.get(schema_key)
        if schema:
            old_value = input_string[idx:idx + 1]
            new_value = schema.get(old_value, "")
            part2 += new_value
            idx += 1


    last_digit = input_string[-1]
    replacement_digit = timing_schemas["T9"].get(last_digit, "0")
    part2 += replacement_digit


    if idx < len(input_string) - 1:
        for i in range(5, 7):
            schema_key = schema_keys[i]
            schema = timing_schemas.get(schema_key)
            if schema:
                old_value = input_string[idx:idx + 1]
                new_value = schema.get(old_value, "")
                part3 += new_value
                idx += 1


    result = f"({part1}){part2}{part3}"
    
    return result


if __name__ == "__main__":
    input_string = input("Please enter old timings (e.g. 141429444544 or (14-14-29) 4-4-4-5-(4-4)): ")
    sanitized_string = sanitize_input(input_string)
    converted_string = convert_timing(sanitized_string)
    print(f"Converted timings: {converted_string}")
