LootData =
{
	BaseSoundPackage =
	{
		SelectionSound = "/SFX/Menu Sounds/GeneralWhooshMENU",
		ConfirmSound = "/SFX/Menu Sounds/GodBoonChoiceConfirm",
		DebugOnly = true,
	},

	BaseLoot =
	{
		UsePromptOffsetX = 75,
		UsePromptOffsetY = 44,
		GodLoot = true,
		DebugOnly = true,
		AnimOffsetZ = 80,
		TextLinesIgnoreQuests = true,
	},

	-- Zeus
	ZeusUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		BoonInfoIcon = "BoonInfoSymbolZeusIcon",
		Icon = "BoonSymbolZeus",
		DoorIcon = "BoonSymbolBaseIsometric",
		Color = { 250, 250, 215, 255 },
		LightingColor = {235, 206, 87, 255},
		LootColor = {255, 255, 64, 255},
		SubtitleColor = {1.000, 0.973, 0.733, 1.0},
		ColorGrade = "ZeusLightning",
		LootRejectionAnimation = "BoonDissipateA_Zeus",
		EventEndSound = "/SFX/ZeusBoonThunder",
		UpgradeSelectedSound = "/SFX/ZeusBoonChoice",

		RequiredMinCompletedRuns = 1,

		PriorityUpgrades = { "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRushTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
		WeaponUpgrades = { "ZeusWeaponTrait", "ZeusRushTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusSecondaryTrait","ZeusShoutTrait" },
		Traits = { "RetaliateWeaponTrait", "SuperGenerationTrait", "OnWrathDamageBuffTrait", "PerfectDashBoltTrait" },
		Consumables = { },
		LinkedUpgrades =
		{
			ZeusBonusBounceTrait =
			{
				OneOf = { "ZeusWeaponTrait", "ZeusRangedTrait"},
			},
			ZeusLightningDebuff =
			{
				PriorityChance = 0.5,
				OneOf = { "ZeusSecondaryTrait", "ZeusShoutTrait", "ZeusRushTrait", "RetaliateWeaponTrait", "ZeusWeaponTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
			},
			ZeusBoltAoETrait =
			{
				OneOf = { "ZeusSecondaryTrait", "ZeusShoutTrait", "ZeusRushTrait", "ShieldLoadAmmo_ZeusRangedTrait", },
			},
			ZeusBonusBoltTrait =
			{
				OneOf = { "ZeusSecondaryTrait", "ZeusShoutTrait", "ZeusRushTrait", "ShieldLoadAmmo_ZeusRangedTrait", },
			},
			LightningCloudTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "DionysusRangedTrait", "DionysusDefenseTrait" },
				}
			},
			AutoRetaliateTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "AresRetaliateTrait", "RetaliateWeaponTrait", "AthenaRetaliateTrait", "AphroditeRetaliateTrait", "DemeterRetaliateTrait" },
				}
			},
			AmmoBoltTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			RegeneratingCappedSuperTrait =
			{
				OneFromEachSet =
				{
					{ "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeRangedTrait", "AphroditeRushTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			ImpactBoltTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait" },
				}
			},
			ReboundingAthenaCastTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait" },
					{ "AthenaRangedTrait" },
				}
			},
			JoltDurationTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "ZeusLightningDebuff" },
				}
			},
			ZeusChargedBoltTrait =
			{
				OneOf = { "ZeusBonusBounceTrait", "ZeusBoltAoETrait", "ZeusBonusBoltTrait" },
			},
		},

		Speaker = "NPC_Zeus_01",
		Portrait = "Portrait_Zeus_Default_01",
		WrathPortrait = "Portrait_Zeus_Wrath_01",
		OverlayAnim = "ZeusOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/ZeusBoonThunder",
		FlavorTextIds =
		{
			"ZeusUpgrade_FlavorText01",
			"ZeusUpgrade_FlavorText02",
			"ZeusUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "ZeusFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidZeusRecently",
			CooldownTime = 40,

			-- Lord Zeus...
			{ Cue = "/VO/ZagreusField_0678" },
			-- Lord Uncle Zeus...
			{ Cue = "/VO/ZagreusField_0679" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ZeusRevealsLuciferAspect01", },
				Queue = "Always",

				-- I see your prideful fall down from the heavens to the flames...
				{ Cue = "/VO/ZagreusField_3580" },
			},
			[2] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[3] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			ZeusWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ReboundingAthenaCastTrait",
				{ Cue = "/VO/Zeus_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Why, look, Zagreus, here comes brave Athena, first to reach you among all my kin, in all her shrewdness. So proactive, you contacted Zagreus prior to even telling me, my dear!" },
				{ Cue = "/VO/Athena_0224",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Lord Father, would that I could settle even more such matters quickly and discreetly, so that only the most vital of them rise up to the level of your notice, sir. Though, I'm certain Zagreus and I are very grateful you have intervened." },
			},
			ZeusWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AutoRetaliateTrait",
				{ Cue = "/VO/Zeus_0126",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Nephew! By my divine authority, my oft-misunderstood son, Ares, now shall lend you a small token of his power. I'll make him helpful yet!" },
				{ Cue = "/VO/Ares_0118",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "It shall be exactly as you say, Lord Father. Your wishes are identical to mine." },
			},
			ZeusWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "RegeneratingCappedSuperTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Young man, I know you'd like to get to know the comely Aphrodite face to face, or I don't know, you can decide once you arrive at last! He can decide, isn't that right, my Lady Aphrodite, hm?" },
				{ Cue = "/VO/Aphrodite_0188",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Why, I never, Lord Zeus! That sounded rather like a crass remark, from {#DialogueItalicFormat}you{#PreviousFormat}! How shocking that the golden standard for the rest of us should have such words for {#DialogueItalicFormat}me{#PreviousFormat}!" },
			},
			ZeusWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AmmoBoltTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Now, Zagreus, once you arrive, we'll have to find for you a suitable mate, won't we? Fine young man such as yourself! Normally, there's much to choose from around here, with some exceptions, of course... such as my cunning daughter, Artemis. Willfully uninclined to take a mate, at all!" },
				{ Cue = "/VO/Artemis_0193",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Yes, Zagreus, in spite of all these perfect, chiseled prospects everywhere about, yearning to marry or embarrass me, for some reason, I prefer to spend my time mostly alone or with my nymph friends in the woods!" },
			},
			ZeusWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "JoltDurationTrait",
				RequiredFalseTextLinesLastRun = { "DemeterWithZeus01" },
				{ Cue = "/VO/Zeus_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Now, now, young man, whatever you have heard about good Demeter, I'm here to clear the air. She's like a sister to me, yes, but only thus. Although her Titan parents and my own met the same fate." },
				{ Cue = "/VO/Demeter_0150",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Why, Foster-Brother Zeus! Such an unlikely bit of candor there, from you! Almost as though you felt compelled to speak the truth only whilst I'm directly within earshot." },
			},

		},

		SuperPriorityPickupTextLineSets =
		{
			ZeusAboutLuciferAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusRevealsLuciferAspect01" },
				RequiredFalseTextLines = { "ZeusRevealsLuciferAspect02" },
 				RequiredFalseTraits = { "GunLoadedGrenadeTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_2653" },

				{ Cue = "/VO/Zeus_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Have you encountered Exagryph and said to it the waking-phrase I gave to you, young man? Why, I'd tell Exagryph myself! Remember, it's {#DialogueItalicFormat}I see your prideful fall down from the heavens to the flames{#PreviousFormat}." },
			},
			ZeusAboutLuciferAspect02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusRevealsLuciferAspect01" },
				RequiredWeapon = "GunWeapon",
				RequiredTrait = "GunLoadedGrenadeTrait",

				{ Cue = "/VO/Zeus_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now that is an entirely unusual design, even for Exagryph! So then the waking-phrase has worked. That aspect's bearer, Lucifer, was it? Struck his own lord father! Tried to, anyway. A not uncommon story it would seem." },
			},

			ZeusAboutPersephone01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutDemeter02", "DemeterAboutPersephone03", "ZeusGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true, FontSize = 26,
					Text = "Poor Demeter, young man. We still wonder what became of her fair daughter. Ran away with mortals, there, perhaps? Some of the tales, even more preposterous. Don't go believing everything you hear, and do be sensitive about the subject, hm? Demeter, she's been through quite enough." },
			},
			ZeusAboutPersephone02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutPersephone01", "DemeterAboutPersephone04" },
				RequiredAnyTextLines = { "PersephoneMeeting05_A", "PersephoneMeeting05_B" },
				RequiredFalseTextLinesLastRun = { "ZeusAboutPersephone01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "The Lady Demeter still prattles on about her missing girl, Zagreus. But I want you to understand something, all right? She's gone. We all have grieved. Perhaps Demeter shall finally accept what has occurred, and we can move forward, having grown stronger as a family." },
			},

			ZeusAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4336", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.63 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Sure hope this works.... In the name of Hades! Olympus, this is an official message! For you, in all your splendor, Lord Uncle Zeus." },
				{ Cue = "/VO/Zeus_0219",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "My, what is this you have for me, young man? Appears to be a message of some sort, bearing my thunder sigil! Though, there's one for everybody on Olympus? Have they as yet received their own? I must know what it says... it's from your father, who else could it be? I'd better check on this!" },
			},
			ZeusAboutOlympianReunionQuest02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusAboutOlympianReunionQuest01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I eagerly await learning some more about the contents of that fascinating message you had sent up here, Nephew! How mysterious, indeed. I'll be keeping an eye on all the others that come in!" },
			},
			ZeusPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true, FontSize = 26,
					Text = "I have to tell you, Zagreus, that it was wonderful to meet with you, at last! We were so pleased to learn Persephone was safe! And Nyx, why, she's as stunning as they say. Shouldn't have lied to us about your parentage, but, I know things get complicated, here, and that what's done is done!" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			ZeusAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Zeus_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poseidon sought you out already, hm? My boastful brother gets on with Lord Hades even worse than I, so let me put a little spark into his storms for you!" },
			},
			ZeusAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Zeus_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My brave daughter Athena beat me to you this time, has she? No matter, with her blessing and my own, you shall be nigh unstoppable!" },
			},
			ZeusAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Zeus_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Has lovely Aphrodite put you in a trance already, Zagreus? Or might I offer you the blessing of Olympus to intensify her catastrophic power with my own?" },
			},
			ZeusAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Zeus_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So my elusive Artemis has shown you favor, has she? The little scamp, she seldom shows respect to anyone, not even me! But I'll enhance her blessing nonetheless." },
			},
			ZeusAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "AresGift01" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Zeus_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Getting along with Ares, are you, Nephew? {#DialogueItalicFormat}Heh{#PreviousFormat}. Would that you were my son instead of he, but no, I jest, I jest! Here, take my blessing, please!" },
			},
			ZeusAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Zeus_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It pleases me to know, young man, that you and Dionysus have been getting on so well. He could use a level-headed friend, and you could use my blessing!" },
			},
			ZeusAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "HermesGift01" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Zeus_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hmm, you've traveled rather quickly to this point... which reminds me, I've not seen swift Hermes anywhere of late! The rascal's likely dallying about!" },
			},

			ZeusAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 3 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, I have somewhat of a favor I must ask. You tell your father, if you so happen to run into him again, that his brother Zeus forgives him, and would like to reconnect, and welcome him into the family again. You tell him for me, hm?" },
			},

			ZeusAboutDemeter03 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/Zeus_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I gather Lady Demeter's already got her frigid hold on you, certainly not the warmest member of the clan, now, is she? But do be patient with her, she's been through a lot." },
			},
			ZeusAboutDemeter01 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutDemeter03" },
				RequiredAnyTextLines = { "DemeterAboutZeus01", "DemeterAboutZeus02", "DemeterAboutFather01" },
				{ Cue = "/VO/Zeus_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My good sister Demeter already tried to poison you against me, as I understand, young man? Oh, {#DialogueItalicFormat}foster{#PreviousFormat}-sister she prefers I say, loath as she is to accept her role as part of our great family." },
			},
			ZeusAboutDemeter02 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutDemeter01", "DemeterAboutPersephone02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true, FontSize = 26,
					Text = "You must forgive the Lady Demeter her scornfulness, Nephew, for she is still recovering after the sudden disappearance of her daughter, though it was quite some time ago the girl, {#DialogueItalicFormat}poof{#PreviousFormat}! Just vanished. I try to lighten up the mood around it every now and then, but {#DialogueItalicFormat}no{#PreviousFormat}, a sore spot, still!" },
			},

			ZeusBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "Flashback_Mother_01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So you are son to Hades by that Nyx, the night-goddess, is that correct, Nephew...? Well I suppose she's closest to a queen as your lord father's like to find down there. I tried to match him up with some more wholesome types, but no, and here we are." },
			},
			ZeusBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusBackstory01", },

				{ Cue = "/VO/Zeus_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "After we learned about your plight and your existence from the goddess Nyx, all of us on Olympus rallied to assist you just as best we could. A family such as mine protects its own!" },
			},
			ZeusBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "ZeusGift01", "PoseidonGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				{ Cue = "/VO/Zeus_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My brothers Hades and Poseidon once fought bravely by my side, you know that, don't you, Nephew? We prevailed against the Titans and established law upon the earth. Your father then descended to the land of death, and we've not seen much of each other since." },
			},
			ZeusBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "ZeusGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 7 },
				{ Cue = "/VO/Zeus_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father must have told you that his governance over the Underworld is due more to the weaving of the Fates than by his choice. Admittedly, he got the short end of the stick. Whereas Poseidon and myself, why, we've been doing rather well indeed." },
			},
			ZeusBackstory05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "ZeusGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 4 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My brother Hades always was a lonesome man, you know. I pitied him! But I could never quite extract him from his thorny shell. Now he stews resentfully down there. You needn't bear the brunt of his frustrations." },
			},
			ZeusBackstory06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredMinRunsCleared = 1,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Old Hades has continued to ignore my every effort to reach out to him, young man. Ah well, but he is obstinate, indeed. You are wise to seek your family's better half." },
			},

			ZeusAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusBackstory01", "ZeusGift03" },
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "By the way, Nephew, I hear-tell your mother Nyx is quite the catch! If you'll forgive my saying so, of course. Your father's never had much of a sensibility around companionship, though perhaps this concubine of his brought something out in him, at last!" },
			},

			ZeusRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredAnyRoomsLastRun = { "B_Boss01", "B_Boss02" },
				{ Cue = "/VO/Zeus_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If and when you reach the surface, Zagreus, you call upon me then and there, all right? I'll personally see to it that you'll be escorted up to Olympus, and your quest shall be complete!" },
			},
			ZeusRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift01" },
				RequiredSeenRooms = { "C_Boss01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know just how much you must want out of there, young man. And I want that as well! {#DialogueItalicFormat}Heh{#PreviousFormat}. Good thing for you, as I get what I want around here. Ask anybody!" },
			},

			ZeusHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Zeus_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You fight your father's legions with Varatha, the Eternal Spear? The irony must not escape him, for he long ago stood by my side against the Titans, with that thing in hand!" },
			},
			ZeusHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Zeus_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It seems the bow called Coronacht is safe and sound there in your hands, young man. I've not seen that old thing in quite some time!" },
			},
			ZeusHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLines = { "ZeusAboutZeusAspect01" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "ShieldWeapon",

				{ Cue = "/VO/Zeus_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That shield of yours, called Aegis, why, in fact, it's mine from long ago, young man! I've no more need of it, of course, though how you found it, you shall have to tell me once you're here!" },
			},
			ZeusHasWeapon04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",

				{ Cue = "/VO/Zeus_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, if it isn't the one and only Rail of Adamant in your possession, there! To strike one's enemies from afar is really the only way, I think, and it's about as good a substitute for lightning bolts as you're likely to find!" },
			},
			ZeusHasWeapon05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Zeus_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, isn't that Malphon the Twin Fists there in your possession, Zagreus? Last god I saw bedecked in those old gloves was Demeter herself, oh, way back when! She was a real fighter at the time, not just a naysayer!" },
			},

			ZeusAboutZeusAspect01 =
			{
				Priority = true,
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "ZeusHasWeapon03" },
				RequiredTrait = "ShieldTwoShieldTrait",
				RequiredWeapon = "ShieldWeapon",

				{ Cue = "/VO/Zeus_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, now that's the Aegis that I know and love! Or {#DialogueItalicFormat}used {#PreviousFormat}to love, at least, the dear old thing! Now I quite love these shocking bolts of mine. Though I am proud you've given Aegis a good home, and bear it in my name!" },
			},
			ZeusRevealsLuciferAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusHasWeapon04", "AchillesRevealsGuanYuAspect01" },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "GunWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				{ Cue = "/VO/Zeus_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hark, young man, for I've a vision I must share with you! A waking-phrase for Exagryph, to be precise. Please beseech the weapon thus: {#DialogueItalicFormat}I see your prideful fall down from the heavens to the flames. {#PreviousFormat}An odd connection to a past or future bearer, apparently one who defied a god!" },
			},

			ZeusRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "AthenaRunCleared01", "PoseidonRunCleared01", "ArtemisRunCleared01", "AphroditeRunCleared01", "AresRunCleared01", "DionysusRunCleared01", "DemeterRunCleared01", "HermesRunCleared01" }, Count = 2 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Zeus_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, I wanted to mention, it was odd how by every account you'd come quite close to breaking free from there at last, of late... only to be abruptly cut off from our contact! I suppose having suffered some ill fate? Perhaps your realm's guardian, Cerberus, is even deadlier than reputed!" },
			},

			ZeusPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusPostEpilogue01", "ZeusGift01" },
				{ Cue = "/VO/Zeus_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your dear mother Persephone is a shrewd woman, Zagreus. More than an equal to your mighty father! I'm pleased to know you've made amends with her, and taken new responsibilities within your House! Naturally, I'll continue to pitch in. And, I hope that we'll meet again, someday!" },
			},
			ZeusPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusPostEpilogue02", "ZeusGift03" },
				{ Cue = "/VO/Zeus_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I must say, Nephew! Although it pleases me that we, here, reconnected with your father's realm... just between us, it pleases me even more that you are able to keep sticking it to him! You keep that up, all right?" },
			},
			ZeusPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "ZeusGift07", "PersephoneGift09", "HadesGift05" },
				{ Cue = "/VO/Zeus_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus, you have a clever mother in Persephone! A very clever mother. And a lordly father! They make quite the team, that's evident! True rivals for Hera and me!" },
			},

			ZeusHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift03" },
				{ Cue = "/VO/Zeus_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The lord and ruler of Olympus and the world, why, he needs a healthy sense of humor, no, young man? Now there's an awful lot of spoil-sports out here, can't take even a little joke, well, I know all their mothers, fie on all of them, I say! Let's joke away!" },
			},
			ZeusAboutRumors01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutRumors01", "ZeusWithDemeter01", "ZeusGift02" },		
				RequiredMinAnyTextLines = { TextLines = { "PoseidonAboutZeus01", "AthenaAboutZeus01", "AphroditeAboutZeus01", "AresAboutZeus01", "ArtemisAboutZeus01", "DionysusAboutZeus01", "DemeterAboutZeus01", "DemeterAboutZeus02", "HermesAboutZeus01", "ChaosAboutZeus01" }, Count = 4 },
				{ Cue = "/VO/Zeus_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I suppose even down in the Underworld, you would have heard such tales of me, young man. They're all untrue, {#DialogueItalicFormat}hahaha{#PreviousFormat}! Except the tales of my bravery. Those are completely accurate, though all too modest, in most cases, I must say." },
			},

			ZeusAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceZeusBoonTrait",
				{ Cue = "/VO/Zeus_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, must be my gleaming Thunder Signet that I transfered to you! Why, I could feel its call from all the way up here!" },
			},

			ZeusLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Zeus_0075",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why you look positively dreadful, Zagreus. That place is doing you no favors, I can tell! Luckily, I'll do you favors aplenty!" },
			},
			ZeusLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Zeus_0076",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You seem in dire need of some assistance, Nephew. So, of course, I dropped what I was doing and then sought you out as quickly as I could!" },
			},
			ZeusLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Zeus_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus, you must have left most of your lifeblood back the other way, {#DialogueItalicFormat}hahahaha{#PreviousFormat}! Oh, I jest, I jest! But you look {#DialogueItalicFormat}terrible{#PreviousFormat}." },
			},
			ZeusLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Zeus_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, no one likes to die, young man! But since you seem about to any moment now, you keep your head held high, do you hear me?" },
			},
			ZeusLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Zeus_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, let's face it, Zagreus, you are as good as dead right now. But you'll just slosh right back out of the River Styx, and give it a good try again, won't you?" },
			},
			ZeusLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Zeus_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remember, young man, dying is for mortals. So don't go making a habit of it, there! But if you have to do it, do it fighting, like a {#DialogueItalicFormat}hero {#PreviousFormat}would!" },
			},

			ZeusLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Zeus_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I wonder, Nephew, whether you're prepared as yet to harness the surpassing power I shall grant you now? Don't take this blessing lightly, and may you use it well." },
			},
			ZeusLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Zeus_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How about, young man, we cease with all the trifling down there and cause a real storm for once? Take now the fiercest of my powers, and you show your no-good father what you're made of!" },
			},
		},

		PickupTextLineSets =
		{
			ZeusFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0776", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.05 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Is this really him? OK. In the name of Hades! Olympus! I accept this message." },
				{ Cue = "/VO/Zeus_0133",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Greetings there, young man! Look, your father's always been rather difficult, and he's not so much as called in quite some time. You'll have a better home where you belong, here on Olympus! And to help you on your journey, have my blessing." },
			},
			ZeusMiscPickup01 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We meet again, young man! Yours isn't my affair, I know, and yet I cannot help but take an interest in your plight. Your father cast his lot; he need not take his anger out on you." },
			},
			ZeusMiscPickup02 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hello, young man, and might I offer you a little taste of the heavens themselves? Though, don't go telling your old sulky father I've been spoiling you rotten!" },
			},
			ZeusMiscPickup03 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I and all of us upon Olympus are anticipating your success, dear Nephew! Now let me see if I can't help spur you along." },
			},
			ZeusMiscPickup04 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, my nephew, you're admittedly in quite a bind down there, but what is life without its struggles, hm? You'll make it here, eventually, I'm certain." },
			},
			ZeusMiscPickup05 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I like the fire in you, Zagreus, and I have every confidence you'll someday clamber from the shadows there into the light!" },
			},
			ZeusMiscPickup06 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here on Olympus, Nephew, we take care of one another and support each other, quite unlike how it must be there in your father's grim domain. No wonder you intend to leave!" },
			},
			ZeusMiscPickup07 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd ask you offer my respects to your lord father, Zagreus, but I suspect you won't have such a chance anytime soon, considering how far you'll come with my support!" },
			},
			ZeusMiscPickup08 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remember you've as many chances as it takes, young man, to fight your way out of the dark and join us in the splendor of Olympus!" },
			},
			ZeusMiscPickup09 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your grim-faced father's such a spoilsport, Nephew, the way he keeps impeding your escape. Ah, well, just keep at it, hm?" },
			},
			ZeusMiscPickup10 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My greetings, young Nephew, and more importantly, my blessing and my strength be with you as you journey towards your rightful home." },
			},
			ZeusMiscPickup11 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Faith and courage, Zagreus, for each and every one of us upon Olympus is behind you all the way throughout this whole affair." },
			},
			ZeusMiscPickup12 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What can I say, young man? You may not make your father very proud, but it is just the opposite with me! Now go, get out of there!" },
			},
			ZeusMiscPickup13 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, Nephew, how about we put both of our backs into this one, and see to it that you go farther through those depths than you have ever managed yet!" },
			},
			ZeusMiscPickup14 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Know that many mortals ask me for my blessings constantly, and I mean all the time, young Nephew, but for you! You needn't ask at all!" },
			},
			ZeusMiscPickup15 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Far be it from me to raise my hand against your father, dear Nephew! Although I do suppose old Hades has it coming, doesn't he." },
			},
			ZeusMiscPickup16 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've every confidence in you, young man! Now you remember that, and take my blessing here, and fight your way on out of there for me!" },
			},
			ZeusMiscPickup17 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, I want you to go and show that surly Hades everything you're made of! And, I've arranged for you a little bit of help along the way!" },
			},
			ZeusMiscPickup18 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 8 },				
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How is old Hades doing, anyway, Nephew? I suspect he's every bit as prickly as ever, whereas you are nothing of the sort!" },
			},
			ZeusMiscPickup19 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I eagerly anticipate getting to meet you face-to-face someday, dear Nephew, just as soon as you can up and out of there!" },
			},
			ZeusMiscPickup20 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good Nephew, I return once more to lend to you my power! I'd like to see your discontented father try and stop you now!" },
			},
			ZeusMiscPickup21 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It is my solemn wish, dear Zagreus, that eventually we settle up our differences with your lord father. But for now, we fight!" },
			},
			ZeusMiscPickup22 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hail, my most honorable, beloved nephew, and I bring to you the blessing of Olympus, so that you might finally get out of there, already!" },
			},
			ZeusMiscPickup23 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I just know you'll reach the surface here eventually, Zagreus! And I look forward to our meeting when you do!" },
			},
			ZeusMiscPickup24 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We'll keep you safe here from your father, Zagreus! But while you're still inside that Underworld, there's only so much we can do." },
			},
			ZeusMiscPickup25 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've a good head on your shoulders, Zagreus, so stay positive, stay healthy, and let nothing stand between you and your goal!" },
			},
			ZeusMiscPickup26 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I wish you well in your continued quest, and offer my sincerest blessings, and of course my power, there, Nephew!" },
			},
			ZeusMiscPickup27 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've seen the sheer destructive power of the heavens! Just imagine what it's like above the surface of the earth!" },
			},
			ZeusMiscPickup28 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Someday when we'll be resting easy on these heights, why, we'll look back at this and laugh, I'm sure of it!" },
			},
			-- relationship improved
			ZeusMiscPickupExtra01 =
			{
				RequiredTextLines = { "ZeusGift01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, but if it isn't my most favored nephew! Striving always toward the surface of my world. Your father cannot possibly believe he can contain you, can he?" },
			},

			-- shorter acknowledgments
			ZeusMiscPickup23 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0002",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You have my blessing now as ever there, young man." },
			},
			ZeusMiscPickup24 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust you shall be getting out of there in due course, Nephew." },
			},
			ZeusMiscPickup25 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall be watching over you, young man, though it is dark down there!" },
			},
			ZeusMiscPickup26 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "May the might of Olympus guide you through the shadows, Nephew." },
			},
			ZeusMiscPickup27 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't let your father get to you, young man, and climb on out from there." },
			},
			ZeusMiscPickup28 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus, we won't be giving up on you, so you keep at it, hm?" },
			},
			ZeusMiscPickup29 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall make the heavens themselves now aid your ascent, Nephew." },
			},
			ZeusMiscPickup30 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'll watch yourself down there, won't you, young man?" },
			},
			ZeusMiscPickup31 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All of us, we're here for you, young man!" },
			},
			ZeusMiscPickup32 =
			{
				Priority = true,
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Please do be careful not to make your situation any worse, Nephew!" },
			},
			ZeusMiscPickup33 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm here for you, young man, so you take heart, and more than that, take {#DialogueItalicFormat}this{#PreviousFormat}!" },
			},
			ZeusMiscPickup34 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "ZeusGift04" },
				{ Cue = "/VO/Zeus_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All of us believe in you, though certainly no one so much as I!" },
			},
			ZeusMiscPickup35 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here's something I can do to help, young man!" },
			},
			ZeusMiscPickup36 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMinRunsCleared = 1,
				{ Cue = "/VO/Zeus_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You just take all the time you need in terms of fighting your way out of there, young man!" },
			},
			ZeusMiscPickup37 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, don't lose heart, young man, and we'll keep at it with you here, as well!" },
			},
			ZeusMiscPickup38 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "As my kin, you are a born fighter, Zagreus! So put your back into it, and you climb right up!" },
			},
			ZeusMiscPickup39 =
			{
				Priority = true,
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It shall be glorious, indeed, the day you finally burst from that oppressive den into the light!" },
			},
			ZeusMiscPickup40 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know you have it in you to surpass your father, Zagreus. Assuming you are anything like me!" },
			},

			ZeusMiscPickupPostEpilogue01 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Zeus_0226",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How fares your lovely mother? Things still good with her and Hades, hm?" },
			},
			ZeusMiscPickupPostEpilogue02 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You tell your good lord father that his brother Zeus shall be always watching over you!" },
			},
			ZeusMiscPickupPostEpilogue03 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0228",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust your good lord father's treating you all right?" },
			},
			ZeusMiscPickupPostEpilogue04 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know you're busy, Zagreus, though someday you shall have to visit us!" },
			},
			ZeusMiscPickupPostEpilogue05 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0230",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm never quite so busy that I can't make time for family, young man!" },
			},
			ZeusMiscPickupPostEpilogue06 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We're all in this together, aren't we, Nephew?" },
			},
		},

		BoughtTextLines =
		{
			ZeusLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I see the boatman of the Underworld has found the means to reach you with my blessing, Nephew. Such strange alliances we forge these days!" },
			},
			ZeusLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why here I am, young man, in such strange circumstances I might add! Luckily the boatman Charon is much easier to get ahold of than your father!" },
			},
			ZeusLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, so then the boatman Charon came through for us after all, did he? Whatever means we have to reach you, we'll employ!" },
			},
			ZeusLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your Charon there must drive quite a hard bargain, Zagreus, if he would keep you from your victory just for a bit of coin!" },
			},
			ZeusLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I thought that ferryman would be content to transfer souls across the River Styx, not rob you on your journey to the surface, there, Nephew!" },
			},
		},

		RejectionTextLines =
		{
			ZeusRejection01 =
			{
				{ Cue = "/VO/Zeus_0051",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "My blessing isn't good enough for you, is that the way of it, young man? How impetuous of you. {#DialogueItalicFormat}Oh{#PreviousFormat}, I never!" },
			},
			ZeusRejection02 =
			{
				{ Cue = "/VO/Zeus_0052",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It isn't wise to go against me, Nephew, both in matters large and small. I am not known for being charitable to the insolent." },
			},
			ZeusRejection03 =
			{
				{ Cue = "/VO/Zeus_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps you have defied me here in jest, young man. Though in such cases pertinent to my authority, you'll find I lack a sense of humor." },
			},
			ZeusRejection04 =
			{
				{ Cue = "/VO/Zeus_0054",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Audacity runs in our family, Zagreus, but my advice to you is that you keep it carefully suppressed in your relationship with me." },
			},
			ZeusRejection05 =
			{
				{ Cue = "/VO/Zeus_0055",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What have I done, good Nephew, to deserve such scorn? Your lapse in judgment here is not so easy to forgive, yet easily punished." },
			},
			ZeusRejection06 =
			{
				{ Cue = "/VO/Zeus_0056",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father likewise turned his back on me before, Nephew, and we both know what has become of him. I'd caution you against this." },
			},
			ZeusRejection07 =
			{
				RequiredTextLines = { "ZeusRejection01", "ZeusRejection02", "ZeusRejection03" },
				{ Cue = "/VO/Zeus_0134",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Apparently, the consequences of displeasing me have slipped your mind, young man. A harsh reminder is in order, then." },
			},
			ZeusRejection08 =
			{
				{ Cue = "/VO/Zeus_0135",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "I did not restore order to this world, and claim the heavens for myself, only to be insulted by my own nephew!" },
			},
			ZeusRejection09 =
			{
				{ Cue = "/VO/Zeus_0136",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Why, Nephew, is this all some sort of jest to you? It isn't one that I appreciate!" },
			},
			ZeusRejection10 =
			{
				{ Cue = "/VO/Zeus_0137",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, when presented with a choice to side against me or not to be such a fool, do be sure to choose the latter next time, hm?" },
			},
			ZeusRejection11 =
			{
				{ Cue = "/VO/Zeus_0138",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't say I didn't warn you, young man! I only wish that I could say you didn't insult me!" },
			},
			ZeusRejection12 =
			{
				{ Cue = "/VO/Zeus_0139",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "This is outrageous, Zagreus! Even your father would agree that actions such as that can't go unpunished." },
			},
			ZeusRejection13 =
			{
				{ Cue = "/VO/Zeus_0140",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Young man, I don't know why you would do this to me, though I trust you're going to think twice, next time!" },
			},
			ZeusRejection14 =
			{
				{ Cue = "/VO/Zeus_0141",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You overstep your bounds with me, Nephew! But I shall make you fall right back in line." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Sorry, Lord Zeus.
				{ Cue = "/VO/ZagreusField_0164" },
				-- Apologies, Lord Zeus.
				{ Cue = "/VO/ZagreusField_4131" },
				-- Forgive me, Uncle.
				{ Cue = "/VO/ZagreusField_4132" },
				-- Hate to do this, Uncle.
				{ Cue = "/VO/ZagreusField_4133" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			ZeusMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, very well, good show, young man! And I think I shall let you off the hook, and take you back under my wing, for now." },
			},
			ZeusMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Commendable of you to live through that, and I suspect you shall think twice next time before so brazenly defying me, won't you?" },
			},
			ZeusMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, now, no need to hold such grudges any longer I suppose, but you just mind yourself around your Uncle Zeus." },
			},
			ZeusMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do not spurn me again like that, do you hear me, young man? I think you do, so let's put this to bed and move along." },
			},
			ZeusMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh Nephew, but I simply can't stay wrathful toward you, much as I might try! Though, better not to tempt me, just in case." },
			},
			ZeusMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, all right, let's call the score between us settled up for now. Just don't go spurning me again, you understand?" },
			},
			ZeusMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, this is becoming unproductive, Zagreus. As you were!" },
			},
			ZeusMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, I don't have the heart to keep exacting vengeance on you, Nephew." },
			},
			ZeusMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I say, such petty squabbles. Aren't we better than this, Zagreus?" },
			},
			ZeusMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, young man, I'd say it's best we put this little slight behind us, wouldn't you?" },
			},
			ZeusMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Pah{#PreviousFormat}! All is forgiven and forgotten, Zagreus. What were we even going on about back there?" },
			},
			ZeusMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, that is quite enough, that's quite enough, I say! You're still alive, aren't you?" },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			ZeusGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0121", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Zeus, erm, Uncle, please, accept this offering, and all my gratitude." },
				{ Cue = "/VO/Zeus_0068",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Goodness, Nephew, that's an offering, indeed! I'm thankful for your piety to me, and as a show of generosity to you, in turn, I present this!" },
			},
			ZeusGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift01", },
				{ Cue = "/VO/ZagreusHome_0527", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I thank you, my Lord Uncle Zeus, for your benevolence and your thunderous might." },
				{ Cue = "/VO/Zeus_0063",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You honor me, young man, as well you should, for I am ruler of Olympus, am I not? Such courtesies are shown me constantly, yet I appreciate them all." },
			},
			ZeusGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift02", },
				{ Cue = "/VO/ZagreusHome_0528", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Zeus, I bid you please accept my humble offering, for all you've done for me." },
				{ Cue = "/VO/Zeus_0064",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, that is rather generous of you, and I'm grateful for it, Nephew! How good of you to make attempts at reciprocity!" },
			},
			ZeusGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift03", },
				{ Cue = "/VO/ZagreusHome_0529", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "This offering is but a trifle, Uncle Zeus, for all your magnanimity." },
				{ Cue = "/VO/Zeus_0065",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So fine a gift again, my dear Nephew? Would that my sons and daughters on Olympus here would show me such respect from time to time!" },
			},
			ZeusGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift04", },
				{ Cue = "/VO/ZagreusField_3434", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Please, Lord Uncle Zeus, accept this gift of Nectar in your honor, though it is such a pittance in comparison to all the generosity you've shown." },
				{ Cue = "/VO/Zeus_0215",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm very pleased to see a show of such respect and admiration for your uncle, Zagreus. You'll go quite far here on Olympus with an attitude like that! Not everyone's as mannered, nor as wise." },
			},
			-- post-epilogue alt below
			ZeusGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift05", },
				RequiredFalseTextLines = { "ZeusGift06_B", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/ZagreusField_3435", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "If you can hear me, mighty Uncle Zeus, I wish to make to you this simple gift, and with it send my humble wish that someday you and Father settle all your differences, and be at peace." },
				{ Cue = "/VO/Zeus_0216",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, most splendid of an offering, young man. And while we've yet to even meet in person, I already feel as though the two of us are close, why, closer than you must be even with your father! {#DialogueItalicFormat}Oh, hahaha{#PreviousFormat}! Perhaps we ought go telling everybody {#DialogueItalicFormat}I'm {#PreviousFormat}your real father, am I right?" },
			},
			ZeusGift06_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift05", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "ZeusGift06" },
				{ Cue = "/VO/ZagreusField_3435", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "If you can hear me, mighty Uncle Zeus, I wish to make to you this simple gift, and with it send my humble wish that someday you and Father settle all your differences, and be at peace." },
				{ Cue = "/VO/Zeus_0248",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, most splendid of an offering, young man. And while we've yet to even meet in person, I already feel as though the two of us are close, why, closer than you must be even with your father! {#DialogueItalicFormat}Oh, hahaha! {#PreviousFormat}Perhaps we ought go telling everybody {#DialogueItalicFormat}I'm {#PreviousFormat}your real father, am I right?" },
			},
			ZeusGift07=
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "ZeusGift06", "ZeusGift06_B" },
				{ Cue = "/VO/ZagreusField_3436", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "King of the Olympians, Lord Zeus! Forgive this offer of Ambrosia, for I know you have no limit of it there. But here, it is the finest gift that can be given, and even still it isn't anything compared to all you've done for me. Thank you, Uncle." },
				{ Cue = "/VO/Zeus_0217",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Zeus_01", Icon = "Keepsake_ZeusSticker_Max" },
					Text = "Now, now, Nephew, you are most generous, indeed, in showing all this deference to me. But we must keep some distance, shouldn't we? Lest all the others here, why, they would be most jealous if they caught me playing favorites! Even though you {#DialogueItalicFormat}are {#PreviousFormat}my favorite! Presently, at least." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- My thanks, Lord Uncle Zeus.
			{ Cue = "/VO/ZagreusHome_0322" },
		},

		ShoutActivationSound = "/SFX/ZeusWrathThunder",
		ShoutVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "ZeusUpgrade",

				-- Olympus smite you!
				{ Cue = "/VO/Zeus_0069" },
				-- It shall be so.
				{ Cue = "/VO/Zeus_0082" },
				-- That can be arranged!
				{ Cue = "/VO/Zeus_0083" },
				-- Easily achieved.
				{ Cue = "/VO/Zeus_0084" },
				-- Now is the time to strike!
				{ Cue = "/VO/Zeus_0171" },
				-- Hoh, you watch this, young man!
				{ Cue = "/VO/Zeus_0172" },
				-- I'll strike them down right now!
				{ Cue = "/VO/Zeus_0173", RequiredMinKillEnemies = 2 },
				-- I can take care of that!
				{ Cue = "/VO/Zeus_0174" },
				-- How dare you anger me!
				-- { Cue = "/VO/Zeus_0070" },
				-- I'll teach you some respect!
				-- { Cue = "/VO/Zeus_0071" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "ZeusUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Don't be a fool, young man.
				{ Cue = "/VO/Zeus_0105", RequiredPlayed = { "/VO/Zeus_0175", "/VO/Zeus_0176", "/VO/Zeus_0177", "/VO/Zeus_0178" }, },
				-- You ought know better, Nephew.
				-- { Cue = "/VO/Zeus_0106" },
				-- You truly are my brother's son.
				-- { Cue = "/VO/Zeus_0107" },
				-- How dare you, young man.
				{ Cue = "/VO/Zeus_0108", RequiredPlayed = { "/VO/Zeus_0175", "/VO/Zeus_0176", "/VO/Zeus_0177", "/VO/Zeus_0178" }, },
				-- Best not to make me angry, my nephew.
				{ Cue = "/VO/Zeus_0111", RequiredPlayed = { "/VO/Zeus_0175", "/VO/Zeus_0176", "/VO/Zeus_0177", "/VO/Zeus_0178" }, },
				-- The sheer audacity!
				{ Cue = "/VO/Zeus_0175" },
				-- I ought to strike you down!
				{ Cue = "/VO/Zeus_0176" },
				-- Have you gone daft, Nephew?!
				{ Cue = "/VO/Zeus_0177" },
				-- Now you ask my favor, Zagreus?
				{ Cue = "/VO/Zeus_0178" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidZeusRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			RequiredFalseTextLinesThisRoom = { "ZeusRevealsLuciferAspect01", },
			UsePlayerSource = true,

			-- A generous offer, Lord Uncle Zeus.
			{ Cue = "/VO/ZagreusField_1866" },
			-- I can't say no, Lord Zeus.
			{ Cue = "/VO/ZagreusField_1867" },
			-- Lord Uncle Zeus, I accept.
			{ Cue = "/VO/ZagreusField_1868" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- A swift death is a mercy of a retribution.
			{ Cue = "/VO/Zeus_0179", RequiredTextLines = { "/VO/Zeus_0180" } },
			-- I did not become ruler of Olympus by forgiving trespasses, young man.
			{ Cue = "/VO/Zeus_0180" },
			-- You can't run from heaven.
			{ Cue = "/VO/Zeus_0181", RequiredTextLines = { "/VO/Zeus_0180", "/VO/Zeus_0179" } },
			-- Struck down.
			{ Cue = "/VO/Zeus_0182", RequiredTextLines = { "/VO/Zeus_0180" } },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.ZeusVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- How do you do, young man.
			{ Cue = "/VO/Zeus_0078" },
			-- My blessings, Nephew!
			{ Cue = "/VO/Zeus_0080" },
			-- How fares my brother's son of late?
			{ Cue = "/VO/Zeus_0081" },
			-- Well I don't see why not.
			{ Cue = "/VO/Zeus_0085" },
			-- I've something for you here.
			{ Cue = "/VO/Zeus_0097" },
		},

	},

	-- Ares
	AresUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolAres",
		BoonInfoIcon = "BoonInfoSymbolAresIcon",
		DoorIcon = "BoonSymbolAresIsometric",
		Color = { 255, 0, 0, 255 },
		LightingColor = {255, 94, 73, 255},
		LootColor = {255, 20, 0, 255},
		SubtitleColor = {0.812, 0.000, 0.000, 1.0},
		EventEndSound = "/SFX/AresBoonBattle",
		UpgradeSelectedSound = "/SFX/AresBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Ares",

		PriorityUpgrades = {"AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
		WeaponUpgrades = {"AresWeaponTrait", "AresRushTrait", "AresRangedTrait", "AresSecondaryTrait" , "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
		Traits = { "AresRetaliateTrait", "IncreasedDamageTrait", "OnEnemyDeathDamageInstanceBuffTrait","LastStandDamageBonusTrait" },
		Consumables = { },

		LinkedUpgrades =
		{
			CurseSickTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				},
			},
			AresLongCurseTrait =
			{
				OneOf = { "AresWeaponTrait", "AresSecondaryTrait", "AresRetaliateTrait" },
			},
			AresLoadCurseTrait =
			{
				OneOf = { "AresWeaponTrait", "AresSecondaryTrait" },
			},
			AresAoETrait=
			{
				OneOf = { "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
			},
			AresDragTrait =
			{
				OneOf = { "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
			},
			TriggerCurseTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AthenaWeaponTrait", "AthenaRushTrait", "AthenaSecondaryTrait" },
				},
			},
			AresHomingTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
				}
			},
			AutoRetaliateTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "AresRetaliateTrait", "RetaliateWeaponTrait", "AthenaRetaliateTrait", "AphroditeRetaliateTrait", "DemeterRetaliateTrait" },
				}
			},
			StationaryRiftTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterShoutTrait" },
				}
			},
			PoisonTickRateTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
				}
			},
			AresCursedRiftTrait =
			{
				OneOf = { "AresAoETrait", "AresDragTrait" }
			},
			PoseidonAresProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresShoutTrait" },
					{ "PoseidonRangedTrait" },
				}
			},
		},

		Speaker = "NPC_Ares_01",
		Portrait = "Portrait_Ares_Default_01",
		WrathPortrait = "Portrait_Ares_Wrath_01",
		OverlayAnim = "AresOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/AresBoonBattle",
		FlavorTextIds =
		{
			"AresUpgrade_FlavorText01",
			"AresUpgrade_FlavorText02",
			"AresUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "AresFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			ThreadName = "RoomThread",

			-- Lord Ares...
			{ Cue = "/VO/ZagreusField_0688" },
			-- Hello, Lord Ares...
			{ Cue = "/VO/ZagreusField_0689" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			AresWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoseidonAresProjectileTrait",
				{ Cue = "/VO/Ares_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Well, my hellborn kin, I have to say that there are times I wish I could have been acquainted with your father somewhat more, if you'll forgive my saying so. My father and my uncle, here... they're predisposed quite differently than I." },
				{ Cue = "/VO/Poseidon_0235",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Perhaps if you were not so odd, and made more effort to be somewhat more approachable, Ares, then we'd have more in common, you and I! Should you need any tips on that, why, you just let me know!" },
			},
			AresWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "TriggerCurseTrait",
				{ Cue = "/VO/Ares_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "I wished only to speak to you in private once again, my kin, except, you see..." },
				{ Cue = "/VO/Athena_0125",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "...Except you see, dear Cousin, that some members of our family are predisposed toward the unspeakable. I caution you around my half-brother, is all. Now carry on." },
				{ Cue = "/VO/Ares_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "You interrupt me once again, dear sister. You know I do not care for that. I warn you to stay out of my affairs. I shall aid my kin as I see fit." },
				{ Cue = "/VO/Athena_0126",
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "You only do as you see fit, Lord Ares. Mind that you continue pulling in the same direction as us all." },
			},
			AresWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CurseSickTrait",
				-- RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "I so anticipate the day you finally arrive upon Olympus. There are few amongst us here with interests such as those I think we share." },
				{ Cue = "/VO/Aphrodite_0052",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Emote = "PortraitEmoteAffection",
					Text = "There are at least a few of us who share such interests here, isn't that so, Lord Ares? As for {#DialogueItalicFormat}you{#PreviousFormat}, dearest, you take all the time you need!" },
			},
			AresWithAphrodite02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CurseSickTrait",
				RequiredTextLines = { "AresWithAphrodite01" },
				{ Cue = "/VO/Ares_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Wars waged over love, my kin... can you imagine that? The lady Aphrodite and I can endlessly discuss such circumstances. I trust, from time to time, you stop to ask yourself how come you choose to fight. Not that you need a reason, of course." },
				{ Cue = "/VO/Aphrodite_0190",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Emote = "PortraitEmoteAffection",
					Text = "Oh, Lord Ares, truly there isn't the need to cloud our little godling's thoughts and judgment with such comments, is there, {#DialogueItalicFormat}hm{#PreviousFormat}? Let's give him what he wants, and we can carry on in private, about that." },
			},
			AresWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonTickRateTrait",
				{ Cue = "/VO/Ares_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ah, my kin! I was just inquiring with Lord Dionysus here, under which circumstances are the greatest mortal feasts of all prepared? Because I have a certain hunch, regarding that..." },
				{ Cue = "/VO/Dionysus_0215",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Text = "Yeah, yeah, Ares, I will hand it to you, man. There's nothing like a feast after a war, all right! Provided you're on the surviving side, that is! Otherwise I guess they'll be feasting with {#DialogueItalicFormat}you {#PreviousFormat}down there, Zag!" },
			},
			AresWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StationaryRiftTrait",
				{ Cue = "/VO/Ares_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "The cold of death is quite becoming of the Goddess Demeter, do you not think so, my death-dealing kin? She is becoming well accustomed to it, too." },
				{ Cue = "/VO/Demeter_0142",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "I think that you forget yourself, Lord Ares, sir. For I am much your elder; my famines had already slain the mortals by the tens of thousands by the time such thoughts of doing so first crossed your mind." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			AresKillQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresKillQuest01", },
				MinRunsSinceAnyTextLines = { TextLines = { "AresKillProgress01", "AresKillProgress02" }, Count = 2 },
				RequiredMinTotalKills = 10000,

				{ Cue = "/VO/Ares_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten thousand souls have fallen to you, now, my hellborn kin. I am rather beside myself, I must admit. Fine work." },
			},

			AresAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4340", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.15 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Here goes, then. In the name of Hades! Olympus, this is an official message! Lord Ares, please consider our proposal... once you're able to decipher it." },
				{ Cue = "/VO/Ares_0229",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "My, what is this, my kin? Some sort of invitation for me, I presume. Not just for me... this symbolizes all the others, here? Most intriguing. I shall investigate the meaning of this as quickly as I'm able, then. But first!" },
			},
			AresPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0230",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I wish to tell you once again I had a splendid time during our recent shared festivities, my kin. At last, I've finally seen your death-filled realm firsthand! I learned a great deal. And I look forward to learning more from our successful collaboration, hm?" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			AresAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Ares_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lord Zeus has gotten to you first, I see? My father's gifts are generous, indeed, though... I think I can help in my own way." },
			},
			AresAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Ares_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The blessing of your uncle Lord Poseidon might have helped you to this point, but here: My gift shall see you further still." },
			},
			AresAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Ares_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear the blessing of Athena, yes? She would protect you from your enemies, whilst I would rather that you slay them, and be done." },
			},
			AresAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Ares_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hm, I see you have Lady Aphrodite's blessing there already. Love and death, together, hand in hand? Sounds most agreeable to me." },
			},
			AresAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Ares_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So Artemis, my lonely half-sister, got to you first? She merely helps you hunt, whilst I shall help you kill. Observe." },
			},
			AresAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Ares_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That drunkard Dionysus cannot help you near as much as I, my hell-born kin. Compare the gift he gave to what I offer you." },
			},
			AresAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "HermesGift01", "AresGift01" },
				RequiredGodLoot = "HermesUpgrade",
				{ Cue = "/VO/Ares_0125",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Our messenger Hermes has been in contact with you by now, yes? Perhaps you shall not see him very often, for my work keeps him rather preoccupied, shepherding souls and such." },
			},
			AresAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/Ares_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I faintly sense the mark of Goddess Demeter upon you, hm? Her power over plentitude is opposite to mine in some respects. But, lately, she has channeled it in manners more agreeable to me." },
			},
			AresAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutTrait",
				{ Cue = "/VO/Ares_0233",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, you bear your own father's blessing, my kin? Such a surprise... I know the two of you are now in league, and yet... I am still quite accustomed to the thought that you harbor war-like hatred for one another. Perhaps there's still a trace of that, though, hm?" },
			},

			AresKillProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLines = { "AresKillProgress02", "AresKillQuestComplete" },
				RequiredMinTotalKills = 100,

				{ Cue = "/VO/Ares_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Did you happen to know, my kin, that you have slain more than a hundred foes since you began your quest? You have! For I am keeping count. And I am most impressed." },
			},
			AresKillProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLines = { "AresKillQuestComplete" },
				RequiredMinTotalKills = 1000,

				{ Cue = "/VO/Ares_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are a most impressive death-dealer, my kin. For by my estimation, you have slain at least a thousand souls down there! Souls mostly having died before, but still." },
			},

			AresKillQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresGift03" },
				RequiredFalseTextLinesLastRun = { "AresKillProgress02" },
				RequiredMinTotalKills = 2000,

				{ Cue = "/VO/Ares_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know that you have many aspirations, my good kin. To be plain with you about my own motive for a moment: As long as you continue bringing swift and steady death, you shall have my unyielding support." },
			},
			AresKillQuestAftermath01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresKillQuestComplete", "AresGift06" },
				RequiredFalseTextLinesLastRun = { "AresKillQuestComplete" },

				{ Cue = "/VO/Ares_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The more you slay your enemies, my kin, the stronger the bond between us, I think. Can you not feel it, too? Though, perhaps your lust for blood overpowers your other senses, hm?" },
			},

			AresAboutThanatos01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "ThanatosFirstAppearance", "ThanatosGift01", "AresGift01" },

				{ Cue = "/VO/Ares_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps you know a god called Thanatos? The two of us are very close associates, you know. Do give him my best wishes, should you see him soon." },
			},
			AresAboutThanatos02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresAboutThanatos01", "AresGift01", "ThanatosGift03" },

				{ Cue = "/VO/Ares_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust that Thanatos is doing well? Although he brings to mortals merciful release, whilst I most certainly do {#DialogueItalicFormat}no {#PreviousFormat}such thing, I do appreciate his take on it." },
			},
			AresAboutThanatos03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" }, Count = 3 },
				{ Cue = "/VO/Ares_0123",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It is my understanding that you have grown rather close with Thanatos, my kin? A perfect choice of mate; though I confess I'd not expected Death to have affection for another save himself." },
			},

			AresRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredRoomLastRun = "C_Intro",

				{ Cue = "/VO/Ares_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You traveled rather far down there since last we met, my kin. And that means you have dealt incalculable death. I must commend you thus." },
			},
			AresRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredKills = { SatyrRanged = 10, RatThug = 10, Crawler = 50 },
				RequiredRoomLastRun = "D_Hub",
				{ Cue = "/VO/Ares_0126",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, my kin, I sensed fresh bloodshed from you recently, the real kind! For you have slain the living near the surface, have you not? Mere vermin, yes, but good enough for me." },
			},

			AresRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresGift01" },
				RequiredBiome = "Asphodel",
				RequiredMinRunsCleared = 1,
				RequiresLastRunCleared = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Recently, there was a burst of violence on the surface, near to where you are, but higher up. 'Twas altogether odd, but must have forced you to return once more. No matter; time is on our side." },
			},
			AresRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinRunsCleared = 2,
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Ares_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I sense so much death at the gates of your father's realm, of late, my kin. Now, I know that seems perfectly ordinary on the face of it, except... there's something more. I wonder if {#DialogueItalicFormat}you {#PreviousFormat}know the reason why..." },
			},
			AresRunCleared03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMinRunsCleared = 3,
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Ares_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know your efforts to come here have repeatedly been thwarted, my good kin. However, we have caused such violence in the intervening time, that we must take this as a real victory. Let us continue for however long it takes." },
			},

			AresAboutWar01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresGift04" },
				{ Cue = "/VO/Ares_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Surely you've heard rumblings about a war which has erupted on the surface, here? Doubtless you've seen an influx of fallen mortals. It's quite a decent one, I have to say! Though, unlikely to rise to the ranks of the greats. Too few armies involved in it, I fear." },
			},
			AresAboutWar02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresAboutWar01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "War's such a wondrous thing, my kin. It solves so many different problems, whilst perpetuating its own inevitability. Let's keep it up, then, hm?" },
			},
			AresAboutWar03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresAboutWar02", "AresGift07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do you ever think to yourself that you were born a bit too late, my kin? For my part, I wish that I could have been there myself when my father and the others waged ferocious war against the Titans. Ah, it must have been a sight!" },
			},

			AresAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMinUnlockedWeaponEnchantments = 5,

				{ Cue = "/VO/Ares_0124",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I sense that you have forged a greater bond with your instruments of destruction there, my kin. Then that is very good. And may their altered forms serve you quite well." },
			},
			AresAboutGuanYuAspect =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon01" },
				RequiredTrait = "SpearSpinTravel",
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Ares_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, I believe that is the Frost Fair Blade you bear! I understand it shall become the instrument of choice of yet another god of war, someday. I long to meet him, this fellow student of death." },
			},
			AresAboutArthurAspect =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredTrait = "SwordConsecrationTrait",
				RequiredWeapon = "SwordWeapon",

				{ Cue = "/VO/Ares_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, that blade of yours... it looks as though it could relieve a mortal of his head with ease. Excalibur, is it? I've studied all the Fates' designs, and this one is among my favorites." },
			},
			AresAboutRamaAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon02" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowBondTrait",

				{ Cue = "/VO/Ares_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The fated bow Sharanga, in your grasp! That is a form I'd not expected you to wield. You have exquisite taste in weaponry, my kin!" },
			},
			AresAboutBeowulfAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon03" },
				RequiredWeapon = "ShieldWeapon",
 				RequiredTrait = "ShieldLoadAmmoTrait",

				{ Cue = "/VO/Ares_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Is that the fire-eating shield of the great warrior Beowulf, which you have there? I knew the Fates had plans for it, but I did not expect for you to be a part!" },
			},
			AresAboutGilgameshAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon05" },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",

				{ Cue = "/VO/Ares_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Those are the gauntlets of the fated king Gilgamesh, are they not? A bringer of destruction, and an agent of the Fates. You are full of surprises, my kin!" },
			},	
			AresAboutLuciferAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon04" },
				RequiredWeapon = "GunWeapon",
				RequiredTrait = "GunLoadedGrenadeTrait",

				{ Cue = "/VO/Ares_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear the warring instrument of one called Lucifer, I see. I've little to go on about him, but it is clear he knows a thing or two about destruction, is it not?" },
			},

			AresAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceAresBoonTrait",

				{ Cue = "/VO/Ares_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, you bear the Blood-filled Vial which I granted you! The mortal's blood contained therein... I drew it myself! Too seldom am I able to become directly involved in such matters." },
			},

			AresBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Ares_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Know that I admire your Lord Father very much. For his grim work lets me continue mine. I trust that one day you shall settle your dispute." },
			},

			AresPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "Flashback_Mother_01" },
				RequiredFalseTextLines = { "AresAboutNyx04", "AresAboutNyx04_B", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are the son of Night herself, they say? A fascinating character, ill-liked upon Olympus, although I myself have always longed to meet her." },
			},

			-- relationship improved
			AresPostGiftPickup01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, my favorite Underworld death-dealer. I so look forward to the pain you shall inflict this time around." },
			},
			AresPostGiftPickup02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift02", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Would that a sudden scourge of war would help you out of your predicament. Why, I would stir one up for you without a second thought." },
			},
			AresPostGiftPickup03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift03", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, my closest kin in all the Underworld, I see you there, I think! Which sort of violence shall we sow together this time, you and I?" },
			},
			AresPostGiftPickup04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift04", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's so much insufferable talk of peace up here, my kin. It is quite the relief to focus on much more important things, with you." },
			},
			AresPostGiftPickup05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift05", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You must know I often hunger for destruction, almost uncontrollably at that. Though I am finding you are able to sate that appetite of mine." },
			},
			AresPostGiftPickup06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "May all the death you bring become the stuff of legends told in fearful mortal whisperings around the world, my kin." },
			},

			AresAboutNyxIntro01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresGift01", "NyxGift01" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },
				{ Cue = "/VO/Ares_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Would that I knew the goddess Nyx, myself, my kin! So many of my wars are waged by night. I am most grateful, and I wish her well." },
			},
			AresAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresAboutNyxIntro01", "AresPostFlashback01", "AresGift02", "NyxGift07", "ThanatosAboutAres01" },
				RequiredFalseTextLines = { "AresAboutNyx01_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How is your mother Nyx of late, my kin? Have you yet given to her my regards? For I should think that Night and War would share a common ground." },
			},
			AresAboutNyx01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresAboutNyxIntro01", "AresPostFlashback01", "AresGift02", "NyxGift07", "ThanatosAboutAres01", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx01" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How is Nyx of late, my kin? Have you yet given to her my regards? For I should think that Night and War would share a common ground." },
			},
			AresAboutNyx02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres01", },
				RequiredFalseTextLines = { "AresAboutNyx02_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do tell your mother Night Herself that I am often thinking of her here, although we haven't met. She must believe that there are those upon Olympus who admire her." },
			},
			AresAboutNyx02_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredAnyTextLines = { "NyxAboutAres01", "NyxAboutAres01_B" },
				RequiredFalseTextLines = { "AresAboutNyx02" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0235",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do tell Night Herself that I am often thinking of her here, although we haven't met. She must believe that there are those upon Olympus who admire her." },
			},			
			AresAboutNyx03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres02", "AresGift03", "NyxGift08" },
				RequiredFalseTextLines = { "AresAboutNyx03_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps once all of this is over, my good kin, you might arrange 'twixt myself and your dark mother, Nyx, some sort of chance to meet? Do think upon it, and declare to her my interest if you please." },
			},
			AresAboutNyx03_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres02", "NyxAboutAres02_B" },
				RequiredTextLines = { "AresGift03", "NyxGift08", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx03" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0236",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps once all of this is over, my good kin, you might arrange 'twixt myself and the goddess Nyx some sort of chance to meet? Do think upon it, and declare to her my interest if you please." },
			},
			AresAboutNyx04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres03", "AresGift03", },
				RequiredFalseTextLines = { "AresAboutNyx04_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your mother Nyx and I, we have begun a correspondence, my good kin. I do appreciate you putting us in touch. She is a lovely specimen, if you don't mind my saying so, perhaps?" },
			},
			AresAboutNyx04_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres03", "AresGift03", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx04" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The goddess Nyx and I, we have begun a correspondence, my good kin. I do appreciate you putting us in touch. She is a lovely specimen, if you don't mind my saying so, perhaps?" },
			},			
			AresAboutNyx05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres04", "NyxAboutAres04_B" },
				RequiredTextLines = { "AresGift04", "NyxGift09" },
				RequiredFalseTextLines = { "AresAboutNyx05_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You shall be pleased to hear that your own mother Nyx and I, why, we intend to meet. I'm quite excited to exchange ideas in the flesh." },
			},
			AresAboutNyx05_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres04", "NyxAboutAres04_B" },
				RequiredTextLines = { "AresGift04", "NyxGift09", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx05" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You shall be pleased to hear that your own mother Nyx and I, why, we intend to meet. I'm quite excited to exchange ideas in the flesh." },
			},
			AresAboutNyx06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres05", "AresPostFlashback01", "AresGift04", },
				RequiredFalseTextLines = { "AresAboutNyx06_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Please send your mother Nyx my warm regards, won't you, my kin? Would that the others on Olympus knew and understood your kind as I now do." },
			},
			AresAboutNyx06_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres05", "NyxAboutAres05_B" },
				RequiredTextLines = { "AresPostFlashback01", "AresGift04", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx06" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0239",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Please send the goddess Nyx my warm regards, won't you, my kin? Would that the others on Olympus knew and understood your kind as I now do." },
			},

			AresPostEpilogue02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresPostEpilogue01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, my kin, I had misunderstood that Nyx was your mother. But, Persephone? I never took her for the sort to have an interest in your realm. Alas that we never had opportunity to discuss the subject here." },
			},
			AresPostEpilogue03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresPostEpilogue02", "AresGift05" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0232",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your good mother, Persephone... dread Queen of the Underworld! I certainly misjudged her when we had occasion to interact whilst she resided on Olympus. Perhaps I, too, should consider a life there in your realm..." },
			},

			AresHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "SpearWeapon",
				RequiredFalseTraits = { "SpearSpinTravel" },

				{ Cue = "/VO/Ares_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear Varatha, the Eternal Spear...! I thought it lost! Have you any idea how many lives it drank during your father's glory days?" },
			},
			AresHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "BowWeapon",
				RequiredFalseTraits = { "BowBondTrait" },

				{ Cue = "/VO/Ares_0064",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, you wield Coronacht, the Heart-Seeker. It pierced three Titans in one shot back in the war amongst our kind. Please do take care of it!" },
			},
			AresHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "ShieldWeapon",
				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },

				{ Cue = "/VO/Ares_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You have the Shield of Chaos, Aegis... quite unlike the one my good sister Athena likes to flash around. You have much better taste." },
			},
			AresHasWeapon04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",
				RequiredFalseTraits = { "GunLoadedGrenadeTrait" },

				{ Cue = "/VO/Ares_0119",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, you are wielding Exagryph, the Rail of Adamant! A most fascinating device. Imagine the new face of war, should its secrets someday be revealed, and spread to mortalkind!" },
			},
			AresHasWeapon05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Ares_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well if it isn't Malphon, the Twin Fists, bound to your very capable hands! So many weapons are so indirect, I think. With Malphon, you are about as close to the destruction as can be." },
			},

			AresLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0127",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The greatest wars require great alliances, my kin. And so, I shall entrust to you some of the greatest methods of destruction I've devised thus far." },
			},
			AresLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0128",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The winds of war blow fiercely on the surface now, my kin. Thus I am able to confer upon you even greater power than has been my custom." },
			},

			AresLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Ares_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You seem to be upon the verge of death, my kin. I cannot wait to hear of it! The experience of death, time after time! You are one of a kind!" },
			},
			AresLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0067",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, my kin, but you have suffered terribly to come this far. No matter, for we soon shall pay your enemies in kind." },
			},
			AresLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So much letting of blood, so much of it, your own. Let's see to keeping you alive and in the fight a while longer, then." },
			},
			AresLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're on the verge of yet another brush with death, I see, my hell-born kin. Do send some others down with you, would you?" },
			},
			AresLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A mortal surely would have already succumbed to injuries such as the ones you've suffered, there. Impressive how you carry on, like that." },
			},
		},

		PickupTextLineSets =
		{
			AresFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0789", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.38 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "This one was bound to show up I guess. In the name of Hades! Olympus! I accept this message." },
				{ Cue = "/VO/Ares_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "You've got quite the fighting spirit in you there, I have to say. Most intriguing, and yet no surprise for someone born in hell itself. You come on out of there, and tell me all about it. I'm a fellow student of death, you see." },
			},
			AresMiscPickup01 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I must say you deal death rather exquisitely. Though, perhaps I could be of some further assistance in such matters, yes?" },
			},
			AresMiscPickup02 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}! I figured that you must have been the source of all that bloodshed underneath the earth. Let me see if I can make your death-dealing a little more efficient." },
			},
			AresMiscPickup03 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, my hell-born kin, my blessing now is yours to do with as you wish; provided you inflict a little suffering for me?" },
			},
			AresMiscPickup04 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've just the thing for you this time, my kin. May I present my instruments of pain?" },
			},
			AresMiscPickup05 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I surely hope your bloodshed's going well, and long that there shall be no end to it. I am, as ever, here to serve your benefit." },
			},
			AresMiscPickup06 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How fares your endless war against the dead? Let it be known that I am happy to take sides in such affairs. Please, I insist!" },
			},
			AresMiscPickup07 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Death rears its head in all too many forms, I'm sure you know. Though you may never find them all, I nonetheless encourage you to try." },
			},
			AresMiscPickup08 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The wretched dead you face perhaps forget themselves. Go, then, remind them of the agony which brought them to your realm." },
			},
			AresMiscPickup09 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Life and death are inextricable, and war is often what connects the two. Don't you agree?" },
			},
			AresMiscPickup10 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "This world has a limitless capacity for pain; and so, it truly is no inconvenience to help you to bring out a little more." },
			},
			AresMiscPickup11 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The living and the dead alike desire what I represent. Their appetite for bloodshed cannot easily be sated. A goal to strive for, no?" },
			},
			AresMiscPickup12 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps the dead you stand against have long forgotten the experience of anguish and despair. I trust that you shall soon remind them for me?" },
			},
			AresMiscPickup13 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Beautiful, isn't it? The strife which follows you. You have a real knack for this, and I for one am happy to assist." },
			},
			AresMiscPickup14 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Some would question the destruction which you sow, but I shall never do so. I fully understand your impulses. Allow me to indulge them." },
			},
			AresMiscPickup15 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Not once has your Lord Father thanked me for delivering vast portions of his clientele. Surely you shall be more grateful for my gifts." },
			},
			AresMiscPickup16 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do you suppose the dead feel pain unlike the living? This is for me an endless fascination, so go on, and give me more to think about." },
			},
			AresMiscPickup17 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "As you continue waging war against the dead, I gladly lend you my support; family to family, no questions asked." },
			},
			AresMiscPickup18 =
			{
				Priority = true,
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It is a veritable crime your father distances himself from all the rest of us. It is fortunate that you yourself are not so disagreeable." },
			},

			-- shorter acknowledgments
			AresMiscPickup19 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let us together deal some death, shall we?" },
			},
			AresMiscPickup20 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Shall we continue our campaign against the dead?" },
			},
			AresMiscPickup21 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say we bring the dead some pain, for old time's sake?" },
			},
			AresMiscPickup22 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The devastation you have caused has not escaped my notice!" },
			},
			AresMiscPickup23 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We stand before a golden opportunity, to inflict pain. Let us proceed!" },
			},
			AresMiscPickup24 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There is no problem war cannot sort out." },
			},
			AresMiscPickup25 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah there you are, my kin! I have a gift to aid your bloody work." },
			},

			AresMiscPickup26 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My blessing be with you, and may death follow in your wake." },
			},
			AresMiscPickup27 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Please spread some suffering down there for me, my kin." },
			},
			AresMiscPickup28 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall empower you to acts of greater violence than before." },
			},
			AresMiscPickup29 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "War needn't carry out solely above the earth, my kin." },
			},
			AresMiscPickup30 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust that the destruction which you sow is going well?" },
			},
			AresMiscPickup31 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "D_Intro",
				{ Cue = "/VO/Ares_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The recent devastation which you caused, that was impressive work." },
			},
			AresMiscPickup32 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whenever you bring death, why, you've my full support." },
			},
			AresMiscPickup33 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How fares the ceaseless slaying of your foes, quite well, my kin?" },
			},
			AresMiscPickup34 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps my blessing shall let you deliver death still more efficiently." },
			},
			AresMiscPickup35 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father's realm shall be quite full, I think, once you and I are through." },
			},
			AresMiscPickup36 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The finest instruments of death at my disposal shall be yours." },
			},
			AresMiscPickup37 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd like to offer you a choice amongst my most exquisite tools which inflict suffering." },
			},
			AresMiscPickup38 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What say we start our next war with a special flair, my kin?" },
			},
			AresMiscPickup39 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've not seen ample blood spilled recently, so let's please make up for lost time." },
			},

			AresMiscPickupExtra01 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There are so many types of death... and yet, the sudden, violent kind is unsurpassed, I think." },
			},
			AresMiscPickupExtra02 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am quite eager to commence jointly killing your enemies, my kin." },
			},
			AresMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMinTotalKills = 1000,
				{ Cue = "/VO/Ares_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say we start another of our famous killing sprees, my kin?" },
			},
			AresMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's not been long since last I saw bloodshed... but far too long for me, nevertheless." },
			},
			AresMiscPickupRareExtra01 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My finest implements of death I now avail to you, my worthy kin." },
			},
			AresMiscPickupRareExtra02 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let us make this blood-letting truly one to remember, then, hm?" },
			},
			AresMiscPickupRareExtra03 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "May you sow such destruction as to shake this mountain to its core, my kin." },
			},
			AresMiscPickupRareExtra04 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall now give to you the means to wreak such havoc there, my kin!" },
			},
			AresMiscPickupAboutNyx01 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresAboutNyx06", "AresAboutNyx06_B" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I was quite pleased to hear again from Nyx of late, my kin." },
			},
			AresMiscPickupAboutNyx02 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresAboutNyx04", "AresAboutNyx04_B" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "May the wondrous goddess Nyx continue to watch over you, and darken the eyes of your foes." },
			},
			AresMiscPickupAboutNyx03 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresAboutNyx02", "AresAboutNyx02_B" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To think you have the goddess Nyx's aid, as well as mine!" },
			},
		},

		BoughtTextLines =
		{
			AresLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I knew that foul boatman would come through, and you would find amongst his wares this gift!" },
			},
			AresLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I give to you this token of respect, buried though it must have been within the boatman's hoard." },
			},
			AresLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust the river-boatman Charon has been keeping plenty busy lately thanks to me?" },
			},
			AresLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The boatman Charon ought invest into a boat of more substantial size if he's to keep up with my work, my kin." },
			},
			AresLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your boatman there is a reliable deliverer of death, it seems. And that makes three of us, I think." },
			},

		},

		RejectionTextLines =
		{
			AresRejection01 =
			{
				RequiredFalseTextLines = { "AresGift03" },
				{ Cue = "/VO/Ares_0003",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You reject my generous offering of aid? {#DialogueItalicFormat}Hahahaha{#PreviousFormat}, you must not know me very well. Death shall come, regardless, either to your enemies, or you." },
			},
			AresRejection02 =
			{
				{ Cue = "/VO/Ares_0045",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You would deny such aid as I would offer you? How rather disappointing. You've more to learn about the art of dealing death, it seems." },
			},
			AresRejection03 =
			{
				{ Cue = "/VO/Ares_0046",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "An incorrect decision, there, my kin, to side against me thus. Blood needs be shed, and yours is going to suffice." },
			},
			AresRejection04 =
			{
				{ Cue = "/VO/Ares_0047",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It seems unwise of you to thus dismiss my offering. Suffer, then, a while by my hand." },
			},
			AresRejection05 =
			{
				{ Cue = "/VO/Ares_0048",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your choice leaves much to be desired here, my kin. My temper I shall keep in check, but only barely so." },
			},
			AresRejection06 =
			{
				{ Cue = "/VO/Ares_0129",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A disappointing choice, my kin, and there are consequences to such choices, every single time." },
			},
			AresRejection07 =
			{
				{ Cue = "/VO/Ares_0130",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your course of action here was ill-advised, my kin. For war shall come to you no matter what, as I shall presently reveal." },
			},
			AresRejection08 =
			{
				{ Cue = "/VO/Ares_0131",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The whims of our kind are unpredictable, my kin. But you shall find responses to such acts to be the definition of consistency." },
			},
			AresRejection09 =
			{
				{ Cue = "/VO/Ares_0132",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'll not abide such disregard of our past companionship, my kin. In war, one must take sides, and you had best choose mine." },
			},
			AresRejection10 =
			{
				{ Cue = "/VO/Ares_0177",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "War shall be waged here, no matter what, my kin. But even still, I am dismayed you would have sided against me." },
			},
			AresRejection11 =
			{
				{ Cue = "/VO/Ares_0178",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You wish to have a taste of what a war against me would be like? Well, then, I shall oblige." },
			},
			AresRejection12 =
			{
				{ Cue = "/VO/Ares_0179",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Did I detect some hesitancy on your part just then? Perhaps you knew that you were making a mistake. No matter; you'll learn now." },
			},
			AresRejection13 =
			{
				{ Cue = "/VO/Ares_0180",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You shall not goad me into anger with a petty insult such as this, you know. Nevertheless, there is a price which must be paid for it." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Apologies, Lord Ares.
				{ Cue = "/VO/ZagreusField_0405" },
				-- Ares, forgive me.
				{ Cue = "/VO/ZagreusField_4140" },
				-- Don't kill me, Ares.
				{ Cue = "/VO/ZagreusField_4141" },
				-- Sorry, Lord Ares.
				{ Cue = "/VO/ZagreusField_4142" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			AresMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A sacrifice in blood is fully paid, and we are squared away. Though think you twice next time before you cross me, hm?" },
			},
			AresMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well haven't you withstood my murderous intent! Resilience as this deserves reward, and I am feeling rather generous." },
			},
			AresMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It is not often I attempt to kill someone and they survive. Bravo! Our score is settled up for now, so let us carry on as friends." },
			},
			AresMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You capably survived my wrath, and I commend you for it. Let us continue on, as friends and kin." },
			},
			AresMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I think that we are squared away, for now. Though, do not test my patience further, hm?" },
			},
			AresMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0133",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You crossed the fields of death impressively back there. Though, you are fortunate I'm in a giving mood." },
			},
			AresMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "When blood is spilled and death is dealt, I simply cannot remain discontented for too long." },
			},
			AresMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0135",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What I could see of that display of violence you just sowed was thoroughly commendable, my kin. Then, here." },
			},
			AresMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your sacrifice to me just now has moved me to forgiveness for the time; thus shall we call a truce." },
			},
			AresMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A war can only last so long, my kin. This one is not worth the pursuit, I think, when we can wage a greater one, together." },
			},
			AresMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, after a show of violence such as that, how can I possibly remain upset, my kin?" },
			},
			AresMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your slight against me is already forgotten; for I was more than pleased to witness to such a monstrous show of force." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			AresGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0126", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Ares, please accept this offering, for giving me such strength as necessary to succeed." },
				{ Cue = "/VO/Ares_0058",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are a flatterer, my death-inflicting kin. And I am feeling generous, as well, so here! A small token for you of my affection." },
			},
			AresGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift01", },
				{ Cue = "/VO/ZagreusHome_0530", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Ares, I honor you for all the strength you've given me to overcome my foes." },
				{ Cue = "/VO/Ares_0054",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Such a splendid offering, to me! How very thoughtful, there, my kin. I am taken aback, though I accept!" },
			},
			AresGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift02", },
				{ Cue = "/VO/ZagreusHome_0531", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Ares! Please accept this token of my deep appreciation for your generous support." },
				{ Cue = "/VO/Ares_0055",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "An offering, for me? Indeed! How gracious that you keep me in your thoughts. Know that, likewise, I keep you in mine." },
			},
			AresGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift03", },
				{ Cue = "/VO/ZagreusHome_0532", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Ares, it is my privilege to have met you, and have learned your death-inflicting way." },
				{ Cue = "/VO/Ares_0056",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I do appreciate this gift to me, although you really shouldn't have! The suffering which you inflict is ample compensation in itself." },
			},
			AresGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift04", },
				{ Cue = "/VO/ZagreusField_3865", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "You have shown me nothing but respect and granted me your favor repeatedly, Lord Ares. This is the least that I can do, in kind." },
				{ Cue = "/VO/Ares_0171",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Most often when I'm given offerings, it is with wishes that I lend my favor in a coming war. Yet from you, my kin, I sense no such motive. I'm quite taken aback by that, I must admit." },
			},
			AresGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift05", },
				{ Cue = "/VO/ZagreusField_3866", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Ares! As bloodshed has become somewhat of a necessity in my situation, I am very grateful that you're with me in this. I know never to take it for granted." },
				{ Cue = "/VO/Ares_0172",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're most gracious with me, my kin; and I remain enthralled as ever by your blood-soaked way of life. I trust the violence I have wrought on your behalf has been quite satisfactory?" },
			},
			AresGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift06", },
				{ Cue = "/VO/ZagreusField_3867", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I offer this Ambrosia in your name and honor, Lord Ares. To the god of war! How many foes have I vanquished with your aid and guidance? But more than that, I'm pleased to know you, and to be your cousin." },
				{ Cue = "/VO/Ares_0173",
					PortraitExitWait = 1.0,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Ares_01", Icon = "Keepsake_AresSticker_Max" },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, such an exquisite gift this is, indeed. Yet, the destruction you have sown, the sheer carnage... nothing can surpass that, I should think. Should you ever go to war, my kin... genuinely go to war, I mean... do look me up. I imagine I would take your side." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- You have my thanks, Lord Ares.
			{ Cue = "/VO/ZagreusHome_0366" },
		},

		ShoutActivationSound = "/SFX/AresWrathBattle",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "AresUpgrade",

				-- Pain and suffering upon you all!
				{ Cue = "/VO/Ares_0060", RequiredMinKillEnemies = 3 },
				-- Blood and death, together hand in hand!
				{ Cue = "/VO/Ares_0061" },
				-- Death and destruction!
				{ Cue = "/VO/Ares_0062" },
				-- Now I am angry.
				{ Cue = "/VO/Ares_0102" },
				-- Perish, all of you!
				{ Cue = "/VO/Ares_0154", RequiredMinKillEnemies = 3 },
				-- Behold the violence!
				{ Cue = "/VO/Ares_0155" },
				-- Suffer and die!
				{ Cue = "/VO/Ares_0156" },
				-- War is inevitable!
				{ Cue = "/VO/Ares_0157" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "AresUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Whom do you take me for.
				{ Cue = "/VO/Ares_0096" },
				-- You test my patience.
				{ Cue = "/VO/Ares_0098" },
				-- Disgusting.
				{ Cue = "/VO/Ares_0100" },
				-- How dare you.
				{ Cue = "/VO/Ares_0101" },
			}
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAresRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- A compelling offer, Lord Ares.
			{ Cue = "/VO/ZagreusField_1878" },
			-- A shrewd exchange, Lord Ares.
			{ Cue = "/VO/ZagreusField_1879" },
			-- Lord Ares, I accept.
			{ Cue = "/VO/ZagreusField_1880" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- That was ill-advised.
			{ Cue = "/VO/Ares_0090" },
			-- A terrible mistake.
			{ Cue = "/VO/Ares_0097" },
			-- A foolish move.
			{ Cue = "/VO/Ares_0099" },
			-- You must know mercy simply isn't in my nature.
			{ Cue = "/VO/Ares_0189" },
			-- What is a war without its tragic losses here and there?
			{ Cue = "/VO/Ares_0190" },
			-- It is unwise to side against me in a war.
			{ Cue = "/VO/Ares_0191" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.AresVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Hail, my kin.
			{ Cue = "/VO/Ares_0068" },
			-- Greetings, fellow bringer of death and so on.
			{ Cue = "/VO/Ares_0069" },
			-- How is hell treating you today?
			{ Cue = "/VO/Ares_0070" },
			-- How fares your war against the dead?
			{ Cue = "/VO/Ares_0071" },
			-- Greetings, it is I.
			{ Cue = "/VO/Ares_0072" },
			-- This is for you.
			{ Cue = "/VO/Ares_0087" },
		},
	},

	-- Artemis
	ArtemisUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolArtemis",
		BoonInfoIcon = "BoonInfoSymbolArtemisIcon",
		DoorIcon = "BoonSymbolArtemisIsometric",
		Color = { 64, 224, 208, 255 },
		LightingColor = {210, 255, 97, 255},
		LootColor = {110, 255, 0, 255},
		SubtitleColor = {0.059, 1.000, 0.035, 1.0},
		EventEndSound = "/SFX/ArtemisBoonArrow",
		UpgradeSelectedSound = "/SFX/ArtemisBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Artemis",

		PriorityUpgrades = { "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait" },
		WeaponUpgrades = { "ArtemisWeaponTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisSecondaryTrait", "ArtemisShoutTrait" },
		Traits = { "CritBonusTrait" },
		Consumables = { },

		LinkedUpgrades =
		{
			--[[
			MarkedDropGoldTrait =
			{
				OneFromEachSet =
				{
					{ "CritVulnerabilityTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
				}
			},
			]]
			ArtemisSupportingFireTrait =
			{
				OneOf = { "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait", "CritBonusTrait" },
			},
			CritVulnerabilityTrait =
			{
				PriorityChance = 0.5,
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
			},
			ArtemisCriticalTrait =
			{
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
			},
			CriticalBufferMultiplierTrait =
			{
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
			},
			CriticalSuperGenerationTrait =
			{
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait" }
			},
			PoisonCritVulnerabilityTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
				}
			},
			AresHomingTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
				}
			},
			AmmoBoltTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			ArtemisReflectBuffTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "AthenaWeaponTrait", "AthenaRushTrait", "AthenaSecondaryTrait" },
				}
			},
			ArtemisBonusProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
				}
			},
			HeartsickCritDamageTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			HomingLaserTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "DemeterRangedTrait" },
				}
			},
			MoreAmmoTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisAmmoExitTrait", "CritVulnerabilityTrait" },
					{ "ArtemisSupportingFireTrait", "ArtemisAmmoExitTrait" },
					{ "ArtemisSupportingFireTrait", "CritVulnerabilityTrait" },
				},
			},
			ArtemisAmmoExitTrait =
			{
				OneOf = { "ArtemisRangedTrait", "PoseidonRangedTrait", "ZeusRangedTrait", "AphroditeRangedTrait", "AthenaRangedTrait"  },
			},
		},

		Speaker = "NPC_Artemis_01",
		Portrait = "Portrait_Artemis_Default_01",
		WrathPortrait = "Portrait_Artemis_Wrath_01",
		OverlayAnim = "ArtemisOverlay",
		Gender = "Female",
		SpawnSound = "/SFX/ArtemisBoonArrow",
		FlavorTextIds =
		{
			"ArtemisUpgrade_FlavorText01",
			"ArtemisUpgrade_FlavorText02",
			"ArtemisUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "ArtemisFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidArtemisRecently",
			CooldownTime = 40,

			-- Lady Artemis...
			{ Cue = "/VO/ZagreusField_0684" },
			-- You found me, Artemis...
			{ Cue = "/VO/ZagreusField_0685" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ArtemisRevealsRamaAspect01", },
				Queue = "Always",

				-- I see you drawn in the arms of the seventh avatar...
				{ Cue = "/VO/ZagreusField_3393" },
			},
			[2] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[3] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			ArtemisWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AmmoBoltTrait",
				RequiredMinNPCInteractions = { ArtemisUpgrade = 4 },
				{ Cue = "/VO/Artemis_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Tsk{#PreviousFormat}, {#DialogueItalicFormat}um{#PreviousFormat}, Zagreus... rather than greet you as I normally would do, instead, allow me to present you my illustrious, kind, generous lord father, your greatest Uncle Zeus!" },
				{ Cue = "/VO/Zeus_0198",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, thank you for the introduction, Daughter! Now, you run along, go frolic with your nymphs, or something! Leave me to assist my nephew, here. Bestow on him your faint blessing, if you must." },
			},

			ArtemisWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ArtemisBonusProjectileTrait",
				RequiredMinNPCInteractions = { ArtemisUpgrade = 4 },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp" },
				{ Cue = "/VO/Artemis_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSurprise", WaitTime = 6.0 },
					Text = "You know my father and my uncle, by now, right, Zagreus? I don't know which of them is worse. {#DialogueItalicFormat}Uh{#PreviousFormat}, I mean... superior! Superior, despite technically spending most of his time in the seas, beneath Olympus, isn't that right, Uncle?" },
				{ Cue = "/VO/Poseidon_0242",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Oh, Artemis, you needn't boast to little Hades there on my account! Besides! Whether you're in the sea, above it, or beneath, makes little difference to your measure as a god! You two are young as yet! Keep at it, and you'll soon be practically as great as I!"
				},
			},
			ArtemisWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HeartsickCritDamageTrait",
				RequiredTextLines = { "ArtemisGift01" },
				{ Cue = "/VO/Artemis_0122",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteDepressed", WaitTime = 7.5 },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hey, uh, Zagreus! There's something I've been wondering, and don't take this the wrong way or anything, OK? Oh, no. It's her." },
				{ Cue = "/VO/Aphrodite_0049",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Emote = "PortraitEmoteCheerful",
					Text = "Why, Artemis, you're absolutely tongue-tied! Due to our little godling in the Underworld, or a little due to me? {#DialogueItalicFormat}Hm-hm{#PreviousFormat}, you shall figure it all out I'm sure!" },
				{ Cue = "/VO/Artemis_0123",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Look, what was I, {#DialogueItalicFormat}ugh{#PreviousFormat}, just, never mind. I'll talk to you some other time, I guess." },
			},
			ArtemisWithAphrodite02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HeartsickCritDamageTrait",
				RequiredTextLines = { "ArtemisGift01", "AphroditeGift01", "ArtemisWithAphrodite01" },
				{ Cue = "/VO/Artemis_0238",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Zagreus, despite my hunter's instincts here, it seems I was unable to elude Aphrodite in this particular case, who insisted that we present ourselves to you at the same time, for whatever reason..." },
				{ Cue = "/VO/Aphrodite_0186",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Oh, come now, Artemis! I'm sure you're very capable of hiding from a common beast, but I can see you plain. Why not be honest with yourself, next time?" },
			},
			ArtemisWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AresHomingTrait",
				{ Cue = "/VO/Artemis_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Zagreus, I wish we all could hear you so that good Lord Ares here might be persuaded that my powers are entirely for different purposes than his!" },
				{ Cue = "/VO/Ares_0160",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Perhaps our skillsets once were meant for different purposes, dear Artemis; but who are we to doubt the end result? Observe what shall transpire once we grant our kin our combined might." },
			},
			ArtemisWithAres02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisWithAres01", "AresGift01", "ArtemisGift01" },
				RequiredMinAnyTextLines = { TextLines = { "ArtemisWithAres01" }, Count = 2 },
				HasTraitNameInRoom = "AresHomingTrait",
				{ Cue = "/VO/Artemis_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Zagreus, I was just hoping for a little privacy before this hunt, which is consistently my preference here, except, you see, Lord Ares always seems to come sniffing about, first sign of any hunting instruments!" },
				{ Cue = "/VO/Ares_0159",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Why, my dear Artemis, the hunt is but a prelude to a war, is that not so? For if all mortalkind knew naught of hunting, why, they would not be nearly so adept at killing one another." },
				{ Cue = "/VO/Artemis_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",					
					Text = "Look, Lord Ares, if I lend you better marksmanship ability, you think that you could bother someone else?" },
			},
			ArtemisWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonCritVulnerabilityTrait",
				{ Cue = "/VO/Artemis_0235",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Oh, great, it's you, Zagreus! Here, let me offer you some fine new Boons, as well as Lord Dionysus here, who I am sure would love to talk your ear off just as much as mine!" },
				{ Cue = "/VO/Dionysus_0213",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Emote = "PortraitEmoteDepressed",
					Text = "{#DialogueItalicFormat}Eh{#PreviousFormat}, tells me I'm being awful loud, and to back off, all sorts of nasty stuff like that, what can you do, though, right?" },
			},
			ArtemisWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HomingLaserTrait",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Artemis_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Oh, hi there, Zagreus, I was just failing to persuade the Lady Demeter to ease up off the snowy stretch that we've been having for a while. Some of the mortals are quite weary of it now, and it sure doesn't make the hunting any easier!" },
				{ Cue = "/VO/Demeter_0148",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "The mortals are resourceful, Artemis. Their one redeeming quality, perhaps! They'll find a way through our long winter here. They ought to, since they brought it on themselves." },
			},

		},

		SuperPriorityPickupTextLineSets =
		{
			ArtemisAboutRamaAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisRevealsRamaAspect01" },
				RequiredFalseTextLines = { "ArtemisAboutRamaAspect02" },
 				RequiredFalseTraits = { "BowBondTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_2052" },

				{ Cue = "/VO/Artemis_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Um, Zagreus, did you attempt to chat with Coronacht just yet? Remember, tell the bow {#DialogueItalicFormat}I see you drawn in the arms of the seventh avatar! {#PreviousFormat}Something good's supposed to happen if you do, some divine archer-person's aspect I should think? You going to try it soon, or not?" },
			},
			ArtemisAboutRamaAspect02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisRevealsRamaAspect01" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowBondTrait",

				{ Cue = "/VO/Artemis_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, look at that! The message must have worked! Practically can see that shiny bow from here! I've never wielded Coronacht myself, at least not yet. Though if the Fates are sending visions to me of its past or future bearers, why, I guess I'm bound to get my shot eventually!" },
			},
			ArtemisAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4341", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.44 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Found you, Huntress, here. In the name of Hades! Olympus, this is an official message! Especially for you, Lady Artemis!" },
				{ Cue = "/VO/Artemis_0225",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Some kind of special message for me...! Oh, looks like there's one for everybody on Olympus, then. Felt rather special for a moment, there! And now you're making me check in with all the others. Great!" },
			},
			ArtemisPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0226",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSparkly", WaitTime = 7.0 },
					UseEventEndSound = true,
					Text = "Have to say, I had a pretty decent time with everybody at our little visit recently! Met you, Uncle Hades, even great Achilles! Still don't quite appreciate you tricking us, but {#DialogueItalicFormat}eh{#PreviousFormat}! I can get over it eventually. Anyway, you still could use assistance from me, right?"
				},
			},
		},
		
		PriorityPickupTextLineSets =
		{
			-- about other gods
			ArtemisAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Artemis_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, good old Father Zeus, he must have blessed you with his lightning bolts, did he? Always looking out for everyone." },
			},
			ArtemisAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Artemis_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Uncle Poseidon blessed you, didn't he. To think that big, fat oaf is your own father's brother. I'm told to be respectful near him, but it's hard." },
			},
			ArtemisAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Artemis_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You met Athena earlier, I guess? I'd never trade my bow for all that pomp and armor, but... I guess to each her own." },
			},
			ArtemisAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "AresGift02" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Artemis_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're pretty close with Ares, aren't you? And here they said it couldn't be done. If I were you I'd watch myself with him." },
			},
			ArtemisAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Artemis_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So Aphrodite reached you first, did she? Sounds exactly like something she'd do. She has a knack for trouble. So, let's just stay focused, here!" },
			},
			ArtemisAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DionysusGift02" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Artemis_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That lush and lecher, Dionysus, counts you as a friend? I'm hoping that there must be some mistake, yeah, Zagreus?" },
			},
			ArtemisAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Artemis_0240",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You seem particularly light on your feet, there, Zagreus. I'd figure Hermes, himself, was speeding you along, except I've not seen him about in... been a while, really." },
			},
			ArtemisAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Artemis_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So even Demeter's become involved in this! Didn't think she would. Though you'll be glad she did! Provided you stay on her warm and fuzzy side, of course. Working on that, myself!" },
			},

			ArtemisBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Artemis_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Something's troubled me a little, about you. You fight so desperately. At first I thought you simply lacked in patience. But now I see it's urgency that drives you. What is it that you're after, really...?" },
			},

			ArtemisRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMinDepth = 8,

				{ Cue = "/VO/Artemis_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's see. You blundered headlong into danger for the past six chambers or more. And you made such a racket I could almost hear it from Olympus. I have to say, your hunting skills are rather unconventional." },
			},
			ArtemisRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinRunsCleared = 2,

				{ Cue = "/VO/Artemis_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm with you every step till you arrive here, Zagreus. Then I will probably ignore you like the rest. Just warning you ahead of time, all right?" },
			},

			ArtemisAboutVermin01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredRoomLastRun = "D_Intro",
				{ Cue = "/VO/Artemis_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, were you hunting vermin near the surface lately, Zagreus? That's practically just like the real thing! It must have been a thrill!" },
			},
			ArtemisAboutVermin02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutVermin01" },
				RequiredRoomLastRun = "D_Intro",
				RequiredKills = { RatThug = 10, RatThugElite = 3, Crawler = 20, CrawlerMiniBoss = 1 },
				{ Cue = "/VO/Artemis_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've become a right accomplished vermin hunter, Zagreus! Maybe you'll get to use those skills against worthier creatures soon enough." },
			},

			ArtemisVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredRunsCleared = 0,
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Artemis_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That Fury down in Tartarus has been a real problem, hasn't she. I see the huntress instinct in her. She thinks she knows your weaknesses. Don't let yourself become predictable." },
			},

			ArtemisVsAchilles01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "AchillesGift02", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "ArtemisVsAchilles02" },
				{ Cue = "/VO/Artemis_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, I once heard Lord Hades has in his employ the greatest hero of the Trojan War, you happen to know anything about that? I'm kind of a fan. You see Achilles, tell him he's the best for me!" },
			},
			ArtemisVsAchilles02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift01", "AchillesGift03" },

				{ Cue = "/VO/Artemis_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So, I have heard that Achilles, himself, taught you how to fight! No wonder you can hold your own down there, that is amazing...! You be sure to honor him from time to time, got it?" },
			},

			ArtemisPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift02" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Artemis_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Living on Olympus here, I'm surrounded by my family, but I always felt alone. I know that's not the same as your experience, but, I'm just saying I relate to what you're going through." },
			},

			ArtemisHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift02", },

				{ Cue = "/VO/Artemis_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I think you might enjoy it on Olympus, there's... a lot of feasting here, I guess, and the air is cool and crisp, and it's much brighter than it is down there. Sounds like a dream, right?" },
			},
			ArtemisHighAffinity02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift04", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Artemis_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I hope that once you make it to Olympus we'll go hunting sometime, you and I, you know? I like being on my own and all, but it's been nice, talking to you like this." },
			},
			ArtemisHighAffinity03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift07", },
				{ Cue = "/VO/Artemis_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I grow so tired of the others here, you know? Much rather be out with the woodland nymphs than with these gods upon this mountaintop. You must know what it's like." },
			},

			ArtemisAboutCallisto01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisHighAffinity01", },

				{ Cue = "/VO/Artemis_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Not everybody on Olympus is a total disappointment, Zagreus. Why, someday maybe you could meet Callisto, she goes hunting with me all the time! Bet you don't see many woodland nymphs down there." },
			},
			ArtemisAboutCallisto02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto01", "ArtemisGift03", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey Zagreus, that Nectar you sent? Callisto and the nymphs and I, we popped it open recently, and it was really good! Had us positively frolicking about. So, thanks!" },
			},
			ArtemisAboutCallisto03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto02", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You must have a friend or two, don't you? It's hard being alone all of the time. At least I have Callisto and the other nymphs, and... I have you! A distant friend is still a friend, isn't that right?" },
			},
			ArtemisAboutCallisto04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto03", "ArtemisGift04", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hope you don't mind, I told Callisto all about you recently! Don't worry, I was quite discreet about it, the two of us were on the hunt, not like I just shouted out your story from the mountaintops!" },
			},
			ArtemisAboutCallisto05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto04", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus, if only you could turn yourself into a woodland creature and just fly or burrow out of there! My Callisto, she can turn into a bear, you ever seen those? Monstrous, furry things, quite huggable, if they don't kill you first!" },
			},
			ArtemisAboutCallisto06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto05", "ArtemisGift05", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've never even seen the woods, have you? I hope you do, someday. You could meet Callisto and the others! It's quite beautiful, and green, and calm, it's... anyway." },
			},
			ArtemisAboutCallisto07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto06", "ArtemisGift06", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't know what it is about you, Zagreus, but I feel like I can be me with you, you know? Maybe it's that you don't constantly talk over me like everybody else, besides Callisto and the nymphs I guess. Not that I can even hear you, but, you know what I mean, right?" },
			},

			ArtemisHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredFalseTraits = { "BowLoadAmmoTrait" },
				-- purposely omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "BowWeapon",

				{ Cue = "/VO/Artemis_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, how'd you get your hands on a nice bow like that? You take good care of Coronacht for me, so I can try it too once you're up here." },
			},
			ArtemisAboutBowWeaponProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift01" },
				RequiredWeapon = "BowWeapon",
				RequiredMinWeaponKills = { BowWeapon = 750 },

				{ Cue = "/VO/Artemis_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Have to admit, you're very capable with Coronacht. Now I can hit a bull's eye in my sleep, but you'll be right there with me if I don't keep practicing I think!" },
			},
			ArtemisAboutSpearWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredWeapon = "SpearWeapon",
				RequiredFalseTextLines = { "ArtemisAboutAchillesAspect01" },

				{ Cue = "/VO/Artemis_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, that's the Eternal Spear, Varatha, isn't it? Your father used to use that, didn't he. A bit ornate for hunting, but a spear's a spear, is what I like to say!" },
			},
			ArtemisAboutAchillesAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredWeapon = "SpearWeapon",
				RequiredTrait = "SpearTeleportTrait",

				{ Cue = "/VO/Artemis_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, that can't possibly be the spear once wielded by the great Achilles, there, can it?! The shape is unmistakable, I mean, have you even the slightest just how many mortals got completely slaughtered by that thing? Oh, it has seen some use!" },
			},
			ArtemisAboutChironAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisHasWeapon01" },
				RequiredWeapon = "BowMarkHomingTrait",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Artemis_0242",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That's not the Coronacht I know, isn't that... Chiron the centaur's bow? So that was Coronacht, as well? Seems every decent bow was just a version of that thing! Except for mine, of course." },
			},
			ArtemisAboutHeraAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisHasWeapon01" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Artemis_0241",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, that's the bow Stepmother Hera herself once wielded, isn't it? Her aspect of Coronacht! I'd know it from the... frankly rather sinister skulls all over it. It's very Hera, trust me." },
			},
			ArtemisAboutFistWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "DemeterFirstPickUp" },
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Artemis_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "When did you get your hands on Malphon, the Twin Fists? Hands {#DialogueItalicFormat}in{#PreviousFormat}, I ought to say! I heard that one time, Demeter, she smacked her father right square in the face with those! Bet you can probably relate." },
			},
			ArtemisAboutGunWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredWeapon = "GunWeapon",

				{ Cue = "/VO/Artemis_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, look at you, with Exagryph, the Rail of Adamant! Seems much too noisy-complicated as a hunting weapon when you could just use a nice quiet bow, but hey, to each her own." },
			},
			ArtemisRevealsRamaAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisHasWeapon01", "AchillesRevealsGuanYuAspect01" },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "BowWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				{ Cue = "/VO/Artemis_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now listen, Zagreus, admittedly this is a little strange, even from me. I have a message for your bow! That's right, just go on up to Coronacht next time, and tell it with a firm, commanding voice, {#DialogueItalicFormat}I see you drawn in the arms of the seventh avatar! {#PreviousFormat}Let me know how it goes, OK?" },
			},

			ArtemisAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceArtemisBoonTrait",

				{ Cue = "/VO/Artemis_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, that's my Adamant Arrowhead on you! Normally, it's for killing things, but in your case it makes it even easier for me to hunt you down, even in the dark. Now that I found you... here!" },
			},

			ArtemisAboutZagreus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				RequiredTextLines = { "ArtemisFirstPickUp", "NyxBackstory01", "ArtemisGift01" },
				{ Cue = "/VO/Artemis_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your name, it means {#DialogueItalicFormat}'great hunter'{#PreviousFormat}, Zagreus! I guess your mother Nyx must have expected someday that you'd pick up a few pointers from myself!" },
			},

			ArtemisRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Artemis_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, hold a moment, Zagreus, I could have sworn... you were so close, before, but now you're back? Ah, must have tripped up just when victory was close at hand, it happens all the time. We'll get you out of there, you'll see!" },
			},

			ArtemisLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, you all right there, Zagreus? Wouldn't do to have you die on me just moments after meeting here like this." },
			},
			ArtemisLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}! Look at you, you're hurt there pretty bad, but, just stay focused on the hunt, and it'll help to keep the pain at bay." },
			},
			ArtemisLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look, I'm just goddess of the hunt, not medicine, so... I don't know if this is going to help right now, but, here!" },
			},
			ArtemisLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your hunt has evidently not been going very well so far, I see. Though, maybe we can still turn it around." },
			},
			ArtemisLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, one good thing about all of the blood you've lost is it was even easier to track you down this time!" },
			},

			ArtemisLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, get ready for this, Zagreus, because I seldom share the greatest of my hunting secrets like I am about to." },
			},
			ArtemisLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, no need to keep on toying with your prey. Here comes one of my finest blessings, now!" },
			},
			ArtemisLegendaryPickUp03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I don't reveal my greatest hunting techniques for just anybody, Zagreus, so you better appreciate what you're about to get, and use it to go far!" },
			},
			ArtemisLegendaryPickUp04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Epic",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How about we not take any chances this time, Zagreus? So here, this is the best I've got. You better not waste it!" },
			},

		},

		PickupTextLineSets =
		{
			ArtemisFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0786", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 5.72 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "There's only one heavenly archer I know of. Well, several, really. Anyway! In the name of Hades! Olympus? I accept this message." },
				{ Cue = "/VO/Artemis_0011",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "I heard about you. Look, I'm not like all the others on Olympus. The power of the hunt helps keep me company, so... maybe it'll help you, too!" },
			},
			ArtemisMiscPickup01 =
			{
				Priority = true,
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Artemis_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey. You're not alone. You're not alone down there, OK? Here, let me show you." },
			},
			ArtemisMiscPickup03 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The dead must make a rather easy target, wouldn't you say? Let's see what you can do to them, given your choice of these." },
			},
			ArtemisMiscPickup04 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You busy, Zagreus? Thought maybe I could interest you in some of these old hunting tricks of mine." },
			},
			ArtemisMiscPickup05 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How fares the hunt this time around, OK? I bet it could be better, so, {#DialogueItalicFormat}erm{#PreviousFormat}, here! Maybe this'll help." },
			},
			ArtemisMiscPickup06 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's take a little hunting expedition, yeah? You'll do most of the work, but hey, I'll be with you in spirit!" },
			},
			ArtemisMiscPickup07 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sorry you're still stuck down there. Sometimes I feel stuck myself, but, a good hunt always sets me straight." },
			},
			ArtemisMiscPickup08 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "When I am on the hunt, my mind is clear, and nothing stands between me and my target. Though, have a blessing just in case you can't relate!" },
			},
			ArtemisMiscPickup09 =
			{
				Priority = true,
				RequiredTextLines = { "ArtemisGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd love to know about your life down there. I'll try and help you live through it this time so that way you can tell me?" },
			},
			ArtemisMiscPickup10 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The wretches whom you face down there have died already, sometimes more than once. Should make for easy targets, right?" },
			},
			ArtemisMiscPickup11 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've never come across a target I couldn't take down. I expect the same of you, you hear me? Hopefully you hear me." },
			},
			ArtemisMiscPickup12 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good hunting, Zagreus! The sooner you get out of there the sooner you can save me from my insufferable relatives. Please?" },
			},
			ArtemisMiscPickup13 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, Zagreus, good luck out there, this time. I'd tell you {#DialogueItalicFormat}'may your aim be true' {#PreviousFormat}but I can guarantee it, actually." },
			},
			ArtemisMiscPickup14 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The hunt requires utter concentration, so, I'll leave you to it, and... just watch your every move in silence over here..." },
			},
			ArtemisMiscPickup15 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You want to make it out of there, you... don't have to listen to a word I say, to be quite honest, but... my huntress blessings ought to help." },
			},
			ArtemisMiscPickup16 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, Zagreus, you getting out of there this time, or am I going to have to keep on hunting by myself for the time being? Probably?" },
			},
			ArtemisMiscPickup17 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift06" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Looks to me like you could use a little help, so I'll just have a look in my big bag of blessings here, and, {#DialogueItalicFormat}oh{#PreviousFormat}! Here's just the thing." },
			},
			ArtemisMiscPickup18 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The hunt comes down to kill-or-be-killed. Except for us immortals, who have to live with our shame, which is worse?" },
			},
			ArtemisMiscPickup19 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Those wretched things harassing you throughout that Underworld just won't give up, will they. Well, just keep killing them, I guess!" },
			},
			ArtemisMiscPickup20 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Need a hunting partner, Zagreus? Not that I'm able to join you myself down there, or even hear you respond for that matter, but, anyway, here." },
			},
			-- relationship improved
			ArtemisMiscPickup21 =
			{
				RequiredTextLines = { "ArtemisGift01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus, it's me! I'm here to join the hunt with you again. Let's show them what we can do." },
			},
			ArtemisMiscPickup22 =
			{
				RequiredTextLines = { "ArtemisGift02", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hello again, you ready for this hunt? Me, I've been looking forward since last time, so, let's get on with it." },
			},
			-- shorter acknowledgments
			ArtemisMiscPickup23 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0002",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Stay on your guard, tread lightly, and all that." },
			},
			ArtemisMiscPickup24 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Keep a sharp eye out there, won't you?" },
			},
			ArtemisMiscPickup25 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good hunting down there, Zagreus." },
			},
			ArtemisMiscPickup26 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What are you hunting this time, I wonder." },
			},
			ArtemisMiscPickup27 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'll be looking out for you. If you don't mind of course." },
			},
			ArtemisMiscPickup28 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remember, Zagreus, kill-or-be-killed." },
			},
			ArtemisMiscPickup29 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How about I join you for this hunt, OK?" },
			},
			ArtemisMiscPickup30 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, you take care of yourself, all right?" },
			},
			ArtemisMiscPickup31 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got you something I bet you could use." },
			},

			ArtemisMiscPickupExtra01 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The finer points of hunting are not easy to communicate, though you're learning from experience, at least!" },
			},
			ArtemisMiscPickupExtra02 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My senses sure are going to be sharp if I keep trying to keep up with you like this in all that dark down there." },
			},

			ArtemisMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A good, clean shot is all it takes, most of the time!" },
			},
			ArtemisMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You getting anywhere down there yet, Zagreus?" },
			},
			ArtemisMiscPickupExtra05 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What are you waiting for, let's get to hunting, then!" },
			},
			ArtemisMiscPickupExtra06 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Not much of a hunt when your prey knows exactly where you are, but it'll do!" },
			},
			ArtemisMiscPickupExtra07 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I hope your every strike cuts to the vital bits of all your prey, there, Zagreus." },
			},
			ArtemisMiscPickupExtra08 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I brought some hunting gear for you to try, if you could give me your attention, Zagreus?" },
			},
			ArtemisMiscPickupExtra09 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, Zagreus, catch your breath, decide, and then what say we get you out of hell maybe?" },
			},
			ArtemisMiscPickupExtra10 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift03" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What are we hunting this time, Zagreus? Don't tell me wretched dead, again?" },
			},
			ArtemisMiscPickupExtra11 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You see how easily I tracked you down? Unless you went out of your way for me, that is?" },
			},
			ArtemisMiscPickupExtra12 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have a Boon for you, here, Zagreus, though just be sure you don't embarrass me." },
			},
			ArtemisMiscPickupExtra13 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, perfect timing, Zagreus, now stock up and head out." },
			},
			ArtemisMiscPickupExtra14 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You want to make it out of there, my Boons are just about the only way to go." },
			},
			ArtemisMiscPickupExtra15 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't you let your father or let {#DialogueItalicFormat}anybody {#PreviousFormat}push you around, Zagreus." },
			},
			ArtemisMiscPickupExtra16 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bet I can help you break out of your father's realm in no time, Zagreus!" },
			},

			ArtemisMiscPickupRare01 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Decided I would pack you something extra for this hunt, if you can handle it!" },
			},
			ArtemisMiscPickupRare02 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Enough toying around with our prey, there, Zagreus. What do you say we finish it, this time?" },
			},
			ArtemisMiscPickupRare03 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know it must be such a struggle for you, Zagreus, so here! In case this helps." },
			},
			ArtemisMiscPickupRare04 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A great hunter ought to have great tools, Zagreus, so here! Please allow me." },
			},
			ArtemisMiscPickupRare05 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift03" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Wish I could hunt with you myself, but here's the next best thing, all right?" },
			},

			ArtemisMiscPickupAboutCallisto01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto02", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know how long it took Callisto to become a master of the hunt? I'm sure you can still learn a thing or two!" },
			},
			ArtemisMiscPickupAboutCallisto02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto03", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I was about to head out with Callisto for a hunt, though I can spare you a quick Boon, I guess!" },
			},
			ArtemisMiscPickupAboutCallisto03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto04", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have to meet Callisto soon, but it won't take me but a moment here to get you on your way!" },
			},
			ArtemisMiscPickupAboutCallisto04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto03", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Someday perhaps you'll join me and Callisto for a hunt! But as for now..." },
			},
			ArtemisMiscPickupAboutCallisto05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto07", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Greetings to you from the forest! Callisto and the woodland nymphs say hi!" },
			},
			ArtemisMiscPickupAboutCallisto06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto02", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'd make a real asset on the hunt, I think. Not that Callisto and I need assistance, though." },
			},
		},

		BoughtTextLines =
		{
			ArtemisLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, one thing I'll say for Charon there? He doesn't talk too much. And since neither do you, I'm letting you have this." },
			},
			ArtemisLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I guess this means you must have paid the boatman's ransom here, and whatever price he charged you, it was worth it." },
			},
			ArtemisLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Even there in your Underworld, it seems quality hunting gear doesn't come cheap, apparently!" },
			},
			ArtemisLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If you're quite done with shopping, Zagreus, what say we cut straight to the chase from here?" },
			},
			ArtemisLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You hunted down a real bargain there in Charon's shop, though how about we try a slightly bigger deal on for size right now?" },
			},

		},

		RejectionTextLines =
		{
			ArtemisRejection01 =
			{
				{ Cue = "/VO/Artemis_0125",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Why would you side with...?! {#DialogueItalicFormat}Ugh{#PreviousFormat}, why do I even bother with some lesser god!" },
			},
			ArtemisRejection02 =
			{
				{ Cue = "/VO/Artemis_0050",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I thought we had an understanding, Zagreus. But, this wouldn't be the first time I was wrong about someone." },
			},
			ArtemisRejection03 =
			{
				{ Cue = "/VO/Artemis_0051",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}, so that's your choice! Maybe you're more like my relatives than I'd care to admit." },
			},
			ArtemisRejection04 =
			{
				{ Cue = "/VO/Artemis_0052",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good shot, there, Zagreus! I guess you got me. Now why don't you go take a shot at {#DialogueItalicFormat}this{#PreviousFormat}." },
			},
			ArtemisRejection05 =
			{
				{ Cue = "/VO/Artemis_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't be messing with my feelings, Zagreus. My loyalty's hard-won, and quickly lost." },
			},
			ArtemisRejection06 =
			{
				{ Cue = "/VO/Artemis_0124",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You really missed an easy shot, here, Zagreus. But I will not. You'll see." },
			},
			ArtemisRejection07 =
			{
				{ Cue = "/VO/Artemis_0126",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Ah, good, just when I had almost forgotten what an arrow to the back felt like!" },
			},
			ArtemisRejection08 =
			{
				{ Cue = "/VO/Artemis_0127",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Am I some kind of pushover to you, Zagreus? Is that what you think?" },
			},
			ArtemisRejection09 =
			{
				{ Cue = "/VO/Artemis_0128",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, look, turns out it's time for target practice once again! Start running, Zagreus." },
			},
			ArtemisRejection10 =
			{
				{ Cue = "/VO/Artemis_0129",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "What made you think I'd stand for this, from you?" },
			},
			ArtemisRejection11 =
			{
				RequiredMinAnyTextLines = { TextLines = { "ArtemisRejection01", "ArtemisRejection02", "ArtemisRejection03", "ArtemisRejection04", "ArtemisRejection05", "ArtemisRejection06", "ArtemisRejection07", "ArtemisRejection08", "ArtemisRejection09", "ArtemisRejection10" }, Count = 8 },
				{ Cue = "/VO/Artemis_0130",
					Emote = "PortraitEmoteFiredUp",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, I knew you'd pull this old maneuver, Zagreus. And I am ready for you, now." },
			},
			ArtemisRejection12 =
			{
				RequiredMinAnyTextLines = { TextLines = { "ArtemisRejection01", "ArtemisRejection02", "ArtemisRejection03", "ArtemisRejection04", "ArtemisRejection05", "ArtemisRejection06", "ArtemisRejection07", "ArtemisRejection08", "ArtemisRejection09", "ArtemisRejection10" }, Count = 8 },
				{ Cue = "/VO/Artemis_0131",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're getting quite predictable when you betray me like this, Zagreus! Start running, then." },
			},
			ArtemisRejection13 =
			{
				RequiredMinAnyTextLines = { TextLines = { "ArtemisRejection01", "ArtemisRejection02", "ArtemisRejection03", "ArtemisRejection04", "ArtemisRejection05", "ArtemisRejection06", "ArtemisRejection07", "ArtemisRejection08", "ArtemisRejection09", "ArtemisRejection10" }, Count = 8 },
				{ Cue = "/VO/Artemis_0132",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Oh really, that's the way it's going to be? You Underworld gods are all alike!" },
			},

		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Forgive me, Lady Artemis.
				{ Cue = "/VO/ZagreusField_0406" },
				-- Sorry, Artemis.
				{ Cue = "/VO/ZagreusField_4146" },
				-- No hard feelings, Lady Artemis?
				{ Cue = "/VO/ZagreusField_4147" },
				-- Had to do it, Artemis.
				{ Cue = "/VO/ZagreusField_4148" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			ArtemisMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Fine, I'm not angry anymore, not really anyway, but you just watch yourself with me, you got it?" },
			},
			ArtemisMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh you're still there I see. Well then, all right, let's call it even for the moment and get on with this." },
			},
			ArtemisMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, all right, I'm going to forgive you now I guess, no need to beg, you just think twice next time OK?" },
			},
			ArtemisMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got to say you handled yourself pretty well back there. I can't stay mad after a show like that." },
			},
			ArtemisMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good hunting just now, Zagreus. You passed my little test, so now we're good, just like it never happened." },
			},

			ArtemisMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0133",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So you survived, so what. Here, why not take a Boon, and then be off?" },
			},
			ArtemisMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I will admit mistakes were made back there, so you just don't make them again, next time all right?" },
			},
			ArtemisMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0135",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know what, I decided not to kill you, Zagreus. No sport in cornered prey, so here, get on with it." },
			},
			ArtemisMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good thing you're nowhere near our mountaintop or I'd have shot you for that stunt, myself." },
			},
			ArtemisMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, Zagreus, it turns out you need all the help that you can get, so here's a pity Boon for you!" },
			},
			ArtemisMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I could keep hunting you until you're dead, but there's too little meat on you to make it worth my while." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			ArtemisGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0124", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lady Artemis, I hope that you'll accept this offering, for all your kindness and support." },
				{ Cue = "/VO/Artemis_0063",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey thank you for this, really. And, I've just the thing to offer in return. It's just a gift, OK?" },
			},
			ArtemisGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift01" },
				{ Cue = "/VO/ZagreusHome_0533", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "My lady Artemis! This is nothing, next to all your grace and favor." },
				{ Cue = "/VO/Artemis_0059",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "Hey wait, this is an offering, for me? I, {#DialogueItalicFormat}oh{#PreviousFormat}, that's very kind, though, let's get back to hunting, now, OK?" },
			},
			ArtemisGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift02" },
				{ Cue = "/VO/ZagreusHome_0534", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lady Artemis! I am indebted to you, for the strength and cunning you have given me." },
				{ Cue = "/VO/Artemis_0060",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look, Zagreus, I don't know what to say, except for... thanks!" },
			},
			ArtemisGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift03" },
				{ Cue = "/VO/ZagreusHome_0535", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "My lady Artemis, your favor's been invaluable to me. No finer huntress ever walked the surface of the earth, or underneath." },
				{ Cue = "/VO/Artemis_0061",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",					
					Text = "You're being very nice to me, and that makes me suspicious, understand? So, you want more of that... you keep this up." },
			},

			ArtemisGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift04" },
				{ Cue = "/VO/ZagreusField_3431", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "At the risk of incurring your wrath, Lady Artemis, I hope you will accept this from me, and see that my gratitude for all you have done for me is genuine." },
				{ Cue = "/VO/Artemis_0212",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you know, another gift of Nectar, that's... quite thoughtful of you, Zagreus! Normally don't care much for the stuff, but, every now and then, I mean... why not?" },
			},
			ArtemisGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift05" },
				{ Cue = "/VO/ZagreusField_3432", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "In your honor, Lady Artemis! Your mighty blessings have helped me through so many trials now, and I always welcome your level-headed presence here." },
				{ Cue = "/VO/Artemis_0213",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look, I like being worshiped just as much as anybody, Zagreus, though bear in mind that you can always leave the worship of me to the forest nymphs, all right?" },
			},
			ArtemisGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift06" },
				{ Cue = "/VO/ZagreusField_3433", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I know you have no shortage of Ambrosia on Olympus, Lady Artemis, but I imagine it's less often that the stuff go all the way from there to here, and back. What can I say? You make me proud to be a member of this family." },
				{ Cue = "/VO/Artemis_0214",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Artemis_01", Icon = "Keepsake_ArtemisSticker_Max" },
					Text = "I never felt like I could be myself with everybody on this mountaintop, you know? So much posturing, and bickering, and... I just head out to the woods most of the time. Maybe you understand me better than the rest, I've no idea still. But I appreciate you've made attempts to try." },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Lady Artemis, you honor me.
			{ Cue = "/VO/ZagreusHome_0326" },
		},

		ShoutActivationSound = "/SFX/ArtemisWrathArrow",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "ArtemisUpgrade",

				-- Nowhere to hide from me!
				{ Cue = "/VO/Artemis_0067" },
				-- Picked up their scent!
				{ Cue = "/VO/Artemis_0068" },
				-- I'll take care of this!
				{ Cue = "/VO/Artemis_0069" },
				-- Care to hunt with me?
				-- { Cue = "/VO/Artemis_0075" },
				-- Oh hi remember me?
				{ Cue = "/VO/Artemis_0077" },
				-- You got it.
				-- { Cue = "/VO/Artemis_0078" },
				-- Understood.
				-- { Cue = "/VO/Artemis_0079" },
				-- I have them in my sights!
				{ Cue = "/VO/Artemis_0178" },
				-- I hear you, firing!
				{ Cue = "/VO/Artemis_0179" },
				-- They are as good as dead!
				{ Cue = "/VO/Artemis_0180", RequiredMinKillEnemies = 2 },
				-- All right, taking the shot!
				{ Cue = "/VO/Artemis_0181" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "ArtemisUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- How dare you.
				{ Cue = "/VO/Artemis_0101" },
				-- What is the matter with you.
				{ Cue = "/VO/Artemis_0104" },
				-- What are you doing?
				{ Cue = "/VO/Artemis_0105" },
				-- I can't believe this.
				{ Cue = "/VO/Artemis_0106" },
				-- Is this some sort of joke?
				{ Cue = "/VO/Artemis_0107" },
				-- Sure, I don't see why not!
				{ Cue = "/VO/Artemis_0182" },
				-- Oh let me get right on it, Zagreus!
				{ Cue = "/VO/Artemis_0183" },
				-- Pray I don't accidentally miss my mark!
				{ Cue = "/VO/Artemis_0184" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidArtemisRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			RequiredFalseTextLinesThisRoom = { "ArtemisRevealsRamaAspect01", },
			UsePlayerSource = true,

			-- A keen offer, Lady Artemis.
			{ Cue = "/VO/ZagreusField_1890" },
			-- A tempting offer, Lady Artemis.
			{ Cue = "/VO/ZagreusField_1891" },
			-- Lady Artemis, I accept.
			{ Cue = "/VO/ZagreusField_1892" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- You may be good at running, Zagreus, but you're bad at hiding.
			{ Cue = "/VO/Artemis_0199" },
			-- You make me mad, I'll hunt you like a stag. You heard of those?
			{ Cue = "/VO/Artemis_0200" },
			-- Don't anger me next time, won't shoot you dead, is it a deal?
			{ Cue = "/VO/Artemis_0201" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.ArtemisVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- How goes it, Zagreus?
			{ Cue = "/VO/Artemis_0073" },
			-- Hey it's me again.
			{ Cue = "/VO/Artemis_0074" },
			-- Care to hunt with me?
			{ Cue = "/VO/Artemis_0075" },
			-- Glad you're still in one piece.
			{ Cue = "/VO/Artemis_0076" },
			-- Now here's something for you.
			{ Cue = "/VO/Artemis_0090" },
		},

	},

	-- Aphrodite
	AphroditeUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolAphrodite",
		BoonInfoIcon = "BoonInfoSymbolAphroditeIcon",
		DoorIcon = "BoonSymbolAphroditeIsometric",
		Color = { 255, 192, 203, 255 },
		LightingColor = {255, 196, 240, 255},
		LootColor = {255, 50, 240, 255},
		SubtitleColor = {1.000, 0.353, 0.675, 1.0},
		EventEndSound = "/SFX/AphroditeBoonLoveChimes",
		UpgradeSelectedSound = "/SFX/AphroditeBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Aphrodite",

		RequiredMinCompletedRuns = 1,

		PriorityUpgrades = { "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeRushTrait", "AphroditeRangedTrait", "ShieldLoadAmmo_AphroditeRangedTrait"},
		WeaponUpgrades = { "AphroditeWeaponTrait", "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
		Traits = { "AphroditeRetaliateTrait", "AphroditeDeathTrait", "ProximityArmorTrait", "HealthRewardBonusTrait" },
		Consumables = { },

		LinkedUpgrades =
		{
			AphroditeDurationTrait =
			{
				OneOf = { "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
			},
			AphroditeRangedBonusTrait  = {
				OneOf = { "AphroditeRangedTrait" },
			},
			AphroditeWeakenTrait =
			{
				OneOf = { "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
			},
			AphroditePotencyTrait =
			{
				OneOf = { "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
			},
			CharmTrait =
			{
				OneFromEachSet =
				{
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
					{ "AphroditeDurationTrait", "AphroditeWeakenTrait", "AphroditePotencyTrait" },
				}
			},
			CurseSickTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				},
			},
			RegeneratingCappedSuperTrait =
			{
				OneFromEachSet =
				{
					{ "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeRangedTrait", "AphroditeRushTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			SelfLaserTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterRangedTrait" },
					{ "AphroditeWeaponTrait", "AphroditeRushTrait", "AphroditeSecondaryTrait", "AphroditeRangedTrait", "AphroditeShoutTrait" },
				}
			},
			HeartsickCritDamageTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			CastBackstabTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait"},
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			ImprovedPomTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			DionysusAphroditeStackIncreaseTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
		},

		Speaker = "NPC_Aphrodite_01",
		Portrait = "Portrait_Aphrodite_Default_01",
		WrathPortrait = "Portrait_Aphrodite_Wrath_01",
		OverlayAnim = "AphroditeOverlay",
		Gender = "Female",
		SpawnSound = "/SFX/AphroditeBoonLoveChimes",
		FlavorTextIds =
		{
			"AphroditeUpgrade_FlavorText01",
			"AphroditeUpgrade_FlavorText02",
			"AphroditeUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "AphroditeFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },

			-- Lady Aphrodite...
			{ Cue = "/VO/ZagreusField_0682" },
			-- Hi, Aphrodite.
			{ Cue = "/VO/ZagreusField_0683" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			AphroditeWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "RegeneratingCappedSuperTrait",
				{ Cue = "/VO/Aphrodite_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Dearest, your lord uncle wishes to address you from our mountaintop, although I had assured him that the two of us, we had everything well under control!" },
				{ Cue = "/VO/Zeus_0199",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Come now, Zagreus, the only thing Lady Aphrodite has under control is her long list of salivating suitors, am I right? Aphrodite, how about you bestow your blessing and be off, and I'll take it from here." },
			},
			AphroditeWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ImprovedPomTrait",
				{ Cue = "/VO/Aphrodite_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "The thing to know about this family, dearest, is that, each of us, we have our little quirks. Although, we always stick together and our love for one another perseveres!" },
				{ Cue = "/VO/Poseidon_0131",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Oh, {#DialogueItalicFormat}hoh{#PreviousFormat}! What do we have here, little Hades? Seems to me that you have {#DialogueItalicFormat}company{#PreviousFormat}! Well, I'll just leave the two of you alone. My lips are sealed tighter than a warship hull!" },
				{ Cue = "/VO/Aphrodite_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Text = "Oh, feel free to stay, Poseidon! I was just explaining what an idiot you are, though you're able to articulate this best! Anyway, dearest, what was I on about...?" },
			},
			AphroditeWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CastBackstabTrait",
				{ Cue = "/VO/Aphrodite_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "You must forgive us, little godling, meaning our extended family here upon Olympus! Some of us are terribly stuck up, and must be making matters much more complicated than they have to be." },
				{ Cue = "/VO/Athena_0123",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "I wonder, dearest Aphrodite, whether you'd be willing to repeat such things directly to my countenance?" },
				{ Cue = "/VO/Aphrodite_0183",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Oh, you must know full well that I would do much more than that directly to your countenance, Athena dear! Quite frankly, you could use a lot of work!" },
			},
			AphroditeWithAthena02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeWithAthena01" },
				HasTraitNameInRoom = "CastBackstabTrait",
				{ Cue = "/VO/Aphrodite_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Dearest, you must know, Goddess Athena and myself, we don't always share a common view, perhaps because she overthinks things constantly, while my heart leads me on!" },
				{ Cue = "/VO/Athena_0124",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "I'm glad we understand each other, then. It would be most embarrassing to be caught bickering amongst ourselves in front of Zagreus." },
			},
			AphroditeWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CurseSickTrait",
				{ Cue = "/VO/Aphrodite_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "I think for many of us, dearest, it can come as a surprise to learn that love and war often go hand in hand. Opposite forces, yet this connects them, doesn't it. The fiercest passions of gods and mortals! Isn't that right, Lord Ares?" },
				{ Cue = "/VO/Ares_0226",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Mortals are so bent on clinging to their lives, that many among them would gladly kill for it. The surge of emotion which they feel... one passion is no different from another, Lady Aphrodite, dear." },
			},
			AphroditeWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HeartsickCritDamageTrait",
				RequiredTextLines = { "AphroditeGift01", "ArtemisGift01" },
				{ Cue = "/VO/Aphrodite_0185",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Oh dearest! I have brought you keen-eyed Artemis, who, in her focus on the hunt, has not developed social graces suitable enough to come to you herself!" },
				{ Cue = "/VO/Artemis_0239",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Social graces, she says! Going about like {#DialogueItalicFormat}that{#PreviousFormat}! I'm sure you know that I can find you when it's necessary, Zagreus. Though, how to get away from Aphrodite, I have no idea."
				},
			},
			AphroditeWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "DionysusAphroditeStackIncreaseTrait",
				{ Cue = "/VO/Aphrodite_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "My powers, dearest, oft go hand-in-hand with those of Dionysus, with his power to persuade the mind to find such beauty where it isn't, really!" },
				{ Cue = "/VO/Dionysus_0211",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Emote = "PortraitEmoteCheerful",
					Text = "{#DialogueItalicFormat}Ah, haha{#PreviousFormat}, no need to flatter me like that, there, Lady Aphrodite! Beauty's almost entirely within the mind, I'm sure! And in the muscles and the jawline and the winning smile and, well, who am I to tell you, yeah?" },
			},
			AphroditeWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SelfLaserTrait",
				{ Cue = "/VO/Aphrodite_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "The venerable goddess of the seasons, Demeter, chooses to look as stately as can be, can you believe it, dearest? Although, why one would mark so many fine lines upon their face, I wouldn't know." },
				{ Cue = "/VO/Demeter_0152",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Oh, Aphrodite, dear... you wouldn't know a thing of substance if it offered you a cloak. Your chosen countenance makes plain the full extent of your intentions, and your interests alike." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			AphroditeAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4339", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.33 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "OK, I think I'm ready. In the name of Hades! Olympus, this is an official message! And I hope it finds you well, Lady Aphrodite!" },
				{ Cue = "/VO/Aphrodite_0207",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Why, {#DialogueItalicFormat}this {#PreviousFormat}is something, dearest! Such an enigmatic message you have sent. How positively captivating; I must know what it says. It bears the marks of others on Olympus, so... perhaps we ought to share some common knowledge on the subject, hm?" },
			},
			AphroditePostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Oh, dearest, you've no idea what a delightful time I had while visiting you recently! So many new sights and sounds and smells, why, it was wonderful! And you are burdened with a big responsibility, aren't you? Mind if I lend my graces to you still from time to time...?" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			AphroditeAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				{ Cue = "/VO/Aphrodite_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lord Zeus has made acquaintances with you? Oh I sometimes forget that he's your uncle! His favor's well worth having, I assure you." },
			},
			AphroditeAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				{ Cue = "/VO/Aphrodite_0045",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That oaf Poseidon spoke to you already, didn't he? All bluster, muscles, and bravado, that one. I'm glad you're not the type." },
			},
			AphroditeAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				{ Cue = "/VO/Aphrodite_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've met Athena, dearest, so you know not all the ladies on Olympus are alike. And I, for one, am grateful to our forebears for {#DialogueItalicFormat}that{#PreviousFormat}!" },
			},
			AphroditeAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "AphroditeGift01" },
				RequiredGodLoot = "AresUpgrade",
				{ Cue = "/VO/Aphrodite_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I sense the mark of my Lord Ares on you, love. He's poorly understood among the gods, yet surely you can see fair qualities in him, and me?" },
			},
			AphroditeAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				{ Cue = "/VO/Aphrodite_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The sullen Artemis reached out to you, did she? Oh, that's adorable, dearest! Just don't make any sudden movements with her, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				{ Cue = "/VO/Aphrodite_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are so fortunate to have received the Boon of Dionysus prior to my own! He, the most noble and important of us all, the god of wine, himself!" },
			},
			AphroditeAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/Aphrodite_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, did sorrowful old Demeter get all the way to you before I did? She stubbornly refuses me when I offer to help! Unlike you, little godling!" },
			},

			AphroditePostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift01", },
				{ Cue = "/VO/Aphrodite_0040",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How I {#DialogueItalicFormat}love {#PreviousFormat}to have these unexpected little run-ins with you, love! You are just so spontaneous, and I've a liking for that sort of thing!" },
			},
			AphroditePostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift02", },
				{ Cue = "/VO/Aphrodite_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Keep following that heart of yours, dearest! It's good enough a guide, believe you me. Mine tells me you are going to succeed!" },
			},

			AphroditePostGiftPickup04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift04", },
				{ Cue = "/VO/Aphrodite_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You {#DialogueItalicFormat}do {#PreviousFormat}know that I'm married, don't you, love...? I'd forgive you if you didn't, for my husband, he's always... busy with his work. I'm grateful that you're there for me to talk to." },
			},

			AphroditePostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0059",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're going to love it on Olympus, little godling. The air is beautiful and brisk, the gardens lush, the feasting plentiful...! Why, it must be the opposite of everything to which you are accustomed!" },
			},
			AphroditePostFlashback02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditePostFlashback01", },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAffection", WaitTime = 4.5 },
					Text = "What shall we do here once you finally arrive? Perhaps we could go out and meet some {#DialogueItalicFormat}mortals{#PreviousFormat}! I know all too many maidens and/or noble gentlemen who'd absolutely love to get to know you." },
			},

			AphroditeVsAchilles01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift01", "AchillesGift01", },
				RequiredFalseTextLinesLastRun = { "AphroditeGift01", "AchillesGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A little bird once told me that the shade of the great hero called Achilles now resides within your father's residence, dearest? I always wished to meet with him someday..." },
			},
			AphroditeVsAchilles02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeVsAchilles01", "AchillesPostFlashback01" },
				{ Cue = "/VO/Aphrodite_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You met Achilles after all, godling. He was quite instrumental in a war of my design. Still, he resisted my attempts to sway his actions. You tell him, simply, I admire him." },
			},
			AphroditeVsAchilles03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeVsAchilles02", "AchillesAboutPatroclus04" },
				{ Cue = "/VO/Aphrodite_0179",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The great hero Achilles, he continues to ignore my polite outreach, doesn't he? Why, I've attempted to reach out at least several times! Your father's realm is really quite a lot. How terribly frustrating it must be!" },
			},

			AphroditeVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "FuryFirstAppearance" },
				RequiredRoomLastRun = "A_Boss01",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "AphroditeAboutMegRelationship01" },
				{ Cue = "/VO/Aphrodite_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've had a brush with Megaera, the Fury, haven't you? Oh I know a thing or two about that one. Though, lately we Olympians no longer mingle with those living in the Underworld. You're the only exception!" },
			},
			AphroditeVsMeg02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "MegaeraGift07" },
				RequiredFalseTextLinesLastRun = { "MegaeraGift07" },
				RequiredFalseTextLines = { "AphroditeAboutMegRelationship01" },
				{ Cue = "/VO/Aphrodite_0055",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A little birdy told me recently that you and Megaera the Fury, why, you've grown quite close! Now {#DialogueItalicFormat}do {#PreviousFormat}be careful around her, and, try not to get attached, there, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},

			AphroditeAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceAphroditeBoonTrait",

				{ Cue = "/VO/Aphrodite_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Why, you have my Eternal Rose, don't you? I am so very touched that you'd think first of me among my mighty kin. It pleases me to know I'm in your thoughts!" },
			},
			AphroditeRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeAboutPersephoneMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Aphrodite_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh what is going {#DialogueItalicFormat}on {#PreviousFormat}down there, dearest? I thought for certain you would make it out, but seems that nasty place has kept you grounded, hasn't it. But don't despair, and you take heart, won't you?" },
			},
			AphroditeAboutPersephoneMeeting01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "PersephoneFirstMeeting" },
				{ Cue = "/VO/Aphrodite_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",					
					Text = "Something has stirred within your heart, dearest! Oh, I can always tell! A certain kind of love, for family? Yes, that must be it, I think! What could have transpired with you, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditePostEpilogue02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditePostEpilogue01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "To think your father and that sweet Persephone, they were together down there, all along! I was so certain that your father's heart was cold. That's just the thing with love, dearest! That, sometimes, it surprises even me!" },
			},

			AphroditeHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift07" },
				RequiredFalseTextLinesLastRun = { "AphroditeGift07" },
				{ Cue = "/VO/Aphrodite_0206",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My dearest little godling, how fares everything with you of late? I love to have these little interactions with you, simple as they are, for they have brightened many of my evenings here." },
			},

			AphroditeAboutLove01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift03" },
				{ Cue = "/VO/Aphrodite_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Little godling, you must know the seven types of love by now, don't you? It's quite a complicated field, though several types intrigue me most of all. In fact, why, I have several types of love for you, right here!" },
			},
			AphroditeAboutLove02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutLove01" },
				-- this is for backward compatability
				RequiredAnyTextLines = { "AphroditeGift06", "AphroditeGift07" },
				RequiredMinAnyTextLines = { TextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B", "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B", "BecameCloseWithDusa01" }, Count = 3 },
				{ Cue = "/VO/Aphrodite_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Dearest, why... I sense your heart is very full, indeed! You positively emanate with love. You must have grown quite close to many dear to you. Perhaps so you may do the same with me...? I'm so delighted to have seen your spirit shine." },
			},
			AphroditeAboutLove03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutLove02", "CerberusGift09", "AchillesGift09_A", "PatroclusGift08_A", "ThanatosGift10", "MegaeraGift10", "BecameCloseWithDusa01", "NyxGift09", "HypnosGift08", "CharonGift07", "SkellyGift09", "SisyphusGift09_A", "PersephoneGift09", "EurydiceGift08", "OrpheusGift08", "HadesGift05", "ZeusGift07", "DemeterGift07", "ArtemisGift07", "AphroditeGift07", "AresGift07", "AthenaGift07", "DionysusGift07", "PoseidonGift07", "ChaosGift08" },
				RequiredAnyTextLines = { "HermesGift08", "HermesGift08B"},
				{ Cue = "/VO/Aphrodite_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Oh, my, dearest! I have to say, your heart is positively bursting with such love for so many you have come to care about! Your dearest friends, your burning passions, family, {#DialogueItalicFormat}everyone{#PreviousFormat}! Why, you're like a living testament to my entire body of work!" },
			},

			AphroditeBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				{ Cue = "/VO/Aphrodite_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I cannot help but wonder, dearest, why Lord Hades would have kept your mere existence hidden from us all this time. Perhaps he knew that, once you met us, you would stop at nothing to come seek us out!" },
			},

			AphroditeAboutMegRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				{ Cue = "/VO/Aphrodite_0173",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "I sense you finally acted on your pent-up passion for the Fury Megaera, yes, little godling? These types of things, they don't escape my notice, and they're always so enjoyable to see!" },
			},
			AphroditeAboutMegRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutMegRelationship01" },
				RequiredMinAnyTextLines = { TextLines = { "MegIntermissionChat01", "MegIntermissionChat02", "MegIntermissionChat03", "MegIntermissionChat04", "MegIntermissionChat05", "MegIntermissionChat06" }, Count = 2 },
				{ Cue = "/VO/Aphrodite_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "How's fearsome Megaera the Fury treating you of late, {#DialogueItalicFormat}hmm{#PreviousFormat}, dearest? I know her type so very well, indeed. She acts as though there's nothing that can get under her skin, isn't that right?" },
			},
			AphroditeAboutThanRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				{ Cue = "/VO/Aphrodite_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "{#DialogueItalicFormat}Mmm{#PreviousFormat}, so my heart tells me that you've developed quite the bond with moody Thanatos, haven't you, there? I always figured that his brooding quality was just an act!" },
			},
			AphroditeAboutThanRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutThanRelationship01" },
				RequiredMinAnyTextLines = { TextLines = { "ThanatosHomeIntermissionChat01", "ThanatosHomeIntermissionChat02", "ThanatosHomeIntermissionChat03", "ThanatosHomeIntermissionChat04", "ThanatosHomeIntermissionChat05", "ThanatosHomeIntermissionChat06" }, Count = 2 },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				{ Cue = "/VO/Aphrodite_0176",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Little godling, would that I knew every last detail of how you and Thanatos are getting on of late! The notorious incarnate of death, and the newly discovered son of Hades, fraternizing? It's positively scandalous I think!" },
			},
			AphroditeAboutDusaRelationship01 =
			{
				Priority = true,
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DusaGift08" },
				RequiredFalseTextLinesLastRun = { "DusaGift08" },
				RequiredFalseTextLines = { "BecameCloseWithDusa01" },
				{ Cue = "/VO/Aphrodite_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, dearest? If my perfectly developed senses are correct, then you appear to be quite smitten with a little gorgon that you've met down there...? Why that must be adorable, if rather strange! " },
			},
			AphroditeAboutDusaRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift02", "BecameCloseWithDusa01" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithDusa01" },
				{ Cue = "/VO/Aphrodite_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Why, something's changed about the beating of your heart, dearest! {#DialogueItalicFormat}Oh{#PreviousFormat}, it's the little gorgon, isn't it. You Underworld dwellers and your complicated feelings! I can never get enough. My blessings to the both of you, then, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},

			AphroditeLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Aphrodite_0078",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",					
					Text = "Oh, look at you, you poor, poor thing, you're hurt! Though, let me see if I can make it better." },
			},
			AphroditeLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Aphrodite_0079",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Tsk{#PreviousFormat}, you're in no condition for an outing with me, dearest. Though, perhaps you might recover from your hardships with my aid?" },
			},
			AphroditeLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Aphrodite_0200",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dearest, why, your heart rate's fluctuating wildly! Has it really been that bad up to this point? I'll try to help however much I can." },
			},
			AphroditeLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Aphrodite_0201",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, you're just in an awful situation, aren't you. Yet, I can tell your proud heart keeps on beating, for the moment anyway! Don't die just yet!" },
			},
			AphroditeLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Aphrodite_0202",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, little godling, you're about to die! Why, none of us want {#DialogueItalicFormat}that{#PreviousFormat}, because if so, you won't get to enjoy my blessings here!" },
			},

			AphroditeLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have been waiting for a special moment to confess my great appreciation for your deeds... this moment's special enough, isn't it?" },
			},
			AphroditeLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0033",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My loveliest of blessings is reserved only for those who've earned my deepest adoration. So, congratulations, love! And here you go!" },
			},
			AphroditeLegendaryPickUp03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0158",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sometimes, our hearts become so full that they could burst! If only you could see how much I care. I would do anything to aid you in your plight! My heartfelt blessings be with you, dearest." },
			},
			AphroditeLegendaryPickUp04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Little godling, you must know that the heart has infinite capacity for empathy. And I so feel for you there, that I have mustered for you some of the most beautiful of blessings I can offer!" },
			},

		},

		PickupTextLineSets =
		{
			AphroditeFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0782", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.23 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "I must be a mess, let's see here. Hi there! In the name of Hades! Olympus, I accept this message." },
				{ Cue = "/VO/Aphrodite_0010",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Why hello, hello, there, little godling. I have to say you're quite the specimen, and so, I've decided I shall aid you for the moment. You interested?" },
			},
			AphroditeMiscPickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0011",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Did you miss me, little godling, {#DialogueItalicFormat}hm{#PreviousFormat}? I thought I'd steal away a bit and that together we might make up for lost time." },
			},
			AphroditeMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0012",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hello again, there, little godling, let's get to it, {#DialogueItalicFormat}hm{#PreviousFormat}? I want what you want; there's no further need for words." },
			},
			AphroditeMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseRooms = { "RoomOpening" },
				RequiredMaxHealthFraction = 0.75,
				{ Cue = "/VO/Aphrodite_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",					
					Text = "Oh, boo, looks like you've rather got yourself into a bind, there, haven't you. Though, not to worry, dearest. I can pull some strings." },
			},
			AphroditeMiscPickup04 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There, there, dearest, you'll tell me all your troubles just as soon as you arrive, so let's just get you out of there for now." },
			},
			AphroditeMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What is it, love, are you still having problems with the dead? I swear, you'd think they had enough of me in life!" },
			},
			AphroditeMiscPickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What did I miss since last time, anything of interest, {#DialogueItalicFormat}hm{#PreviousFormat}? You'll have to fill me in once you break free, dearest." },
			},
			AphroditeMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0017",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, look at you, there, love! So well-prepared to take on any danger that may come! But, I must wonder, are you well-prepared for {#DialogueItalicFormat}this{#PreviousFormat}?" },
			},
			AphroditeMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ready yourself, dearest, because you and I? We're going to have ourselves a little outing I expect that neither one of us shall soon forget." },
			},
			AphroditeMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Would you by any chance have room, there, in your heart for a most-gentle blessing from a goddess such as me?" },
			},
			AphroditeMiscPickup10 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't lose heart, now, little godling! I won't have you giving up before you get to see me in the flesh among the gardens of Olympus here...!" },
			},
			AphroditeMiscPickup11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dearest, I've known many gods and godlings through the ages. And, I have to say, you're {#DialogueItalicFormat}quite {#PreviousFormat}intriguing, even for our kind." },
			},
			AphroditeMiscPickup12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, dearest, I suspect we'll have ourselves a most exciting time together, you and I! Just do your best and it'll all be fine!" },
			},
			AphroditeMiscPickup13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am always here, or close enough, to help you through whatever troubles you may face, my little godling. So do not hesitate to call upon me, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				MinRunsSinceAnyTextLines = { TextLines = { "AphroditePostEpilogue01" }, Count = 3 },				
				{ Cue = "/VO/Aphrodite_0024",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd ask you show me a good time, there, love, although I almost can't imagine a good time where you reside! So dreary, constantly!" },
			},
			AphroditeMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				{ Cue = "/VO/Aphrodite_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I missed you terribly, my little godling! All that I ask is that you do not die on me again, why, I don't think that I can take it anymore!" },
			},
			AphroditeMiscPickup16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How you must yearn to reach the surface, little godling! It likewise stirs in me a yearning to assist you, by all means at my disposal!" },
			},
			AphroditeMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0027",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No need to worry any longer, dearest! I bring you strength and comfort, and I shall be watching every step of yours most carefully." },
			},
			AphroditeMiscPickup18 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0028",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, how I long to see you face-to-face! Until such time, however, this old means of keeping touch shall have to do. So you take care, now, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup19 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0029",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know I would do anything to have you here among us, don't you, love? Oh, I just hope my blessings are enough...!" },
			},
			AphroditeMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Love tends to blossom in the strangest places at the strangest times, you know that, don't you, dearest? All one can do is entertain the chance." },
			},
			AphroditeMiscPickup21 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't work yourself too hard down there, you promise, little godling? We need you in good shape and spirits on Olympus here." },
			},

			-- shorter acknowledgments
			AphroditeMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0002",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say we skip the chat and get right to it, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, would you look at whom I found, all by his lonely self." },
			},
			AphroditeMiscPickup24 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's see what mischief we can make, between the two of us!" },
			},
			AphroditeMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You want my blessings, dearest, here they are!" },
			},
			AphroditeMiscPickup26 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I hope I didn't keep you waiting very long, did I?" },
			},
			AphroditeMiscPickup27 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Even immortal hearts can break, my little godling." },
			},
			AphroditeMiscPickup28 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0008",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say we go and make new friends together, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup29 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You seem like you could use a helping hand, there, love." },
			},

			AphroditeMiscPickup30 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The bond of love is strong enough to suffer any hardship, dearest." },
			},
			AphroditeMiscPickup31 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Times of adversity make love grow even stronger, little godling." },
			},
			AphroditeMiscPickup32 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I hate to see you struggling, dearest! Please do be careful, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup33 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Love conquers everything, you see that, don't you, dearest?" },
			},
			AphroditeMiscPickup34 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Think of all those you love, and may they spur your courage, little godling." },
			},
			AphroditeMiscPickup35 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your passion to achieve your goal is quite inspiring, I have to say!" },
			},
			AphroditeMiscPickup36 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's such a pity I can barely see you in that awful darkness, little godling." },
			},
			AphroditeMiscPickup37 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Love spurs the heart to greater acts of valor, doesn't it, dearest?" },
			},
			AphroditeMiscPickup38 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0150",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Take heart, now, little godling. And how about you take this from me, as well." },
			},
			AphroditeMiscPickup39 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd love to help you however best I'm able, my little godling." },
			},

			AphroditeMiscPickupRare01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have the loveliest selection of my blessings for you this time, dearest!" },
			},
			AphroditeMiscPickupRare02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0153",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I think I'll give you something very special this time, little godling." },
			},
			AphroditeMiscPickupRare03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Is not the purest act of love to aid somebody in their time of need?" },
			},
			AphroditeMiscPickupRare04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0155",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm feeling wonderful of late, dearest, so here, enjoy the benefits!" },
			},

		},

		BoughtTextLines =
		{
			AphroditeLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Looks like we meet again, dearest, here among the foul detritus of the boatman's wares! You truly take me to the best of places!" },
			},
			AphroditeLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "At first I didn't know how to get through to that odd river-boatman, Charon. Turns out he lusts for coin, and now I understand him well!" },
			},
			AphroditeLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0156",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You spent your hard-earned wealth on my account, dearest? Why if that isn't just the sweetest thing!" },
			},
			AphroditeLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "One cannot put a price on love, but on my blessings, from the boatman, for my dearest? I'd say we're settled up." },
			},
		},

		RejectionTextLines =
		{
			AphroditeRejection01 =
			{
				{ Cue = "/VO/Aphrodite_0063",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "And here I was beginning to think that we had something special going, no...? Look here, little godling, let me save you lots of future suffering: I happen to be the jealous type." },
			},
			AphroditeRejection02 =
			{
				{ Cue = "/VO/Aphrodite_0064",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'd best not take for granted my affection, godling. Yes, I've lots of it to go around; but I can just as easily rescind such privileges." },
			},
			AphroditeRejection03 =
			{
				{ Cue = "/VO/Aphrodite_0065",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "They say a lot of things about me, dearest; and they'll tell you, in your dealings with me, ample caution is in order. Let me show you why." },
			},
			AphroditeRejection04 =
			{
				{ Cue = "/VO/Aphrodite_0066",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't {#DialogueItalicFormat}ever {#PreviousFormat}take me for some thoughtless nymph to be manipulated, dearest. I expect reciprocal devotion from you. Do you understand?" },
			},
			AphroditeRejection05 =
			{
				{ Cue = "/VO/Aphrodite_0067",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Oh, {#DialogueItalicFormat}really{#PreviousFormat}? You shall find I don't take such rejections lying down. And you shall find it out the hard way." },
			},
			AphroditeRejection06 =
			{
				{ Cue = "/VO/Aphrodite_0068",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "If it's your wish to test the limits of the fine relationship we've built, why then... I can confirm you're testing them, all right!" },
			},
			AphroditeRejection07 =
			{
				{ Cue = "/VO/Aphrodite_0133",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Now, dearest... surely there's no way that could have been one of the wiser choices that you've lately made?" },
			},
			AphroditeRejection08 =
			{
				{ Cue = "/VO/Aphrodite_0134",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Dearest, just in case it hasn't been made clear as crystal lately, let me tell you: When presented with the opportunity, don't {#DialogueItalicFormat}ever {#PreviousFormat}reject me." },
			},
			AphroditeRejection09 =
			{
				{ Cue = "/VO/Aphrodite_0135",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'd spurn my love this easily, dearest? You are about to find the consequences are much harder to dismiss without a second thought." },
			},
			AphroditeRejection10 =
			{
				{ Cue = "/VO/Aphrodite_0136",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "I must admit I'm unaccustomed to rejection, love. But {#DialogueItalicFormat}you {#PreviousFormat}must be accustomed to swift death! Here comes one for you now." },
			},
			AphroditeRejection11 =
			{
				{ Cue = "/VO/Aphrodite_0213",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Oh, but this is such a heartbreak, dearest! Why would you do that? You know that I won't take this lying down." },
			},
			AphroditeRejection12 =
			{
				{ Cue = "/VO/Aphrodite_0214",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "You {#DialogueItalicFormat}dare {#PreviousFormat}to play with {#DialogueItalicFormat}my {#PreviousFormat}heart, little godling? I'll just take yours, and shatter it to pieces, then, I think!" },
			},
			AphroditeRejection13 =
			{
				{ Cue = "/VO/Aphrodite_0215",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sometimes I think that you're quite {#DialogueItalicFormat}different {#PreviousFormat}than most all the others here, darling. And then, you go and do something like {#DialogueItalicFormat}this{#PreviousFormat}." },
			},
			AphroditeRejection14 =
			{
				{ Cue = "/VO/Aphrodite_0216",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "You think you can brush me aside like that? Well, I think I can crush you into tiny, little bits! Let's see who's right, shall we?" },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Forgive me, Aphrodite.
				{ Cue = "/VO/ZagreusField_0407" },
				-- Lady Aphrodite, I'm sorry.
				{ Cue = "/VO/ZagreusField_4143" },
				-- Don't hate me, Aphrodite.
				{ Cue = "/VO/ZagreusField_4144" },
				-- Aphrodite won't appreciate this.
				{ Cue = "/VO/ZagreusField_4145" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			AphroditeMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0069",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's say we kissed and made up, dearest. Just, do not anger me again, or I might come down and kill you there myself!" },
			},
			AphroditeMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0070",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Alas that passion sometimes drives me into vengeance, dearest! Yet, who among us isn't without vices, hm?" },
			},
			AphroditeMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0071",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, how I hate to fight with you like this! Let's forgive each other and forget, go back to how things used to be?" },
			},
			AphroditeMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm not angry with you any longer, dearest! Though, might I suggest you take some extra steps to keep it that way, hm?" },
			},
			AphroditeMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0073",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAffection", WaitTime = 7.6 },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A loving heart is a forgiving heart, don't you agree? So I shall let this little matter slide, and you've my loving heart to thank for it, {#DialogueItalicFormat}hm-hm{#PreviousFormat}!" },
			},
			AphroditeMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The truth is I'm a lover, not a fighter, dearest. So how about we call this matter put to bed, and get on with our lives?" },
			},
			AphroditeMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd say this little squabble can be put to bed, for now. I'm better for the moment, but I was very angry with you, love!" },
			},
			AphroditeMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0138",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I cannot bring myself to stay upset with you forever, little godling, so let's move along from that small misunderstanding there." },
			},
			AphroditeMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There is no common sense with love, godling, so... why don't we pretend your indiscretion there did not occur." },
			},
			AphroditeMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It is through times of difficulty that the love we share is tested and reforged. But you just watch yourself when testing it like that." },
			},
			AphroditeMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Love and jealousy go hand in hand, don't they, dearest? Although the former's much more pleasant, isn't it." },
			},
			AphroditeMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0217",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, all this fighting! It's just not like us at {#DialogueItalicFormat}all{#PreviousFormat}, dearest! Let's say we kissed and then made up, all right?" },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			AphroditeGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0125", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lady Aphrodite, I am truly blessed simply to have made your acquaintance, so, this is for you." },
				{ Cue = "/VO/Aphrodite_0037",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lasting relationships are built on reciprocity. So if you lavish me with gifts, why, what am I to do but give you something in return?" },
			},
			AphroditeGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift01" },
				{ Cue = "/VO/ZagreusHome_0536", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "My lady Aphrodite, if not for our acquaintance, I am certain that my days or nights would be much drearier indeed." },
				{ Cue = "/VO/Aphrodite_0034",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, dearest, such a wonderfully thoughtful gift, for me? I love it, and I would be lying if I said you shouldn't have!" },
			},
			AphroditeGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift02" },
				{ Cue = "/VO/ZagreusHome_0537", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lady Aphrodite, I'm afraid there really isn't much here worthy of you, but perhaps this can suffice." },
				{ Cue = "/VO/Aphrodite_0035",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My, but if this isn't such a treasure to behold, and I accept it as a sign of your affection! Of something even more, perhaps...?" },
			},
			AphroditeGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift03" },
				{ Cue = "/VO/ZagreusHome_0538", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dear Aphrodite, surely you have all the offerings you can stand, but I would ask that you accept one more." },
				{ Cue = "/VO/Aphrodite_0036",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, dearest, but it stirs my heart to know you care so deeply for our wonderful relationship! To celebrate it with such princely gifts!" },
			},
			AphroditeGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift04" },
				{ Cue = "/VO/ZagreusField_3469", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dear Aphrodite, the incomparable beauty of Olympus is less difficult to fathom, having already met you. I am so grateful to have earned your favor." },
				{ Cue = "/VO/Aphrodite_0203",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My, but don't {#DialogueItalicFormat}you {#PreviousFormat}come on rather strong, there, little godling! Though, I can take much more of your affections, you shall see!" },
			},
			AphroditeGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift05" },
				{ Cue = "/VO/ZagreusField_3470", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Aphrodite, you must have more worshipers and suitors than all your kin upon Olympus combined. I may not fall exactly into either category, though I hope you know my gratitude for all you've done for me is true." },
				{ Cue = "/VO/Aphrodite_0204",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, dearest, I am more worshiped than perhaps anybody else upon Olympus! You'd think getting such praise would roll right off my back by now, but no! I love receiving it. Especially from you." },
			},
			AphroditeGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift06" },
				{ Cue = "/VO/ZagreusField_3471", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "My lady Aphrodite, once more you've graced me with your presence and your favor, which inspire the best from me. Let this modest gift of Ambrosia signify I'm forever in your debt." },
				{ Cue = "/VO/Aphrodite_0205",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Aphrodite_01", Icon = "Keepsake_AphroditeSticker_Max" },
					Text = "My little godling. I'd say you've honored me more times than I could count, but that would be a lie, now, wouldn't it. I so admire your devotion and your perseverance! If ever you do reach us on Olympus, I should very much enjoy getting to know you even better, then." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I'm honored, Aphrodite.
			{ Cue = "/VO/ZagreusHome_0325" },
		},

		ShoutActivationSound = "/SFX/AphroditeWrathLoveChimes",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "AphroditeUpgrade",

				-- You're going to love this!
				{ Cue = "/VO/Aphrodite_0075" },
				-- Who dares threaten my little godling?
				{ Cue = "/VO/Aphrodite_0076" },
				-- Just leave it to me, dearest!
				{ Cue = "/VO/Aphrodite_0077" },
				-- Would be my pleasure!
				{ Cue = "/VO/Aphrodite_0087" },
				-- I like the sound of that.
				{ Cue = "/VO/Aphrodite_0088" },
				-- When shall they ever learn?
				{ Cue = "/VO/Aphrodite_0104" },
				-- I'll pierce them through the heart!
				{ Cue = "/VO/Aphrodite_0166", RequiredMinKillEnemies = 2 },
				-- Let's complicate things, hm?
				{ Cue = "/VO/Aphrodite_0167" },
				-- Oh it shall be my pleasure!
				{ Cue = "/VO/Aphrodite_0168" },
				-- Pure passion, coming up!
				{ Cue = "/VO/Aphrodite_0169" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "AphroditeUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Of all the nerve, dearest!!
				{ Cue = "/VO/Aphrodite_0170" },
				-- You call upon me now?
				{ Cue = "/VO/Aphrodite_0171" },
				-- I'll break your heart next!
				{ Cue = "/VO/Aphrodite_0172" },
				-- Best not to anger me.
				{ Cue = "/VO/Aphrodite_0108" },
				-- You are impossible!
				{ Cue = "/VO/Aphrodite_0110" },
				-- What has gotten into you?
				{ Cue = "/VO/Aphrodite_0111" },
				-- You truly dare?
				{ Cue = "/VO/Aphrodite_0112" },
				-- Such utter foolishness.
				{ Cue = "/VO/Aphrodite_0113" },
				-- You don't want to make me angrier.
				{ Cue = "/VO/Aphrodite_0114" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAphroditeRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- Lady Aphrodite, how can I say no?
			{ Cue = "/VO/ZagreusField_1884" },
			-- A lovely offer, Aphrodite.
			{ Cue = "/VO/ZagreusField_1885" },
			-- Lady Aphrodite, I gladly accept.
			{ Cue = "/VO/ZagreusField_1886" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- You break my heart, I break your body, little godling.
			{ Cue = "/VO/Aphrodite_0194" },
			-- You ought to worship me, rather than anger me.
			{ Cue = "/VO/Aphrodite_0195" },
			-- Don't you refuse my good graces like that again.
			{ Cue = "/VO/Aphrodite_0196" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.AphroditeVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Lovely to see you, hm?
			{ Cue = "/VO/Aphrodite_0081" },
			-- Well look at you, hm-hm.
			{ Cue = "/VO/Aphrodite_0083" },
			-- Oh good, we meet again!
			{ Cue = "/VO/Aphrodite_0084" },
			-- You're such a sweetheart.
			{ Cue = "/VO/Aphrodite_0129" },
			-- How lovely.
			{ Cue = "/VO/Aphrodite_0130" },
		},
	},

	-- Dionysus
	DionysusUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolDionysus",
		BoonInfoIcon = "BoonInfoSymbolDionysusIcon",
		DoorIcon = "BoonSymbolDionysusIsometric",
		Color = { 128, 0, 128, 255 },
		LootColor = {200, 0, 255, 255},
		SubtitleColor = {0.600, 0.427, 0.890, 1.0},
		EventEndSound = "/SFX/DionysusBoonWineLaugh",
		LootRejectionAnimation = "BoonDissipateA_Dionysus",
		UpgradeSelectedSound = "/SFX/DionysusBoonChoice",

		PriorityUpgrades = {"DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusRangedTrait", },
		WeaponUpgrades = {"DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusRangedTrait", "DionysusShoutTrait", },
		Traits = { "DoorHealTrait", "LowHealthDefenseTrait", "FountainDamageBonusTrait" },
		Consumables = { "DionysusGiftDrop" },

		LinkedUpgrades =
		{
			DionysusSpreadTrait =
			{
				OneOf = { "DionysusRushTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait" },
			},
			DionysusSlowTrait =
			{
				OneOf = { "DionysusRushTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
			},
			DionysusPoisonPowerTrait =
			{
				OneOf = { "DionysusRushTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusShoutTrait", },
			},
			DionysusDefenseTrait =
			{
				OneOf = { "DionysusRangedTrait", },
			},
			DionysusAphroditeStackIncreaseTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			PoisonCritVulnerabilityTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" },
				}
			},
			RaritySuperBoost =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRangedTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			LightningCloudTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "DionysusRangedTrait", "DionysusDefenseTrait" },
				}
			},
			DionysusComboVulnerability =
			{
				OneFromEachSet =
				{
					{ "DionysusSpreadTrait", "DionysusSlowTrait", "DionysusPoisonPowerTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
					{ "DionysusRangedTrait", "DionysusDefenseTrait" },
				}
			},
			IceStrikeArrayTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "DionysusRangedTrait" },
				}
			},
			SlowProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			PoisonTickRateTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
				}
			},
		},

		Speaker = "NPC_Dionysus_01",
		Portrait = "Portrait_Dionysus_Default_01",
		WrathPortrait = "Portrait_Dionysus_Wrath_01",
		OverlayAnim = "DionysusOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/DionysusBoonWineLaugh",
		FlavorTextIds =
		{
			"DionysusUpgrade_FlavorText01",
			"DionysusUpgrade_FlavorText02",
			"DionysusUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "DionysusFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			ThreadName = "RoomThread",

			-- Lord Dionysus...
			{ Cue = "/VO/ZagreusField_0690" },
			-- Hello there, Dionysus...
			{ Cue = "/VO/ZagreusField_0691" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			DionysusWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "LightningCloudTrait",
				{ Cue = "/VO/Dionysus_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hey Zag, my Dad, he's here and wants to have a word, be cool man, go along with what he says, OK?" },
				{ Cue = "/VO/Zeus_0127",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "That Dionysus, always much too kind with introductions, though at least he shows me suitable respect. Perhaps someday he can instruct you in the customs of Olympus here." },
			},
			DionysusWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "RaritySuperBoost",
				{ Cue = "/VO/Dionysus_0115",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Text = "{#DialogueItalicFormat}Uh{#PreviousFormat}, Zag, {#DialogueItalicFormat}erm{#PreviousFormat}... your uncle's passing through. Not Dad, {#DialogueItalicFormat}erm{#PreviousFormat}, the other one I mean, and he just wanted to check in, see how you're doing, so..." },
				{ Cue = "/VO/Poseidon_0128",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Emote = "PortraitEmoteFiredUp",					
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, there you are, my little nephew! Dionysus showing you the ropes, or what? You want a real feast, though, you just stick with {#DialogueItalicFormat}me{#PreviousFormat}! Now take my blessing, {#DialogueItalicFormat}go{#PreviousFormat}!" },
				{ Cue = "/VO/Dionysus_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, anyway we're here, man, waiting up for you! We know you're going to make it, I would say eventually?" },
			},
			DionysusWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SlowProjectileTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hey, Zag, when you arrive, it's going to be a real scene, I'll tell you now! Even Athena here will cut loose for a bit, let down her hair, you know, put on something more comfy, yeah, it's going to be {#DialogueItalicFormat}great{#PreviousFormat}!" },
				{ Cue = "/VO/Athena_0230",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Perhaps Lord Dionysus here is the true god of strategy, as it appears he is uncannily aware of my next move, Cousin. Although, be that as it may, I shall attempt to remain focused on your situation. Not his feast." },
			},
			DionysusWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonTickRateTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "You know, Zag, maybe once you get here, you could get old Ares to just lighten up a little, you know, man? Always dragging down the mood, with talk of blood, and nastiness, all sorts of stuff like that!" },
				{ Cue = "/VO/Ares_0228",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Why, my Lord Dionysus! I fail to see why such discussion is perceived as unbecoming of a feast. A successfully conducted war is certainly a cause for celebration, is it not?" },
			},
			DionysusWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "DionysusAphroditeStackIncreaseTrait",
				{ Cue = "/VO/Dionysus_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Look, Zag, you should know by now that when it comes to feasting, it's Yours Truly here who puts on the best performance. But I do have Lady Aphrodite's help!" },
				{ Cue = "/VO/Aphrodite_0210",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteAffection",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Wine does have a rather special way of making everybody look even more beautiful than ever, Dionysus dear! And from such beauty, why, long-lasting love is born! And also shorter-lasting love, much of the time." },
			},
			DionysusWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonCritVulnerabilityTrait",
				{ Cue = "/VO/Dionysus_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Zag, man, I was just attempting here to get our good friend Artemis to finally make an appearance at one of my feasts, it's just... wouldn't you know, she's all preoccupied, something about a hunt?" },
				{ Cue = "/VO/Artemis_0234",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "That's right, Lord Dionysus, a {#DialogueItalicFormat}hunt{#PreviousFormat}! Which requires lots and lots of {#DialogueItalicFormat}total quiet{#PreviousFormat}, and clear-minded focus. So, if you'll excuse me?" },
			},
			DionysusWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "IceStrikeArrayTrait",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Dionysus_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hey Zag, got a favor here I mean to ask, could you maybe persuade the Lady Demeter to ease up on the whole {#DialogueItalicFormat}'not let anything grow' {#PreviousFormat}thing she's been going on about?" },
				{ Cue = "/VO/Demeter_0140",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "I daresay, my Lord Dionysus, that partaking of less wine for some amount of time might do you good. Regardless, you'll not coax a better crop from me." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			DionysusAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4342", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.27 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Hope this lives up to your expectations, mate. In the name of Hades! Olympus? This is an official message! Should be a good time, Lord Dionysus!" },
				{ Cue = "/VO/Dionysus_0216",
					PortraitExitWait = 1.25,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "Whoa, hold just for a moment, Zag, now, I can recognize an invite when I see one, man! And this is definitely almost certainly some sort of invite, one for me, and... one for everybody else, it looks like, here? Hoh, I'm excited, that is something really special, I can tell!" },
			},
			DionysusPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look, Zag, I don't entirely recall what happened at that feast you threw for all of us down there, but let me tell you, I am under the impression it went {#DialogueItalicFormat}smashingly{#PreviousFormat}! It was {#DialogueItalicFormat}amazing{#PreviousFormat}, man! Let's have another one again sometime, all right?" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			DionysusAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Dionysus_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So Zag, you met my dad by now, your uncle Zeus? He's cool and loves a feasting, just... be sure to keep him in your thoughts. OK?" },
			},
			DionysusAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Dionysus_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hoh-ho{#PreviousFormat}, no way Zag, looking like you got yourself a gift from old Poseidon there? He's quite the catch, but here, hope you saved some room for more!" },
			},
			DionysusAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Dionysus_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey man, I heard Athena had a word with you already yeah? She's cool, though, once you get to know her. Here! I got something that ought to suit her style." },
			},
			DionysusAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Dionysus_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoa, hey, you must have had a run-in with the lovely Aphrodite, am I right, or am I right, there Zag? But I have {#DialogueItalicFormat}just {#PreviousFormat}the thing to go with her!" },
			},
			DionysusAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Dionysus_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, Zag, got to tell you I cannot believe that little Artemis is hanging out with you! She doesn't hang with anybody, man! But I digress, take this!" },
			},
			DionysusAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Dionysus_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You hanging out with Ares, are you, Zag? He's quite the chap, I'll give him that, I'll give him that, and now, I'll give you {#DialogueItalicFormat}this{#PreviousFormat}!" },
			},
			DionysusAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Dionysus_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Felt a shiver in the air just now, and that can only mean that chilly Demeter decided to give you a little help, there, huh? Or maybe it's just cold, I mean, this is a mountaintop!" },
			},
			DionysusAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/Dionysus_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, Zag, uh... I may just be losing it or something here, but isn't that your dad's own blessing that you've got? That's something, man, I didn't know that he was helping you!" },
			},

			DionysusPostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift01", },

				{ Cue = "/VO/Dionysus_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now how's my favorite Underworld god surviving, Zag, you holding up or what? Right better momentarily, I bet!" },
			},
			DionysusPostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift02" },

				{ Cue = "/VO/Dionysus_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Man oh man, Zag, someday you will be the guest of honor at the biggest feast that you have ever seen! Though I know you have got your hands full for the time, so, first things first!" },
			},

			DionysusBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMinCompletedRuns = 3,

				{ Cue = "/VO/Dionysus_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sometimes I have to wonder, man, what's going through your head, I mean, I know you hear me and the others but it's so damn dark down there I can't hear you at all!" },
			},
			DionysusBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift02" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let me tell you something, Zag, I know your dad he's got to be a real handful, I relate to that, you understand me, mate? So you get out of there, and you'll be more than welcome here, with us!" },
			},

			DionysusHighRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift05" },

				{ Cue = "/VO/Dionysus_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've got a feeling this time, man, like things are really going to take a turn for you, and I mean for the better, almost certainly, I think!" },
			},
			DionysusHighRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift06" },

				{ Cue = "/VO/Dionysus_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The key to any halfway decent feast is lots and lots of preparation, man. Or maybe just having to improvise, you know?" },
			},

			DionysusRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMinCompletedRuns = 19,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I got to hand it to you, Zag, you don't back down, you don't ever back down, what is this, like the twentieth time that you've attempted to escape?" },
			},
			DionysusRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredRoomLastRun = "B_Intro",
				RequiredFalseRoomLastRun = "C_Intro",
				RequiredBiome = "Tartarus",
				RequiredMaxRunsCleared = 2,				
				{ Cue = "/VO/Dionysus_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're getting somewhere, getting somewhere, man, I understand you made it up to Asphodel before, now that is progress, keep it up, you keep on going, yeah?" },
			},
			DionysusRunProgress03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusGift02" },
				RequiredKills = { SatyrRanged = 6, SatyrRangedMiniboss = 1 },
				RequiredRoomLastRun = "D_Hub",
				{ Cue = "/VO/Dionysus_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard you wrestled with some Satyrs near the surface, Zag! Nice work making it that far, and I just want to let you know that they are definitely not my crew, man! Satyrs I know aren't like that at all!" },
			},

			DionysusRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Dionysus_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, Zag, what {#DialogueItalicFormat}happened {#PreviousFormat}last time, man? It seemed like you were rather close, but then, we couldn't see you anymore from here, and now you're back? Well, give another go!" },
			},
			DionysusRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusRunCleared01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Dionysus_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Want you to know something, here, man. It's been a bit of a long haul, but you are getting closer to the surface, and you'll get there someday, and we're with you, however long it takes, OK?" },
			},

			DionysusPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusPostEpilogue01" },
				{ Cue = "/VO/Dionysus_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, back when we had that feast, there, man, I, I hope I didn't, you know, make for any inconveniences or anything down there, did I...?" },
			},
			DionysusPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusPostEpilogue02" },
				{ Cue = "/VO/Dionysus_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zag, I cannot believe your mom's Persephone, that's something else, I got to tell you, man! I never took her for the sort to be all into Underworld stuff!" },
			},

			DionysusAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceDionysusBoonTrait",

				{ Cue = "/VO/Dionysus_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, isn't that the Overflowing Cup I handed down to you, I'm glad you like it, man! I guess it's overflowing still, because I figure otherwise I couldn't tell at all!" },
			},

			DionysusAboutNectar01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLifetimeResourcesSpentMin = { GiftPoints = 60 },
				RequiredMinAnyTextLines = { TextLines = { "CerberusGift01", "ZeusGift01", "PoseidonGift01", "AthenaGift01", "AphroditeGift01", "AresGift01", "ArtemisGift01", "HermesGift01", "DemeterGift01", "MegaeraGift01", "ThanatosGift01", "AchillesGift01", "NyxGift01", "SkellyGift01", "SisyphusGift01", "PatroclusGift01", "EurydiceGift01", "DusaGift01", "HypnosGift01", "HadesGift01" }, Count = 8 },
				RequiredTextLines = { "DionysusGift04" },
				{ Cue = "/VO/Dionysus_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You, man, must be mates with just about {#DialogueItalicFormat}everybody {#PreviousFormat}down there, by now, yeah? Doling out Nectars left and right, just livening the place right up!" },
			},
			DionysusAboutNectar02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredResourcesMin = { GiftPoints = 25 },
				RequiredTextLines = { "DionysusGift02" },
				{ Cue = "/VO/Dionysus_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, let me just point out you've got a lot of Nectar on you, man! Oh, I can tell, I like the stuff a lot, myself, but even I don't pack {#DialogueItalicFormat}that {#PreviousFormat}much, and I mean, {#DialogueItalicFormat}wow{#PreviousFormat}!" },
			},

			DionysusAboutAmbrosia01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusGift01" },
				RequiredFalseTextLines = { "DionysusAboutAmbrosia02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredResourcesMin = { SuperGiftPoints = 1 },
				{ Cue = "/VO/Dionysus_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, man, if I'm not mistaken, I think you got yourself a bottle of Ambrosia, there? I'd no idea you could get that stuff downstairs! Do me a solid, though, hang on to any more you find, or better yet, give it away! I'd hate to think even a drop has gone to waste!" },
			},
			DionysusAboutAmbrosia02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift03", "DionysusAboutAmbrosia04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia03", "DionysusAboutAmbrosia04" }, Count = 3 },
				RequiredResourcesMin = { SuperGiftPoints = 5 },
				{ Cue = "/VO/Dionysus_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, would you just look at yourself, Zag! You are like a walking stockpile of Ambrosia, aren't you? Taking the best of care of it, at that. I knew I could count on you, but... {#DialogueItalicFormat}<Sniff> {#PreviousFormat}I didn't know I could be just so proud of you, you know, man?" },
			},
			DionysusAboutAmbrosia03 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia04" },
				RequiredTextLines = { "DionysusGift06" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLifetimeResourcesSpentMin = { SuperGiftPoints = 10 },
				RequiredMinAnyTextLines = { TextLines = { "CerberusGift07", "ZeusGift07", "PoseidonGift07", "AthenaGift07", "AphroditeGift07", "AresGift07", "ArtemisGift07", "HermesGift07", "DemeterGift07", "MegaeraGift07", "ThanatosGift07_A", "AchillesGift07_A", "NyxGift07", "SkellyGift07", "SisyphusGift07_A", "PatroclusGift07_A", "EurydiceGift07", "DusaGift07", "HypnosGift07" }, Count = 6 },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia03", "DionysusAboutAmbrosia04" }, Count = 3 },
				{ Cue = "/VO/Dionysus_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zag, turns out I am quite the judge of character, and you, man, have an {#DialogueItalicFormat}awful {#PreviousFormat}lot of it, I mean, you've given out how much Ambrosia now? To {#DialogueItalicFormat}all {#PreviousFormat}your mates, and {#DialogueItalicFormat}more{#PreviousFormat}?!" },
			},
			DionysusAboutAmbrosia04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusAboutAmbrosia02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLifetimeResourcesGainedMin = { SuperGiftPoints = 15 },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia03", "DionysusAboutAmbrosia04" }, Count = 3 },
				RequiredTextLines = { "DionysusGift03" },
				{ Cue = "/VO/Dionysus_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You got to let me in on something, Zag, how did you gather up so much Ambrosia, there? I mean, sometimes I think the stuff is plentiful up here, but you are positively swimming in it, man!" },
			},
			DionysusAboutGifting01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift02", "PoseidonGift02", "AthenaGift02", "AresGift02", "ArtemisGift02", "AphroditeGift02", "DionysusGift02", "DemeterGift02" },
				{ Cue = "/VO/Dionysus_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are the talk of the mountain, you know that, man? Good on you, getting on just about everybody's good side up here, I mean, that is a feat, all right!" },
			},

			DionysusAboutOrpheus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusGift01", "OrpheusTallTale03", "OrpheusGift01" },
				{ Cue = "/VO/Dionysus_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hey Zag, ever see a fellow by the name of Orpheus down there, you ever heard of him? I bet you have, and I have had a funny thought, a little jest that maybe we could try, if you'd be up to have a little harmless fun?" },
				{ Cue = "/VO/ZagreusField_1218", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Harmless fun at the expense of Orpheus? You have my full and complete attention, Dionysus mate." },
				{ Cue = "/VO/Dionysus_0043", PreLineWait = 0.35,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "...That chap comes up with the most smashing songs, so I was thinking, maybe we could spin him a tall tale, something like how maybe you and I, like, we're connected or something? He'll buy it, tell him, tell him for me, yeah?!" },
			},
			DionysusAboutOrpheus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusAboutOrpheus01", "OrpheusTallTale04" },
				RequiredFalseTextLinesLastRun = { "OrpheusTallTale04" },
				{ Cue = "/VO/Dionysus_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, Zag! I heard you got to Orpheus, he's got this whole entire ballad now, about how you are really me, or maybe it's the other way around, I've no idea, {#DialogueItalicFormat}hahahaha{#PreviousFormat}! Here!" },
			},
			DionysusAboutSingersReunionQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusAboutOrpheus02", "OrpheusWithEurydice01" },
				{ Cue = "/VO/Dionysus_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Zag, I heard that Orpheus, he found his missing bride, why, isn't that the sweetest thing, isn't it, man? I'll drink to that, and I think so should you!" },
			},

			DionysusVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Dionysus_0041",
					Emote = "PortraitEmoteDepressed",					
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, hey, man, you been having some bad run-ins with that Fury, Megaera, is that her name? Now isn't she a real firebrand! Maybe this'll help you out next time you meet!" },
			},
			DionysusAboutMegRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusVsMeg01", "MegaeraGift08" },
				RequiredFalseTextLines = { "DionysusAboutMegRelationship02" },
				{ Cue = "/VO/Dionysus_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoa, Zag, heard you're hanging with the Fury Megaera of late, well cheers to that, man, bet she's something else, but you just watch for that whip of hers, OK?" },
			},
			DionysusAboutMegRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusAboutMegRelationship01" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutMegRelationship01" }, Count = 3 },
				{ Cue = "/VO/Dionysus_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey man, I'm hearing up here that you got in good with Megaera, the Fury, is that right, I mean, I hope it is, because, {#DialogueItalicFormat}hahaha, yeow{#PreviousFormat}, know what I mean? They say she's something else!" },
			},
			DionysusAboutThanRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredAnyTextLines = { "ThanatosGift10" },
				{ Cue = "/VO/Dionysus_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, you're in good with Thanatos, isn't that right? A real broody sort, sometimes I think maybe I ought to just invite him to a feast, but then, what if he cools the whole thing down, makes everybody kind of {#DialogueItalicFormat}ehhhhh{#PreviousFormat}, you know?" },
			},

			DionysusVsTheseus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredRoomLastRun = "D_Hub",
				RequiredKills = { Theseus = 3 },
				{ Cue = "/VO/Dionysus_0118",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard that you took care of Theseus down in Elysium of late, there, Zag! Nice work, never liked that one, between us. There's this nice lass helped him out one time, and he just dumped her rotten, I don't like that, man!" },
			},

			DionysusAboutYarn01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusVsTheseus01" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				-- RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0119",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, you've a Yarn of Ariadne, right there, Zag, I know the lass for whom that yarn is named! She was a right attractive one, we had our little time, long story, though, will save it till you get here!" },
			},

			DionysusLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoaa Zag, man, you look positively knackered, you be sure and take it easy if you can out there, all right? Here, maybe this'll help!" },
			},
			DionysusLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0066",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oof{#PreviousFormat}, Zag, look, I know you're not in a good spot right now, you must be really out of sorts! Though maybe {#DialogueItalicFormat}this {#PreviousFormat}might numb the pain a bit!" },
			},
			DionysusLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0205",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Eugh{#PreviousFormat}, you're a proper mess right now, got to be candid with you, man, you're bleeding everywhere, get it together, yeah?" },
			},
			DionysusLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now what's the matter, down there, Zag, it's like you've been up feasting day and night, you're barely standing, everything OK?" },
			},
			DionysusLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ooh{#PreviousFormat}, you're in no shape to be going off, what happened to you, there? Well, here, you know what? Let me see if we can get you back into it, man!" },
			},

			DionysusLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0123",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh-hoh{#PreviousFormat}, Zag, have I got something special here for you, I mean {#DialogueItalicFormat}this {#PreviousFormat}here is top-notch stuff, {#DialogueItalicFormat}even {#PreviousFormat}among the top-notch stuff I have to give, just look at this!" },
			},
			DionysusLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0124",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look, man, I am feeling generous right now, know what I mean? And so, here's something {#DialogueItalicFormat}extra {#PreviousFormat}potent for you, ought to keep you going for a while longer than you're used to, there!" },
			},

		},

		PickupTextLineSets =
		{
			DionysusFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0792", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 6.1 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "That was... revelry? People having a good time? Well, sure, then! In the name of Hades! Olympus, I'll accept this message." },
				{ Cue = "/VO/Dionysus_0002",
					PortraitExitWait = 1.25,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heeey, there, Zag, man, how's it going? Look, you have got to get here with the rest of us already, we've been saving you a spot! Let me see what I can do, make life a little sweeter for you in the meantime!" },
			},
			DionysusMiscPickup01 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Looks like this feast is getting started still, am I not right about that, Zag? Come on, let's show everybody a good time." },
			},
			DionysusMiscPickup02 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Just getting warmed up down there, yeah, Zag? Here, I've a fine selection of my blessings, just for you!" },
			},
			DionysusMiscPickup03 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",

				{ Cue = "/VO/Dionysus_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whooaa{#PreviousFormat}, Zag, I bet you could use a little pick-me-up right about now, and I am here to offer you whichever one you please!" },
			},
			DionysusMiscPickup04 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey Zag, how is life, you hanging in there, yeah? I reckoned maybe we could raise a glass here, to your health, but then I thought, {#DialogueItalicFormat}'No, wait! I can do a little more than that!{#PreviousFormat}' So, here we go!" },
			},
			DionysusMiscPickup05 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, how you living life down there right now, all right I take it, yeah? No, wait, though, I have just the thing!" },
			},
			DionysusMiscPickup06 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, hello, Zag! Fancy running into you, though there's no need to work yourself so hard, you hear me, yeah? I reckon this should take the edge right off!" },
			},
			DionysusMiscPickup07 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How goes it this time, man, everything fine? Though hold that thought, I wager we can make things finer yet!" },
			},
			DionysusMiscPickup08 =
			{
				Priority = true,
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That Underworld of yours, place is a real pit, isn't it Zag, a shame you're stuck down there. But we are going to get you out of there, together, you and I!" },
			},
			DionysusMiscPickup09 =
			{
				Priority = true,
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Soon as you get up to Olympus, man... it's going to be a feast like you have {#DialogueItalicFormat}never {#PreviousFormat}seen, you mark my words! Now take this, and good luck!" },
			},
			DionysusMiscPickup10 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You give those musty shades and corpses a fair fighting chance down there, you hear me, Zag? Though just in case you need a hand..." },
			},
			DionysusMiscPickup11 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0014",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You got this, man! I {#DialogueItalicFormat}so {#PreviousFormat}believe in you, it's almost like the Greeks believe in me! And they believe in me an awful lot, you know!" },
			},
			DionysusMiscPickup12 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Time for another go at getting out of there, eh, Zag? Well not to worry, we'll make something happen, let's hop to it then!" },
			},
			DionysusMiscPickup13 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now listen up here, Zag, 'cause this time I have got something for you that's going to put some extra fire in your step, you ready, man?" },
			},
			DionysusMiscPickup14 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You wait for just a moment, Zag, 'cause I got just the thing for this occasion, you are going to love it, get a load of this!" },
			},
			DionysusMiscPickup15 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, Zagreus, I'm certain everything is going fine for you right now, but just in case, but {#DialogueItalicFormat}just in case{#PreviousFormat}! I got a little something, just for you!" },
			},
			DionysusMiscPickup16 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's me, Zag, hey, I know you haven't got a lot of time to listen to me prattle on like this, and so, I'm cutting to the chase here, look!" },
			},
			DionysusMiscPickup17 =
			{
				Priority = true,
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey again as ever Zag, now you keep at it like you have been and I bet we'll all be hanging out up here in no time flat! I'm with you all the way!" },
			},
			DionysusMiscPickup18 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",

				{ Cue = "/VO/Dionysus_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, hey, let's see, man, I am thinking that {#DialogueItalicFormat}this {#PreviousFormat}time around this smattering of my concoctions ought to do you right!" },
			},
			-- shorter acknowledgments
			DionysusMiscPickup19 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0022",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here's to an interesting time, how about that, yeah?" },
			},
			DionysusMiscPickup20 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0023",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd like to make a toast, to {#DialogueItalicFormat}you {#PreviousFormat}of course my friend! Good luck out there!" },
			},
			DionysusMiscPickup21 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, man, I have got your back, and you have got this, go!" },
			},
			DionysusMiscPickup21 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, hey, have I got just the thing for this particular occasion, man!" },
			},
			DionysusMiscPickup22 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				-- RequiredMinAnyTextLines = { TextLines = GameData.DionysusBasicPickUpTextLines, Count = 14 }
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, Zag, what is going on, you going to get out of here this time? Why, yes, I think you are!" },
			},
			DionysusMiscPickup23 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "OK Zag. You and me. We're getting through this, now or never, ready, yeah?" },
			},
			DionysusMiscPickup24 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh hey, Zag, here's a toast to your success, so... {#DialogueItalicFormat}clink{#PreviousFormat}! Cheers and all that!" },
			},
			DionysusMiscPickup25 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here's something for you man, grab it and go!" },
			},
			DionysusMiscPickup26 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0135",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I got you, Zag, got just the thing, right here!" },
			},
			DionysusMiscPickup27 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah there you are, man, I got what you need!" },
			},
			DionysusMiscPickup28 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know you're busy, man, so here you go, get on with it, all right?" },
			},
			DionysusMiscPickup29 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's good to kind of see you down there man, now here, take this!" },
			},
			DionysusMiscPickup30 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sure is dark there, Zag, I hope you're hanging in there, yeah?" },
			},
			DionysusMiscPickup31 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You getting anywhere, yet, man? 'Cause if you're not, it's cool, we've all got time!" },
			},
			DionysusMiscPickup32 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got something that is going to knock you off your feet, here, man!" },
			},
			DionysusMiscPickup33 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You ready for this, Zag, now here's a good one, courtesy of me!" },
			},
			DionysusMiscPickup34 =
			{
				Priority = true,
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's going to be a real feast here once you make it, man!" },
			},
			DionysusMiscPickup35 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Only the best for you, man, now check this out, you'll see!" },
			},
			DionysusMiscPickup36 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "This here, Zag, is among the best I have to offer, it is good!" },
			},
			DionysusMiscPickup37 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0146",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm feeling really good right now, and thought I'd pass that right along!" },
			},
			DionysusMiscPickup38 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here's something extra special for you, man, now cheers!" },
			},

			DionysusMiscPickupExtra01 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Past time we got things going for you there, what do you say, you ready for this, man?" },
			},
			DionysusMiscPickupExtra02 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I got to make it to a feast in just a little bit, here, man, but quickly, take this, yeah?" },
			},
			DionysusMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunNotCleared = true,
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 5 },

				{ Cue = "/VO/Dionysus_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know it's been tough times of late, but look, you just keep going, and you'll make it, man!" },
			},
			DionysusMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunNotCleared = true,

				{ Cue = "/VO/Dionysus_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "This time for sure, I mean, I know you're going to make it to the top, together with me, man!" },
			},
			DionysusMiscPickupExtra05 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey I propose a toast to {#DialogueItalicFormat}you{#PreviousFormat}, there, man, and may you always kill whatever's in your path, and on and on!" },
			},
			DionysusMiscPickupExtra06 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A toast, man, to your health! Or to the lack of it, for anybody who gets on your bad side, yeah?" },
			},

			DionysusMiscPickupRare01 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Have I got just the thing for you, here, man, you ready? Here we go!" },
			},
			DionysusMiscPickupRare02 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say we go {#DialogueItalicFormat}all out {#PreviousFormat}this time, how about it, Zag, you with me, man, or what?" },
			},
			DionysusMiscPickupRare03 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Been saving something for the right occasion, though I figure it's as good a time as any, yeah?" },
			},
			DionysusMiscPickupRare04 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, cheers to you, and everything you do, there, Zag! Only the best from me to you, man!" },
			},

		},

		BoughtTextLines =
		{
			DionysusLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0045",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heeey, what's, uh, with that Charon, man, he's sort of, {#DialogueItalicFormat}I-don't-know{#PreviousFormat}, though I am glad he's been of service!" },
			},
			DionysusLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0046",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, you found me holing up in Charon's nasty stash there did you man, well good, good, here!" },
			},
			DionysusLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Looks like you are stocked for one hell of a night down there, man! I knew Charon would hook you up with what you need!" },
			},
			DionysusLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, cheers for picking up the tab, there, Zag, now, I cannot exactly pay you back, though I could give you {#DialogueItalicFormat}this{#PreviousFormat}!" },
			},
			DionysusLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I bet that Charon has to be the life of every feast you have down there, with such a personality, am I not right about that, man?" },
			},
		},

		RejectionTextLines =
		{
			DionysusRejection01 =
			{
				{ Cue = "/VO/Dionysus_0003",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, come {#DialogueItalicFormat}on{#PreviousFormat}, Zag, and here I thought that we were cool. You hurt my pride, there, man. I guess I'm going to have to hurt yours...." },
			},
			DionysusRejection02 =
			{
				{ Cue = "/VO/Dionysus_0047",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Ohhh man, that was definitely not a thing to do, I mean, are we best mates, or not...? You think on that, while I do {#DialogueItalicFormat}this{#PreviousFormat}." },
			},
			DionysusRejection03 =
			{
				{ Cue = "/VO/Dionysus_0048",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look Zag, I'm not going to lie, you hurt my feelings here, I thought we had a thing! A close familial bond! I'm really {#DialogueItalicFormat}mad {#PreviousFormat}now that I think on it!" },
			},
			DionysusRejection04 =
			{
				{ Cue = "/VO/Dionysus_0049",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "What, you wouldn't hang with me given the choice? I thought I had you sorted, man, but maybe you just don't appreciate the finer things!" },
			},
			DionysusRejection05 =
			{
				{ Cue = "/VO/Dionysus_0050",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Ah, come on, Zag, now that was not the choice I would have made, you messing with me, man? All right! I'll mess with {#DialogueItalicFormat}you{#PreviousFormat}." },
			},
			DionysusRejection06 =
			{
				RequiredTextLines = { "DionysusRejection01", "DionysusRejection02" },
				{ Cue = "/VO/Dionysus_0125",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, we all make mistakes from time to time, man, and you ought to know! You made one there just now!" },
			},
			DionysusRejection07 =
			{
				{ Cue = "/VO/Dionysus_0126",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Why do it to me like that, Zag, man, I thought we were close as grapes upon the vine, but I was wrong?" },
			},
			-- DionysusRejection08 skipped
			DionysusRejection09 =
			{
				{ Cue = "/VO/Dionysus_0127",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Did I do something to deserve this, man, because I thought that we were getting on just fine, better than fine, but this?" },
			},
			DionysusRejection10 =
			{
				{ Cue = "/VO/Dionysus_0128",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "It's not that I'm upset or anything, here, Zag, you know I'm not, but truthfully I am a bit annoyed, a little bit, and so, I got to send the message, man." },
			},
			DionysusRejection11 =
			{
				{ Cue = "/VO/Dionysus_0165",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Really, man? After everything we've been through together, {#DialogueItalicFormat}this {#PreviousFormat}is the gratitude I get?" },
			},
			DionysusRejection12 =
			{
				{ Cue = "/VO/Dionysus_0166",
					Emote = "PortraitEmoteDepressed",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Well, way to spoil the feast, there, Zag, I mean come on, I thought I was your mate? Was I mistaken, man?" },
			},
			DionysusRejection13 =
			{
				{ Cue = "/VO/Dionysus_0167",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zag, I can take a jest, ask anybody, but when it comes to competition here, it's not a laughing matter! Do you understand me, man?" },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Sorry, Dionysus.
				{ Cue = "/VO/ZagreusField_0166" },
				-- Sorry, Dionysus mate.
				{ Cue = "/VO/ZagreusField_4149" },
				-- Don't take it personally, Dionysus.
				{ Cue = "/VO/ZagreusField_4150" },
				-- Still mates, right, Dionysus?
				{ Cue = "/VO/ZagreusField_4151" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			DionysusMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, all right, all right, we're cool, we're cool, no need to get all hot and bothered any longer, here!" },
			},
			DionysusMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "OK, let's say we're settled up now, Zag, and go on being best mates just like before, yeah?" },
			},
			DionysusMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, Zag, you are not so bad, just had a little lapse in judgment, happens to me all the time, now let's get on with it!" },
			},
			DionysusMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0054",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, now, that was quite a sight, I got to hand it to you, man, and you {#DialogueItalicFormat}deserve {#PreviousFormat}this, here!" },
			},
			DionysusMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Know what, man, I'm not even angry after that. What was I even going off about, do you recall...?" },
			},
			DionysusMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0129",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "OK, all right, it's fine already, Zag, you win this time and I am good as grapes." },
			},
			DionysusMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0130",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Appreciate your understanding, there, man, so let's just avoid this type of little shake-up next time, yeah?" },
			},
			DionysusMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0131",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hahahahahah{#PreviousFormat}, OK, thanks for a good laugh, there, Zag, what was it I was going on about, before...?" },
			},
			DionysusMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0132",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh I just can't stay mad about you, Zag, and to be honest, why, I wasn't that mad to begin with, I just thought I'd shake your branches up a bit!" },
			},
			DionysusMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.DionysusMiscRejectionTextLines,
				{ Cue = "/VO/Dionysus_0133",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're all right, man, you're all right, don't even worry about the rough patch we just crossed back there, we're stronger than all that!" },
			},
			DionysusMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.DionysusMiscRejectionTextLines,
				{ Cue = "/VO/Dionysus_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I figured this time I'd stay mad at you for sure, man, but you know what, I just couldn't! No matter how hard I tried." },
			},
			DionysusMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.DionysusMiscRejectionTextLines,
				{ Cue = "/VO/Dionysus_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's like I always say, Zag, you have got to permit yourself a bad time every now and again to really appreciate all the good times, yeah?" },
			},
			DionysusMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Know what, man, just forget about what happened, yeah? 'Cause I already did, I mean, it happens, right?" },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			DionysusGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0127", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Lord Dionysus, it's been great getting to know you, so, please accept this humble offering." },
				{ Cue = "/VO/Dionysus_0059",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now that is something, a right princely gift, there, Zag, and just so happens I got something here I have been meaning to give you!" },
			},
			DionysusGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift01", },
				{ Cue = "/VO/ZagreusField_1219", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "A toast in your honor, Lord Dionysus mate. Have I mentioned how pleased I am to have made your acquaintance?" },
				{ Cue = "/VO/Dionysus_0056",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Hoh-oh{#PreviousFormat}, what, is that for me, {#DialogueItalicFormat}really{#PreviousFormat}, I mean, cheers man, that is awful generous of you, I'm much obliged!" },
			},
			DionysusGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift02", },
				{ Cue = "/VO/ZagreusField_1220", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Dionysus mate, you have made the mood down here materially less miserable, and I am much obliged." },
				{ Cue = "/VO/Dionysus_0057",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What, is that for me, why Zag, I mean you really shouldn't have, you know I can't get enough of this stuff, right?" },
			},
			DionysusGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift03", },
				{ Cue = "/VO/ZagreusField_1221", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Dionysus mate, you must have no shortage of supreme vintage at your disposal, but this one's from me." },
				{ Cue = "/VO/Dionysus_0058",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why Zag, how positively thoughtful, man, I mean I love it, positively love this stuff, and I am very moved that you would think of me for it!" },
			},

			DionysusGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift04", },
				{ Cue = "/VO/ZagreusField_3868", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Hey, on no occasion whatsoever, cheers to you again, Lord Dionysus mate! This place is so much less dreary under your influence!" },
				{ Cue = "/VO/Dionysus_0158",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, this is the greatest, Zag! This feast I'm headed to? I was getting a little concerned I wasn't going to have quite enough to go around for everyone. Well, you just saved my evening, man! Too bad you couldn't be there, yeah?" },
			},
			DionysusGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift05", },
				{ Cue = "/VO/ZagreusField_3869", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dionysus mate, sometimes things weigh heavily on me, but then I hear from you, and it's like I don't have a care in the world! To your health!" },
				{ Cue = "/VO/Dionysus_0159",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, you're really too much for me sometimes, you know that, man? Got to tell you, I don't think I ever felt so close to somebody so damn far away. But through the gift of drink? It's like we're with each other in spirit, all the time, you know?" },
			},
			DionysusGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift06", },
				{ Cue = "/VO/ZagreusField_3870", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "What does one offer to the god of wine? The very best, is what, and down here, this is it, mate! I'm grateful I've got some of your spirit in me. To have such a connection, with you despite all the distance between us...!" },
				{ Cue = "/VO/Dionysus_0160",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Dionysus_01", Icon = "Keepsake_DionysusSticker_Max" },
					Text = "Zag, I cannot believe what you are offering to me! Ambrosia, man, for {#DialogueItalicFormat}me{#PreviousFormat}? And talk about a bottle that has seen some wild days and nights, I mean if it got all the way to you down there, only to come back up! Know what? I'm saving it, till we can share it, here!" },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Thank you, Dionysus mate.
			{ Cue = "/VO/ZagreusHome_0327" },
		},

		ShoutActivationSound = "/SFX/DionysusWrathWineLaugh",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "DionysusUpgrade",

				-- You want to tangle with us?!
				{ Cue = "/VO/Dionysus_0062" },
				-- Here, this one's on me!!
				{ Cue = "/VO/Dionysus_0063" },
				-- Drink up, mates!!
				{ Cue = "/VO/Dionysus_0064", RequiredMinKillEnemies = 2 },
				-- Positively man!
				{ Cue = "/VO/Dionysus_0074" },
				-- Oh absolutely!
				{ Cue = "/VO/Dionysus_0075" },
				-- Have I got just the thing for you!
				{ Cue = "/VO/Dionysus_0086" },
				-- Time for a real feast!
				{ Cue = "/VO/Dionysus_0148" },
				-- Something for everyone!
				{ Cue = "/VO/Dionysus_0149", RequiredMinKillEnemies = 2 },
				-- You got it, man!
				{ Cue = "/VO/Dionysus_0150" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "DionysusUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Come on already man.
				{ Cue = "/VO/Dionysus_0097" },
				-- You serious right now?
				{ Cue = "/VO/Dionysus_0099" },
				-- You kidding me with this?
				{ Cue = "/VO/Dionysus_0100" },
				-- I can't believe this man.
				{ Cue = "/VO/Dionysus_0101" },
			}
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidDionysusRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- An exciting offer, Dionysus mate.
			{ Cue = "/VO/ZagreusField_1896" },
			-- A fine exchange, Lord Dionysus.
			{ Cue = "/VO/ZagreusField_1897" },
			-- Dionysus mate, I accept.
			{ Cue = "/VO/ZagreusField_1898" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- What can I say, man, it's a shame all right.
			{ Cue = "/VO/Dionysus_0090", RequiredPlayed = { "/VO/Dionysus_0177", "/VO/Dionysus_0178", "/VO/Dionysus_0179" }, },
			-- I'm absolutely gutted man.
			{ Cue = "/VO/Dionysus_0091", RequiredPlayed = { "/VO/Dionysus_0177", "/VO/Dionysus_0178", "/VO/Dionysus_0179" }, },
			-- Now that's a crying shame.
			{ Cue = "/VO/Dionysus_0093", RequiredPlayed = { "/VO/Dionysus_0177", "/VO/Dionysus_0178", "/VO/Dionysus_0179" }, },
			-- Didn't have to be like this, man! We were having such a good time!
			{ Cue = "/VO/Dionysus_0177" },
			-- Hate to sour the occasion like this, Zag. What was I supposed to do?
			{ Cue = "/VO/Dionysus_0178" },
			-- Eugh, I feel bad all of a sudden, man, I mean, what happened, there?
			{ Cue = "/VO/Dionysus_0179" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.DionysusVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Oh hey man, what is new?
			{ Cue = "/VO/Dionysus_0068" },
			-- Hey you hanging in there yeah?
			{ Cue = "/VO/Dionysus_0069" },
			-- You still in one piece, man?
			{ Cue = "/VO/Dionysus_0070" },
			-- Hoh yeah I'm into it!
			{ Cue = "/VO/Dionysus_0076" },
			-- Here this one's for you!
			{ Cue = "/VO/Dionysus_0084" },
		},
	},

	-- Athena
	AthenaUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolAthena",
		BoonInfoIcon = "BoonInfoSymbolAthenaIcon",
		DoorIcon = "BoonSymbolAthenaIsometric",
		Color = { 255, 215, 255, 255 },
		LightingColor = {253, 189, 49, 255},
		LootColor = {96, 64, 255, 255},
		SubtitleColor = {1.000, 0.847, 0.235, 1.0},
		EventEndSound = "/SFX/AthenaBoonHolyShield",
		UpgradeSelectedSound = "/SFX/AthenaBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Athena",

		ColorGrade = "Team02",
		PriorityUpgrades = {"AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait" },
		WeaponUpgrades = {"AthenaWeaponTrait", "AthenaRushTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaSecondaryTrait", "AthenaShoutTrait" },
		Traits = { "TrapDamageTrait", "EnemyDamageTrait", "AthenaRetaliateTrait", "PreloadSuperGenerationTrait" },
		Consumables = { "LastStandDurationDrop", "LastStandHealDrop" },

		LinkedUpgrades =
		{
			AthenaBackstabDebuffTrait =
			{
				PriorityChance = 0.5,
				OneOf = { "AthenaWeaponTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaSecondaryTrait" },
			},
			AthenaShieldTrait =
			{
				OneOf = { "AthenaWeaponTrait", "AthenaRushTrait", "AthenaRetaliateTrait", "AthenaSecondaryTrait" },
			},
			TriggerCurseTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AthenaWeaponTrait", "AthenaRushTrait", "AthenaSecondaryTrait" },
				},
			},
			CastBackstabTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait"},
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			ArtemisReflectBuffTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "AthenaWeaponTrait", "AthenaRushTrait", "AthenaSecondaryTrait" },
				}
			},
			SlowProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			NoLastStandRegenerationTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait","ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait", "DemeterShoutTrait" },
				}
			},
			StatusImmunityTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonShoutTrait" },
				}
			},
			ReboundingAthenaCastTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "AthenaRangedTrait" },
				}
			},
			ShieldHitTrait =
			{
				OneOf = { "AthenaShieldTrait" }
			}
		},

		Speaker = "NPC_Athena_01",
		Portrait = "Portrait_Athena_Default_01",
		OverlayAnim = "AthenaOverlay",
		WrathPortrait = "Portrait_Athena_Wrath_01",
		Gender = "Female",
		SpawnSound = "/SFX/AthenaBoonHolyShield",
		FlavorTextIds =
		{
			"AthenaUpgrade_FlavorText01",
			"AthenaUpgrade_FlavorText02",
			"AthenaUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "AthenaFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidAthenaRecently",
			CooldownTime = 40,

			-- Lady Athena...
			{ Cue = "/VO/ZagreusField_0680" },
			-- Goddess Athena...
			{ Cue = "/VO/ZagreusField_0681" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			AthenaWithZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AutoRetaliateTrait",
				{ Cue = "/VO/Athena_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Noble cousin, my lord father has taken keen interest in your journey and your plight, and now seeks to aid you with the thunder of heaven itself. And you've my support, as well, of course." },
				{ Cue = "/VO/Zeus_0195",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "I thank you for the generous introduction, fair Athena, and I always rest assured when you are close at hand. I trust with our combined might, our good Zagreus is virtually certain to succeed!" },
			},
			AthenaWithPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StatusImmunityTrait",
				{ Cue = "/VO/Athena_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "When I first notified Lord Father Zeus and other members of our family of your existence, Zagreus, it was Uncle Poseidon here who first leapt up, and pledged his power over sea and earth to you. Is that not so, Uncle?" },
				{ Cue = "/VO/Poseidon_0233",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Exactly so, Athena! You, with that fine memory of yours! For it isn't everyday I learn my doleful brother Hades sired a fine son! He does not know how good he has it, there! And {#DialogueItalicFormat}you{#PreviousFormat}, Nephew, could have it even better, {#DialogueItalicFormat}here{#PreviousFormat}!" },
			},
			AthenaWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CastBackstabTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Athena_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Your predicament has pulled our family together, united in a desire to assist you, Cousin. Even those who typically do not think much of those other than themselves." },
				{ Cue = "/VO/Aphrodite_0209",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteAffection",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Oh, if only I had wisdom such as yours, Athena dear, so that I was more capable of picking up on subtle jabs and insults such as that! You're not fooling anybody with your feigned benevolence, you know." },
				{ Cue = "/VO/Athena_0226",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "The world is not all lies and deceit as you make it out to be, Aphrodite. Sometimes, a lending of assistance is no more than it appears to be. Now either back up Zagreus, or stand aside." },
			},
			AthenaWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ArtemisReflectBuffTrait",
				RequiredTextLines = { "AthenaGift01", "ArtemisGift01" },
				{ Cue = "/VO/Athena_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "If you've a moment, Zagreus? One of my relatives has claimed that I usurp your time. So I invited her to contact you." },
				{ Cue = "/VO/Artemis_0121",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Um, hello, Zagreus... Athena here is grandstanding or trying to prove a point, or something. I don't know. Anyway, nice talking to you." },
				{ Cue = "/VO/Athena_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Well, I suppose that's settled, then. I am afraid such interactions aren't uncommon here amongst my family; but what's a family without flaws?" },
			},
			AthenaWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SlowProjectileTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Athena_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Some members of our family do not yet fully understand just how precarious your situation is, Cousin. My Lord Dionysus here, he goes about as though this is a festive matter of some sort!" },
				{ Cue = "/VO/Dionysus_0209",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Emote = "PortraitEmoteCheerful",
					Text = "Oh, come on, Athena girl, you really mean to tell me that discovering a long-lost relative isn't a cause for celebrating right away, I mean, you can't be telling me a thing like {#DialogueItalicFormat}that{#PreviousFormat}? Because if Zag isn't a cause for feasting, I don't know what is!" },
			},
			AthenaWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "NoLastStandRegenerationTrait",
				RequiredTextLines = { "AthenaAboutDemeter01" },
				{ Cue = "/VO/Athena_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "I bring to you the Lady Demeter, Cousin. I've asked that she please rest assured knowing we have your matter well under control. Though, in her infinite compassion, she has taken up your cause, nevertheless!" },
				{ Cue = "/VO/Demeter_0146",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Oh, you needn't lavish me with your faint praise, Athena dear. In all your boundless intellect I'd have expected you would know I see through your intentions, plain as day." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			AthenaAboutDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Athena_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The biting cold surrounding you must mean the Goddess of Seasons decided to take an interest in your struggle, Zagreus? I did not count on Demeter being a part of this. Take heart, though use discretion around her." },
			},
			AthenaAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", "PersephoneAboutOlympianReunionQuest01" },
				{ Cue = "/VO/ZagreusField_4338", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.24 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "This is it, then. In the name of Hades! Olympus, this is an official message! Lady Athena, I trust you'll quickly figure this one out." },
				{ Cue = "/VO/Athena_0233",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Is this some kind of offering for me? No, hold a moment, this appears to be a message! Part of one. Then, can this mean...? I have to notify the others. I trust they also have received something from you, or shortly shall." },
			},
			AthenaPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It was my privilege to have visited your father's House, and briefly had a chance to meet {#DialogueItalicFormat}you{#PreviousFormat}, Zagreus. Nyx and your mother each are very shrewd; perhaps you've taken after both of them. As for your new responsibilities... exposing weak points in defenses is my specialty." },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			AthenaAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Athena_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I understand you've been in contact with my father. Your uncle Zeus, I mean. He's taken interest in your plight; you should feel honored!" },
			},
			AthenaAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Athena_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've met the master of the seas, Poseidon, haven't you? Our uncle's affable but quick to anger. Be on your guard with him, is my advice." },
			},
			AthenaAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Athena_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cousin, you've met Aphrodite, no? She likes beguiling others with her charms; but her intentions with you I believe are pure. You'll find our strengths are complementary." },
			},
			AthenaAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Athena_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My warlike brother Ares reached you, didn't he. I've always found his conduct quite disturbing. At least it seems he's helping you for now." },
			},
			AthenaAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Athena_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'll tell you something, Cousin: If even Artemis is aiding you, it's proof your cause is just. She doesn't often take an interest in family affairs." },
			},
			AthenaAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Athena_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Did Dionysus truly visit you before? He tends to seek out revelry, not conflict. I'm pleased to know he's making himself useful here." },
			},
			AthenaAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Athena_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You arrived sooner than anticipated, Cousin, and my estimations seldom are inaccurate. All for the best, of course. Perhaps you're simply faster than I thought." },
			},
			AthenaAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/Athena_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus, perhaps it is a fancy of imagination, but it seems almost as though, this time, you bear the blessing of... your own father! If Lord Hades is assisting you in any way in this, then I shall hold out hope that your relationship yet has capacity to heal, to some extent at least." },
			},
			AthenaAboutHadesKeepsake02 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaAboutHadesKeepsake01", "AthenaGift03", "HadesGift03" },
				MinRunsSinceAnyTextLines = { TextLines = { "AthenaAboutHadesKeepsake01" }, Count = 2 },
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/Athena_0238",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So you've another blessing from Lord Hades, then. Zagreus, I'm under no delusion you and your father shall become the closest friends, from here. Neverthless, I do believe it's possible to move forward even such a relationship as yours. Believe me... I know." },
			},

			AthenaPostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift01", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I so look forward to our meeting face to face amongst the gods, dear Cousin. Olympus shall be merrier and wiser once you're here." },
			},
			AthenaPostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift02", },

				{ Cue = "/VO/Athena_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hail and good tidings to you, noble Cousin. May you be swift and thorough vanquishing the dead who dare oppose you." },
			},
			AthenaPostGiftPickup03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift03", },

				{ Cue = "/VO/Athena_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remain relentless in your effort to escape, dear Cousin. In spite of all our differences, perseverance is a quality we all possess." },
			},
			AthenaPostGiftPickup04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift04", },

				{ Cue = "/VO/Athena_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You can always count upon assistance from me, Zagreus. I always shall prioritize the needs of our family above everything else." },
			},
			AthenaPostGiftPickup05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift05", },

				{ Cue = "/VO/Athena_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let my voice be a glimmer in the darkness, noble Cousin; though, may the blessing I am about to provide be even more than that." },
			},

			AthenaVsOlympians01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "PoseidonFirstPickUp", "ZeusFirstPickUp", "ArtemisFirstPickUp", "AphroditeFirstPickUp", "DionysusFirstPickUp", "AresFirstPickUp" },

				{ Cue = "/VO/Athena_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've met your distant relatives by now. We don't all share the same demeanor, nor see eye to eye. Though, all of us, I think, wish you the best." },
			},

			AthenaBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The one called Nyx... she is your mother, as I understand? We Olympians rarely consort with the chthonic gods. Though Nyx herself reached out to me about your plight, and I was spurred to act." },
			},
			AthenaBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAthena01", "AthenaGift02", "NyxGift02", "NyxAboutPersephone01" },
				RequiredFalseTextLinesLastRun = { "AthenaBackstory01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Please send the goddess Nyx my kind regards. That she supports you in your effort to escape her own domain suggests a selflessness I would not have expected." },
			},
			AthenaBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaBackstory01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's such a cruelty that your father hid the knowledge of your birth and life from us, my cousin. It's unacceptable." },
			},
			AthenaBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father Hades and my father Zeus have not communicated in some time, and Zeus refuses to explain. Something transpired between the two of them. Perhaps you know better than I." },
			},
			AthenaBackstory05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaVsOlympians01" },

				{ Cue = "/VO/Athena_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's something that I've wished to tell you, Zagreus: There is no shame in your upbringing. Many of us on Olympus, we likewise were born and raised under the strangest circumstances. Someday I'll have to tell you about mine." },
			},

			AthenaPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "HadesPostFlashback01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're nothing like your father, Zagreus. I mean that as a compliment. He cut himself off from the rest of us. Many times have we attempted peace, to no avail." },
			},

			AthenaRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyRoomsLastRun = { "B_Boss01", "B_Boss02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It comforts me to see how far you've come, Cousin. And I am confident that you shall make your way, eventually. I shall look forward to our conversations then." },
			},
			AthenaRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "B_Intro",
				RequiredFalseRoomLastRun = "C_Intro",
				RequiredRunsCleared = 0,
				{ Cue = "/VO/Athena_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You reached the flames of Asphodel, well done! You may have quite a distance still to go, but having crossed through Tartarus is no small step, Cousin." },
			},
			AthenaRunProgress03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "C_Intro",
				RequiredFalseRoomLastRun = "D_Intro",
				RequiredMaxRunsCleared = 2,
				{ Cue = "/VO/Athena_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I see you've made it all the way to hallowed Elysium, Cousin? A significant way toward the surface, and if you could get there the one time, surely you have what it takes to do it again, and overcome the dangers that await therein." },
			},
			AthenaRunProgress04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyRoomsLastRun = { "D_Intro" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunNotCleared = true,
				{ Cue = "/VO/Athena_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I understand you nearly reached the surface lately, Zagreus. My confidence remains unshaken that you shall get out of there, eventually. No matter what sorts of unknown horrors lie shrouded beyond the boundary there." },
			},

			AthenaRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Athena_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Were you not close to having reached the surface lately, Cousin? Then, this can only mean some unforeseen impediment prevented your escape." },
			},
			AthenaRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				RequiredTextLines = { "AthenaRunCleared01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There must be some unconquerable force or foe awaiting you, just at the border of your realm and ours. We cannot even see it through a shroud of darkness, there. I shall make certain that your family knows it may take considerable time to surpass... so fear not, for we are patient, here." },
			},
			AthenaRunCleared03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				RequiredTextLines = { "AthenaRunCleared01", "AthenaGift06" },
				{ Cue = "/VO/Athena_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Despite whatever difficulties you've encountered, dear Cousin, again and again, you have never yielded. I must admit, your strength of will is quite inspiring. For, even I have doubts, from time to time. It's all the clearer to me why the goddess Nyx spoke so highly of you." },
			},

			AthenaPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "AthenaPostEpilogue01" },
				{ Cue = "/VO/Athena_0235",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's fortunate your troubles with your mother were resolved. Persephone, I mean! To think I led all of my family to believe your mother was the goddess Nyx, instead. It seems I was an unwitting accomplice to a bit of a deception, there. But Nyx, I know she merely tried to help." },
			},

			AthenaAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceAthenaBoonTrait",

				{ Cue = "/VO/Athena_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear my Owl Pendant, noble Cousin! Wherever it should go, I faintly see its shimmer from afar. Even where you reside! For owls see in total darkness, after all." },
			},

			AthenaAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift04", "NyxGift04" },
				{ Cue = "/VO/Athena_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have grown closer than expected with the goddess Nyx in all of this, Cousin. It is quite evident to me how much she cares for you. I must admit I envy your relationship, sometimes. For I've made do without a mother's presence in my life." },
			},
			AthenaAboutNyx02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift04", "AresWithAthena01" },
				RequiredAnyTextLines = { "AresAboutNyx04", "AresAboutNyx04_B" },
				RequiredFalseTextLinesLastRun = { "AresAboutNyx04", "AresAboutNyx04_B" },
				{ Cue = "/VO/Athena_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lord Ares has suggested he and goddess Nyx have grown much closer to each other, in all this. Nothing untoward, if you must know. Ares and I have often disagreed, about so many things, and yet we share a fondness for the Night herself, it seems." },
			},
			AthenaAboutNyx03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift07", "NyxGift09" },
				{ Cue = "/VO/Athena_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sometimes I think about the Goddess Nyx, and how I long for her to be the mother that I never had, Cousin. Is it improper that I say such things to you? One would expect I would already have somebody on Olympus, yet... it often feels as though I am the mother, here." },
			},

			AthenaAboutQuestLog01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredCosmetics = { "QuestLog", },
				RequiredMinQuestsComplete = 5,
				{ Cue = "/VO/Athena_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The goddess Nyx has indicated you possess a list of prophecies from the Three Fates. I've such a list upon Olympus, here! It seems to be connected to your own, as several prophecies already are fulfilled. Isn't it such an honor to urge Fate along?" },
			},

			AthenaLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You cannot withstand your father's legions, Zagreus. But if you possess one of my greatest blessings, things may unfold differently, I think." },
			},
			AthenaLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dear Cousin, would that I could give to you everlasting, tireless resolve. Though, come to think of it, this may be suited as a counterpart." },
			},

			AthenaMaxRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Athena_07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Supporting you through your ordeal, Cousin? It's reminiscent of the thrill of doing battle by the side of those whom I hold dear. I may be safe upon our mountaintop, though I am with you there, as well... for every well-earned victory, and bitter loss." },
			},

			AthenaHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Athena_0068",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You brandish the Eternal Spear we call Varatha...! So then it wasn't lost during the war. A magnificent weapon, in deserving hands." },
			},
			AthenaHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "BowWeapon",

				{ Cue = "/VO/Athena_0069",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, you wield Coronacht the Heart-Seeker...! I never took you for an archer, though the power of that bow is undeniable. Use it wisely!" },
			},
			AthenaHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "ShieldWeapon",
				RequiredTrait = "ShieldRushBonusProjectileTrait",

				{ Cue = "/VO/Athena_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear Aegis, the original itself...! My own shield was forged much later, in its image. You'll have to tell me someday how you found it." },
			},
			AthenaHasWeapon04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Athena_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You got your hands on Malphon, the Twin Fists, I see. No ordinary weapon. Prone to fits of savagery quite unbecoming of a well-trained warrior. Then watch yourself, and throw not caution to the wind." },
			},
			AthenaHasWeapon05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",

				{ Cue = "/VO/Athena_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The Rail of Adamant, itself, has found its way into your hands, Cousin? A malignant thing, if you were to ask me, and not one I would ever use, myself. Unless, perhaps, I had no other choice. I suppose it must have been that way for you." },
			},

			AthenaLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're badly injured aren't you, Cousin? I wish that I could will the pain away, though at the least I can provide you this." },
			},
			AthenaLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look at you, Zagreus, you're barely fit to fight from all the injury that you've sustained! I'll try to keep you going for as long as possible." },
			},
			AthenaLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It seems to me that you've sustained life-draining injuries already, Zagreus. But don't lose hope. We can sustain you in a proper fighting shape." },
			},
			AthenaLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You may have suffered many wounds but shall not perish imminently, Cousin. Not if I have anything to say about it. Here." },
			},
			AthenaLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "AthenaGift01" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, Zagreus... your recent battles evidently haven't gone as hoped. Nevertheless, always strive onward, while you still draw breath." },
			},

			AthenaLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "For you, my cousin Zagreus, I wish to offer the most potent of the blessings I am able to bestow. Make wise your use of this, and rise toward us!" },
			},
			AthenaLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The circumstances spur me now to offer you the greatest of my powers, Cousin. Take my strength, and strike the darkness down!" },
			},
		},

		PickupTextLineSets =
		{
			AthenaFirstPickUp =
			{
				PlayOnce = true,
				RequiredRoom = "RoomSimple01",
				{ Cue = "/VO/ZagreusField_0774", Portrait = "Portrait_Zag_Default_01", Speaker = "PlayerUnit_Intro", SpeakerLabelOffsetY = 18,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 5.7 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "It's got to be her. Then, here goes nothing... {#DialogueItalicFormat}Ahem{#PreviousFormat}. In the name of Hades! Olympus, I accept this message." },
				{ Cue = "/VO/Athena_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Hail, noble Cousin. Now let's get you from that miserable place. I'll see that all of us upon Olympus do our part, beginning here with me." },
			},
			AthenaMiscPickup01 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Keep fighting, Cousin. Fight from out of that eternal gloom. I trust that you'll be joining us upon Olympus shortly." },
			},
			AthenaMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have your back, Cousin. Rise now to your rightful station with my blessings!" },
			},
			AthenaMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "May the light and fury of Olympus guide you from the dark, Cousin. I've a token of it for you here." },
			},
			AthenaMiscPickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Push forward, noble Cousin. I shall be keen to see you circumvent the perils that the Fates arranged for you this time." },
			},
			AthenaMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vanquish all who stand against you, noble Cousin. I and your relatives upon Olympus shall assist you in so doing." },
			},
			AthenaMiscPickup06 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sometimes I think about what you've endured, to have been living in that loathsome squalor, Cousin. I swear, you'll have your justice." },
			},
			AthenaMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do not fear your father's cruel legions, Cousin! Their lives are long since forfeit, and they cannot stand against one of your birthright, nor against my power." },
			},
			AthenaMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Yours is a brazen plan of action, Zagreus, and I admire it. The boldest strategy often prevails. Especially with my support." },
			},
			AthenaMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Take heart, Cousin; for you have found me even in the suffocating darkness of the Underworld. May my power be of some assistance." },
			},
			AthenaMiscPickup10 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your struggles have not gone unnoticed, Cousin, so take heart. Eternity awaits you once you finally break free." },
			},
			AthenaMiscPickup11 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here on Olympus is the opposite of everything about that lifeless squalor you reside in, Zagreus. Fight on and come to us!" },
			},
			AthenaMiscPickup12 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cousin, I grow angry merely thinking of your situation. May what power I can offer be of service as you struggle towards your fate." },
			},
			AthenaMiscPickup13 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father chose to sever ties with all of us, and stew alone within his land beneath the earth. But you are not beholden to his actions. Fight!" },
			},
			AthenaMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your labors make you stronger, noble Cousin. And, the blessings I now offer ought to make you stronger still." },
			},
			AthenaMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've found you once again, dear Cousin, and my strength is yours; so much of it as I can send there to the bowels of the earth." },
			},
			AthenaMiscPickup16 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm here again to lend to you my power, noble Cousin. Though your own strength of will is how you'll finally break free of that cruel place." },
			},
			AthenaMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm pleased to see your father's stubbornness is manifest in you as such determination, Zagreus. My blessing be with you." },
			},
			AthenaMiscPickup18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What wretched fools dare stand against you, Cousin? Punish them, so that they learn something they ought have learned in life." },
			},
			AthenaMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hold fast to your resolve, Cousin, and climb on toward the surface. No matter how often your foothold falters, I am here." },
			},
			AthenaMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall not keep you, Zagreus, except to offer you some of my power to improve your chances of escape. Now quickly choose, and go." },
			},

			-- shorter acknowledgments
			AthenaMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "May wisdom and good fortune guide you toward the light of day this time, Cousin." },
			},
			AthenaMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The Underworld's wretched dead shall fear you yet, Cousin." },
			},
			AthenaMiscPickup21 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Strength and wisdom guide you from the darkness, Zagreus." },
			},
			AthenaMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The low cunning of your lifeless enemies is not a match for your divine might." },
			},
			AthenaMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remember I am always watching over you, dear Cousin." },
			},
			AthenaMiscPickup24 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'll have your justice in due course, Cousin. I promise you." },
			},
			AthenaMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The might and fury of Olympus courses through you, noble Cousin." },
			},

			AthenaMiscPickupExtra01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I take it you've a plan in mind this time for how you're going to escape, don't you, Cousin?" },
			},
			AthenaMiscPickupExtra02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall not keep you, Zagreus, except to offer you my power to improve your chances of escape." },
			},
			AthenaMiscPickupExtra03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remain relentless in your effort, Zagreus. For perseverance is a quality we all possess." },
			},
			AthenaMiscPickupExtra04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I and your family on Olympus all stand ready to support you in your efforts, noble Cousin." },
			},
			AthenaMiscPickupExtra05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remember, doubt and hesitancy are your real enemies, Cousin." },
			},
			AthenaMiscPickupExtra06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know that you are more than capable even without my power, Cousin. But just in case..." },
			},
			AthenaMiscPickupExtra07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Athena_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Envision your success, and choose the means by which you shall achieve it, Zagreus." },
			},
			AthenaMiscPickupExtra08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall not offer empty words, dear Cousin; I shall instead offer you this." },
			},
			AthenaMiscPickupExtra09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "With our ferocity combined, Cousin, what chances do your father's forces even have?" },
			},
			AthenaMiscPickupExtra10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My support alone is not enough to see you through this, Zagreus; but it certainly shall help." },
			},
			AthenaMiscPickupExtra11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your foes shall soon find it impossible to overcome your strength, combined with mine." },
			},
			AthenaMiscPickupExtra12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've every confidence that you shall imminently put my blessing to good use." },
			},
			AthenaMiscPickupExtra13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let not your sense of purpose waver, Zagreus. Visualize the outcome you desire." },
			},
			AthenaMiscPickupExtra14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Make not the same mistake twice, and you shall always grow wiser, no matter what else." },
			},
			AthenaMiscPickupExtra15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall do everything within my power to defend you from the perils of your journey, Zagreus." },
			},
			AthenaMiscPickupExtra16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Take heed against your father's legions, Zagreus. And take also my power." },
			},
			AthenaMiscPickupExtra17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do not forget that changing strategy can be the key to victory, Cousin." },
			},
			AthenaMiscPickupExtra18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I cannot glean the details of your predicament right now, Cousin. Though maybe this shall help." },
			},
			AthenaMiscPickupExtra19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0172",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The might and honor of Olympus shield you against the darkness and the dead, Zagreus." },
			},

			AthenaMiscPickupRare01 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0173",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I take it having an impenetrable defense against your enemies may be of some use, Cousin?" },
			},
			AthenaMiscPickupRare02 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm not in any mood to trifle with your father's nonsense this time, Zagreus. So, use this." },
			},
			AthenaMiscPickupRare03 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "These are among the mightest defenses I can offer, Zagreus. Choose wisely, then." },
			},
			AthenaMiscPickupRare04 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've readied several of my most potent blessings so your victory can be achieved, Cousin." },
			},
			AthenaMiscPickupRare05 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Observe, dear Cousin, for this time I offer you uncommonly superior protection." },
			},

		},

		BoughtTextLines =
		{
			AthenaLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It feels unseemly to make contact from that most-unpleasant boatman's stash of ill-gotten wares. Nonetheless, this was an opportunity." },
			},
			AthenaLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're difficult to track there in the depths, Cousin; though, the boatman Charon thankfully is proving of some help." },
			},
			AthenaLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The river-boatman Charon is beholden to your father's realm, but seems agreeable enough, for a fair price." },
			},
			AthenaLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A shrewd expenditure of wealth is sometimes all that stands between a victory and sore defeat, isn't that right, Cousin?" },
			},
			AthenaLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We cannot effectively communicate with Charon from Olympus, but he is amenable to certain trades, and seems unfettered by your father's influence." },
			},

		},

		RejectionTextLines =
		{
			AthenaRejection01 =
			{
				{ Cue = "/VO/Athena_0049",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I thought we were on better terms, Cousin. I ask only for your cooperation, yet still you turn your back...?" },
			},
			AthenaRejection02 =
			{
				{ Cue = "/VO/Athena_0050",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm disappointed you would spurn me like this, Cousin. Know that I retaliate not out of spite, but by necessity." },
			},
			AthenaRejection03 =
			{
				{ Cue = "/VO/Athena_0051",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'd choose one of my relatives, instead of me...? Though I myself was first to contact you? Alas, I must respond to you in kind." },
			},
			AthenaRejection04 =
			{
				{ Cue = "/VO/Athena_0052",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Upon Olympus, I'm your closest confidant. You'd best remember this before you spurn me again." },
			},
			AthenaRejection05 =
			{
				{ Cue = "/VO/Athena_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We Olympians, we are a prideful family, Cousin. You cannot simply choose a favorite without spurring one of us to wrath." },
			},
			AthenaRejection06 =
			{
				{ Cue = "/VO/Athena_0135",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I understand you've made your choice, Cousin. And I, in turn, now have my family's reputation to uphold." },
			},
			AthenaRejection07 =
			{
				{ Cue = "/VO/Athena_0136",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If you had given due consideration to this matter, then I doubt you would have chosen this outcome." },
			},
			AthenaRejection08 =
			{
				{ Cue = "/VO/Athena_0137",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No one in our family can avoid taking sides forever, Zagreus. But you can take the more sensible side, at least." },
			},
			AthenaRejection09 =
			{
				{ Cue = "/VO/Athena_0138",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A senseless, punishable choice. But if you wish to face the consequences, so be it." },
			},
			AthenaRejection10 =
			{
				{ Cue = "/VO/Athena_0139",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You could have avoided this outcome any number of ways, yet still you risk incurring my wrath." },
			},
			AthenaRejection11 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0140",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Are you testing the limits of my patience with you, Zagreus? Then, I shall test your limits, in turn." },
			},
			AthenaRejection12 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0141",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I knew there was a possibility that you would side against me once again, but your doing so never ceases to amaze, Cousin." },
			},
			AthenaRejection13 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0142",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If this is your idea of humor, Zagreus, then I shall make clear to you again that I am unamused." },
			},
			AthenaRejection14 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0143",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I think we understand by now that when you test my patience, I shall test your ability to survive." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Apologies, Athena.
				{ Cue = "/VO/ZagreusField_0163" },
				-- Lady Athena, I'm sorry.
				{ Cue = "/VO/ZagreusField_4137" },
				-- I hate to do this, Athena.
				{ Cue = "/VO/ZagreusField_4138" },
				-- Forgive me, Athena.
				{ Cue = "/VO/ZagreusField_4139" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			AthenaMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, let's continue on, already, Zagreus. There isn't any point in feuding, and there's much to do before your quest is done." },
			},
			AthenaMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now then! I hope we can move past this little incident, and keep our focus on the task at hand." },
			},
			AthenaMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm satisfied we understand each other better, now, don't we. What do you say we carry on, and get you from this place?" },
			},
			AthenaMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All is forgiven, Zagreus, and I take no offense. Exacting vengeance is just something we Olympians all do from time to time." },
			},
			AthenaMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd say I've bickered with you quite enough for now, Cousin. Let us continue down a more productive path." },
			},
			AthenaMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We've better things to do, I think, than fight amongst ourselves over a matter such as this." },
			},
			AthenaMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I would very much prefer to think we both know better than to let old grudges stew forever, Zagreus." },
			},
			AthenaMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You see I have my father's temper, Zagreus. I am able to keep it in check, though I expect you to do your part." },
			},
			AthenaMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Conflict between the members of our family is inevitable, Zagreus. All we can do is learn and grow from it." },
			},
			AthenaMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I see no benefit to staying angry, Cousin. I promised Nyx that I would help rather than hinder you." },
			},
			AthenaMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father also made some questionable choices, Zagreus. But all of us are family, after all." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			AthenaGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0123", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I'm indebted to you, Goddess, for all that you and your side of the family have done for me." },
				{ Cue = "/VO/Athena_0062",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well it simply isn't in my nature to allow such offerings to go unanswered, noble Cousin. In turn, I wish for you to have this, with my compliments." },
			},
			AthenaGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift01", },
				{ Cue = "/VO/ZagreusHome_0539", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "For you, Lady Athena, without whom I would assuredly be lost." },
				{ Cue = "/VO/Athena_0059",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "This is an unexpected gesture, Cousin! I do appreciate it, though please do not feel obliged. I offer you my friendship, not a loan to be repaid." },
			},
			AthenaGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift02", },
				{ Cue = "/VO/ZagreusHome_0540", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I have a simple token for you, Goddess. Although it's insufficient thanks for all the aid you've given me." },
				{ Cue = "/VO/Athena_0060",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are most gracious, Cousin, to extend this offering. You honor me, yet I would ask you think of your well-being for the time, not mine." },
			},
			AthenaGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift03", },
				{ Cue = "/VO/ZagreusHome_0541", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Goddess Athena, please accept this gift. Your wisdom ever guides me toward the light." },
				{ Cue = "/VO/Athena_0217",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My, how very generous of you, to offer me this gift! I'm very grateful, though I ask that you not go out of your way on my account. Let's please stay focused, here?" },
			},
			AthenaGift05A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift04" },
				RequiredFalseTextLines = { "AthenaGift05B", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/ZagreusField_3859", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "As I remain committed to my task, Goddess, I'm reminded none of this would have been possible without your aid. And so, I must give thanks, even if through a meager offering." },
				{ Cue = "/VO/Athena_0218",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know there isn't much that you can do to show your gratitude at present, Zagreus. But I would ask that you save it for when your task is complete. You've more important matters to attend to now!" },
			},
			AthenaGift05B =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift04", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AthenaGift05A" },
				{ Cue = "/VO/ZagreusField_3859", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "As I remain committed to my task, Goddess, I'm reminded none of this would have been possible without your aid. And so, I must give thanks, even if through a meager offering." },
				{ Cue = "/VO/Athena_0219",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know there isn't much that you can do to show your gratitude at present, Zagreus. But I would ask that you save it for a better time. You've more important matters to attend to, now!" },
			},
			AthenaGift06 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "AthenaGift05A", "AthenaGift05B" },
				{ Cue = "/VO/ZagreusField_3860", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lady Athena, I know there's more at stake for you in this than just my plight... you care so much about this family. That care and your determination spurs me on. I'm ever grateful." },
				{ Cue = "/VO/Athena_0220",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps there really is no time quite like the present when it comes to showing thanks to one another, my dear Cousin. You've opened my eyes to the possibility, though I remain steadfast in my resolve to fight for you." },
			},
			AthenaGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift06" },
				{ Cue = "/VO/ZagreusField_3861", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I know this Ambrosia originated on Olympus, Lady Athena. Though through its long voyage to these depths, I trust its savor is more worthy of your grace. No one's ever had a greater cousin. And I'll never forget what you've done for me." },
				{ Cue = "/VO/Athena_0221",
					PortraitExitWait = 1.0,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Athena_01", Icon = "Keepsake_AthenaSticker_Max" },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus? When Nyx revealed herself to me and I first learned of you, I saw it as an opportunity to bridge the great divide between Olympus and your father's realm. But, having had all these glimpses into who you are, it is an even greater honor to have forged this partnership with you." },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Lady Athena, thank you.
			{ Cue = "/VO/ZagreusHome_0324" },
		},

		ShoutActivationSound = "/SFX/AthenaWrathHolyShield",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "AthenaUpgrade",

				-- The fury of Olympus!
				{ Cue = "/VO/Athena_0065" },
				-- Behold our power!
				{ Cue = "/VO/Athena_0066" },
				-- I shall protect you, Cousin!
				{ Cue = "/VO/Athena_0067" },
				-- As you wish.
				{ Cue = "/VO/Athena_0078" },
				-- You're under my protection!
				{ Cue = "/VO/Athena_0195" },
				-- You are untouchable for now, Cousin!
				{ Cue = "/VO/Athena_0196" },
				-- Just let them try and stop you!
				{ Cue = "/VO/Athena_0197", RequiredMinKillEnemies = 2 },
				-- Become unstoppable!
				{ Cue = "/VO/Athena_0198" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "AthenaUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- I strongly disapprove.
				{ Cue = "/VO/Athena_0103" },
				-- Have you gone mad, Cousin?
				{ Cue = "/VO/Athena_0104" },
				-- I ought not help you thus!
				{ Cue = "/VO/Athena_0199" },
				-- You ask me now to aid you, is that so?!
				{ Cue = "/VO/Athena_0200" },
				-- Are you quite serious about this, Zagreus?!
				{ Cue = "/VO/Athena_0201" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAthenaRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- A thoughtful offer, Lady Athena.
			{ Cue = "/VO/ZagreusField_1860" },
			-- I must oblige, Lady Athena.
			{ Cue = "/VO/ZagreusField_1861" },
			-- Lady Athena, I accept.
			{ Cue = "/VO/ZagreusField_1862" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- Perhaps next time you shall cooperate with me again.
			{ Cue = "/VO/Athena_0192" },
			-- Wound the pride of an Olympian, and pay the price.
			{ Cue = "/VO/Athena_0193" },
			-- Know that this could have been avoided, Zagreus.
			{ Cue = "/VO/Athena_0194" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.AthenaVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- I greet you, Cousin.
			{ Cue = "/VO/Athena_0073", },
			-- I've come to offer my support.
			{ Cue = "/VO/Athena_0074" },
			-- Wisdom guide you, Cousin.
			{ Cue = "/VO/Athena_0077" },
			-- My blessing be with you.
			{ Cue = "/VO/Athena_0089", },
			-- I commend you for your efforts.
			{ Cue = "/VO/Athena_0120", },
		},
	},

	-- Poseidon
	PoseidonUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolPoseidon",
		BoonInfoIcon = "BoonInfoSymbolPoseidonIcon",
		DoorIcon = "BoonSymbolPoseidonIsometric",
		Color = { 0, 191, 255, 255 },
		LightingColor = {139, 199, 253, 255},
		LootColor = {0, 200, 255, 255},
		SubtitleColor = {0.196, 1.000, 0.745, 1.0},
		EventEndSound = "/SFX/PoseidonBoonWaveCrash",
		RequiredMinCompletedRuns = 1,
		LootRejectionAnimation = "BoonDissipateA_Poseidon",
		UpgradeSelectedSound = "/SFX/PoseidonBoonChoice",

		PriorityUpgrades = {"PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRushTrait", "PoseidonRangedTrait" },
		WeaponUpgrades = {"PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
		Traits = { "RoomRewardBonusTrait", "DefensiveSuperGenerationTrait", "EncounterStartOffenseBuffTrait" },
		Consumables = { "RandomMinorLootDrop" },

		LinkedUpgrades =
		{
			PoseidonShoutDurationTrait =
			{
				OneOf = { "PoseidonShoutTrait" },
			},
			BonusCollisionTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			BonusCollisionTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			SlamExplosionTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			SlipperyTrait =
			{
				PriorityChance = 0.5,
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			BossDamageTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			StatusImmunityTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonShoutTrait" },
				}
			},
			FishingTrait =
			{
				OneFromEachSet =
				{
					{ "RoomRewardBonusTrait" },
					{ "PoseidonPickedUpMinorLootTrait" },
				}
			},
			DoubleCollisionTrait =
			{
				OneFromEachSet =
				{
					{ "BonusCollisionTrait", "SlamExplosionTrait", "SlipperyTrait" },
					{ "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
				}
			},
			ImprovedPomTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			RaritySuperBoost =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRangedTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			ImpactBoltTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait" },
				}
			},
			BlizzardOrbTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "PoseidonRangedTrait" },
				}
			},
			ArtemisBonusProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
				}
			},
			PoseidonAresProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresShoutTrait" },
					{ "PoseidonRangedTrait" },
				}
			},
		},

		Speaker = "NPC_Poseidon_01",
		Portrait = "Portrait_Poseidon_Default_01",
		WrathPortrait = "Portrait_Poseidon_Wrath_01",
		OverlayAnim = "PoseidonOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/PoseidonBoonWaveCrash",
		FlavorTextIds =
		{
			"PoseidonUpgrade_FlavorText01",
			"PoseidonUpgrade_FlavorText02",
			"PoseidonUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			-- Wrath Intro
			{
				PlayOnce = true,
				RequiredRoom = "RoomOpening",
				PreLineWait = 1.75,
				BreakIfPlayed = true,
				RequiredMinCompletedRuns = 4,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "PoseidonWrathIntro01" },
				RequiredAnyKeepsakes = { "ForceZeusBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait" },
				RequiredKillEnemiesNotFound = true,
				Queue = "Always",

				-- What's Uncle Poseidon doing here?
				{ Cue = "/VO/ZagreusField_1524", },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PlayOnceThisRun = true,
				PreLineWait = 0.85,
				ChanceToPlay = 0.33,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },

				-- Uncle Poseidon...
				{ Cue = "/VO/ZagreusField_0686" },
				-- Lord Poseidon...
				{ Cue = "/VO/ZagreusField_0687" },
			},
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PreLineWait = 1.0,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "Shop" },
				PlayOnce = true,
				PlayOnceContext = "WrathIntro",
				RequiredTextLinesThisRun = "PoseidonWrathIntro01",
				TriggerCooldowns =
				{
					"ZagreusFoundRareBoonSpeechPlayed",
				},

				-- Hoh, what's this.
				{ Cue = "/VO/ZagreusField_1470" },
			},
			{
				PreLineWait = 1.0,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "Shop" },
				PlayOnce = true,
				PlayOnceContext = "FishQuestIntro",
				RequiredTextLinesThisRun = "PoseidonFishQuest01",

				-- What is this...
				{ Cue = "/VO/ZagreusField_3339" },
			},
			[3] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[4] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			PoseidonWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ImpactBoltTrait",
				PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSurprise", DoShake = true, WaitTime = 11.2 },
				{ Cue = "/VO/Poseidon_0129",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Now, little Hades, you have met my brother Zeus! He's sometimes known as king of all the gods! Although, in many ways, he's not as powerful as I! Nor anywhere as dashing. Why, I, {#DialogueItalicFormat}oop{#PreviousFormat}--!" },
				{ Cue = "/VO/Zeus_0125",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Now, Brother, you know better than to say such things about me, I should think! I know that tact does not come easily to you, though I'd be careful what you say to our good nephew there." },
				{ Cue = "/VO/Poseidon_0130",
					Emote = "PortraitEmoteFiredUp",					
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Buh{#PreviousFormat}, {#DialogueItalicFormat}erm{#PreviousFormat}, anyway, as I was saying, little Hades! Brother Zeus is king of all the gods! And the most dashing, powerful, and hey, let's face it, {#DialogueItalicFormat}godliest {#PreviousFormat}of all!" },
			},
			PoseidonWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StatusImmunityTrait",
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Poseidon_0232",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "As you can see by now, we are a big and clever family, little Hades! My niece Athena here being the cleverest of all. You'd never know that she was childless, the way she looks after and cares for all of us!" },
				{ Cue = "/VO/Athena_0228",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Surely my cleverness comes from your brother and yourself, Lord Uncle Poseidon. And I would only add, my feeling is we've more than enough children in this family, thus no further need for more of them, for now." },
			},
			PoseidonWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoseidonAresProjectileTrait",
				{ Cue = "/VO/Poseidon_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Now, little Hades, you must know by now I've other nephews here, don't you? For instance, Ares comes to mind, the god of war! Some mighty wars have taken place at sea, is that not so?" },
				{ Cue = "/VO/Ares_0224",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Indeed, they have, good Uncle Poseidon. Mortals show great ingenuity when war is concerned; it drives their sense of progress, more than anything at all. Perhaps someday they shall wage war even in Father's skies." },
			},
			PoseidonWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ArtemisBonusProjectileTrait",
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Poseidon_0236",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "The thing about me, Nephew, is I get along with everybody, here! A skill apparently that's rather rare! Take my niece Artemis, for instance! Can't ever take a simple jest, at all! You won't easily attract a mate with such a sour look about you, girl!" },
				{ Cue = "/VO/Artemis_0236",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Oh, and wouldn't that be such a pity, Uncle Poseidon. I wonder what could be the cause of this sour look that I perpetually have up here? Maybe Zagreus knows." },
				{ Cue = "/VO/Poseidon_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}! See exactly what I mean, Nephew?" },
			},
			PoseidonWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "BlizzardOrbTrait",
				{ Cue = "/VO/Poseidon_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "My foster-sister Goddess Demeter, despite her stern approach, she often likes to make good sport of me, Nephew! Why, here she is right now!" },
				{ Cue = "/VO/Demeter_0144",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "If you're quite finished blathering, Poseidon, our young Zagreus has more important things to do. He needs your blessings, not your point of view. Don't you, young sprout?" },
			},

		},

		SuperPriorityPickupTextLineSets =
		{
			PoseidonBeatTheseusQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredKillsLastRun = { "Theseus2" },
				RequiredTextLines = { "PoseidonBeatTheseusQuest01" },
				{ Cue = "/VO/Poseidon_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-haha{#PreviousFormat}! I knew that I could count on you, Nephew! So the ungrateful Theseus, the winsome prize he earned was just some chariot, correct? And he was vanquished on it, anyway! That's what he gets! Boasting his prize was greater than any in his mortal days, {#DialogueItalicFormat}pah{#PreviousFormat}!" },
			},

			PoseidonFishQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFishQuest01" },
				RequiredFalseTextLinesLastRun = { "PoseidonFishQuest01" },
				RequiredMinTotalCaughtFish = 25,
				RequiredAnyCaughtFishTypes = { "Fish_Tartarus_Legendary_01", "Fish_Asphodel_Legendary_01", "Fish_Elysium_Legendary_01", "Fish_Styx_Legendary_01", "Fish_Chaos_Legendary_01", "Fish_Surface_Legendary_01" },
				{ Cue = "/VO/Poseidon_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-haha-hah{#PreviousFormat}, little Hades, I was certain you'd the wherewithal to thin the ranks of the betraying river denizens who fled my surface-seas to your father's domain!! I bid you such good fish-hunting forevermore!" },
			},
			PoseidonAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4337", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.38 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "All right, here goes. In the name of Hades! Olympus! This is an official message! Uncle Poseidon, hope you can make this out." },
				{ Cue = "/VO/Poseidon_0238",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "What's this, Nephew? Why, isn't this a note? Or, part of one, addressed to me, but it appears there should be other pieces, for the others here? {#DialogueItalicFormat}Ah{#PreviousFormat}, it's like a sunken treasure, then! Which means I must seek its mysteries at once!" },
			},
			PoseidonPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Poseidon_0239",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, Nephew, I had a positively raucous time down there, with your old father, and Persephone, was she a sight! I never thought I'd see {#DialogueItalicFormat}her {#PreviousFormat}again! So then, we're one big happy family, at last! But you've a job to do, and we upon Olympus, we'll do our fair share!" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			PoseidonAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Poseidon_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So, Nephew, my honored brother Zeus already has endowed you with his thunderous might? Well you shall soon forget about all that, after a taste of {#DialogueItalicFormat}this{#PreviousFormat}!" },
			},
			PoseidonAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Poseidon_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, you've received a blessing from Athena there already, little Hades! So careful all the time, that one, but here, I'll help you live a little, just in case!" },
			},
			PoseidonAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Poseidon_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh-hoh{#PreviousFormat}, so you've already heard from Aphrodite, have you, Nephew? Understandable, but first things first, now let me add a little something to all that!" },
			},
			PoseidonAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Poseidon_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hoy, Nephew, it's my understanding you've been blessed already by one of my {#DialogueItalicFormat}other {#PreviousFormat}nephews, Ares! As you can see, not all of us are cut from the same cloth; and thank the Fates for that!" },
			},
			PoseidonAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Poseidon_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I sense that you've been marked by the elusive Artemis, correct, Nephew?! She shies away from most of us, so if she's taken somewhat of a liking to you, great!" },
			},
			PoseidonAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Poseidon_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whenever Dionysus calls a feast, I'm turning up sooner or later, hear me, Nephew? So make room for one more blessing, and, let's go!" },
			},
			PoseidonAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Poseidon_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Little Hades, it appears that you are moving right along! Almost at an uncanny pace!! I wonder how you got to be so fast! Aquatic exercise?!" },
			},
			PoseidonAboutHermes02 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonAboutHermes01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Poseidon_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, how is it you're navigating your cruel father's realm at such a blinding speed?! There's only one Olympian who moves that quick! Besides myself! Where is he, anyway?" },
			},
			PoseidonAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Poseidon_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, little Hades, there's a certain chill about you, meaning you received an ice-cold blessing courtesy of Elder Goddess Demeter, correct? Now, personally, I think water's best in liquid form, but who am I to judge?" },
			},

			PoseidonVsZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp", "ZeusGift01" },
				RequiredMinCompletedRuns = 3,

				{ Cue = "/VO/Poseidon_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've come to know your Uncle Zeus, by now, correct? Just want to let you know, good Zeus gets very busy on the regular, so you just stick with me, I've always time for you, Nephew!" },
			},

			PoseidonBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Poseidon_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, your cruel father, Hades, he's my elder brother, you know that? Not exactly the expressive type, and never was. We seldomly saw eye-to-eye on things!" },
			},
			PoseidonBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonBackstory01", "PoseidonGift02" },
				{ Cue = "/VO/Poseidon_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I daresay, little Hades, you've some spunk in you! Why, I think you take after me more than my crusty elder brother! You'll get away from that old codger yet!" },
			},
			PoseidonBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonBackstory01", "HadesPostFlashback01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Poseidon_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My crusty elder brother Hades must have tried to poison you against us lot, I can imagine it as clear as water, Nephew! I'm proud that you've resisted his undoubtedly most-twisted words!" },
			},
			PoseidonBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonBackstory01", "HadesPostFlashback01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Poseidon_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Last time your father and I spoke, he told me I was all washed up, can you believe the nerve of it, Nephew? Why, he took the words right out of my mouth!" },
			},
			PoseidonAboutPowers01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's likely, little Hades, that you currently reside just underneath one of my boundless seas! Normally you'd have to be submerged to use this power, but you know what, close enough!" },
			},
			PoseidonHighRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know I've many vitally important things to do besides lending my aid to you repeatedly, Nephew? But, all of that can wait! Family comes first!" },
			},
			PoseidonMaxRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If you should ever make it here, Nephew, know this! I shall be pleased to stand in for the father figure I can tell you never really had. We can engage in all sorts of aquatic competitions, solve riddles, visit the sea-nymphs! Oh, it would be great, wouldn't you think?" },
			},
			PoseidonAboutSeas01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift03" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nephew, why, the seas up here, they're just about as widely feared as your vast Underworld down there! For water can be deadlier than bronze!" },
			},
			PoseidonAboutSeas02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My oceans, they are filled with danger, not just water, little Hades! Many of the dead you face, they met their mortal end at sea, and not on land!" },
			},

			PoseidonVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "PoseidonVsMeg02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Poseidon_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, it seems to me you've had yourself a spot of lady trouble, lately, isn't that correct, Nephew? I mean the Fury down in Tartarus, of course! You going to let her keep on bossing you around?!" },
			},
			PoseidonVsMeg02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredKills = { Harpy = 3 },
				RequiredKillsLastRun = { "Harpy" },
				{ Cue = "/VO/Poseidon_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! I heard you showed that good-for-nothing Fury after all, I knew you'd handle that old crone, Nephew! And if she troubles you again, you just remind her who's in charge down there!" },
			},

			PoseidonRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonVsMeg02" },
				RequiredRoomLastRun = "B_Intro",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Poseidon_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good tidings, Nephew! I've learned that you have managed to get all the way to Asphodel, fine work! Now, you just keep on going!" },
			},
			PoseidonRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "C_MiniBoss01",
				RequiredMinTimesSeenRoom = { C_MiniBoss01 = 2 },
				{ Cue = "/VO/Poseidon_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, Nephew, you've stood against the Bull of Minos, have you? Well I must apologize for any inconvenience there, because, he was a living testament to my revenge! Long story, boring really, rather sordid, too. Stay strong!" },
			},
			PoseidonRunProgress03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMinTimesSeenRoom = { D_Boss01 = 2 },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/Poseidon_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Word reaches us that you've come very far, indeed, Nephew! Striking distance from the surface! You just keep at it like that, and with our help, we'll have you out of there for sure!" },
			},
			PoseidonRunProgress04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/Poseidon_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I wonder what monstrosities await you near the surface, little Hades? There's your father's terrifying hell-hound, for one thing! Ah, well, I'm sure you'll find a way to sail past whatever's in your way!" },
			},
			PoseidonRunProgress05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "D_Intro",
				RequiresLastRunNotCleared = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now don't lose heart, Nephew! Because in spite of all your efforts, it is probably the case that you still have a long and painful road ahead!" },
			},

			PoseidonRunCleared01 =
			{
				PlayOnce = true,
				RequiresLastRunCleared = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, I thought for certain you were well on your way out of there last time, Nephew! But, no matter, we'll just get you on another voyage to the top!" },
			},
			PoseidonRunCleared02 =
			{
				PlayOnce = true,
				RequiresLastRunCleared = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Little Nephew, why, I could have sworn you made it to the surface recently, and yet, you're all the way back there, again? Must be some sort of terrible monstrosity preventing your way out!" },
			},

			PoseidonPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Poseidon_0240",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'll tell you, Nephew, I was quite taken aback to learn Persephone, she was your mother all along! Just disappeared up here, one day! Ran off, I figured, as she's got some mortal blood in her. But she was with your father! That rascal is my brother, after all!" },
			},
			PoseidonPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift03" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				{ Cue = "/VO/Poseidon_0244",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So how is crusty old Hades faring down there of late, Nephew? Fewer worries there upon his brow? That Underworld of yours all running smoothly, and all that? We'll keep on pitching in from over here. Least we can do!" },
			},
			PoseidonPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift04" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Poseidon_0245",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Persephone, she says you're really stuck down there, born of the Underworld, something like that? Well, if you ask me, that's no kind of attitude to have! You can do {#DialogueItalicFormat}anything {#PreviousFormat}you set your mind to, Nephew! Take it from me!" },
			},
			PoseidonPostEpilogue05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift07" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 4 },
				{ Cue = "/VO/Poseidon_0246",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If you {#DialogueItalicFormat}do {#PreviousFormat}ever get the opportunity to spend some time up here, Nephew, know I shall take you on a grand tour of the surface! From the depths of my seas to the height of Olympus! Sure, maybe not today, or tomorrow, or even the next aeon! But sometime, we should go!" },
			},
			PoseidonPostEpilogue06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift07", "ZeusGift07", "HadesGift05" },
				{ Cue = "/VO/Poseidon_0247",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Been nice to see my brothers getting on again, just like old times! Well, not exactly like old times, and come to think of it, there always was a bit of tension there between those two, but still! It's better than before!" },
			},

			PoseidonAboutPersephoneVisit01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Poseidon_0243",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your good mother Persephone, she's here all safe and sound, thought you should know, there, little Hades! Shame you can't be here with her, too, but {#DialogueItalicFormat}ah{#PreviousFormat}! Doubtless we'll someday meet again!" },
			},

			PoseidonAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForcePoseidonBoonTrait",
				{ Cue = "/VO/Poseidon_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah-{#DialogueItalicFormat}hah{#PreviousFormat}! I sense you have in your possession that fine shell I sent to you, a little gift plucked straight out of the sea! You keep it close so I can better track you down!" },
			},

			PoseidonHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",
				{ Cue = "/VO/Poseidon_0132",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My, my, little Hades, you brandish Exagryph, the Rail of Adamant! That weapon's power was so terrifying that we sealed it away. Oh well! Surely its mortal-damning secrets shall be safely guarded in your hands!" },
			},
			PoseidonAboutFistWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/Poseidon_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Huh! Why, if my eyes do not deceive me through those murky depths, you brandish {#DialogueItalicFormat}Malphon{#PreviousFormat}! Let me tell you, little Hades, those old gloves have done some dirty work before your time!" },
			},
			PoseidonHasWeaponUpgrade01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "DislodgeAmmoTrait",
				RequiredWeapon = "SwordWeapon",
				{ Cue = "/VO/Poseidon_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, little Hades, it is awful murky where you are, but if I'm not mistaken, and I never am, you wield fearsome Stygius! She once belonged to me, you know! Not quite my type, but we sure had our times! You take good care of her for me!" },
			},
			PoseidonAboutHadesAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "SpearWeaveTrait",
				RequiredWeapon = "SpearWeapon",
				{ Cue = "/VO/Poseidon_0223",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, is it me, or do you bear your father's ancient spear, Nephew? I always wanted one a bit like that. And now I have one even better. {#DialogueItalicFormat}Hah{#PreviousFormat}!" },
			},

			PoseidonLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "This time, Nephew, let's really show your father what you're made of: {#DialogueItalicFormat}Water{#PreviousFormat}! For the most part! Mortals, at least, are mostly made of it. Bet you did not know that!" },
			},
			PoseidonLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The mortals like to give me thanks for all my generosity, Nephew! But little do they know, I have been saving up a bunch of it for {#DialogueItalicFormat}you{#PreviousFormat}!" },
			},

			PoseidonAboutTheseus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "C_Boss01",
				{ Cue = "/VO/Poseidon_0224",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, word has reached me that you squared against one known as Theseus, now champion there in Elysium? He was a handful even when he lived! So much so that my honored brother Zeus, he took to calling him my son, can you believe the nerve?" },
			},
			PoseidonAboutTheseus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "C_Boss01",
				RequiredTextLines = { "PoseidonAboutTheseus01" },
				{ Cue = "/VO/Poseidon_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So, little Hades, doubtless you have seen that we upon Olympus also lend our favor to the mighty Theseus, who bars your passage from Elysium! Now, don't you take it personally, there, because our blessings go to {#DialogueItalicFormat}all {#PreviousFormat}who deserve them. Although, we try to save the best for you!" },
			},
			PoseidonBeatTheseusQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "C_Boss01",
				RequiredTextLines = { "PoseidonAboutTheseus02", "PoseidonGift04", "PoseidonRunProgress02" },
				RequiredMinRunsCleared = 1,
				{ Cue = "/VO/Poseidon_0226",
					Emote = "PortraitEmoteAnger",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That scoundrel Theseus! Apparently he earned himself some sort of winsome prize, for all his blustering there in Elysium! Though, I'm quite certain that, no matter what he and his bull friend have at their disposal, you've the power to defeat them, utterly! So go do it, surely I'll get word!" },
			},

			PoseidonAboutFishing01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredCosmetics = { "FishingUnlockItem" },

				{ Cue = "/VO/Poseidon_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Why, Nephew, you've procured the Rod of Fishing, I detect! Fine handiwork if I say so myself! Its line is nigh-invisible and causes denizens of my domain to flock to it like mortals to temples of mine! Good fortune with that thing!" },
			},
			PoseidonAboutFishing02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonAboutFishing01", "PoseidonGift02" },
				RequiredCosmetics = { "FishingUnlockItem" },
				RequiredFalseTextLinesLastRun = { "PoseidonAboutFishing01" },
				RequiredMinTotalCaughtFish = 9,
				{ Cue = "/VO/Poseidon_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm told a number of the underwater denizens from my domain were captured fair-and-square through your surpassing skill using the Rod of Fishing, little Hades!! They're yours, I've millions more!" },
			},
			PoseidonAboutFishing03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonAboutFishing02", "PoseidonGift06" },
				RequiredFalseTextLinesLastRun = { "PoseidonAboutFishing02" },
				RequiredMinTotalCaughtFish = 18,
				RequiredHasFish = true,
				{ Cue = "/VO/Poseidon_0241",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All these river denizens you've caught, little Hades... it can only mean we share a deep connection, don't you think? I, with my power over the entire vastness of the seas! And you, with the power to ensnare a hapless fish with but a flick of the wrist!" },
			},

			PoseidonAboutGuanYuAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "SpearSpinTravel",
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Poseidon_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, what exactly is that very mighty-looking spear I think I faintly see in your possession there, it's... why, I've not seen a thing like that except on very distant shores! It's almost as impressive as my trident here! {#DialogueItalicFormat}Almost{#PreviousFormat}, I say!" },
			},
			PoseidonAboutArthurAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "SwordConsecrationTrait",
				RequiredWeapon = "SwordWeapon",

				{ Cue = "/VO/Poseidon_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear some sort of splendid-looking weapon, there, Nephew! Must be another aspect of fair Stygius, my old discarded blade! Never did see that one myself, but, I saw many others that were splendid, too!" },
			},

			PoseidonLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hoh{#PreviousFormat}, you look positively in atrocious shape, there, Nephew! What's the matter, one too many run-ins with the wretched dead before {#DialogueItalicFormat}I {#PreviousFormat}intervened?" },
			},
			PoseidonLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Seems to me that you're in dire straits, there, little Hades! Why, you're bleeding everywhere! Here, let me try and do something for that." },
			},
			PoseidonLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0199",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, what happened to you, little Hades?! I can tell even from here that you've been beaten like a skiff during a storm!" },
			},
			PoseidonLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, don't go dying on me, yet, Nephew! You have to {#DialogueItalicFormat}live{#PreviousFormat}! Or else the Boon I offer you shall go to waste!" },
			},
			PoseidonLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your hated enemies, they almost got the best of you, I fear! But you can still turn it around, especially now that you have my aid!" },
			},

			PoseidonLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, have I got something for you this time, little Hades! Something special I have saved for when you {#DialogueItalicFormat}really {#PreviousFormat}proved yourself!" },
			},
			PoseidonLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's nothing stronger than the sea, Nephew, neither above it nor below!! And, if you are in need of further proof, behold: The greatest of my blessings, just for you!" },
			},
		},

		PickupTextLineSets =
		{
			PoseidonFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0779", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.85 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "It's uncle number two, it's got to be. Then, in the name of Hades! Olympus, I accept this message." },
				{ Cue = "/VO/Poseidon_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Hoy there, little Hades! You recognize your uncle, do you not? We've a lot of catching up to do, but first things first, you get yourself out of that dour Underworld! As for me, I'll see if I can {#DialogueItalicFormat}stir {#PreviousFormat}things up a bit to cover your advance!" },
			},
			PoseidonMiscPickup01 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hoy, Nephew, it's excellent to see you once again, and in good spirits, still? Then, come, let's make some waves!" },
			},
			PoseidonMiscPickup02 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Ahoy, little Hades, it is I! The greatest of your uncles! Here to aid you in your daringest escape attempt! And I do admire your persistence!" },
			},
			PoseidonMiscPickup03 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good tidings once again, there, little Nephew!! It is I, returned as ever here to make a splash against your many, many foolish enemies!" },
			},
			PoseidonMiscPickup04 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoy, Nephew! I bet you have your hands full dealing with your enemies down there, so let me see what I can do. And I can do a lot!" },
			},
			PoseidonMiscPickup05 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It seems you're getting somewhere, little Nephew! Good, but here, allow your favorite Uncle to bestow a little boost!" },
			},
			PoseidonMiscPickup06 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Ah, hahaha! {#PreviousFormat}Found you down there, Nephew! Now let's overwhelm your enemies in a typhoon of godly might, what do you say?" },
			},
			PoseidonMiscPickup07 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Little Hades, have I ever told you I detest the dead? Well, I admit it, I just cannot stand a mortal past his due. So how about we get you far away from all such filth, agreed?" },
			},
			PoseidonMiscPickup08 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say, there, Nephew, ready to get wet, or no? Oh I suspect you are, so let's get to it, and dispense some liquid justice!" },
			},
			PoseidonMiscPickup09 =
			{
				Priority = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How fares your feud against my crusty elder brother lately, good? Big Hades, he is disagreeable with all of us, not just with you, so, don't you take it personal, and stick with me!" },
			},
			PoseidonMiscPickup10 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Looks like {#DialogueItalicFormat}you {#PreviousFormat}could use the power of the sea, wouldn't you say so, little Hades? Good thing I'm here, so that together, we might wash your enemies away!" },
			},
			PoseidonMiscPickup11 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Enough kidding around without me, Nephew! I am here, so let's go bust you out, much like a raging river through a frail little dam!" },
			},
			PoseidonMiscPickup12 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're looking somewhat stronger than before, there, little Nephew, but you're much too scrawny still, to be quite blunt. So, here! Let's fatten you right up!" },
			},
			PoseidonMiscPickup13 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Hoy{#PreviousFormat}, my nephew! I think I have kept you waiting long enough, so then, let's {#DialogueItalicFormat}go{#PreviousFormat}! And break our enemies to pieces, like so many ships upon the shoals!" },
			},
			PoseidonMiscPickup14 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'll have you know, the power of the seas themselves is yours once more, Nephew! So how about you put it to its rightful purpose, and go smash some stuff!" },
			},
			PoseidonMiscPickup15 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Are you perchance in need of godlike aid, Nephew? Well, excellent! Because I happen to command the sea, and I shall hereby let you take it for a whirl!" },
			},
			PoseidonMiscPickup16 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0027",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Who dares to mess with little Hades? You simply point me at them, Nephew, and we'll leave them shivering and sopping wet, you'll see!" },
			},
			PoseidonMiscPickup17 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "At last I found you once again, Nephew! You eating well and getting strong, correct? I'll help you with the latter category in a moment. Here!" },
			},
			PoseidonMiscPickup18 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0029",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The awesome bounty of the sea is yours to do with as you please, Nephew! I've mustered forth a sample, anyway!" },
			},
			PoseidonMiscPickup19 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Hoh, little Hades! I'd heard you were preparing to rain terrible destruction on your enemies! So I got here as quickly as I could! I'm not too late, am I?" },
			},
			PoseidonMiscPickup20 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All of us must sail through troubled waters now and then, correct, Nephew? Fortunately, navigation is my speciality, so let's be on our way!" },
			},
			PoseidonMiscPickup21 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your victory's most certainly at hand now that I'm here, Nephew! So long as you make sure to take advantage of the absolutely awesome power I bequeath!" },
			},
			-- relationship improved
			PoseidonMiscPickup23 =
			{
				RequiredTextLines = { "PoseidonGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Why, if it isn't the most favored of my nephews, stuck as ever though you may yet be! We'll get you from there, little Hades, don't despair, Uncle Poseidon's here!!" },
			},
			PoseidonMiscPickup24 =
			{
				RequiredTextLines = { "PoseidonGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Good tidings, my most favored nephew! All is relatively well, I hope? But hope alone is worthless without action, is it not? So here, let's act {#DialogueItalicFormat}together{#PreviousFormat}!" },
			},
			PoseidonMiscPickup25 =
			{
				RequiredTextLines = { "PoseidonGift04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Just wait until you see the seas, Nephew! My underwater realm is the most glorious of the world's habitats. It positively teems with life, and it's much cooler there than in that sweaty Underworld of yours!" },
			},

			-- shorter acknowledgments
			PoseidonMiscPickup26 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, Nephew, supposing it's high time for the high seas to lend their might once more?" },
			},
			PoseidonMiscPickup27 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your uncle's offering to shake things up once more, what say you, little Hades?" },
			},
			PoseidonMiscPickup28 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No more dallying about, now, little Nephew! Time instead we really got somewhere!" },
			},
			PoseidonMiscPickup29 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0007",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good tidings, little Hades! It is I! And I am always here to help!" },
			},
			PoseidonMiscPickup30 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Fear not, Nephew, it is I, your uncle! Come to wash away your troubles, here and now!" },
			},
			PoseidonMiscPickup31 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0009",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Just point me toward your enemies, Nephew, and they'll become sworn enemies of mine!" },
			},
			PoseidonMiscPickup32 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's get you out from underneath the sea, there, little Nephew!" },
			},
			PoseidonMiscPickup33 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoy, my godly Nephew, I've arrived, so set aside your worries and let's drench the dead!" },
			},

			PoseidonMiscPickupExtra01 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How about we set you up here with some real {#DialogueItalicFormat}water{#PreviousFormat}-power, little Hades?" },
			},
			PoseidonMiscPickupExtra02 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0172",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I take it you could use some liquid courage at this time, no, little Hades?" },
			},
			PoseidonMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0173",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How about a swim, there, little Hades? A swim, that is, within the Pool of Blessings! Now, dive in!" },
			},
			PoseidonMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm here, Nephew, to aid you in your time of need, with {#DialogueItalicFormat}this{#PreviousFormat}!" },
			},
			PoseidonMiscPickupExtra05 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I heard that you could use the awesome power of the sea, Nephew!" },
			},
			PoseidonMiscPickupExtra06 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Go on and make a splash for me, why don't you, little Hades!" },
			},
			PoseidonMiscPickupExtra07 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The treasures of the sea are limitless, so here! You take your pick!" },
			},
			PoseidonMiscPickupExtra08 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you say we make some waves, right, little Hades?" },
			},
			PoseidonMiscPickupExtra09 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't let the wretched dead dampen your spirits, little Hades! Dampen {#DialogueItalicFormat}theirs{#PreviousFormat}!" },
			},
			PoseidonMiscPickupExtra10 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here comes another cool, refreshing blessing for you, Nephew!" },
			},
			PoseidonMiscPickupExtra11 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Water can even cut through solid stone, with enough time! So you keep at it, there!" },
			},
			PoseidonMiscPickupExtra12 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know that you can do it, little Hades! Whatever it may be!" },
			},
			PoseidonMiscPickupExtra13 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMaxHealthFraction = 0.45,
				{ Cue = "/VO/Poseidon_0183",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's darker than the bottom of the sea in there! Are you alive, Nephew?!" },
			},
			PoseidonMiscPickupExtra14 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Poseidon_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The secrets of the sea can all be yours! Eventually at least, I have just three for now!" },
			},
			PoseidonMiscPickupExtra15 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMaxHealthFraction = 0.45,
				{ Cue = "/VO/Poseidon_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You still alive down there, Nephew? Because if so, why, this ought to keep it that way!" },
			},
			PoseidonMiscPickupExtra16 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Must get so stuffy in that dreary place, Nephew! So why don't you cool off a bit, with {#DialogueItalicFormat}this{#PreviousFormat}!" },
			},
			PoseidonMiscPickupExtra17 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You have a dirty job down there, Nephew, but I can help you to clean up a bit!" },
			},
			PoseidonMiscPickupExtra18 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All that I ask, here, little Nephew, is for you to do your best! As I would do!" },
			},

			PoseidonMiscPickupRare01 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoy, and now prepare yourself! For I've a rare treat here, especially for you!" },
			},
			PoseidonMiscPickupRare02 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am ever impressed with your will to succeed, Nephew, so here! Great blessings be with you!" },
			},
			PoseidonMiscPickupRare03 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've earned only the very finest of my blessings, little Hades! Why? Why {#DialogueItalicFormat}not{#PreviousFormat}!" },
			},
			PoseidonMiscPickupRare04 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If you are ever going to get out of there, only the mightiest of all my blessings will suffice!" },
			},
			PoseidonMiscPickupRare05 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift06" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My favorite Nephew ought have access to my greatest blessings, should he not?" },
			},
		},

		BoughtTextLines =
		{
			PoseidonLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0051",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah-{#DialogueItalicFormat}hah{#PreviousFormat}! You found me, little Nephew! Strewn among the inventories of that most disturbing river-boatman! That means you win my blessing!" },
			},
			PoseidonLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, well, my plan to get ahold of you via the boatman worked out flawlessly! Harness the might of the sea, then, why don't you?" },
			},
			PoseidonLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, Nephew, I know that salty Charon can be difficult. But I am certain that whatever price you paid, you got a {#DialogueItalicFormat}deal{#PreviousFormat}!" },
			},
			PoseidonLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nothing comes freely for the mortals on the surface, Nephew! And from the sound of things, it isn't any different with that Charon character!" },
			},
			PoseidonLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonGift05" },
				{ Cue = "/VO/Poseidon_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let me just say, Nephew, that money-hoarding boatman best be fair with you! Because I'd hate to see anything happen to that little boat of his!" },
			},
		},

		RejectionTextLines =
		{
			PoseidonRejection01 =
			{
				{ Cue = "/VO/Poseidon_0003",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Whaaaa{#PreviousFormat}, you think that you've a chance in hell without my help, am I to understand?! You made a big mistake there, little Hades, just you watch." },
			},
			PoseidonRejection02 =
			{
				{ Cue = "/VO/Poseidon_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How bold of you to throw your lot in with my relatives instead of me, given the choice, there, little Hades. But don't you ever bet against {#DialogueItalicFormat}this {#PreviousFormat}horse!" },
			},
			PoseidonRejection03 =
			{
				{ Cue = "/VO/Poseidon_0054",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, now, it seems to me your strength outweighs your smarts, there, Nephew, if you're prone to picking other sides than mine!" },
			},
			PoseidonRejection04 =
			{
				{ Cue = "/VO/Poseidon_0055",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A word of caution, little Nephew: Never turn your back against the sea. And, while you're at it, never take up sides against your greatest uncle!" },
			},
			PoseidonRejection05 =
			{
				{ Cue = "/VO/Poseidon_0056",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Augh! I'm absolutely flabbergasted, Nephew!! I offer you the finest blessings of the earth and sea, and they're not good enough?" },
			},
			PoseidonRejection06 =
			{
				{ Cue = "/VO/Poseidon_0057",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Apparently my crusty elder brother failed to teach you any manners, if you deign to thusly spurn my offerings! But I can teach you yet!" },
			},
			PoseidonRejection07 =
			{
				{ Cue = "/VO/Poseidon_0152",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Betrayal{#PreviousFormat}, little Hades!! Of all my nephews, you should know better than this! Or perhaps I should. One of us, at least!" },
			},
			PoseidonRejection08 =
			{
				{ Cue = "/VO/Poseidon_0153",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That's definitely not the choice {#DialogueItalicFormat}I {#PreviousFormat}would have made, Nephew! Because, for me to side against myself, why, that would make no sense at all!" },
			},
			PoseidonRejection09 =
			{
				{ Cue = "/VO/Poseidon_0154",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Nephew, what you have just done is tantamount to spitting in my face! Let me remind you, then, the ocean can spit back!" },
			},
			PoseidonRejection10 =
			{
				{ Cue = "/VO/Poseidon_0155",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "You wound me, little Hades, with your callous choice! It's fortunate I'm quite impervious to harm. But I don't think the same is true for you!" },
			},
			PoseidonRejection11 =
			{
				{ Cue = "/VO/Poseidon_0156",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know the saying not to play with fire, don't you, Nephew? You'll find the same is very much the case with water, too!" },
			},
			PoseidonRejection12 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0157",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Again, you would defy me, little Hades? I'm beginning to see why your father might be very frustrated, indeed, having to deal with you!" },
			},
			PoseidonRejection13 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0158",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "It seems that you require yet one more gentle reminder not to scoff at chances to accept my blessings, little Hades! Now remember this!" },
			},
			PoseidonRejection14 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0159",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sometimes I think, surely my nephew takes to heart my strongly worded threats about my distaste for his little acts of treachery, but {#DialogueItalicFormat}no{#PreviousFormat}!" },
			},
			PoseidonRejection15 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0160",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I could have sworn I told you never to take the power of the sea for granted, little Hades? It seems the time for words is over, then!" },
			},

		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlayAll = 0.33,
				UsePlayerSource = true,

				-- I'm sorry, Uncle.
				{ Cue = "/VO/ZagreusField_0165" },
				-- Sorry, Uncle Poseidon.
				{ Cue = "/VO/ZagreusField_4134" },
				-- Don't be mad, Uncle?
				{ Cue = "/VO/ZagreusField_4135" },
				-- Poseidon won't like this.
				{ Cue = "/VO/ZagreusField_4136" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			PoseidonMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, very well then, little Hades! Uncle's going to let you off the hook this time. Just mind your manners next we meet!" },
			},
			PoseidonMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I must hand it to you, little Hades! I did not expect that you would weather such a storm! I'm mightily impressed!" },
			},
			PoseidonMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, I can't stay angry! Let us call all that unpleasantness back there water under the bridge, what say you, Nephew?" },
			},
			PoseidonMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My, a show of strength like that deserves a commendation I should think! Although, for next time, know my favor's not a thing to trifle with!" },
			},
			PoseidonMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, that's quite enough, I take it you have had about enough of that, correct? You're pretty good! So here, why don't you run along!" },
			},
			PoseidonMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, {#DialogueItalicFormat}hoh-hoh{#PreviousFormat}, you've got some fire in you, don't you, little Hades? Here! I've just the thing to cool you down, fresh from my own domain!" },
			},
			PoseidonMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0161",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-haha{#PreviousFormat}, my fits of anger come and go just like the tides, Nephew! Now take this from me, and get out of here!" },
			},
			PoseidonMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now that was truly finely fought, indeed, Nephew! And I've a suitable reward here, just for you! Don't even know what I was mad about!" },
			},
			PoseidonMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What can I say, Nephew? Sometimes our tempers get the best of all of us. You're fortunate mine didn't get the best of you back there!" },
			},
			PoseidonMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You weathered the storm, there, little Hades, and the sea is once again at peace. And you'll make every attempt to keep it that way, correct?" },
			},
			PoseidonMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, no need to fight about this any longer, don't you think, Nephew? Here, take my blessing, like you should have in the first place!" },
			},
			PoseidonMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now let's not set a bad example for the family, Nephew! We're better than all that. Besides! They've many bad examples as it is." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			PoseidonGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0122", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Uncle Poseidon, it's been excellent to know you, sir, so, please, this is for you." },
				{ Cue = "/VO/Poseidon_0067",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh I am positively moved by your affection, little Nephew! Though, I think I have just the thing for you, in turn! Here, I shall transfer it to you!!" },
			},
			PoseidonGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift01", },
				{ Cue = "/VO/ZagreusHome_0542", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Uncle Poseidon, this here is for you. Would that my father were as easygoing as yourself." },
				{ Cue = "/VO/Poseidon_0064",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}! a show of generosity from my most favored nephew! Your gift is mightily appreciated!! I'll just go ahead and add it to the pile." },
			},
			PoseidonGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift02", },
				{ Cue = "/VO/ZagreusHome_0543", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Mighty Poseidon, greatest of my uncles, arguably, please accept this gift!" },
				{ Cue = "/VO/Poseidon_0065",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "For all the times I'm offered gifts or sacrifices, little Nephew, I still always very much appreciate it! I mean, look! I'm grinning ear to ear!" },
			},
			PoseidonGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift03", },
				{ Cue = "/VO/ZagreusHome_0544", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Uncle Poseidon, I have a special catch for you! Although it pales next to your sheer awesomeness." },
				{ Cue = "/VO/Poseidon_0066",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whaaa{#PreviousFormat}, now would you look at that! Is that an offering, to your most favored uncle, {#DialogueItalicFormat}me{#PreviousFormat}? You know what, Nephew, I've decided I shall take it! Thanks!!" },
			},
			PoseidonGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift04", },
				{ Cue = "/VO/ZagreusField_3862", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I salute you, Uncle Poseidon! Your strength and confidence inspire me, and you accepted me as part of the family without question. It means a lot." },
				{ Cue = "/VO/Poseidon_0228",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, Nephew, but you needn't shower me with offerings and praise, you know! Why, I've no need of showering at all! Not when I've the sea itself, to do with as I please!" },
			},
			PoseidonGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift05", },
				{ Cue = "/VO/ZagreusField_3863", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Whenever I encounter you, Uncle Poseidon, my spirits lift, and I feel there must not be anything that can stop me. I only wish we met sooner, though I'm grateful to have met you at all." },
				{ Cue = "/VO/Poseidon_0229",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I thought I told you, Nephew, not to make such offerings to me? Ah, probably forgot! Or getting you mixed up, perhaps, for I have many other nephews, thanks to Zeus! Though, between us, I don't like any one of them as much as you!" },
			},
			PoseidonGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift06", },
				{ Cue = "/VO/ZagreusField_3864", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Uncle Poseidon, sometimes I wonder what my life would have been like had you been a part of it sooner. Your encouragement, your enthusiasm... it means a lot. To you! This Ambrosia's been to hell and back!" },
				{ Cue = "/VO/Poseidon_0230",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Poseidon_01", Icon = "Keepsake_PoseidonSticker_Max" },
					Text = "{#DialogueItalicFormat}Hohhh{#PreviousFormat}, but isn't this a kingly offering, indeed, my little Hades! I know how difficult it must have been to get, so distant from Olympus as you are! I'll never understand how come your father's cruel to you, for if you were my son, I would be proud! Proud anyway, but you get the idea." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I thank you, Uncle.
			{ Cue = "/VO/ZagreusHome_0323" },
		},

		ShoutActivationSound = "/SFX/PoseidonWrathWaveCrash",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "PoseidonUpgrade",

				-- Who dares attack my nephew?!
				{ Cue = "/VO/Poseidon_0070" },
				-- You can do this, little Hades!!
				{ Cue = "/VO/Poseidon_0071" },
				-- Engulf them, Nephew!!
				{ Cue = "/VO/Poseidon_0072" },
				-- You got it, Nephew!
				{ Cue = "/VO/Poseidon_0082" },
				-- Of course, Nephew!
				{ Cue = "/VO/Poseidon_0083" },
				-- No problem whatsoever!
				{ Cue = "/VO/Poseidon_0080" },
				-- It's time to make a splash!
				{ Cue = "/VO/Poseidon_0211" },
				-- Harness the ocean's might!
				{ Cue = "/VO/Poseidon_0212" },
				-- Now ride the wave, Nephew!
				{ Cue = "/VO/Poseidon_0213" },
				-- Here comes some real water-power!
				{ Cue = "/VO/Poseidon_0214" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "PoseidonUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- My tolerance has limits, little Hades.
				{ Cue = "/VO/Poseidon_0105" },
				-- Why, you tiny little gnat...!
				{ Cue = "/VO/Poseidon_0106" },
				-- You're acting like a fool!
				{ Cue = "/VO/Poseidon_0107" },
				-- Who do you think you are!
				{ Cue = "/VO/Poseidon_0108" },
				-- You cannot treat your uncle like THIS!
				{ Cue = "/VO/Poseidon_0109" },
				-- You call for my aid, now?!
				{ Cue = "/VO/Poseidon_0215" },
				-- Have you no shame, Nephew?!
				{ Cue = "/VO/Poseidon_0216" },
				-- Oh, now you want my help?!
				{ Cue = "/VO/Poseidon_0217" },
			}
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidPoseidonRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- A mighty offer, Uncle.
			{ Cue = "/VO/ZagreusField_1872" },
			-- You drive a hard bargain, Uncle.
			{ Cue = "/VO/ZagreusField_1873" },
			-- Uncle Poseidon, I accept.
			{ Cue = "/VO/ZagreusField_1874" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- Ah, haha, how embarrassing!
			{ Cue = "/VO/Poseidon_0098" },
			-- I warn you not to trifle with me, Nephew!
			{ Cue = "/VO/Poseidon_0103" },
			-- Oh you shouldn't have done that.
			{ Cue = "/VO/Poseidon_0104" },
			-- Next time, Nephew, best not be such a fool!
			{ Cue = "/VO/Poseidon_0208" },
			-- You disrespect the sea, and it is liable to swallow you!
			{ Cue = "/VO/Poseidon_0209" },
			-- Do not forget yourself with me next time, Nephew!
			{ Cue = "/VO/Poseidon_0210" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.PoseidonVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Good tidings, Nephew!
			{ Cue = "/VO/Poseidon_0075", },
			-- Smooth sailing, little Hades?
			{ Cue = "/VO/Poseidon_0076", },
			-- Ahoy, my nephew, it is I!
			{ Cue = "/VO/Poseidon_0077", },
			-- Think you're going to like this!
			{ Cue = "/VO/Poseidon_0095", },
			-- Whaaat?
			{ Cue = "/VO/Poseidon_0121", },
		},
	},

	-- Demeter
	DemeterUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolDemeter",
		BoonInfoIcon = "BoonInfoSymbolDemeterIcon",
		DoorIcon = "BoonSymbolDemeterIsometric",
		Color = { 255, 215, 255, 255 },
		LightingColor = {253, 189, 49, 255},
		LootColor = {96, 189, 255, 255},
		SubtitleColor = {0.74, 0.941, 1.0, 1.0},
		EventEndSound = "/SFX/DemeterBoonFrost",
		UpgradeSelectedSound = "/SFX/Player Sounds/DemeterColdBoonSelect",
		LootRejectionAnimation = "BoonDissipateA_Demeter",

		RequiredSeenRooms = { "D_Boss01" },

		ColorGrade = "Team02",
		PriorityUpgrades = {"DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait" },
		WeaponUpgrades = {"DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait", "DemeterShoutTrait" },
		Traits = { "CastNovaTrait", "ZeroAmmoBonusTrait", "DemeterRetaliateTrait",},
		Consumables = { "HealingPotencyDrop", "HarvestBoonDrop"},

		LinkedUpgrades =
		{

			MaximumChillBlast =
			{
				OneOf = { "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait", "CastNovaTrait" },
			},
			MaximumChillBonusSlow =
			{
				OneOf = { "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait", "CastNovaTrait" },
			},
			DemeterRangedBonusTrait =
			{
				OneOf = { "DemeterRangedTrait" },
			},
			InstantChillKill =
			{
				OneFromEachSet =
				{
					{ "MaximumChillBlast", "ZeroAmmoBonusTrait" },
					{ "MaximumChillBonusSlow", "MaximumChillBlast" },
					{ "ZeroAmmoBonusTrait", "MaximumChillBonusSlow" }
				}
			},
			NoLastStandRegenerationTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait", "DemeterShoutTrait" },
				}
			},
			StationaryRiftTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterShoutTrait" },
				}
			},
			SelfLaserTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterRangedTrait" },
					{ "AphroditeWeaponTrait", "AphroditeRushTrait", "AphroditeSecondaryTrait", "AphroditeRangedTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			HomingLaserTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "DemeterRangedTrait" },
				}
			},
			BlizzardOrbTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "PoseidonRangedTrait" },
				}
			},
			IceStrikeArrayTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "DionysusRangedTrait" },
				}
			},
			JoltDurationTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "ZeusLightningDebuff" },
				}
			}
		},

		Speaker = "NPC_Demeter_01",
		Portrait = "Portrait_Demeter_Default_01",
		WrathPortrait = "Portrait_Demeter_Wrath_01",
		OverlayAnim = "DemeterOverlay",
		Gender = "Female",
		SpawnSound = "/SFX/DemeterBoonFrost",
		FlavorTextIds =
		{
			"DemeterUpgrade_FlavorText01",
			"DemeterUpgrade_FlavorText02",
			"DemeterUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "DemeterFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidDemeterRecently",
			CooldownTime = 40,

			-- Lady Demeter...
			{ Cue = "/VO/ZagreusField_2971" },
			-- The Goddess Demeter...
			{ Cue = "/VO/ZagreusField_2972", RequiredPlayed = { "/VO/ZagreusField_2971" } },
			-- It's Demeter...
			{ Cue = "/VO/ZagreusField_2973", RequiredPlayed = { "/VO/ZagreusField_2971" } },
			-- It's Lady Demeter...
			{ Cue = "/VO/ZagreusField_2974", RequiredPlayed = { "/VO/ZagreusField_2971" } },
			-- Grandmother Demeter...
			-- { Cue = "/VO/ZagreusField_2975" },
			-- My Grandmother...
			-- { Cue = "/VO/ZagreusField_2976" },
		},

		--[[
		PickupVoiceLines =
		{
			{
				PlayOnce = true,
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.75,
				RequiredTextLinesThisRun = "DemeterAboutPersephone03",

				-- Wait... Persephone... Mother... is Demeter's daughter?
				{ Cue = "/VO/ZagreusField_3003" },
			},
		},
		]]--

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				PreLineWait = 1.1,
				RequiredAnyTextLines = { "DemeterMiscPickup11", "DemeterMiscPickupAboutWinter01", "DemeterMiscPickupAboutWinter02", "DemeterMiscPickupAboutWinter03", "DemeterRejection09", "DemeterMakeUp06", "DemeterMakeUp07", "DemeterMakeUp10" },
				RequiredFalseTextLines = { "LordHadesAboutEternalWinter01", "LordHadesAboutEternalWinter01_B" },
				Queue = "Always",

				-- Winter... that's when it's cold, or something, right?
				{ Cue = "/VO/ZagreusField_3004" },
			},
			{
				PlayOnce = true,
				PreLineWait = 1.3,
				RequiredTextLines = { "DemeterAboutPersephone03" },
				RequiredFalseTextLines = { "Ending01" },
				Queue = "Always",

				-- Wait... Persephone... Mother... is Demeter's daughter?
				{ Cue = "/VO/ZagreusField_3003" },
			},
			[3] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[4] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			DemeterWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "JoltDurationTrait",
				RequiredTextLines = { "DemeterGift01" },
				RequiredFalseTextLinesLastRun = { "ZeusWithDemeter01" },
				{ Cue = "/VO/Demeter_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Well, now, young sprout, you've met the so-called King of the Olympians, and I. Whom do you now suppose is genuinely ruler of this snow-encrusted mountaintop of ours?" },
				{ Cue = "/VO/Zeus_0201",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Oh, {#DialogueItalicFormat}hah-hah-hah{#PreviousFormat}, Lady Demeter! Your wit is just as dry as the earth lying quite fallow in your care! Perhaps you should go tend to that again, though let's we go ahead and help our young man first!" },
			},
			DemeterWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "BlizzardOrbTrait",
				{ Cue = "/VO/Demeter_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ah, little sprout. I was just notifying Lord Poseidon here that all of his domain exists because it pleases me; remember, my good foster-brother, I could freeze your oceans solid if I chose." },
				{ Cue = "/VO/Poseidon_0145",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "{#DialogueItalicFormat}Ah, hahahah! {#PreviousFormat}Excellently stated, venerable Goddess Demeter! I'm reminded once more of your vast experience, though, I think we all prefer our oceans liquidy, isn't that right, Nephew?!" },
			},
			DemeterWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "NoLastStandRegenerationTrait",
				RequiredTextLines = { "AthenaAboutDemeter01" },
				{ Cue = "/VO/Demeter_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "To think, young sprout, our strategist Athena, warrior-goddess, sprang from Zeus' head!! I would expect that no high intellect could come from there." },
				{ Cue = "/VO/Athena_0232",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Please do not mind the Lady Demeter's good-natured sense of humor, Zagreus. She and my father often like to jest with one another, even in the most difficult times." },
			},
			DemeterWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StationaryRiftTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Young Zagreus, once you arrive, do tell Lord Ares here that his great power's not worth anything without my own. Wars have their causes, among which, many I control." },
				{ Cue = "/VO/Ares_0162",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "I do not question that your influence can stir a mortal's impulses toward war, O Goddess Demeter. At least we can agree that our domains are quite compatible!" },
			},
			DemeterWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SelfLaserTrait",
				{ Cue = "/VO/Demeter_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Remember something for us, Zagreus. A frozen heart holds no sway over anyone at all. Isn't that right, oh Aphrodite, dear?" },
				{ Cue = "/VO/Aphrodite_0192",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Oh, I don't know, my dearest Demeter! The frozen heart has tendency to thaw, and then begin to beat with renewed vigor after that. I trust your time shall come! It can never be too late, except for mortals, the poor things." },
			},
			DemeterWithArtemis =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HomingLaserTrait",
				RequiredTextLines = { "DemeterGift01", "ArtemisGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Why, Zagreus, my gentle Artemis here was just saying how concerned she was for your predicament! I'm sure she'd like it if we both could help you in this case." },
				{ Cue = "/VO/Artemis_0198",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteFiredUp",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Concerned? I don't see anyone concerned, you have this, Zagreus! You don't need anybody's help, and you can get through this all on your own, though just in case, and I mean just in case! Um, here." },
			},
			DemeterWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "IceStrikeArrayTrait",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Demeter_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "The crops shall wither and decay so long as I may please, young Zagreus. Although we do have those upon Olympus who take issue with my reasoning..." },
				{ Cue = "/VO/Dionysus_0157",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Text = "Um, yeah, milady, I take issue here! I mean how are the grapes supposed to grow and wine supposed to flow when you are so uptight, now, just ease up a little there, let's see what we can do!" },
			},
		},

		SuperPriorityPickupTextLineSets = 
		{
			DemeterAboutZeus01 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				{ Cue = "/VO/Demeter_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I see the noble King of the Olympians has reached you prior to me, Zagreus. I wonder which of all his many lies he's told you last." },
			},

			DemeterAboutPersephone01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "DemeterAboutLove01", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0078",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					-- used for moments when Zag follow-up VO isn't appropriate
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "My foster-brother's wayward son appears! I, too, once lost a child, Zagreus. I was quite foolish with her from the start. Her father was a baseborn farm-boy; worshiped me! He's gone as well, of course. Only the cold remains." },
			},
			DemeterAboutPersephone02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone01" },
				RequiredAnyTextLines = { "PersephoneMeeting06", "DemeterGift03" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0086",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "My daughter to a base-born farmboy, she... why, little sprout, I wasn't very kind to her, I think. Certainly not once her father passed. It was her mortal blood that made her weak! Born to mortals, taken by mortals, I suspect. So now, they {#DialogueItalicFormat}pay{#PreviousFormat}." },
			},
			DemeterAboutPersephone03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone02" },
				RequiredAnyTextLines = { "PersephoneMeeting07", "DemeterGift04" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0085",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "I don't suppose... no, it is nothing, little sprout, it's just... I hear such wicked rumors now and then, about my daughter, lost to me, and what became of her. Kore, we called her, then. Persephone is what she called herself. Before she vanished utterly, leaving no trace...." },
			},
			DemeterAboutPersephone04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone03" },
				RequiredAnyTextLines = { "PersephoneMeeting08", "DemeterGift05" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "After my daughter Kore disappeared, I left this mountaintop. Wandered the earth, in search. For naught, of course. It was a necessary journey, I suppose. May yours fare better." },
			},

			DemeterAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterFirstPickUp", "PersephoneAboutOlympianReunionQuest01" },
				{ Cue = "/VO/ZagreusField_4344", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.4 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Hope Mother knows what she's doing, in the name of Hades! Olympus, this is an official message! Lady Demeter, this is for you." },
				{ Cue = "/VO/Demeter_0212",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "What's all of this, young Zagreus, a message of some sort, for me, indeed? I... can't decipher it, although... it bears the marks of my two foster-brothers here, and... well! It seems we'd better compare notes!" },
			},

			DemeterPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", },
				{ Cue = "/VO/Demeter_0226",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, little sprout, young Zagreus... my grandson! I can scarce believe it, still! To think that, Kore, or... Persephone, my daughter... she had been with Foster-Brother Hades, all this time! A match I wouldn't have expected... or approved. That's why she left! Our blasted hearts do what they want." },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			DemeterAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				{ Cue = "/VO/Demeter_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bear the blessing of Poseidon, Zagreus? Someday I shall remind him of his place, and freeze his watery domain entirely." },
			},
			DemeterAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				{ Cue = "/VO/Demeter_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Athena has imparted you her {#DialogueItalicFormat}wisdom{#PreviousFormat}, Zagreus? A simulacrum of the real thing, at any rate. True wisdom only comes with age, I think." },
			},
			DemeterAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",
				{ Cue = "/VO/Demeter_0064",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All of the love and beauty in the world can wither in a season, Zagreus. Remember that when next the goddess Aphrodite makes her promises." },
			},
			DemeterAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",
				{ Cue = "/VO/Demeter_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lord Ares already got hold of you, has he? He's good at making mortals kill each other, yes. But he has utterly no knack for subtlety." },
			},
			DemeterAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				{ Cue = "/VO/Demeter_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The gentle Artemis already found you, Zagreus? She takes my orders well; one cannot blame her, for she'd have nothing to hunt if not for me." },
			},
			DemeterAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				{ Cue = "/VO/Demeter_0067",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You stumbled into Dionysus, Zagreus? One of these days I shall prevent his vineyards all from ripening; put to the test his carefree attitude." },
			},
			DemeterAboutChaos01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredLootThisRun = "TrialUpgrade",
				{ Cue = "/VO/Demeter_0068",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The mark of Chaos is upon you, isn't it? A force older than I! Yet one which you ought not trust so readily. No rhyme or reason to that one at all." },
			},
			DemeterAboutPom01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredLootThisRun = "StackUpgrade",
				{ Cue = "/VO/Demeter_0069",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Is that the bloodlike stain of pomegranate on you, Zagreus? A hardy fruit resistant to a winter's chill. How fascinating they survive, down there." },
			},

			DemeterLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I don't often divulge such blessings as I am about to, Zagreus. Don't thank me for it, but make certain that you use my power well." },
			},
			DemeterLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have affection for you, little sprout. No need for reciprocity, but now I'll offer you the fiercest of my capabilities." },
			},

			DemeterPostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift03" },
				{ Cue = "/VO/Demeter_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I must admit I have grown fond of you, young sprout; nevertheless, I shall not spoil you like some ill-mannered child." },
			},
			DemeterPostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift02" },
				{ Cue = "/VO/Demeter_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My, but you're as determined as my foster-brothers were, when my sisters and I stood with them 'gainst the Titans way back when." },
			},

			DemeterAboutLoss01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift01" },
				{ Cue = "/VO/Demeter_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Our family, why, I think we understand something of loss, now, don't we, Zagreus? Unlike the mortals on the surface. Always begging me for plenty. They'll get none. But as for you, I have a plethora to offer!" },
			},
			DemeterAboutLoss02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss01" },
				{ Cue = "/VO/Demeter_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You are entirely too young to have had meaningful experience with loss, young Zagreus. Pray to me that you never have to learn." },
			},

			DemeterAboutSurface01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss01" },
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Demeter_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You live within the bosom of the earth, and know its warmth. But there is no such warmth up here, young Zagreus. You truly wish to feel the bitter cold of the outside? Then, here." },
			},
			DemeterAboutSurface02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/Demeter_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Someday, you'll gain the surface, Zagreus; and you shall see firsthand what mortalkind has wrought. You'll find it has some commonality with your domain." },
			},

			DemeterAboutMotherhood01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0079",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Motherhood's a curse, young Zagreus. Be thankful you're immune. You sprang from Nyx herself, or so I hear? I sprang from Theia, whoever she was. And I once bore a child, too. Long gone. A mother's work... isn't it such a waste?" },
			},

			DemeterAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutMotherhood01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father Hades and I share a common fate, each having lost a child fully grown; except that he's a hollow fool, whose child left! Whereas my daughter never would have. Ever!" },
			},

			DemeterAboutHades02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHades01", "DemeterAboutZeus01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your father always had a sternness to him that his brothers lacked. Thought him a decent sort, comparatively anyway; though evidently he is no such thing." },
			},

			DemeterAboutLove01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHades01", "DemeterGift02" },
				RequiredRoomLastRun = "D_Boss01",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Should you achieve your goal, and see this surface-world, Zagreus, I've but one bit of knowledge to impart: Don't ever fall for mortals. Use them if you must, but do not waste your love on those who waste away." },
			},

			DemeterAboutHelios01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone04", "DemeterAboutRumors01" },
				{ Cue = "/VO/Demeter_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have a brother, Helios, the Sun. A nonsense-talker with a flaming chariot. Why, he once told me that my Kore, that she went into that Underworld of yours! Preposterous. The clouds now blot him out entirely." },
			},
			DemeterAboutHelios02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHelios01" },
				{ Cue = "/VO/Demeter_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "This land is not unlike your own in certain ways. For, Helios the Sun has not shone down upon it for some time. How long, I really couldn't tell you, little sprout! Long enough for mortals to take notice, certainly." },
			},

			DemeterAboutSisters01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 5 },
				{ Cue = "/VO/Demeter_0075",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My sisters Hestia and Hera surely would assist as well, young sprout. Except they and our foster-brothers haven't been getting along of late. Though as for me? I'll never leave this mountaintop of mine." },
			},

			DemeterAboutFather01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHades01" },
				{ Cue = "/VO/Demeter_0076",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "We all are willful children, are we not? I'm daughter to Hyperion, you know; a Titan so obscure and hated that Lord Zeus, he started calling me his birth-sister, so much did he dislike this bit of truth! And to get a rise out of me, too." },
			},
			DemeterAboutFather02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutFather01" },
				{ Cue = "/VO/Demeter_0077",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "As seasons give to one another, so do generations, I suppose. Hyperion, my father? He'd not a one redeeming quality. My sisters and my foster-brothers and myself; this world owes us a debt for ridding it of him and his kind." },
			},

			DemeterAboutZeus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift01", "ZeusGift01", "DemeterAboutZeus01" },
				{ Cue = "/VO/Demeter_0082",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "I ought to warn you that my foster-brother Zeus, he has just a {#DialogueItalicFormat}disgusting {#PreviousFormat}sense of humor, little sprout. He'd have you think he sired half the countryside! I have to shudder at the very thought." },
			},

			DemeterAboutRumors01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "DemeterAboutZeus02", "DemeterAboutSurface02" },
				{ Cue = "/VO/Demeter_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "There's so much nonsense that the mortals say to one another of our family, Zagreus. How viciously the rumors spread! Whether from that oaf, Zeus, or likely from the mortal drunkard-poets with no better use of their limited time!" },
			},

			DemeterHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0115",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "I warn you, Zagreus, best not to make attempts to grow much closer with me, thus. I'm much your elder, after all, and you're my little sprout. What say we keep it that way, hm?" },
			},
			DemeterHighAffinity02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift07" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "I... I am so very moved, I... have a daughter once again. And... I've a grandson, too! I thought, I felt something when first I met you, but... I brushed it off. Just like a fleck of snow..." },
			},

			DemeterRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,

				{ Cue = "/VO/Demeter_0083",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Someday, my little sprout, you'll gain the surface of your father's realm, and see my handiwork. Until such time, I'll come to your aid as I can. It's quite the entertaining pastime, honestly!" },
			},

			DemeterPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterPostEpilogue01" },
				{ Cue = "/VO/Demeter_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "By the way, we had entirely a lovely time within your father's house, Grandson. And, to see Kore once again, it... warmed my heart. I'm beyond grateful that your mother's safe. And that you've an important job to do. Here, I shall help." },
			},
			DemeterPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterGift06" },
				{ Cue = "/VO/Demeter_0228",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "I meant to tell you something, Grandson... you needn't have deceived the rest of us. You could have sent word that my daughter was with you down there, all along! Ah, but families are a complicated thing. Just swear that you'll be candid with us, next time." },
			},
			DemeterPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterLiftsWinterCurse01" },
				MinRunsSinceAnyTextLines = { TextLines = { "DemeterLiftsWinterCurse01" }, Count = 3 },
				{ Cue = "/VO/Demeter_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "You must visit us sometime up here, Grandson! I understand the surface hasn't been agreeable with you... though perhaps if not in this age, then the next, we shall have you over. It's brisk up here... but nice enough, I think." },
			},
			DemeterPostEpilogue05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterGift04" },
				{ Cue = "/VO/Demeter_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "Young sprout, I cannot fully understand my daughter's choices, such as what she saw in your gloom-filled father to have eloped with him. But if you are the result, then she is clearly wiser than I estimated." },
			},
			DemeterPostEpilogue06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PersephoneReturnsFromOlympus01", "DemeterGift07" },
				{ Cue = "/VO/Demeter_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "I made mistakes raising your mother, sprout. When she was my Kore. I was blind to the possibility that she could have left me, but... I see it now. If you become a parent yourself, someday... may you listen more than I." },
			},
			DemeterPostEpilogue07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 4 },		
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "You tell my Kore... {#DialogueItalicFormat}erm, Persephone{#PreviousFormat}, that is... the Queen! You tell her that her mother sends her warm regards. You tell her that. And you take care of her." },
			},
			DemeterPostEpilogue08 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PersephoneReturnsFromOlympus01", "PersephoneGift08", "DemeterGift07" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Grandson, my daughter Queen Persephone, she sent me the most precious message, courtesy of Hermes, as of late. I'm pleased to hear that you are getting on all right. Though, I know you're at work, so here!" },
			},

			-- winter's curse removed / long winter / eternal winter (see below)
			DemeterLiftsWinterCurse01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift07", "PersephoneReturnsFromOlympus01", "DemeterAboutLoss01" },
				{ Cue = "/VO/Demeter_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "My little grandson, little sprout, I've thought... if my Persephone's alive, why then... this winter, hasn't it endured for long enough...? It's grown to have a certain stubbornness, but I... I am the goddess of the seasons, Zagreus. Perhaps it's time I changed them once again."
				},
			},
			DemeterLiftsWinterCurse02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Demeter_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "I've lifted the cold from the earth, much as I said I would, grandson. But, near your father's realm... I have decided it shall stay the way it is. Bereft of warmth. As a reminder to us all, about all this." },
			},

			DemeterAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceDemeterBoonTrait",

				{ Cue = "/VO/Demeter_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The Frostbitten Horn which you bear once overflowed. It holds a certain power still, of course. But never again shall mortalkind take it for granted." },
			},

			DemeterAboutPact01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredActiveShrinePointsMin = 6,

				{ Cue = "/VO/Demeter_0080",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The heat has risen quite considerably there, is that not so? Then if my foster-brother's tampered with the temperature, I'll have to cool things off." },
			},

			DemeterAboutAsphodel01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredBiome = "Asphodel",

				{ Cue = "/VO/Demeter_0081",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The heat of your surroundings must be difficult to bear, my little sprout. It's fortunate I've just the thing for that." },
			},
			DemeterAboutStyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredBiome = "Elysium",

				{ Cue = "/VO/Demeter_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That chill sensation I detect must indicate that you are near the surface, Zagreus. If you can overcome the final challenges ahead, you soon shall see the long winter yourself." },
			},

			DemeterHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Demeter_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That's Sister Hera's Heart-Seeker you have! The very weapon which she used to put our predecessors down. It hasn't lost its potency I see. Fear not, I shall not mention this to her, if I see her." },
			},
			DemeterHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredWeapon = "GunWeapon",
				RequiredTrait = "GunManualReloadTrait",

				{ Cue = "/VO/Demeter_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, isn't that there Sister Hestia's oddly constructed armament you bear? She always was so predisposed to flame; I thought she'd never give it up! If it's to be in any hands, then may as well be yours." },
			},
			DemeterHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistWeaveTrait",

				{ Cue = "/VO/Demeter_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I scarcely can see... are those the Twin Fists that you bear, young sprout? I once made ample use of them myself, if you'll imagine it. Wielding the cold since has been adequate for me, but you? May you put them to work as I once did." },
			},

			DemeterLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, you've the look of one who has endured a terribly long winter, Zagreus! I trust you'll cling to life a little longer, now." },
			},
			DemeterLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I sense your grip on life is coming loose, young Zagreus. Now turn that cold you feel against your enemies." },
			},
			DemeterLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0118",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You seem to be in dire need of some assistance, Zagreus. I think perhaps I have a bit to spare." },
			},
			DemeterLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0119",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're in the winter of your current stretch of life, aren't you, Zagreus? Do try and live a little longer for me, hm?" },
			},
			DemeterLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You waste away just like a common mortal, Zagreus. How rather unbecoming of a god." },
			},
			DemeterLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The flame of life is easily extinguished by the cold, young Zagreus. Surely you feel the warmth within you giving way?" },
			},
			DemeterLowHealth07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cold comfort for your terrible predicament, young Zagreus, but I am here." },
			},

		},

		PickupTextLineSets =
		{
			DemeterFirstPickUp =
			{
				PlayOnce = true,
				RequiredFalseRooms = { "TestAllThings", },
				{ Cue = "/VO/ZagreusField_2966", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 7.3 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Last time I felt a chill like this was... on the surface, but, who...? Well, one way to find out. Then, in the name of Hades! Olympus, I accept this message!" },
				{ Cue = "/VO/Demeter_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "I understand, young Zagreus, that you would seek to leave that bitter darkness for this bitter cold? Quite honestly I fail to see why. But I'll aid your plight, why not? For I can offer plenty of assistance, and you soon shall grow fond of it, I think." },
			},
			DemeterMiscPickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I once had plentitudes of blessings I would offer readily, young Zagreus; but I am feeling not as generous of late." },
			},
			DemeterMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Did you detect perhaps a certain spirit-shaking chill within the air, young Zagreus?" },
			},
			DemeterMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Plenty of blessings left to go around; although, only for you, young Zagreus." },
			},
			DemeterMiscPickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your enemies shall have no shelter from the cold whilst I am at your side, young Zagreus." },
			},
			DemeterMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's something to the barrenness, where you reside; perhaps someday it shall be more like that up here." },
			},
			DemeterMiscPickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your realm there is much like the wind-swept surface here. Mostly devoid of life, such as it's been of late." },
			},
			DemeterMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Olympus must seem like a distant paradise to you, young Zagreus; it is a frozen waste to me. But still, it's home." },
			},
			DemeterMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your foes shall more than catch cold by the time we're through, don't you agree, young sprout?" },
			},
			DemeterMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All those who stand opposed to you, why, we shall shatter more than their resolve, I think, young Zagreus." },
			},
			DemeterMiscPickup10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "One of these seasons I suppose I ought to double-check the mortals haven't gone extinct without my intervention at each step." },
			},
			-- winter references
			DemeterMiscPickup11 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "None can endure an everlasting winter's chill, young Zagreus; not even your father's lifeless servants there beneath the earth." },
			},
			DemeterMiscPickup12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The seasons have a certain beauty to them, I suppose. Though struggle onward, and you needn't take my word for it." },
			},
			DemeterMiscPickup13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've known your father and his brothers here for many seasons now; they bicker endlessly with me and one another." },
			},
			DemeterMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I have to tell you something, little sprout. I take cold comfort knowing that my foster-brother Hades is no better at his parenting than I." },
			},
			DemeterMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd gladly scour all your father's realm if doing so would free you from his clutches, Zagreus." },
			},
			DemeterMiscPickup16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'll have you know something, young Zagreus: The bitter cold and frost is just as inescapable as death itself." },
			},
			DemeterMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The seasons turn relentlessly, without regard, and thusly should you doggedly push forward on your path." },
			},
			DemeterMiscPickup18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I shall bring desolation upon those who wrong you, little sprout." },
			},
			DemeterMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I hope that you're aware how seldomly I give my blessing as of late, young Zagreus." },
			},
			DemeterMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's no escaping from the bitter cold, you know." },
			},
			DemeterMiscPickup21 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your adversaries soon shall know something of loss, I think." },
			},
			DemeterMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let us see to it your foes are left with nothing." },
			},
			DemeterMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There shall be only souls for harvesting this day, I think, young Zagreus." },
			},
			DemeterMiscPickup24 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				{ Cue = "/VO/Demeter_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My warm regards, and all my blessings to you, little sprout." },
			},
			DemeterMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The bitterness of cold and death go hand in hand, I do suppose." },
			},
			DemeterMiscPickup26 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "When all is taken away, the cold yet remains, young Zagreus." },
			},
			DemeterMiscPickup27 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Demeter_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am not feeling quite so generous of late, young Zagreus, but nevertheless: Choose." },
			},
			DemeterMiscPickup28 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your lifeless foes must foolishly believe they've nothing left to lose." },
			},
			DemeterMiscPickup29 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Demeter_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Go with my blessings, Zagreus; though you may take but one." },
			},
			DemeterMiscPickup30 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Decay is the inevitable state of things; we are merely helping it along." },
			},
			DemeterMiscPickup31 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The cold of Mount Olympus shall bring utter ruin on your enemies." },
			},
			DemeterMiscPickup32 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Death and cold, they are irrevocably bound together, Zagreus." },
			},
			DemeterMiscPickup33 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredBiome = "Asphodel",
				{ Cue = "/VO/Demeter_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The climate in those depths needs cooling, then, I take it, Zagreus?" },
			},
			DemeterMiscPickup34 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You bring with you the season of decay, young Zagreus." },
			},
			DemeterMiscPickup35 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your foes shall all wither before you like unwatered crops." },
			},
			DemeterMiscPickup36 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The frost eventually shall cover everything, young Zagreus." },
			},
			DemeterMiscPickup37 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'll find that life gives way quite easily to cold, young sprout." },
			},
			DemeterMiscPickup38 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Demeter_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look carefully upon my blessings, Zagreus, and take no more than one." },
			},
			DemeterMiscPickup39 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust that harvesting dead souls is not unlike the harvest we have on the surface, Zagreus." },
			},
			DemeterMiscPickup40 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're like a little flame there in your father's realm; easy enough to spot." },
			},
			DemeterMiscPickup41 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It seems to me your foes are ripe for harvesting, young Zagreus." },
			},
			DemeterMiscPickup42 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Any who stand against you soon shall wither from the cold, young sprout." },
			},

			DemeterMiscRarePickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I seldom feel too generous of late, and yet for you, young Zagreus? Why not." },
			},
			DemeterMiscRarePickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I once offered the mortals generosities as this in much more copious supply." },
			},
			DemeterMiscRarePickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It soon shall be exceptionally cold down in the Underworld, I think." },
			},
			DemeterMiscRarePickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd never give out blessings such as this to merely anyone, I hope you know." },
			},
			DemeterMiscRarePickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I've quite the harvest here from which to choose, my little sprout." },
			},
			DemeterMiscRarePickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Soon, the season there shall turn exceptionally cold, young Zagreus." },
			},
			DemeterMiscRarePickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It is particularly cold outside, today; and soon it shall be so in there for you." },
			},

			-- winter references
			DemeterMiscPickupAboutWinter01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift01" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, my little sprout, we shall have to get you through this winter's cold." },
			},
			DemeterMiscPickupAboutWinter02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A crisp and pleasant winter's evening to you, Zagreus; now, here." },
			},
			DemeterMiscPickupAboutWinter03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift02" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My finest winter blessings to you, little sprout." },
			},

			-- post-epilogue
			DemeterMiscPickupExtra01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, Grandson, it's growing rather cold, don't you agree?" },
			},
			DemeterMiscPickupExtra02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm here to ease some of your burdens, my young sprout. That's what we grandmothers are for." },
			},
			DemeterMiscPickupExtra03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust you're keeping yourself warm enough in all of this, Grandson?" },
			},
			DemeterMiscPickupExtra04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "When all this is over, please do come and visit us sometime, Grandson." },
			},
			DemeterMiscPickupExtra05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd tell you not to work too hard, Grandson, although your family is in need of more hard-working sorts." },
			},
			DemeterMiscPickupExtra06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Foul weather's on the forecast for your foes, Grandson." },
			},
			DemeterMiscPickupExtra07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't let my foster-brother bully you about, you hear, Grandson?" },
			},
			DemeterMiscPickupExtra08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's cool down that hot head of yours a bit, why don't we, Grandson?" },
			},
			DemeterMiscPickupExtra09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete", "DemeterGift05" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My best regards to Queen Persephone and your lord father, little sprout. You keep it up." },
			},
			DemeterMiscPickupExtra10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete", "DemeterGift06" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust your mother Queen Persephone is faring well if she has as fine a son as you, young Zagreus." },
			},
			-- post-epilogue, persephone away
			DemeterMiscPickupPersephoneAway01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your mother sends you all her love from Mount Olympus, Grandson." },
			},
			DemeterMiscPickupPersephoneAway02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All the best from Queen Persephone, young sprout. She misses you, you know." },
			},
			DemeterMiscPickupPersephoneAway03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0224",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Persephone is doing well here on Olympus, Zagreus. You ought to visit, too, sometime." },
			},
		},

		BoughtTextLines =
		{
			DemeterLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Be thankful that the rivers to your realm have not yet frozen over, Zagreus." },
			},
			DemeterLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I trust your ferry-boatman Charon has no qualms about the freezing temperatures up here?" },
			},
			DemeterLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My message comes to you by river-boat this time, young Zagreus. At least that Charon is amenable to our attempts to contact you." },
			},
		},

		RejectionTextLines =
		{
			DemeterRejection01 =
			{
				{ Cue = "/VO/Demeter_0087",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My blessing's seldom given and ought not be so readily refused, young Zagreus." },
			},
			DemeterRejection02 =
			{
				{ Cue = "/VO/Demeter_0088",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am accustomed to such disrespect from all those blasted mortals, Zagreus, but {#DialogueItalicFormat}you{#PreviousFormat}?" },
			},
			DemeterRejection03 =
			{
				{ Cue = "/VO/Demeter_0089",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "If you are so disinterested in my generosity, young Zagreus, then you shall have my wrath." },
			},
			DemeterRejection04 =
			{
				{ Cue = "/VO/Demeter_0090",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I don't recall if I yet warned against this type of attitude, although it doesn't matter either way." },
			},
			DemeterRejection05 =
			{
				{ Cue = "/VO/Demeter_0091",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Do you believe I give my blessings liberally, Zagreus? Well then I've news for you." },
			},
			DemeterRejection06 =
			{
				{ Cue = "/VO/Demeter_0092",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Offend me, and I'll drain the last traces of color from those cheeks of yours." },
			},
			DemeterRejection07 =
			{
				{ Cue = "/VO/Demeter_0093",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That was an ill-advised decision, Zagreus. I'm past quickly forgiving such mistakes." },
			},
			DemeterRejection08 =
			{
				{ Cue = "/VO/Demeter_0094",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You truly think you can withstand the ravages of winter, Zagreus? That I would like to see." },
			},
			DemeterRejection09 =
			{
				{ Cue = "/VO/Demeter_0095",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A harsh winter is coming for you, Zagreus. And I'm afraid you've brought it on yourself." },
			},
			DemeterRejection10 =
			{
				{ Cue = "/VO/Demeter_0096",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "For that decision, Zagreus, it is about to be a very cold day down there in your Underworld." },
			},
			DemeterRejection11 =
			{
				{ Cue = "/VO/Demeter_0097",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A careless choice you've made, there, Zagreus. As you grow long in years, perhaps you shall learn better judgment as to whom to trust, and whom to never, ever disrespect." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlayAll = 0.33,
				UsePlayerSource = true,

				-- I'm sorry, Demeter.
				{ Cue = "/VO/ZagreusField_2988" },
				-- Forgive me, Demeter.
				{ Cue = "/VO/ZagreusField_2989" },
				-- I'm sorry, Grandmother.
				{ Cue = "/VO/ZagreusField_2990", RequiredTextLines = { "OlympianReunionQuestComplete" }, },
				-- Lady Demeter, apologies.
				{ Cue = "/VO/ZagreusField_4152" },
				-- Have mercy, Demeter...
				{ Cue = "/VO/ZagreusField_4153" },
				-- Sorry, Demeter.
				{ Cue = "/VO/ZagreusField_4154" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			DemeterMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0098",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps you'll exercise more wisdom in such interactions moving forward, hm?" },
			},
			DemeterMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0099",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It ultimately isn't my intent to leave you in the cold like this, young Zagreus." },
			},
			DemeterMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0100",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The freezing cold ought to have drained the life from you; but I've allowed it to relent, for now." },
			},
			DemeterMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0101",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Next time, young Zagreus, perhaps I'll take every last bit of warmth you've left down there." },
			},
			DemeterMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0102",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am the eldest of Olympus, Zagreus. And I expect for you to treat me suitably." },
			},
			DemeterMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0103",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The harsh of winter's gone for now, young Zagreus; and so take heart, but also you take heed." },
			},
			DemeterMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0104",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So you survived a little winter's chill, didn't you, there? Be careful, though; next season could be worse." },
			},
			DemeterMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0105",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Remember, next time, Zagreus, that on my whim I can take everything from you." },
			},
			DemeterMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0106",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I am quite capable of making your life plenty difficult, you do now realize, young Zagreus?" },
			},
			DemeterMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0107",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Perhaps a few more winter seasons such as that might teach you more of how this world works." },
			},
			DemeterMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0108",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Enough; I do not hold to grudges, Zagreus. You've my good graces, and my temper's cooled, for now." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			DemeterGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusField_2999", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Good Lady Demeter, you've shown me warmth and generosity, and I am very grateful for it. Please, accept this as a small token of my appreciation." },
				{ Cue = "/VO/Demeter_0109",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "An offering well suited for the season, there, young Zagreus! In turn, as you are honorable and obedient, you'll have from me what the mortals have not." },
			},
			DemeterGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift01" },
				{ Cue = "/VO/ZagreusField_3000", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "A little offering for you, good Lady Demeter. I'm deeply grateful for your willingness to aid me in all this." },
				{ Cue = "/VO/Demeter_0110",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I must acknowledge and accept your thoughtful gift of Nectar, Zagreus; would that the mortals showed deference thus." },
			},
			DemeterGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift02" },
				{ Cue = "/VO/ZagreusField_3001", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "May this small offering bring you some joy there on Olympus, Lady Demeter. Thank you for all your help." },
				{ Cue = "/VO/Demeter_0111",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A conscientious gift, my little sprout; and I am grateful for your generosity. A bit of Nectar cuts straight through the cold, I say." },
			},
			DemeterGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift03" },
				{ Cue = "/VO/ZagreusField_3002", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Your power and your wisdom has been of such help, good Lady Demeter. I'm honored, and this is the least I can do in exchange." },
				{ Cue = "/VO/Demeter_0112",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I was quite certain that the youth today was lacking any sort of tactfulness, young Zagreus. For once I'm thankful to be proven wrong." },
			},
			DemeterGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift04" },
				{ Cue = "/VO/ZagreusField_3871", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lady Demeter, I am forever in your debt for the affection that you've shown to me, and for the power you've bestowed." },
				{ Cue = "/VO/Demeter_0113",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "The everlasting winter means that Nectar's been in rather short supply; that you would think of {#DialogueItalicFormat}me {#PreviousFormat}for such an offering is duly noted, then." },
			},
			DemeterGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift05" },
				{ Cue = "/VO/ZagreusField_3872", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",					
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I often remember that there's sweetness in this world only by your grace, Lady Demeter. I'm thankful that we've grown closer through all this." },
				{ Cue = "/VO/Demeter_0114",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You would make further offerings to me? Even though I have made quite clear I've lately not been at my charitable best, young Zagreus? You're either naive or you're much too kind, or both." },
			},
			DemeterGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift06" },
				{ Cue = "/VO/ZagreusField_4547", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Um, Grandmother? If you don't mind I call you that. Knowing we're related like this fills me with pride. Your power over life... I think I've some of it in me! And I could not have come this far without your help. Please, for everything... this is for you." },
				{ Cue = "/VO/Demeter_0199",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Demeter_01", Icon = "Keepsake_DemeterSticker_Max" },
					Text = "Why, Grandson, how you honor me, with this... I am so very grateful that we've met, and that... you're {#DialogueItalicFormat}you{#PreviousFormat}, if that makes any sense at all. I have my sisters, but... I'd no one else, for very long, indeed." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I'm in your debt, great Goddess Demeter.
			{ Cue = "/VO/ZagreusField_2987" },
		},

		ShoutActivationSound = "/SFX/DemeterWrathBlizzard",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "DemeterUpgrade",

				-- Beware of winter's cold!
				{ Cue = "/VO/Demeter_0123" },
				-- A wasteland void of life!
				{ Cue = "/VO/Demeter_0124" },
				-- All shall soon decay!
				{ Cue = "/VO/Demeter_0125", RequiredMinKillEnemies = 2 },
				-- Freeze to death!
				-- { Cue = "/VO/Demeter_0126" },
				-- I shall take everything away!
				{ Cue = "/VO/Demeter_0127" },
				-- They shall have nothing!
				{ Cue = "/VO/Demeter_0128", RequiredMinKillEnemies = 2 },
				-- No comfort from the bitter cold!
				{ Cue = "/VO/Demeter_0129" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "DemeterUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- You beg my favor now?!
				{ Cue = "/VO/Demeter_0130" },
				-- The limitless audacity of youth!
				{ Cue = "/VO/Demeter_0131" },
				-- Shiver and rot, for all I care!
				{ Cue = "/VO/Demeter_0132" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAthenaRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- Appreciate the offer, Lady Demeter.
			{ Cue = "/VO/ZagreusField_2994" },
			-- I can't refuse this, Lady Demeter.
			{ Cue = "/VO/ZagreusField_2995" },
			-- Good Lady Demeter, I must accept.
			{ Cue = "/VO/ZagreusField_2996" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- I have no tolerance for disrespect.
			{ Cue = "/VO/Demeter_0133" },
			-- I warned you not to side against me, little sprout.
			{ Cue = "/VO/Demeter_0134" },
			-- Respect your elders next time, Zagreus.
			{ Cue = "/VO/Demeter_0135" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.6,
			Source = { SubtitleColor = Color.DemeterVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- My greetings to you, little sprout.
			{ Cue = "/VO/Demeter_0163" },
			-- I greet you, Zagreus.
			{ Cue = "/VO/Demeter_0164" },
			-- Hello, young Zagreus.
			{ Cue = "/VO/Demeter_0165" },
			-- A winter's greeting to you, Zagreus.
			{ Cue = "/VO/Demeter_0167" },
			-- Oh truly?
			{ Cue = "/VO/Demeter_0189" },
		},

	},

	-- Hermes
	HermesUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		GodLoot = false,
		TreatAsGodLootByShops = true,
		Weight = 10,
		Icon = "BoonSymbolHermes",
		BoonInfoIcon = "BoonInfoSymbolHermesIcon",
		DoorIcon = "BoonSymbolHermesIsometric",
		Color = { 255, 100, 0, 255 },
		LightingColor = {255, 120, 0, 255},
		LootColor = {255, 90, 0, 255},
		SubtitleColor = {0.945, 0.686, 0.349, 1.0},
		EventEndSound = "/SFX/HermesBoonWhoosh",
		UpgradeSelectedSound = "/SFX/HermesBoonChoice",

		RequiredTextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp" },

		PriorityUpgrades = { },
		WeaponUpgrades = {},
		Traits = { "RegeneratingSuperTrait", "ChamberGoldTrait", "AmmoReloadTrait", "HermesShoutDodge", "HermesWeaponTrait", "HermesSecondaryTrait", "RushRallyTrait", "MoveSpeedTrait", "RushSpeedBoostTrait", "RapidCastTrait", "BonusDashTrait", "DodgeChanceTrait", "AmmoReclaimTrait" },
		Consumables = { },
		LinkedUpgrades =
		{
			SpeedDamageTrait =
			{
				OneOf = { "MoveSpeedTrait", "RushSpeedBoostTrait", "FastClearDodgeBonusTrait", },
			},
			MagnetismTrait =
			{
				OneOf = { "RapidCastTrait", "AmmoReclaimTrait", "AmmoReloadTrait" },
			},
			UnstoredAmmoDamageTrait =
			{
				OneOf = { "RapidCastTrait", "AmmoReclaimTrait", "AmmoReloadTrait" },
			}
		},

		Speaker = "NPC_Hermes_01",
		Portrait = "Portrait_Hermes_Default_01",
		Gender = "Male",
		SpawnSound = "/SFX/HermesBoonWhoosh",
		FlavorTextIds =
		{
			"HermesUpgrade_FlavorText01",
			"HermesUpgrade_FlavorText02",
			"HermesUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "HermesFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidHermesRecently",
			CooldownTime = 40,

			-- Lord Hermes.
			{ Cue = "/VO/ZagreusField_1925", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- Hello, Hermes.
			{ Cue = "/VO/ZagreusField_1926", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- It's Hermes.
			{ Cue = "/VO/ZagreusField_1927" },
			-- Time for a boost.
			{ Cue = "/VO/ZagreusField_1928", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- Right on time.
			{ Cue = "/VO/ZagreusField_1929", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- There he is.
			{ Cue = "/VO/ZagreusField_1930", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- Message for me?
			{ Cue = "/VO/ZagreusField_1931", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- He's back.
			{ Cue = "/VO/ZagreusField_1932", RequiredPlayed = { "/VO/ZagreusField_1927" } },
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "HermesAboutSkelly01" },
				Queue = "Always",

				-- What... he meant Skelly's tooth?
				{ Cue = "/VO/ZagreusField_3962" },
			},
			[2] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[3] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		SuperPriorityPickupTextLineSets =
		{
			HermesSecondPickUp =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What's going on, there, Coz? Can I call you Coz? Got something here for you should make your battles to the death end that much quicker!" },
			},

			-- keepsake responses
			HermesExpectingZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "ZeusUpgrade",
				RequiredTrait = "ForceZeusBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sorry, boss, my pop had pressing matters to attend to. But I'm here! Relaying you that message, and relaying this." },
			},
			HermesExpectingPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "PoseidonUpgrade",
				RequiredTrait = "ForcePoseidonBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here to tell you that Poseidon's on his way, boss. Sometimes he is a little slow. But you'll meet up with him again eventually!" },
			},
			HermesExpectingAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "AthenaUpgrade",
				RequiredTrait = "ForceAthenaBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Expecting someone else, there, boss? A certain half-sister of mine perchance? Well, tough break, I got here first. Want one of these, or not?" },
			},
			HermesExpectingAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "AresUpgrade",
				RequiredTrait = "ForceAresBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Soon as I heard you were looking to see Ares, boss, I got here as fast as I could! He's never going to beat me. Much less in all that armor." },
			},
			HermesExpectingAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseGodLoot = "AphroditeUpgrade",
				RequiredTrait = "ForceAphroditeBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0064",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Aphrodite said she's running just a little late, Coz, though I'm sure you understand. Besides, I'm here! In spirit anyhow." },
			},
			HermesExpectingArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "ArtemisUpgrade",
				RequiredTrait = "ForceArtemisBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Wanted to let you know my sister Artemis is out looking for you. You should be running into her in any chamber, now!" },
			},
			HermesExpectingDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "DionysusUpgrade",
				RequiredTrait = "ForceDionysusBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Afraid that Dionysus couldn't be here for you, boss. Though punctuality has never been one of his stronger suits." },
			},
			HermesExpectingDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "DemeterUpgrade",
				RequiredTrait = "ForceDemeterBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That chill you were expecting in the air, that wasn't Demeter this time, here, boss! No, that was just me whisking to you in a flash. Makes for a little pleasant breeze I think!" },
			},

			HermesBeatCharonQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "BossCharonHermesQuestComplete01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0200",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You did it, Coz! And by {#DialogueItalicFormat}it {#PreviousFormat}I'm referring to the act of beating down my seemingly invincible boatman associate, who fancies himself pretty tough as Underworld deities go! He wasn't sure you had it in you, and if I may be so bold, neither was I!" },
			},

			HermesAboutPlume02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				-- MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutPlume01" },
				RequiredAnyTextLines = { "HermesGift06", "HermesGift06B" },
				RequiredTrait = "FastClearDodgeBonusTrait",
				RequiresMaxKeepsake = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0115",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey looking like you're getting some good use out of that fancy plume of yours! Keep going like that, maybe someday you'll be half as quick as me!" },
			},

			HermesAboutSkelly01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredAnyTextLines = { "SkellyBackstory01", "HermesAboutHourglass01", "HermesLootBought01", "HermesLootBought01_B" },
				RequiredTrait = "ReincarnationTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I got a keen eye, boss, so I happened to notice that you've got a certain tooth you're carrying about. Know you're from the land of the dead and all, but don't you think that comes across as just a little odd?" },
			},

			-- ending
			HermesAboutPersephoneMeeting01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "PersephoneFirstMeeting" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard that you finally got out of there, Coz! Big congratulations due for that: Congrats! The secret's safe with me, of course! The others here, they think you're still at it. Though, I guess you are!" },
			},
			HermesPostEnding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "Ending01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I heard a certain someone's back at home with you down there now, Coz! I'd call it wonderful news, except it {#DialogueItalicFormat}isn't {#PreviousFormat}news, at least not yet! Though if the time comes that you want to spread the word, just give the signal here!" },
			},
			HermesAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HermesFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				-- MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/ZagreusField_4343", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.7 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "I get to be the messenger this time. In the name of Hades! Olympus, this is an official message! Lord Hermes? Got here as quickly as I could." },
				{ Cue = "/VO/Hermes_0226",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Why, that looks like you've got a message just for {#DialogueItalicFormat}me{#PreviousFormat}, this time, how special is that, boss? Some sort of invite from the looks of things. You sure that I'm supposed to have this, seeing as I'm not officially involved?" },
			},

			HermesPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got to tell you, Coz, that was a real something of a feast back your place! A little awkward, having to pretend we just met, but hey, I'm an Olympian! Means I can posture with the best of them. Good times, Coz! Glad it all worked out." },
			},
		},

		PriorityPickupTextLineSets =
		{
			HermesFirstLootPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoom = "RoomOpening",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got here as quickly as I could, boss. Now what say we get you promptly the hell out of there!" },
			},
			HermesFirstLootPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoom = "RoomOpening",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey Coz, gathered you were just about to make another go of breaking out of there! Thought I'd stop by and give you a boost." },
			},
			HermesFirstLootPickup03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoom = "RoomOpening",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're raring for your next trek out of there, right, boss? Well then I guess I got here just in time." },
			},
			HermesFirstLootPickup04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoom = "RoomOpening",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard you were heading out again, boss. Changed my schedule around a bit, not a big deal, and figured I'd drop in!" },
			},
			HermesFirstLootPickup05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoom = "RoomOpening",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're off again, are you? All right well then safe travels! Or swift travels, failing that!" },
			},
			HermesFirstLootPickup06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoom = "RoomOpening",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You ready for another go at this, Coz? Well then think I can speed you on your journey there." },
			},

			HermesExpectingMiscOlympian01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 4 },
				RequiredRoom = "RoomOpening",
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Afraid your regularly scheduled Olympian could not be here right now, because I'm that much faster, boss!" },
			},
			HermesExpectingMiscOlympian02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 4 },
				RequiredRoom = "RoomOpening",
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You might have been expecting someone else, here, boss. But I just couldn't help beating them to the punch this time!" },
			},
			HermesExpectingMiscOlympian03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 4 },
				RequiredRoom = "RoomOpening",
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got here just as quickly as I could, Coz. Which turns out to be quite a bit faster than my relatives!" },
			},
			HermesExpectingMiscOlympian04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 4 },
				RequiredRoom = "RoomOpening",
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'm sure that keepsake that you brought will come in handy soon enough, there, boss!" },
			},
			HermesExpectingMiscOlympian05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 4 },
				RequiredRoom = "RoomOpening",
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My relatives are normally quite quick to heed the call of anybody bearing one of their keepsakes! Huh!" },
			},
			HermesExpectingMiscOlympian06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 4 },
				RequiredRoom = "RoomOpening",
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I may not be the god you're looking for right at the moment, boss, but I will get you on your way to them in no time here!" },
			},

			-- about other gods
			HermesAboutZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You heard already from my pop, haven't you, Coz? Wonderful guy. Don't get to spend a lot of time together, though! You know how that is. Well, see you!" },
			},
			HermesAboutZeus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutZeus01" },
				RequiredGodLoot = "ZeusUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, Coz, my pop never gives his lightning blessings to me! He's quite invested in what happens to you, isn't he?" },
			},
			HermesAboutPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Want to bring you in on something, boss. Reason that Uncle Poseidon got to you before I did is, I let him. He's under the impression he's as spry as ever! {#DialogueItalicFormat}Hah!{#PreviousFormat}" },
			},
			HermesAboutAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So then Athena's looking out for you, that's good, that's good! She likes to put a lot of thought and stuff in everything, it's all a little much, if you ask me!" },
			},
			HermesAboutAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "AresUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know who keeps me awful busy, Coz? Ares. Nothing like a good old war amongst the mortals to create demand for lots and lots of messages to go around!" },
			},
			HermesAboutArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Did Artemis manage to locate you already, boss? She's pretty good at that, I have to say. I'm faster! But she's fast, she's pretty fast, all right." },
			},
			HermesAboutAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Aphrodite's really something, don't you think so, Coz? Normally I'd stop for no one here. But when it comes to her, exceptions must be made!" },
			},
			HermesAboutDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You ever get the feeling life's been moving all too quickly for you, boss? Well Dionysus doesn't, as you're probably aware. Throws quite a feast, though!" },
			},
			HermesAboutDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseFlags = { "PersephoneAway" },
				RequiredGodLoot = "DemeterUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Been downright chilly up here lately, Coz! We've Demeter to thank for that! Me, I try to stay out of her way, she doesn't think I'm of much help to her. Although I'm sure she's warmed to you at least!" },
			},
			HermesAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutKeepsake",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0235",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, isn't that your father's blessing on you, Coz?! I almost can't believe it, but you've done such a good job of things, how could he {#DialogueItalicFormat}not {#PreviousFormat}approve?" },
			},

			HermesBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoa, what's good, there, Coz? Though, who am I kidding, we can cut the small talk. I don't mind. I interrupt my brothers and my sisters all the time!" },
			},
			HermesBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0067",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Boss, you've probably caught yourself thinking: {#DialogueItalicFormat}Hermes sure is quick! So how come it took so long for him to show up in the first place? {#PreviousFormat}Well, I'm afraid that's not for you to know. But! It's not because I was late. Not late for anything." },
			},
			HermesBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory01", "HermesBackstory02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0068",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, uh, could you do a little favor for me, Coz? My brothers, sisters, family, and whatnot, they're unaware I'm working with you, here. It's no big deal, but let's keep it that way for now. All right?" },
			},
			HermesBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HermesLootBought02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0069",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Happened to be in the area, boss! Seeing as the mortal folk up here keep dying off, and someone's got to bring their souls to your domain, now, don't they." },
			},
			HermesBackstory05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesGift05" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Know that saying {#DialogueItalicFormat}'don't be hasty'{#PreviousFormat}, boss? That comes from me. I swear! A little way to stave off competition, masquerading as the wisdom of a sage. Those stupid mortals will buy anything!" },
			},
			HermesBackstory06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory03", "HermesGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Not that I really know {#DialogueItalicFormat}exactly {#PreviousFormat}what you're up to, Coz, but! If I did, I don't think anybody on Olympus is aware of it. Or, if they are, they're keeping their mouths shut. The same as me!" },
			},
			HermesBackstory07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory02", "HermesGift04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You ever wonder how I got this fast, Coz? Lots of practicing, I'll tell you that! And being born unnaturally quick, I guess!" },
			},

			HermesAboutSkinnyLittleChap01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				-- these requirements are purely coincidental to the content of this event
				RequiredAnyTextLines = { "HermesAboutSecretService01", "SkellyBackstory03", "SkellyGift09", "HermesGift08" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Once took a skinny little chap down to the Underworld, got the business end of a sharp spear, he did! He had it coming, though, a lot of lying, cheating, and the like. Last that I heard, he's still making his amends down there. {#DialogueItalicFormat}Eh{#PreviousFormat}!" },
			},

			HermesAboutSkelly02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "SkellyAboutSources01", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0118",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Boss, I know you've heard a certain rumor from a very skinny individual who's uninclined to move. You best keep that one to yourself, all right? Or else our jig is up, and your father wouldn't like that, nor would you. So, cheers!" },
			},
			HermesAboutSkelly03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesAboutSkelly01", "HermesGift05", "SkellyGift09" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Say, you're in good with what's-his-name, the one who gave you his lucky tooth? So he's an all-right sort, then. Has to be, if you put up with him!" },
			},
			HermesAboutSecretService01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "SkellyAboutSources02" },
				RequiredFalseTextLinesLastRun = { "SkellyAboutSources02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So, now you've found me out, haven't you, Coz? Heard from the big boat-man himself. Well, good! We're pleased to be of service. And {#DialogueItalicFormat}we've {#PreviousFormat}got a lot of dirt on {#DialogueItalicFormat}you{#PreviousFormat}, so you be sure to keep our secrets, too. All right?" },
			},
			HermesAboutSecretService02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "Ending01", "HermesGift08", "CharonGift07" },
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B", "HermesAboutHourglass01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So my professional associate, the fearsome boatman on the River Styx? You got to know him pretty well in all of this, right, Coz? Hard getting through to him, I know, but his heart's in the right place! It's why I'm working with him, after all this time!" },
			},

			HermesAboutMegRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HermesGift03" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" }, Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard you've been seeing the Fury, Megaera, Coz? Got the impression she was quite a handful, though I guess the same can probably be said of you, there, huh? You two have fun!" },
			},

			HermesAboutCharonFight01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B", "HermesAboutHourglass01" },
				RequiredSeenRooms = { "CharonFight01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I can't believe you got into a fight with my professional associate, you daft or something, Coz? Just about everybody that I know, they're all at least a little bit afraid of that one and his boat, yet you think you can take him, huh?" },
			},
			HermesAboutCharonFight02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutCharonFight01", "BossCharonOutro01" },
				RequiredFalseTextLines = { "HermesBeatCharonQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So you took on my good professional associate, is that right, Coz? And you beat the big boatman himself! I knew that you were pretty tough, but not {#DialogueItalicFormat}that {#PreviousFormat}tough! Impressive work! He's impressed, too. He isn't even mad!" },
			},

			HermesBeatCharonQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutCharonFight01", "HermesGift03" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, uh, so I kind of placed a bet with the old boatman, my associate that is, that you could beat him in a fight, twice in a row! No pressure, or anything, but just in case you prove me right one of these days, I would appreciate it, Coz!" },
			},

			HermesMessage01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory03", "HermesSecondPickUp", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Message from Olympus for you, boss! It says, {#DialogueItalicFormat}'It sure is nice up here upon this mountain, not having to escape the Underworld! Come join us soon, won't you?'{#PreviousFormat}" },
			},
			HermesMessage02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				RequiresLastRunNotCleared = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Message for you, boss. It says, {#DialogueItalicFormat}'You're rather slow. If only somebody could help you out with that.' {#PreviousFormat}Huh, fancy that, what a coincidence!" },
			},

			HermesMessage03 =
			{
				Priority = true,
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinCompletedRuns = 20,
				RequiresLastRunNotCleared = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0075",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got you a message, Coz. Says here, {#DialogueItalicFormat}ahem{#PreviousFormat}: {#DialogueItalicFormat}'Hurry up and get out of there already.' {#PreviousFormat}It's from the surface of the earth, says so right here." },
			},
			HermesMessage04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Another message here! It says, {#DialogueItalicFormat}'One small spoon dried oregano, two spoons extra virgin olive oil, one large onion, minced, a dash of salt to taste,' {#PreviousFormat}wait, this isn't for you. Though you should try it sometime if you ever make it out!" },
			},

			HermesMessage05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredAnyTextLines = { "HermesGift07", "HermesGift07B" },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Message for you, Coz, it says, {#DialogueItalicFormat}'On behalf of all Olympus, we would like for you to know that was a right good bottle of Ambrosia that you offered to the god of travel, Hermes, who appreciated every drop.' {#PreviousFormat}Sincerely, me!" },
			},
			HermesMessage06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredAnyTextLines = { "HermesGift08", "HermesGift08B" },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Another message for you, Coz, this one says, {#DialogueItalicFormat}'Hey, mate! If you ever do make it up here up on this mountaintop for whatever reason, we should hang out, all right? I can show you around.' {#PreviousFormat} Your friend, Hermes." },
			},
			HermesMaxRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, boss, just between us? Out of all special delivery recipients I've had over the ages, here, I've got to say, you're the most interesting one!" },
			},

			HermesRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "HermesLootBought02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, Coz, all this time that I've been bussing souls across the borders of your father's land, it's good to have the chance to help somebody out the other way!" },
			},

			HermesSquelch01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "HermesBackstory05", "HermesMessage01", "HermesMessage02" },
				{ Cue = "/VO/Hermes_0078",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, Coz, you're now well accustomed to our little chats, but I want you to level with me here. You're the boss, if you prefer, I would be happy to shut up, no harm no foul. Just give the signal, hey?" },
				{
					Text = "Hermes_OfferText01",
					Choices =
					{
						{
							ChoiceText = "Squelch_KeepTalking",
							{ Cue = "/VO/ZagreusField_1951", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Perish the thought, Lord Hermes. It's been great hearing from you from time to time." },
							{ Cue = "/VO/Hermes_0079",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "Well, all right, boss. Just making sure that I'm not interrupting anything!" },
						},
						{
							ChoiceText = "Squelch_BeQuietAWhile",
							{ Cue = "/VO/ZagreusField_1952", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Now that you mention it, Lord Hermes, yes, let's keep our interactions nice and quick." },
							{ Cue = "/VO/Hermes_0080",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes",
								Text = "I hear you, boss, we'll cut straight to the chase next time, all right?" },
						},
					},
				},
			},
			HermesSquelch02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSquelch01Squelch_BeQuietAWhile" },
				{ Cue = "/VO/Hermes_0081",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahem{#PreviousFormat}! Pardon the interruption, boss. You let me know if you prefer that I pipe up again next time, more like I used to!" },
				{
					Text = "Hermes_OfferText02",
					Choices =
					{
						{
							ChoiceText = "Squelch_ResumeTalking",
							{ Cue = "/VO/ZagreusField_1953", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "I miss hearing from you, Hermes. Let's carry on like we did before." },
							{ Cue = "/VO/Hermes_0082",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}, sure thing, boss. It's good to have a chat from time to time!" },
						},
						{
							ChoiceText = "Squelch_KeepQuiet",
							{ Cue = "/VO/ZagreusField_1954", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Appreciate you checking in, Lord Hermes. I think we should keep at it like we have been, nice and quiet." },
							{ Cue = "/VO/Hermes_0083",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes",
								Text = "No problem whatsoever, boss. Just checking in." },
						},
					},
				},
			},
			-- if you squelched him variant
			HermesSquelch03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSquelch01Squelch_BeQuietAWhile" },
				RequiredFalseTextLines = { "HermesSquelch03B" },
				RequiredMinCompletedRuns = 80,
				{ Cue = "/VO/Hermes_0084",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Thought I'd check in again real quick, there, boss. You want my witty conversation next time, or straight to the Boons?" },
				{
					Text = "Hermes_OfferText03",
					Choices =
					{
						{
							ChoiceText = "Squelch_ResumeTalking",
							{ Cue = "/VO/ZagreusField_1955", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "You know, yes, let's go back to having witty conversation from you, Hermes. That sounds great." },
							{ Cue = "/VO/Hermes_0085",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}, good! I like these little chats! Take care, now, boss." },
						},
						{
							ChoiceText = "Squelch_KeepQuiet",
							{ Cue = "/VO/ZagreusField_1956", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Straight to the Boons, Lord Hermes. We both appreciate cutting straight to the chase." },
							{ Cue = "/VO/Hermes_0086",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes", PostLineFunctionArgs = { Permanent = true, },
								Text = "I get it, boss. Words are too slow, aren't they. Won't bother you again word-wise, but I'll be seeing you!" },
						},
					},
				},
			},
			-- if you did not squelch him
			HermesSquelch03B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSquelch01" },
				RequiredFalseTextLines = { "HermesSquelch03" },
				RequiredMinCompletedRuns = 80,
				{ Cue = "/VO/Hermes_0084",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Thought I'd check in again real quick, there, boss. You want my witty conversation next time, or straight to the Boons?" },
				{
					Text = "Hermes_OfferText01",
					Choices =
					{
						{
							ChoiceText = "Squelch_KeepTalking",
							{ Cue = "/VO/ZagreusField_2711", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Definitely witty conversation, Lord Hermes. The Boons are more than welcome after that." },
							{ Cue = "/VO/Hermes_0085",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Good, I like these little chats! Take care, now, boss." },
						},
						{
							ChoiceText = "Squelch_BeQuietAWhile",
							{ Cue = "/VO/ZagreusField_1956", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Straight to the Boons, Lord Hermes. We both appreciate cutting straight to the chase." },
							{ Cue = "/VO/Hermes_0086",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes",
								Text = "I get it, boss. Words are too slow, aren't they. Won't bother you again word-wise, but I'll be seeing you!" },
						},
					},
				},
			},

			HermesAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HadesAboutCharon01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Met your father face to face only the one time, Coz. Despite rendering services to him for quite a while. Memorable experience, I'll give it that! Seems like he's not done anything with all the messages my side keeps sending him." },
			},

			HermesAboutThanatos01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "ThanatosGift06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0076",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're pretty close with Thanatos, aren't you, boss? We don't often run in the same lanes, though our duties sometimes intersect a bit. Odd chap. Seems good at what he does, though!" },
			},
			HermesAboutThanatos02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutThanatos01", },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Saw Thanatos again lately, here, boss, and want to tell you, almost looked as though he cracked a smile when he mentioned you! Never seen anything like that with him!" },
			},

			HermesAboutOrpheus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OrpheusGift02", "HermesGift02" },
				RequiredMinNPCInteractions = { NPC_Orpheus_01 = 10 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I hear you're close with Orpheus down there, you get the chance, you tell him I said hey! He's pretty decent with that lyre of his, last time I checked." },
			},

			HermesAboutEurydice01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesGift03", "HermesAboutOrpheus01" },
				RequiredAnyTextLines = { "EurydiceAboutOrpheus01", "EurydiceAboutOrpheus01_B" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0224",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey boss, in all your travels there, you happen to run into a lass by name Eurydice? Hope she's all right! I feel bad because we didn't get a proper send-off last we met." },
			},
			HermesAboutEurydice02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "EurydiceAboutHermes01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I caught wind you found Eurydice down there, that's great! Long as she's on the up and up, I can eject her from the tiny worry center of my mind." },
			},

			HermesAboutHourglass01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredTrait = "ShopDurationTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "That's quite a nice Bone Hourglass you got, there, boss! So you're in good with my professional associate, as well. A real gentleman!" },
			},

			HermesAboutPlume01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredTrait = "FastClearDodgeBonusTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0114",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, look at you, there, boss! I recognize that fancy plume you got! Just an iota of my speediness in there, but still! Much more than most can do." },
			},

			HermesAboutWhippedFrenzy01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "EnemySpeedShrineUpgrade", Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0077",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoa, what's gotten into all those lifeless wretches that you're always fighting with down there? They're really moving lately! Whatever's made them go all out, it wasn't me!" },
			},
			HermesAboutEnemySpeedCondition01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredActiveMetaUpgrade = "EnemySpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got all your father's lifeless wretches hot and bothered, going all out all because of that {#DialogueItalicFormat}Forced Overtime {#PreviousFormat}condition of his, isn't that right, Coz? Well, if they're interested in getting things done quickly, I am sure you can oblige them in a bit!" },
			},
			HermesAboutEnemySpeedCondition02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy01", },
				RequiredMinActiveMetaUpgradeLevel = { Name = "EnemySpeedShrineUpgrade", Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Looks like those lifeless wretches you're contending with down there are {#DialogueItalicFormat}really {#PreviousFormat}on the move this time around, aren't they, boss? Oh, well, you're faster still, I'm sure!" },
			},

			HermesAboutBiomeSpeedCondition01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy01", },
				RequiredActiveMetaUpgrade = "BiomeSpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Somebody's on a tight deadline, I take it, Coz? Courtesy of your father's Pact, well, you believe me, I know how that is, so I won't keep you, just keep moving, right?" },
			},
			HermesAboutBiomeSpeedCondition02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy03", },
				RequiredActiveMetaUpgrade = "BiomeSpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I realize you're on a tight deadline, there, boss, so let's dispense with all unnecessary chit-chat here and get you on your merry way, posthaste!" },
			},
			HermesAboutBiomeSpeedCondition03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy01", },
				RequiredActiveMetaUpgrade = "BiomeSpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You racing against time to keep things interesting, or what, there, boss? Turns out that time goes pretty quick. I like racing against it, too!" },
			},

			-- speed running
			HermesAboutTimer01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredTrueConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0087",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hah! {#PreviousFormat}Can't help but notice you've been timing yourself, boss! Good habit that. Keep an eye on the time, you'll get faster and faster! Not as fast as me, mind." },
			},
			HermesAboutTimer02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer01", },
				RequiredTrueConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0088",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, Coz, since you're timing yourself, case you haven't noticed, doesn't count against you when we stop to have these chats! Insisted on that little rule myself." },
			},
			HermesAboutTimer03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer01", },
				RequiredFalseConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0089",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, you stopped timing yourself, boss, everything all right? If that's not a cry for help, well, I don't know what is. Um, here!" },
			},
			HermesAboutTimer04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer01", "HermesAboutTimer03" },
				RequiredTrueConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0090",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Good, boss, I can see you're clocking yourself once again. Little term I like to use, means beating yourself up whilst keeping time!" },
			},
			HermesAboutTimer05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer04", },
				RequiredFalseConfigOptions = { "ShowGameplayTimer", },
				{ Cue = "/VO/Hermes_0091",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Look, Coz, if you aren't always going to time yourself, that is a choice of lifestyle I have to respect. And learn to understand." },
			},

			-- run clears
			HermesFirstRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Another message from Olympus, boss. This goes, {#DialogueItalicFormat}'Zagreus, take absolutely all the time you need making your way to us; we know the going must be treacherous, and we assure you our support, however long it takes.' {#PreviousFormat}Well, how about that!" },
			},

			HermesRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiresLastRunCleared = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0109",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard you got through pretty quick last time! Not bad, not bad!" },
			},
			HermesRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiresLastRunCleared = true,
				RequiredMinRunsCleared = 3,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You'd think that once you break free to the surface we could see you from Olympus a bit more than usual, but no! It's like you're shrouded in eternal night up here, hm? Something like that. Odd, right?" },
			},

			HermesRunClearedNewRecord01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstRunCleared01", },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0110",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, you beat your fastest time fighting through all of that! Not that I'm keeping track! I'm keeping track." },
			},
			HermesRunClearedNewRecord02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord01" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0111",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey Coz, that last run-through that you did, I almost can't believe how quick you pulled that off! You're really pretty good!" },
			},
			HermesRunClearedNewRecord03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord02" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, you got out of there in practically no time at all before! Let's see if you can have another go like that!" },
			},
			HermesRunClearedNewRecord04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord03" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're getting faster, Coz, keep at it, just like that! Can always go a little faster than before is what I always say!" },
			},
			HermesRunClearedNewRecord05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord04" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, Coz, looks to me you beat your fastest time climbing up out of there! That's nicely done! Can you go faster still?" },
			},
			HermesRunClearedNewRecord06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord05" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What do you know, you beat your personal best time escaping recently! I hope my blessing helped a bit with that!" },
			},

			HermesRunClearStreak01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiresLastRunCleared = true,
				RequiredMinConsecutiveClears = 3,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0112",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well look at you, Coz! Rushing to victory after successive victory. Caught wind of your accomplishments down there! Well then, let's keep the streak alive!" },
			},
			HermesRunClearStreakBroken01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearStreak01", },
				RequiresLastRunNotCleared = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0113",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Heard the news you broke your streak of victories of late, boss. Happens, right? You seem the sort to bounce right back, though. Let me help with that!" },
			},

			HermesPostEnding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "Ending01", "HermesGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0232",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "So {#DialogueItalicFormat}you {#PreviousFormat}get to keep breaking out of there, time after time, so that {#DialogueItalicFormat}your father {#PreviousFormat}can keep finding ways to make it even harder to escape? Something like that? Sounds like an interesting assignment, Coz!" },
			},

			HermesPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0228",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Everybody on Olympus, they're still going on about Persephone, Queen of the Underworld! They had no idea she was down there all along, none whatsoever, Coz! And as for me, now I can deliver you my blessings more officially, I think!" },
			},
			HermesPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", "HermesGift03" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Even though everything's out in the open, now, and all my brothers, sisters, and whatnot are going to keep helping you fight your way out of there, I've still been keeping to myself, of late! That way nobody slows me down." },
			},
			HermesPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", "HermesGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0230",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Some members of the family up here, I know they haven't helped at all, but just don't take it personal or anything, all right? Think of it this way: You've got more of us getting along and talking properly than I have ever {#DialogueItalicFormat}seen{#PreviousFormat}!" },
			},

			HermesAboutPersephoneVisit01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0233",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your mother got from there just fine, don't worry, Coz! She had me looking after her, and such. Seemed real nice! Told me to tell you hi." },
			},
			HermesAboutPersephoneVisit02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, I never knew the pomegranate seeds down in the Underworld held such power if not for your mother mentioning it, Coz! And here I thought they were just tasty, that was it!" },
			},

			HermesAboutHearing01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredTextLines = { "HermesGift01" },
				RequiresLastRunNotCleared = true,
				RequiredFalseRooms = { "RoomOpening" },
				{ Cue = "/VO/Hermes_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Thought I'd check up on you, there, boss. You doing well, everything good and all? Can't hear you one iota, mind, so then, don't answer that!" },
			},

			HermesAboutHurrying01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredTextLines = { "HermesGift05" },
				RequiredFalseConfigOptions = { "ShowGameplayTimer", },
				RequiredInactiveMetaUpgrade = "BiomeSpeedShrineUpgrade",

				{ Cue = "/VO/Hermes_0205",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Come quickly, boss! You need to hurry up and get out of there, you're running out of time!! You're not, really, but it's a bit of motivation, hey?" },
			},

			-- legendary pickups
			HermesLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0099",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, you ready for this, boss? Got you the {#DialogueItalicFormat}Premium Express {#PreviousFormat}this time. Absolute cream of the crop right here! You're going to go real far." },
			},
			HermesLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0100",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Guess what, Coz? It's the {#DialogueItalicFormat}Premium Express{#PreviousFormat}, delivered straight to you, fresh from the richest mountaintop up here! You're going to like this." },
			},
			HermesLegendaryPickUp03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0101",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Express-delivered message for you, Coz. It says: 'Congratulations! You're my hundredth customer today.' And here is what you get!" },
			},

			-- low health
			HermesLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0092",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Eugh, I have to tell you, you look awful, Coz. You're barely holding on! Let's see if we can't perk you right back up." },
			},
			HermesLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0093",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whew{#PreviousFormat}! Looks like times hit you hard since last we had a run-in, Coz. Well, when life is tough, just hurry through the rubbish bits, I say!" },
			},
			HermesLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0094",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoa you're a hot mess, there, Coz, what happened getting here? Ah well, I hope your travels run a little smoother here on out." },
			},
			HermesLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's a fine line between being quick and being hasty, boss. And if you're hurt as bad as I think, I think you might be on the hasty side!" },
			},
			HermesLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, good news is you got to me, but I can tell you hit a lot of bad news on the way! You stay alive, all right?" },
			},
			HermesLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0221",
					Emote = "PortraitEmoteSurprise",					
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oof{#PreviousFormat}! What happened getting here, boss? Let me guess, you got whipped, burned, beat up with spectral clubs... something like that?" },
			},
			HermesLowHealth07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're looking worse for wear, I hate to tell you, boss. But, we can pick you up and get you going here, I think!" },
			},

		},

		PickupTextLineSets =
		{
			HermesFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/ZagreusField_1923", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.05 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "This mark, almost like a bat wing. In the name of Hades! Olympus! I accept this message." },
				{ Cue = "/VO/Hermes_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Hey boss, found you, good. Hermes, at your service. Pleasure! You are the talk of Olympus! Normally I wouldn't get mixed up, but for you, I will be making an exception. Now, come on, we both got places to be!" },
			},

			HermesMiscPickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, Coz, here's the goods, fresh from our mountaintop. Take all the time you need deciding! If you want to be a slowpoke." },
			},
			HermesMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Won't need but a moment of your time, here, boss! And you'll more than make up for it right quick, you got my guarantee!" },
			},
			HermesMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseBiome = "Tartarus",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, Coz, express delivery to {#DialogueItalicFormat}where{#PreviousFormat}-in-blazes are you at right now? Anyway take one of these, and go about your business!" },
			},
			HermesMiscPickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I know you're kind of in a hurry, boss. But let me show you what a {#DialogueItalicFormat}real {#PreviousFormat}hurry's all about in just a moment here!" },
			},
			HermesMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Package for you, boss! And I think you know what's inside. Well, maybe not exactly, but... just pick something, will you?" },
			},
			HermesMiscPickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Come on, Coz, you can do this! And furthermore, I think you can do this rather quick! Now go!" },
			},
			HermesMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It's you, boss, that's good! But you're standing still! That's bad. Let's get you up and moving about again, all right?" },
			},
			HermesMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, boss! Not much to report up here. But I've not exactly come this far to bring you news, have I?" },
			},
			HermesMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Afraid there's no one faster than myself, here, Coz. But good news is, {#DialogueItalicFormat}you {#PreviousFormat}are about to close the gap a little bit!" },
			},
			HermesMiscPickup10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slow day so far, there, boss? Well all of that's about to change, you got my guarantee!" },
			},
			HermesMiscPickup11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How 'bout we pick the pace up {#DialogueItalicFormat}just {#PreviousFormat}a little, Coz? Or maybe by a lot! Whatever you've the mood and stomach for right now." },
			},
			HermesMiscPickup12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Last thing I ever want to do is slow you down, boss. So, enough chit-chat. Now pick and go. {#DialogueItalicFormat}Go{#PreviousFormat}!" },
			},
			HermesMiscPickup13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've got a ways to go yet, boss. Good news is, the slowest part of this particular trip is hereby over... {#DialogueItalicFormat}now{#PreviousFormat}!" },
			},
			HermesMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All's well enough here on the surface, Coz. Though, sooner you can make it out of there, the better it'll be!" },
			},
			HermesMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Another go up to the surface, boss? Might suggest that you be very quick about it. And might give you this!" },
			},
			HermesMiscPickup16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's hustle, shall we, boss? Honestly, I don't know how the rest of you can stand it, trudging about like you don't have someplace to be!" },
			},
			HermesMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hiya, boss! I'd ask what's new, but I already know! I have my ways. And you have to get right on out of there." },
			},
			HermesMiscPickup18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Wish I could just fly in and haul you out of there, Coz, but there's some rules even I can't break. Though nice to see {#DialogueItalicFormat}you {#PreviousFormat}have a go of it!" },
			},
			HermesMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I come with urgent tidings, boss! Unfortunately not addressed to you. But someone got you these!" },
			},
			HermesMiscPickup20 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sorry, Coz, no messages this time. Guess that's what happens when your whole existence is kept secret from the world!" },
			},

			HermesMiscPickupExtra01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseRooms = { "RoomOpening" },
				RequiredTextLines = { "HermesFirstPickUp" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "There's not much new worth mentioning up here, though looks like {#DialogueItalicFormat}you {#PreviousFormat}have got your hands full down there, boss!" },
			},
			HermesMiscPickupExtra02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You've got a tough climb up ahead, Coz, so you just pace yourself, all right? Just kidding, go as quickly as you can. It works for me!" },
			},

			HermesMiscPickup21 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Come on, now, boss, let's get you moving here!" },
			},
			HermesMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got here in practically no time at all, boss. Ready now?" },
			},
			HermesMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey Coz, package for you here. Knock yourself out!" },
			},
			HermesMiscPickup24 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Got a customary care package for you, Coz." },
			},
			HermesMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, what's it going to be this time, boss?" },
			},
			HermesMiscPickup26 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Come on, Coz, let's pick up the pace a bit!" },
			},
			HermesMiscPickup27 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Go get yourself out of there in a hurry, Coz." },
			},
			HermesMiscPickup28 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No rush, but go on and pick one of these, boss." },
			},
			HermesMiscPickup29 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Message for you, Coz: It says {#DialogueItalicFormat}'Take one, it's free, enjoy!'{#PreviousFormat}" },
			},
			HermesMiscPickup30 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "What's going on, there, boss? Are things all right?" },
			},
			HermesMiscPickup31 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You want the usual, or what, there, boss?" },
			},
			HermesMiscPickup32 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Special delivery and all that, boss! Here, take your pick." },
			},
			HermesMiscPickup33 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey boss! You take one of these, and go for it." },
			},
			HermesMiscPickup34 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Just so happened to be in the area, here, boss!" },
			},
			HermesMiscPickup35 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Making sure you got this, Coz. You got this, Coz!" },
			},
			HermesMiscPickup36 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Here comes a little boost to get you up and out of there in no time, boss!" },
			},
			HermesMiscPickup37 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Now, don't just stand there, Coz, pick one of these and {#DialogueItalicFormat}go{#PreviousFormat}!" },
			},
			HermesMiscPickup38 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your quickness is my number one priority, here, boss." },
			},
			HermesMiscPickup39 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No time to waste and so on, Coz. Now, choose!" },
			},
			HermesMiscPickup40 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Caught wind you need my services here, boss?" },
			},
			HermesMiscPickup41 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Thought I'd check in, Coz. See how things are going. Slow, right? Not for long." },
			},
			HermesMiscPickup42 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ready to hustle? Good! I'll take that as a yes." },
			},
			HermesMiscPickup43 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Let's get you quickly on your way, there, Coz!" },
			},
			HermesMiscPickup44 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Message for you, boss. It says: {#DialogueItalicFormat}'Here, choose one of these, and go!'{#PreviousFormat}" },
			},
			HermesMiscPickup45 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Another message for you! This one says: {#DialogueItalicFormat}'Hey boss! Take this!'{#PreviousFormat}" },
			},
			HermesMiscPickup46 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Just thought I'd check up on you, boss, and bring you this!" },
			},
			HermesMiscPickup47 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hope you enjoyed the life of being slow, because all that's about to change, right here!" },
			},
			HermesMiscPickup48 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, boss, here, let's get you on your way!" },
			},
			HermesMiscPickup49 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Past time we got you out of there, right, boss?" },
			},
			HermesMiscPickup50 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Just thought I'd drop by, give you this, and go!" },
			},
			HermesMiscPickup51 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "We'll have you racing out of here in no time, Coz!" },
			},
			HermesMiscPickup52 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How goes it underground of late, there, boss?" },
			},
			HermesMiscPickup53 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nice day we're having on the surface! You should see it, boss!" },
			},
			HermesMiscPickup54 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredMinRunsCleared = 2,
				{ Cue = "/VO/Hermes_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Another day, another race up to the top! You ready, boss?" },
			},
			HermesMiscPickup55 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well, here we go again! Let's go, then, boss!" },
			},
		},

		BoughtTextLines =
		{
			HermesLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseTextLines = { "HermesLootBought01_B" },
				{ Cue = "/VO/Hermes_0095",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, hello, Coz! Odd that we're running into one another here! Among the wares of my professional associate, I mean. Must be some sort of clerical mistake!" },
			},
			HermesLootBought01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredFalseTextLines = { "HermesLootBought01", "HermesSecondPickUp" },
				{ Cue = "/VO/Hermes_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Why, hello, boss! Odd that we're running into one another here! Among the wares of my professional associate, I mean. Must be some sort of clerical mistake!" },
			},

			HermesLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B", "HermesAboutHourglass01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0096",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You're well familiar with my professional associate, there, with the boat? Souls of the recently departed got to make it over to the Underworld somehow. Part of my job! I bring them in, he takes them down." },
			},
			HermesLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought02" },
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0097",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I guess I'm used to these one-sided chats here, boss, thanks to my work experience with my professional associate down there! You tell him I said hi, all right?" },
			},
			HermesLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought02", "HermesLootBought03" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0098",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A word of caution, Coz. Don't ask too many questions about me, or my professional associate down there. I hand souls over to him, and that's it, you understand?" },
			},
			HermesLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Wouldn't you know it, boss! I was just minding my own business, handing off a few dearly departed souls to my professional associate, and who shows up, but {#DialogueItalicFormat}you{#PreviousFormat}?" },
			},
			HermesLootBought06 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My heavy-breathing professional associate was gracious enough to drop me off here with his other stuff, and for quite an affordable price, at that!" },
			},
			HermesLootBought07 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "All right, then, let's go make that spend of hard-earned coin well worth your while! What do you think, Coz?" },
			},
			HermesLootBought08 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I'd tell you not to ask too many questions of my good professional associate nearby, but then, {#DialogueItalicFormat}who are we kidding{#PreviousFormat}, boss? Not like he'd answer you those questions anyhow!" },
			},
			HermesLootBought09 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Message for you, boss, from my professional associate, who wanted you to know, and I quote, {#DialogueItalicFormat}'Hhhrrrrnnnngggggghhhhhh.'{#PreviousFormat}" },
			},
			HermesLootBought10 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Been working with my good professional associate, the boatman there, since I-don't-know-how-long. Though, let me tell you, Coz, we haven't had a job quite like this yet!" },
			},
			HermesLootBought11 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Among the many ways in which you could parlay your earnings into better chances of survival here, I'm flattered you would think of me this time!" },
			},
			HermesLootBought12 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "How strange of a coincidence that you keep running into me along the riverside like this, don't you agree, there, Coz?" },
			},
			HermesLootBought13 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.5,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Don't normally go selling off my blessings to the highest bidder, boss, but your bid there is good enough for me!" },
			},

		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			HermesGift01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "HermesGift01B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1933", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Hermes, please accept this gift as a small token of my appreciation. Thank you for always keeping me on my toes." },
				{ Cue = "/VO/Hermes_0106",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}! Mighty keen of you to leave a tip, there, boss. And I've a tip for you: Don't be slow! Maybe this will help with that." },
			},
			HermesGift01B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "HermesGift01" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1933", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Lord Hermes, please accept this gift as a small token of my appreciation. Thank you for always keeping me on my toes." },
			},

			HermesGift02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift01", "HermesGift01B" },
				RequiredFalseTextLines = { "HermesGift02B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1934", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Lord Hermes sir, you've asked for nothing in return, and so, please take this humble offering, because... it's nothing, really!" },
				{ Cue = "/VO/Hermes_0102",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Well now, that's awful kind, there, Coz! No need to thank me, though. Not so profusely anyhow!" },
			},
			HermesGift02B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift01", "HermesGift01B" },
				RequiredFalseTextLines = { "HermesGift02" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1934", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Lord Hermes sir, you've asked for nothing in return, and so, please take this humble offering, because... it's nothing, really!" },
			},

			HermesGift03 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift02", "HermesGift02B" },
				RequiredFalseTextLines = { "HermesGift03B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1935", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Hermes, my friend? May I call you my friend? I hope this modest offering will lift your spirits but won't slow you down." },
				{ Cue = "/VO/Hermes_0172",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I look like I got the sort of time to sip Nectar, Coz? Well, guess what, I do! So, cheers!" },
			},
			HermesGift03B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift02", "HermesGift02B" },
				RequiredFalseTextLines = { "HermesGift03" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1935", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hermes, my friend? May I call you my friend? I hope this modest offering will lift your spirits but won't slow you down." },
			},

			HermesGift04 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift03", "HermesGift03B" },
				RequiredFalseTextLines = { "HermesGift04B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1936", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Ever since we met, Lord Hermes, life here in the Underworld has been much faster-paced, and I am ever grateful. This is for you." },
				{ Cue = "/VO/Hermes_0104",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hey, boss, I appreciate the tip. But just as a reminder, all my services are paid in full already! No need for special thanks. Though... cheers." },
			},
			HermesGift04B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift03", "HermesGift03B" },
				RequiredFalseTextLines = { "HermesGift04" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1936", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ever since we met, Lord Hermes, life here in the Underworld has been much faster-paced, and I am ever grateful. This is for you." },
			},

			HermesGift05 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift04", "HermesGift04B" },
				RequiredFalseTextLines = { "HermesGift05B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1937", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I never could have come this far this quickly had it not been for your tireless support, Lord Hermes, sir. I'm in your debt." },
				{ Cue = "/VO/Hermes_0105",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, Coz, I got to say I had a few concerns when first we met, your father being who he is and all. But you're all right!" },
			},
			HermesGift05B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift04", "HermesGift04B" },
				RequiredFalseTextLines = { "HermesGift05" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1937", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "I never could have come this far this quickly had it not been for your tireless support, Lord Hermes, sir. I'm in your debt." },
			},

			HermesGift06 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift05", "HermesGift05B" },
				RequiredFalseTextLines = { "HermesGift06B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3873", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "This one's for you, swift and sure-footed messenger of the gods! You make what you do look easy. But I know you're going out of your way. Thank you so much, Hermes." },
				{ Cue = "/VO/Hermes_0173",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My rule is not to let things get too personal as far as work-related matters are concerned, Coz. But you're family! And, well, you're a right decent chap, I think. Offering up a bit of Nectar to me in the middle of all this!" },
			},
			HermesGift06B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift05", "HermesGift05B" },
				RequiredFalseTextLines = { "HermesGift06" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3873", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "This one's for you, swift and sure-footed messenger of the gods! You make what you do look easy. But I know you're going out of your way. Thank you so much, Hermes." },
			},

			HermesGift07 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift06", "HermesGift06B" },
				RequiredFalseTextLines = { "HermesGift07B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3874", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I salute you, Lord Hermes, with this rarest of delicacies! Pretty rare here, anyway. You never show it, but I can only imagine how hard you must be working to back me up. Cheers, mate!" },
				{ Cue = "/VO/Hermes_0174",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You know, the last time anybody offered me Ambrosia from the Underworld was {#DialogueItalicFormat}never{#PreviousFormat}, before now! That's quite a gesture on your part. You could have just as well taken my services for granted and I'd not have minded in the least! But, thank you, Coz." },
			},
			HermesGift07B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift06", "HermesGift06B" },
				RequiredFalseTextLines = { "HermesGift07" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3874", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "I salute you, Lord Hermes, with this rarest of delicacies! Pretty rare here, anyway. You never show it, but I can only imagine how hard you must be working to back me up. Cheers, mate!" },
			},

			HermesGift08 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift07", "HermesGift07B" },
				RequiredFalseTextLines = { "HermesGift08B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3875", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Message for you, Lord Hermes! It says, {#DialogueItalicFormat}'This offering is dedicated to the incomparable god of swiftness, from whom the news is always good, because he's bringing it. You are a real mate, you know that? I really owe you one.' {#PreviousFormat}Zagreus." },
				{ Cue = "/VO/Hermes_0175",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Hermes_01", Icon = "Keepsake_HermesSticker_Max" },
					Text = "Look, Coz, I am going to accept this choice Ambrosia from you one last time, all right? But from this point, I am doubling down on all professional responsibilities, here. Strictly business between us! Although, secretly, you're one of my best mates. Want you to know." },
			},
			HermesGift08B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift07", "HermesGift07B" },
				RequiredFalseTextLines = { "HermesGift08" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3875", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Hermes_01", Icon = "Keepsake_HermesSticker_Max" },
					Text = "Message for you, Lord Hermes! It says, {#DialogueItalicFormat}This offering is dedicated to the incomparable god of swiftness, from whom the news is always good, because he's bringing it. You are a real mate, you know that? I really owe you one. {#PreviousFormat}Zagreus." },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Lord Hermes, I am in your debt.
			{ Cue = "/VO/ZagreusField_1950" },
		},

		ShoutActivationSound = "/SFX/AthenaWrathHolyShield",
		ShoutVoiceLines =
		{
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "HermesUpgrade",

				-- The fury of Olympus!
				-- { Cue = "/VO/Athena_0065" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "HermesUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- I strongly disapprove.
				-- { Cue = "/VO/Athena_0103" },
			},
		},
	},

	-- Chaos / Primordial Chaos
	TrialUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		GodLoot = false,
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolChaos",
		BoonInfoIcon = "BoonInfoSymbolChaosIcon",
		DoorIcon = "BoonSymbolChaosIsometric",
		ConfirmSound = "/SFX/Menu Sounds/ChaosBoonConfirm",
		Color = { 100, 25, 255, 255 },
		LightingColor = { 100, 25, 255, 255 },
		LootColor = { 100, 25, 255, 255},
		SubtitleColor = {1.000, 0.973, 0.733, 1.0},
		EventEndSound = "/Leftovers/Menu Sounds/SkillUpgradeConfirm",
		UpgradeSelectedSound = "/SFX/ChaosBoonChoice",

		TransformingTraits = true,
		PermanentTraits = { "ChaosBlessingMeleeTrait", "ChaosBlessingRangedTrait", "ChaosBlessingAmmoTrait", "ChaosBlessingMaxHealthTrait", "ChaosBlessingBoonRarityTrait", "ChaosBlessingMoneyTrait", "ChaosBlessingMetapointTrait", "ChaosBlessingSecondaryTrait", "ChaosBlessingDashAttackTrait", "ChaosBlessingExtraChanceTrait", "ChaosBlessingBackstabTrait", "ChaosBlessingAlphaStrikeTrait", },
		TemporaryTraits = { "ChaosCurseNoMoneyTrait", "ChaosCurseAmmoUseDelayTrait", "ChaosCursePrimaryAttackTrait", "ChaosCurseSecondaryAttackTrait", "ChaosCurseCastAttackTrait", "ChaosCurseDeathWeaponTrait", "ChaosCurseHiddenRoomReward", "ChaosCurseDamageTrait", "ChaosCurseTrapDamageTrait", "ChaosCurseHealthTrait", "ChaosCurseMoveSpeedTrait", "ChaosCurseSpawnTrait", "ChaosCurseDashRangeTrait", },

		Speaker = "NPC_Chaos_01",
		Portrait = "Portrait_Chaos_Default_01",
		OverlayAnim = "ChaosOverlay",
		Gender = "X",
		SpawnSound = "/SFX/Menu Sounds/KeepsakeChaosEgg",
		FlavorTextIds =
		{
			"ChaosUpgrade_FlavorText01",
			"ChaosUpgrade_FlavorText02",
			"ChaosUpgrade_FlavorText03",
		},

		PickupFunctionName = "ChaosInteractPresentation",
		PickupGlobalVoiceLines = "ChaosBoonUsedVoiceLines",

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ChaosRevealsBeowulfAspect01", },
				Queue = "Always",

				-- I see you stand your ground against the serpent's flame...
				{ Cue = "/VO/ZagreusField_3579" },
			},
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ChaosSurfaceQuest01", },
				Queue = "Always",

				-- Um... yes? Was I supposed to respond there?
				{ Cue = "/VO/ZagreusField_3805" },
			},
			[3] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[4] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		SuperPriorityPickupTextLineSets =
		{
			ChaosAboutBeowulfAspect01_A =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosRevealsBeowulfAspect01" },
				RequiredFalseTextLines = { "ChaosAboutBeowulfAspect02" },
 				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_2648" },

				{ Cue = "/VO/Chaos_0316",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I sense that you have not yet spoken with the all-seeing artifact you call Aegis. Tamper with the Fates' design, then, all you like. But if you change your mind, do speak the words to it: {#DialogueItalicFormat}I see you stand your ground against the serpent's flame.{#PreviousFormat}" },
			},
			ChaosAboutBeowulfAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutBeowulfAspect01_A", "ChaosAboutShieldWeapon01" },
				RequiredFalseTextLines = { "ChaosAboutBeowulfAspect02" },
 				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0293",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "You have not yet used the waking-phrase that I imparted? Or perhaps you merely chose not to present me the result. I would quite like to see it, at some point. Remember, Son of Hades: Say to the all-seeing artifact, {#DialogueItalicFormat}I see you stand your ground against the serpent's flame.{#PreviousFormat}" },
			},
			ChaosAboutBeowulfAspect02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosRevealsBeowulfAspect01" },
 				RequiredTrait = "ShieldLoadAmmoTrait",

				{ Cue = "/VO/Chaos_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Out of the infinitely spanning possibilities, here before me stands the Son of Hades, bearing my all-seeing artifact, appearing in the aspect of a bearer yet unborn, who shall be known throughout the north as Beowulf. How very droll." },
			},

			ChaosSurfaceQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "LordHadesChaosSurfaceQuestDefeat01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0320",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I faintly sensed that you were able to confront your father while in possession of my small round catalyst. It seems my asking you, and your success, was in accordance with the Fates' design, as well. The result is more amusing even than expected. Thus, thank you." },
			},

			-- NyxChaosReunionQuest
			ChaosAboutNyx05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredFalseQueuedTextLines = { "NyxInChaos01" },
				RequiredFalseTextLines = { "NyxInChaos01" },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0283",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I have detected some unusual activity within the reaches of the Underworld, Son of Hades... vast sums of Darkness, collected in an ancient catalyst, which I see now almost like a beacon, shining in the night. This either is the work of Nyx, or you, or both. I am anticipating the result." },
			},

			-- NyxChaosReunionQuest Complete
			ChaosAboutNyx06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "NyxAboutChaos07" },
				{ Cue = "/VO/Chaos_0284",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					SetFlagFalse = "NyxChaosReunionInProgress",
					Text = "It pleases me immensely, Son of Hades, to have seen the goddess Nyx again. The significant amount of time that has elapsed since last this happened dulled sufficiently old pains, I think. Thus, it becomes a basis on which our connection may, in time, take shape again." },
			},

			ChaosAboutResponding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ChaosGift01", },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0168",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "As we become acquainted, Son of Hades, I shall make myself quite clear in one respect: I fear I have a lack of patience for discussion. When visiting, please merely listen, then accept my mark, and then depart. Respond only when necessary. Or when prompted. Yes?" },
				{ Cue = "/VO/ZagreusField_3458", Speaker = "CharProtag", Portrait = "Portrait_Zag_Defiant_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineWait = 0.4,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "...Merely listen, so it's just like when I get those messages from the Olympians. Wait, you did just prompt me, Master Chaos, didn't you? Or should I have remained silent just now?" },
				{ Cue = "/VO/Chaos_0169",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "I cannot offer you advice. But you were prompted, yes. You may speak freely, then, or anytime, despite my wishes that you not do so. Absolute silence is my general preference. It may not be yours." },
			},

			ChaosAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutResponding01", "ChaosGift01", "NyxAboutChaos01" },
				RequiredAnyTextLines = { "NyxPostFlashback01", "ZeusBackstory01", "AresAboutNyx01", "AthenaBackstory01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "ChaosAboutNyx01_B" },				
				{ Cue = "/VO/Chaos_0081",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "I understand that Zeus and all his kin on Mount Olympus think that you are born of Hades and the goddess Nyx? I was amused to learn of this deception. Nyx has mothered many of the Underworld's own, so, why not you?" },
				{ Cue = "/VO/ZagreusField_0541", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",					
					Text = "I believed this to be true myself most of my life. She isn't my birthmother, no, but she is like a mother to me. Do you know her?" },
				{ Cue = "/VO/Chaos_0082",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Oh, I know the goddess Nyx quite well, of course. Though, it has been a while since we last communicated, and I fear... well, I was not the charitable sort, back then. It is my hope that Nyx is faring well." },
			},

			ChaosPostEnding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "Ending01", "ChaosGift01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 20 },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0307",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Lately, Son of Hades, I have sensed what I would call a sort of shift within your father's residence. Did something noteworthy occur, perhaps? Respond." },
				{ Cue = "/VO/ZagreusField_4297", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Master Chaos, it's Persephone, my mother. She's returned! She's chosen to return. So... things feel different, certainly, with her around, although... I didn't feel any sort of shift." },
				{ Cue = "/VO/Chaos_0308",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "You may not sense these shifts as I. The lightness of this space bends and adjusts with time. What you describe... it must have been the cause. I trust that the occasion is a welcome one. And I am pleased that you returned, nevertheless." },
			},

			ChaosAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "ChaosPostEnding01", "PersephoneAboutOlympianReunionQuest03", "NyxAboutOlympianReunionQuest02" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0313",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Again I sensed some sort of shifting in your father's residence. You seek to ask something of me about it, do you not? Respond." },
				{ Cue = "/VO/ZagreusField_4299", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oh, I'm glad you asked, it's just... my mother, she's... we're reaching out to the Olympians. Trying to reconnect the family. It's been a while, relatively, since she and Father saw the others, but... in case a gathering occurs, I did wish you to know you're cordially invited, too." },
				{ Cue = "/VO/Chaos_0314",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					PreLineWait = 0.35,
					Text = "Cordially invited...? A generous proposal, Son of Hades, though unless your gathering is to occur within my space, please understand it would be difficult for me to bring the full entirety of my presence there. However... I think I can arrange to be with you in some capacity. Thank you." },
			},

			-- alt below
			ChaosPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutOlympianReunionQuest01", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "ChaosPostEpilogue01_B" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0315",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "It pleases me your gathering of the Olympians occurred. I must inform you... I had never once before detected quite so many of my offspring in a single space. At least not without violent intent. I appreciate that you included me, and that you have returned. Shall we continue, then?" },
			},
			ChaosPostEpilogue01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "ChaosAboutOlympianReunionQuest01", "ChaosPostEpilogue01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0335",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "It pleases me your gathering of the Olympians occurred. I must inform you... I had never once before detected quite so many of my offspring in a single space. At least not without violent intent." },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			ChaosAboutZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0072",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You bear the blessing of the great Lord Zeus. He still believes he holds dominion over both heaven and earth. I think, perhaps, he has forgotten about me." },
			},
			ChaosAboutPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0073",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Lord Poseidon offered you his blessing, it would seem. He can be rather boastful and belligerent, exhibiting the most unattractive manners of your father and Lord Zeus alike." },
			},
			ChaosAboutAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0074",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "This wise goddess Athena has imbued you with her charms, I see, O Son of Hades. Perhaps to her you are a tool with which her broken family may as yet be mended." },
			},
			ChaosAboutAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0075",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "It is not unexpected that you consorted with the violent Ares, and now bear his Boon. He still worships me, you know; yet, I would say he does not know me very well." },
			},
			ChaosAboutAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0077",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The charms of goddess Aphrodite are upon you unmistakably, although I shall be curious to see if her command over one's sense of love shall have any effect beneath the earth." },
			},
			ChaosAboutArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0076",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I understand the hunting-goddess Artemis recently has turned her gaze towards you. It is unexpected she would offer her assistance, even to a relative in need." },
			},
			ChaosAboutDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0078",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The drunkard Dionysus offered you his services, I see? He can be rather unpredictable, and therefore offers me a source of some amusement." },
			},
			ChaosAboutHermes01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "HermesUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0294",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Swift Hermes spurs you on, I see, O Son of Hades. Beware the narrow distance between hastiness and swiftness; a distinction I am not so sure the god of travel fully understands." },
			},
			ChaosAboutDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0295",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Embittered Demeter has reached you, hasn't she? She once was full of warmth, you know; but lately, as I understand, she is more prone to taking it away." },
			},

			-- backstory
			ChaosAboutOlympians01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "HermesFirstPickUp", "ChaosGift01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				{ Cue = "/VO/Chaos_0085",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You have met many of the Olympians by now, each spurring you toward their mountaintop. They place such value on familial bonds, yet none of them remember who I am. Do not place too much faith in them, O Son of Hades." },
			},
			ChaosAboutOlympians02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutOlympians01", "ChaosAboutResponding01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0170",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I ask you listen but not speak, O Son of Hades, whilst the Olympians? They do not ask at all. They merely send their messages to you, unprompted, providing a choice of blessing, but no say. I seek to understand their point of view. But it is difficult." },
			},
			ChaosAboutOlympians03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutOlympians01", },
				RequiredMinAnyTextLines = { TextLines = { "ZeusGift01", "PoseidonGift01", "AthenaGift01", "AphroditeGift01", "AresGift01", "ArtemisGift01", "DionysusGift01", "HermesGift01", "DemeterGift01" }, Count = 4 },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0171",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "When you extend an offering to the Olympians, for a fleeting instant, it appears as though they are able to hear your prayer. Or so I have observed. How interesting that your thoughts are capable of breaking free, yet you cannot." },
			},

			ChaosAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "ChaosGift02" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0086",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Your father and his brothers, when they sealed the Titans in the darkest reaches of this world, that was the last they saw of me, as well. You are dissimilar from them, and I feel safe communicating thus with you." },
			},

			ChaosAboutNyx01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				RequiredTextLines = { "NyxAboutChaos02", "NyxGrantsRespec", "ChaosAboutResponding01" },
				RequiredAccumulatedMetaPoints = 1000,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0277",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "I knew you would arrive. But only in the moments prior to the fact. Thus, I am experiencing residual surprise. Your movements through the Underworld are as though a veil of darkness enshrouds you. The goddess Nyx's influence, perhaps? Respond." },
				{ Cue = "/VO/ZagreusField_3400", Speaker = "CharProtag", Portrait = "Portrait_Zag_Defiant_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",					
					Text = "I... do not know how to respond to that, exactly, Master Chaos, but, Nyx, yes, she has been aiding me, in my attempts to flee my father's realm." },
				{ Cue = "/VO/Chaos_0278",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "You move in darkness, not as infinitely black as hers, but reminiscent to me, nonetheless. I would invite her to try to elude me, and then attempt to locate her. A minor amusement for the both of us. Now, I have you for this, I see." },
			},

			ChaosAboutNyx01_C =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutChaos03", "ChaosGift03" },
				{ Cue = "/VO/Chaos_0321",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I was at times uncharitable with the goddess Nyx, when we were closer, long ago. After she bore her first children, I nevertheless expected her attention to remain undivided. I kept creating. When finally I slowed, I realized my mistake. But our connection had been severed, by that point." },
			},

			ChaosAboutNyx02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutChaos04" },
				{ Cue = "/VO/Chaos_0083",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "I sense that something is the matter, Son of Hades. Speak, then, what is on your mind? I can decipher some of it without your telling though would rather hear it from you voluntarily." },
				{ Cue = "/VO/ZagreusField_0542", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Um, Master Chaos? The goddess Nyx, she... seems to want to speak with you again, I wonder, would you maybe contact her sometime? She seems convinced it is your move to make if you so choose." },
				{ Cue = "/VO/Chaos_0279",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "The goddess Nyx wishes to hear from me...? Now that is unexpected, Son of Hades, and I wonder if, perhaps, this is a jest of yours. Though, your intentions evidently are sincere. Then, I shall make no promises in this, except that... I am considering the possibility." },
			},
			ChaosAboutNyx03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutNyx02", "ChaosGift03" },
				RequiredFalseTextLinesLastRun = { "ChaosAboutNyx02" },
				{ Cue = "/VO/Chaos_0280",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Son of Hades, should eventually you spawn your own offspring... I recommend maintaining sub-infinite distances with them in space and time. Even if they are most tiresome, there always seems to come a point when one wishes to be in their presence once again." },
			},

			-- NyxChaosReunionQuest
			ChaosAboutNyx04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				RequiredTextLines = { "NyxAboutChaos05", "ChaosGift06" },
				{ Cue = "/VO/Chaos_0281",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "After some consideration, and on your recommendation, I attempted lately to make contact with the goddess Nyx again. She is quite distant from me now, of course. If you happen to know... did she receive the message well? Respond." },
				{ Cue = "/VO/ZagreusField_3401", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Well, Master Chaos, she can be a little difficult to read at times, but... I got the impression she was quite surprised, even excited to have heard from you again. She said that she would think about how to respond. Or, whether to respond." },
				{ Cue = "/VO/Chaos_0282",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "I see. Well, she shall find a way, if it is warranted. I always did expect the world from her. There were times when I expected her to shine as bright as day, though she is Night. When she achieved a certain level of ability... she left. And I could not find her." },
			},

			-- NyxChaosReunionQuest Post-Quest
			ChaosPostReunionQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "ChaosAboutNyx06", "ChaosGift07" },
				MinRunsSinceAnyTextLines = { TextLines = { "ChaosAboutNyx06" }, Count = 2 },
				{ Cue = "/VO/Chaos_0322",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "My daughter, the goddess Nyx. When I learned the Olympians mistakenly assumed she was your mother, I did not fully consider the possibility that she essentially was a mother to you... the technicality of birth, aside. She cares for you to the extent a mother can." },
			},
			ChaosPostReunionQuest02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "ChaosPostReunionQuest01" },
				MinRunsSinceAnyTextLines = { TextLines = { "ChaosPostReunionQuest01",  }, Count = 3 },
				{ Cue = "/VO/Chaos_0323",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Prior to your intervention, Son of Hades, I expected that the goddess Nyx had forgotten about me... whether purposefully, or from passage of time. I believed that to be forgotten was the one true inevitability. Perhaps, however, I was incorrect." },
			},
			ChaosPostReunionQuest03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "ChaosPostReunionQuest02", "ChaosGift08" },
				MinRunsSinceAnyTextLines = { TextLines = { "ChaosPostReunionQuest02" }, Count = 3 },
				{ Cue = "/VO/Chaos_0324",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I find that it is difficult maintaining my connection with many consciousnesses, such as yours, and that of the goddess Nyx. Yet I am also finding that this difficulty is fully warranted. Our connections give me much to consider as I await our next exchange." },
			},

			-- relationship improved
			ChaosStatusImproved01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ChaosGift07" },
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0070",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Ah, here is my favorite among those immortals dwelling underneath the Earth. How may I change your life today, O Son of Hades?" },
			},
			ChaosStatusImproved02 =
			{
				RequiredTextLines = { "ChaosGift04" },
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0071",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "May you enjoy a moment's peace within my space before venturing on in uncertainty. To my surprise, I must admit I do appreciate the company." },
			},

			ChaosPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMinRunsCleared = 1,
				RequiredTextLines = { "ChaosFirstPickUp", "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "ArtemisFirstPickUp", "AphroditeFirstPickUp", "DionysusFirstPickUp", "AresFirstPickUp", "ChaosAboutResponding01" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0079",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Have you grown trusting yet of the Olympians, for all their generosity? Perhaps you ought to let them know the truth about your journey's goal. They are vain, and think that it is them you seek." },
				{ Cue = "/VO/ZagreusField_0540", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "I'll never get out of here if not for their help, but... I can't let them know about Mother. She wants to remain hidden from them." },
				{ Cue = "/VO/Chaos_0080",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "A difficult position to be in, Son of Hades. The Olympians may not appreciate being misled. But you can trust that I shall keep your secret. I wish to see how your predicament plays out." },
			},

			ChaosDarknessProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredAccumulatedMetaPoints = 10000,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0298",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Such darkness emanates from you, O Son of Hades, that I once again did not entirely anticipate you would arrive just now. I suspect even your father must have difficulty keeping track of you through the domain he calls his own." },
			},
			ChaosDarknessProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredAccumulatedMetaPoints = 600,
				{ Cue = "/VO/Chaos_0325",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You move in darkness, practically unseen, Son of Hades. It is quite difficult even for me to sense your presence at times. The Olympians catch their glimpses now and then. But you are always in a shroud. Thus is the influence of Nyx." },
			},

			-- high affinity
			ChaosAboutFates01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosGift07" },
				{ Cue = "/VO/Chaos_0299",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "How strange it is to be subjected to the Fates. But do not fall into the cognitive delusion that they have already made your choices for you, Son of Hades. Rather, they are keen about anticipating every choice that everyone shall make. Such as the following." },
			},
			ChaosAboutInfinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosGift08", "ChaosAboutResponding01" },
				{ Cue = "/VO/Chaos_0296",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "I sense your consternation, Son of Hades, as you look about this space; you have another question, and are free to ask." },
				{ Cue = "/VO/ZagreusField_3402", Speaker = "CharProtag", Portrait = "Portrait_Zag_Empathetic_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oh, it's just... I sometimes wonder, Master Chaos... if you created all of this, then... who created {#DialogueItalicFormat}you{#PreviousFormat}? What was this place before you arrived?" },
				{ Cue = "/VO/Chaos_0297",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "All of this simply came to be, and so did I, presumably after a former time had finally reached its end. I hesitate to say it was an act of will. It was more like a sudden shift, as when a conflagration happens from a spark. I arrived at such a time, and all else then arrived, from me." },
			},
			ChaosAboutDeath01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutInfinity01" },
				RequiredFalseTextLinesLastRun = { "ChaosAboutInfinity01" },
				{ Cue = "/VO/Chaos_0300",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "When you expire, and then suddenly return to life within your father's residence, perhaps it is akin to when I first gained consciousness so long ago. Perhaps I, too, had just expired, only to reawaken." },
			},
			ChaosAboutDiscovery01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosGift07", "NyxGift07" },
				{ Cue = "/VO/Chaos_0301",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You may have wondered, Son of Hades, how it is you came to find me in this space, when I have gone unseen by most for quite some time. I have wondered this, as well, and think that our connection to Goddess Nyx is the most likely answer." },
			},

			-- alt below (if you met persephone already)
			ChaosAboutPersephone01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutResponding01", "ChaosGift01" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "ChaosAboutPersephone01_B", "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0302",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Son of Hades, I believe I have deduced something I ought have sooner recognized. Your mother must have been one who called herself Persephone. Her stay within the Underworld was brief, from my perspective, but impactful, nonetheless. You seek her now? Respond." },
				{ Cue = "/VO/ZagreusField_3403", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "I do. She's somewhere on the surface. That's why I keep on finding you like this. I'm trying to find her." },
				{ Cue = "/VO/Chaos_0303",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "I hope that your attempts achieve success. She is beyond my senses, presently, though of course I am still able to assist you in your journey, thus." },
			},
			ChaosAboutPersephone01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutResponding01", "ChaosGift01", "PersephoneFirstMeeting" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },				
				RequiredFalseTextLines = { "Ending01", "ChaosAboutPersephone01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0302",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Son of Hades, I believe I have deduced something I ought have sooner recognized. Your mother must have been one who called herself Persephone. Her stay within the Underworld was brief, from my perspective, but impactful, nonetheless. You seek her now? Respond." },
				{ Cue = "/VO/ZagreusField_4296", Speaker = "CharProtag", Portrait = "Portrait_Zag_Empathetic_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oh, Master Chaos... you should know I have located her, already. Though where she is, I cannot stay for long. So I am visiting, as often as I can. It's... not unlike our visits here. Only, somehow, even harder to get to where she is." },
				{ Cue = "/VO/Chaos_0306",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "I see. Then, it is good to know that you have been in contact. And I trust that your successive visits shall be worth their while. Not unlike our visits here." },
			},

			ChaosAboutPersephone02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutPersephone01", "ChaosGift05", },
				RequiredFalseTextLines = { "PersephoneFirstMeeting", "ChaosAboutPersephone01_B" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0304",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Son of Hades, if you locate the one who called herself Persephone, shall it then come to pass that we no longer see each other in this way? Respond." },
				{ Cue = "/VO/ZagreusField_3404", Speaker = "CharProtag", Portrait = "Portrait_Zag_Empathetic_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oh! I... Master Chaos, I don't know what to expect from there. But, to be direct with you, if I could leave the Underworld forever... I think I would. Though, I would miss you. Many others here." },
				{ Cue = "/VO/Chaos_0305",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" }, PreLineWait = 0.5,
					Text = "...I would miss you as well. Thank you for telling me." },
			},

			ChaosPostEnding02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosPostEnding01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },			
				{ Cue = "/VO/Chaos_0309",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Tell me something, Son of Hades. If the one who called herself Persephone is back, then... why do you continue to return? Respond." },
				{ Cue = "/VO/ZagreusField_4298", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Master Chaos, it seems I've developed something of a talent around breaking out of here. Or, there, I mean, the Underworld, so... it's become more of an official role for me, I guess. If escape shouldn't be possible, then someone needs to find the gaps." },
				{ Cue = "/VO/Chaos_0310",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					PreLineWait = 0.35,
					Text = "Indeed. Then, you shall visit with me still, despite accomplishing the principal object of your journey back when first we met. Good." },
			},

			ChaosAboutFishing01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredCosmetics = { "FishingUnlockItem" },
				RequiredAnyCaughtFishTypes = { "Fish_Chaos_Common_01", "Fish_Chaos_Rare_01", "Fish_Chaos_Legendary_01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0176",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I am impressed that you were able to procure a specimen out from the flowing currents here in my domain, with nothing but a simple instrument. I shall look forward to your subsequent attempts." },
			},
			ChaosAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ChaosBoonTrait",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0292",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I trust the small round catalyst which I provided you has been of value, Son of Hades? It is my hope it makes your journeys to this space less difficult, perhaps inducing them on a more frequent interval." },
			},
			ChaosAboutBlackShawl01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredTrait = "BackstabAlphaStrikeTrait",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0291",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You have arrived within a certain shroud of darkness, Son of Hades. The goddess Nyx's ancient shawl. I had not sensed its void in a considerable amount of time." },
			},

			ChaosAboutStyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredRoomLastRun = "D_Intro",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0317",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You have traveled recently beyond my senses, Son of Hades. I persist here only in the fathomless depths. I know what lies out there, having created it. But I know nothing of what it is like, right now. Do not tell me. I prefer to think of all the possibilities." },
			},
			ChaosSurfaceQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutStyx01", "ChaosGift06", "LordHadesDefeated02" },
				RequiredRoomLastRun = "D_Intro",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				RequiredMinRunsCleared = 2,

				{ Cue = "/VO/Chaos_0318",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "From the rumblings of the earth, I have deduced your father, himself, stands against you when at last you are about to leave these depths. It must be quite an interaction between you. Have I deduced correctly? Respond." },
				{ Cue = "/VO/ZagreusField_3804", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "That's right, Master Chaos. My father personally takes it upon himself to stop me in the event none of his underlings beat him to it. He... can be a handful." },
				{ Cue = "/VO/Chaos_0319",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Well, then. Consider bringing to one of your future interactions the small round catalyst, which I provided you. The one in the shape you call an egg? It shall serve no purpose there at all. Yet if you succeed, then it shall bring us some amusement, shall it not?" },
			},
			-- low health
			ChaosLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0103",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It seems to me that you are very close to death, O Son of Hades, and yet you deigned to visit me within my space. I could hasten your demise, if you so choose?" },
			},
			ChaosLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0104",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I almost did not notice you, O Son of Hades, for you are closer now to death than life. Perhaps, though, we can stave off the inevitable for a little while." },
			},
			ChaosLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your deaths are but a temporary setback, Son of Hades. Though it appears to me you are quite close to having such a setback, now." },
			},
			ChaosLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Your next experience with death seems to be imminent, though let us see if I can hasten or forestall it." },
			},
			ChaosLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "ChaosGift03" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "It may seem cruel that I would wish you death, O Son of Hades. But from my perspective, it means you are much more likely to return to me." },
			},
			ChaosLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Although you may succumb soon to your injuries, please make the most of your remaining life, rather than anticipate the next. The future is uncertain to all save the Fates." },
			},

			-- weapons & weapon enchantments
			ChaosAboutShieldWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredFalseTextLines = { "ChaosAboutWeaponEnchantments01", "ChaosAboutShieldWeapon01" },
				RequiredWeapon = "ShieldWeapon",
 				RequiredFalseTraits = { "ShieldRushBonusProjectileTrait", "ShieldTwoShieldTrait", },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0172",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You come to my domain bearing an all-seeing artifact that sprang from me after the dawn of time. It is considered a defensive instrument, I do believe. Though, I suspect you have discovered, or soon shall discover, it is nothing of the sort." },
			},
			ChaosAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", },
				RequiredTrait = "ShieldRushBonusProjectileTrait",
				RequiredWeapon = "ShieldWeapon",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0173",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "I expected your arrival, Son of Hades. For I am able to see through you. Rather, through the all-seeing artifact, which sprang from me after the dawn of time, and now resembles, in your hands, its foremost form. Respond." },
				{ Cue = "/VO/ZagreusField_2692", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "What, you must mean the Shield of Chaos, here? {#DialogueItalicFormat}Your {#PreviousFormat}shield, Master Chaos, I should say. It's a remarkable artifact. Imposing, too! Your original creations must have been astounding." },
				{ Cue = "/VO/Chaos_0174",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Your response is acceptable. And I am grateful to have had my recent firsthand glimpses of this vast domain." },
			},
			ChaosAboutZeusAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", },
				RequiredTrait = "ShieldTwoShieldTrait",
				RequiredWeapon = "ShieldWeapon",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0175",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Ah, you have that all-seeing artifact of mine, but in the old guise that the great Lord Zeus once used when he retaliated violently against his parentage. I watched his movements through it for some time." },
			},
			ChaosRevealsBeowulfAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "AchillesRevealsGuanYuAspect01" },
				RequiredAnyTextLines = { "ChaosAboutShieldWeapon01", "ChaosAboutZeusAspect01", "ChaosAboutWeaponEnchantments01", },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "ShieldWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0177",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "I bear a message for you, Son of Hades. One recorded in an age when certain concepts it describes did not yet all exist. Remember this: {#DialogueItalicFormat}I see you stand your ground against the serpent's flame. {#PreviousFormat}A waking-phrase, to which you and the all-seeing artifact of my creation may respond." },
				{ Cue = "/VO/ZagreusField_3394", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "A waking-phrase... and an all-seeing artifact, you must mean Aegis, right? So I'm to say to it, {#DialogueItalicFormat}I see you stand your ground against the serpent's flame{#PreviousFormat}, and it'll wake right up. Though, can you tell me what it means, or who?" },
				{ Cue = "/VO/Chaos_0178",
					SecretMusicActiveStems = { "ChaosBass" },
					UseEventEndSound = true,
					Text = "Oh, I can tell you almost anything. However, I would much prefer it if you learned most of the answers you seek by yourself." },
			},

		},

		PickupTextLineSets =
		{
			ChaosFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/ZagreusField_1069", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.9 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "ChaosInteractPresentation",
					Text = "This... is not someone I recognize, so, in the name of Hades! Um, hello? May I ask who's calling? " },
				{ Cue = "/VO/Chaos_0048", Speaker = "MysteryUpgrade", SpeakerLabelOffsetY = 18,
					SecretMusicActiveStems = { "ChaosBass" },
					PortraitExitWait = 1.25,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0 },
					PreContentSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "...The Olympians have all grown soft... would you not agree?" },
				{ Cue = "/VO/ZagreusField_0145", Speaker = "CharProtag", Portrait = "Portrait_Zag_Defiant_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}... have we met?" },
				{ Cue = "/VO/Chaos_0049",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Oh, we have met, in a way. I know everybody, here, and there. You wish to leave this place? Then, it is my wish to make your doing so a little bit more interesting... and, if you encounter the Olympians someday, do give them my regards." },
			},
			ChaosMiscPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0050",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I sensed a certain rumbling here within the bowels of the earth. It is as though it had ingested something that did not sit well... perhaps the earth itself wishes to spit you up and out...?" },
			},
			ChaosMiscPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup01" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0051",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The Olympians are vying for your favor, are they not? So often they forget themselves. They force their blessings onto you, whilst I? I merely offer you a choice." },
			},
			ChaosMiscPickup03 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup02" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0052",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Your path is yours to shape as you see fit, regardless of the Fates' design. Together we may twist that path a bit, if you would like." },
			},
			ChaosMiscPickup04 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0053",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I both expected you to come and am surprised to see you, Son of Hades. Where shall your journey take you from this point?" },
			},
			ChaosMiscPickup05 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0054",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Please tell me how my power over all existence may be of small assistance to you this time, Son of Hades?" },
			},
			ChaosMiscPickup06 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0055",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The tremors underneath the earth foretold of your arrival at this very moment, Son of Hades; and, I have anticipated it." },
			},
			ChaosMiscPickup07 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0056",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You chose to visit me again within these darkest reaches of the earth, as I, in turn, now choose to offer you the means to alter your reality." },
			},
			ChaosMiscPickup08 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0057",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Back when I conceived the world and the immortals, Son of Hades, I did not expect you would be standing here before me now." },
			},
			ChaosMiscPickup09 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0058",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You have arrived at last, just as I wondered how we might best alter one another's courses of existence here today." },
			},
			ChaosMiscPickup10 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0059",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Son of Hades, let me welcome your return here to my space within the Underworld, and bid you choose an alteration to the fabric of reality." },
			},
			ChaosMiscPickup11 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0060",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "It pleases me that you are here again; for, through you I can tinker with reality, along the fringes that are not yet fully formed." },
			},
			ChaosMiscPickup12 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0061",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Your presence never ceases to intrigue me, Son of Hades; for you are not like the Olympians on high, who have forgotten me, or thusly choose to act." },
			},
			ChaosMiscPickup13 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0062",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "From my perspective I have summoned you, whilst you believe you came of your volition; both statements can be true, is that not so?" },
			},
			ChaosMiscPickup14 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0063",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Come forth, O Son of Hades, and together, let us sow my namesake through the depths of what your father thinks his own domain." },
			},
			ChaosMiscPickup15 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0064",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "How fares these days the never-ending cycle of rebirth and death for you, O Son of Hades? Sufficiently amusing, I should hope?" },
			},
			ChaosMiscPickup16 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0065",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Out of the infinitely spanning possibilities before us, Son of Hades, I have arbitrarily selected only three again from which to let you choose." },
			},
			ChaosMiscPickup17 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0066",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The Fates have much in store for you, O Son of Hades. Perhaps, however, we can tamper with their weavings here to some extent." },
			},
			ChaosMiscPickup18 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0067",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Let us conspire to expand and frustrate your lord father's sense of both what is and is not possible within his Underworld." },
			},
			ChaosMiscPickup19 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0068",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Infinite possibilities can be tedious to choose from, so, let me provide you with a significantly smaller set with which you may yet change the Fates' designs." },
			},
			ChaosMiscPickup20 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0069",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Through the expanse of time, I often wondered, is it necessary to be fair? The immortals are my offspring; surely I should treat them equally. And yet I find that there is little sport in doing so." },
			},

			ChaosMiscPickupExtra01 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0154",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Among infinite possibilities, consider only these." },
			},
			ChaosMiscPickupExtra02 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0155",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Choose carefully, in general, and now." },
			},
			ChaosMiscPickupExtra03 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				{ Cue = "/VO/Chaos_0156",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "We are the sum of all decisions that we make, and that are made for us." },
			},
			ChaosMiscPickupExtra04 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0157",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "This space grows far more interesting when you occupy a small amount of it." },
			},
			ChaosMiscPickupExtra05 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0158",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "How you evaluate decisions is of limitless interest to me." },
			},
			ChaosMiscPickupExtra06 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0159",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The burden of the passing time shall force a choice from you." },
			},
			ChaosMiscPickupExtra07 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0160",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Is there not pleasure in determining an outcome, Son of Hades?" },
			},
			ChaosMiscPickupExtra08 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0161",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "My mark be with you, Son of Hades. You need merely choose its shape." },
			},
			ChaosMiscPickupExtra09 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0162",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Though the waters of the Styx may wash away my mark, I can restore it." },
			},
			ChaosMiscPickupExtra10 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0163",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "The rhythm of your visits here over the course of time is pleasant, Son of Hades." },
			},
			ChaosMiscPickupExtra11 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0164",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "You are already back, and you are always welcome, Son of Hades." },
			},
			ChaosMiscPickupExtra12 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ChaosGift05" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0165",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Please visit me as frequently as you would like or dare." },
			},
			ChaosMiscPickupExtra13 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ChaosGift06" },
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0166",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I find myself anticipating your arrivals, Son of Hades." },
			},
			ChaosMiscPickupExtra14 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0167",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I require no exchange of words with you. Merely a choice." },
			},

			ChaosMiscPickup21 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				AreIdsNotAlive = GameData.NyxInChaosIds,
				{ Cue = "/VO/Chaos_0002",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Once more you have returned to my domain." },
			},
			ChaosMiscPickup22 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = Game