/*
 * Decompiled with CFR 0.152.
 */
package com.xortroll.ulaunch.uscreen.ui;

import com.xortroll.ulaunch.uscreen.ui.MainController;
import com.xortroll.ulaunch.uscreen.usb.UsbInterface;
import com.xortroll.ulaunch.uscreen.usb.UsbMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.Properties;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class MainApplication
extends Application {
    private MainController controller;
    private Scene scene;
    private UsbInterface usb_intf = null;
    private Object dialog_wait_lock = new Object();
    private boolean is_dialog_finished = false;

    private void die() {
        if (this.usb_intf != null) {
            this.usb_intf.finalize();
        }
        Platform.exit();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOkDialogFromTask(String subtitle, String message, boolean terminate) {
        this.is_dialog_finished = false;
        Platform.runLater(() -> {
            Dialog dialog = new Dialog();
            dialog.setTitle("uScreen - " + subtitle);
            dialog.setContentText(message);
            ButtonType type = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
            dialog.getDialogPane().getButtonTypes().add(type);
            dialog.showAndWait();
            if (terminate) {
                this.die();
            }
            Object object = this.dialog_wait_lock;
            synchronized (object) {
                this.is_dialog_finished = true;
            }
        });
        while (true) {
            Object object = this.dialog_wait_lock;
            synchronized (object) {
                if (this.is_dialog_finished) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbInterface showUsbFailReconnectDialogFromTask(String message, boolean initial_start_silent) {
        boolean skip_dialog = initial_start_silent;
        String show_message = message;
        while (true) {
            if (!skip_dialog) {
                this.is_dialog_finished = false;
                String dialog_msg = show_message;
                Platform.runLater(() -> {
                    Dialog dialog = new Dialog();
                    dialog.setTitle("uScreen - USB connection");
                    dialog.setContentText(dialog_msg);
                    dialog.getDialogPane().getButtonTypes().add(new ButtonType("Reconnect", ButtonBar.ButtonData.YES));
                    dialog.getDialogPane().getButtonTypes().add(new ButtonType("Exit", ButtonBar.ButtonData.NO));
                    dialog.showAndWait().ifPresent(ret_type -> {
                        if (ret_type.getButtonData() == ButtonBar.ButtonData.NO) {
                            this.die();
                        }
                    });
                    Object object = this.dialog_wait_lock;
                    synchronized (object) {
                        this.is_dialog_finished = true;
                    }
                });
                while (true) {
                    Object object = this.dialog_wait_lock;
                    synchronized (object) {
                        if (this.is_dialog_finished) {
                            break;
                        }
                    }
                }
            }
            skip_dialog = false;
            Optional<UsbInterface> maybe_intf = UsbInterface.createInterface(0);
            if (maybe_intf.isPresent()) {
                return maybe_intf.get();
            }
            show_message = "Unable to connect via USB";
        }
    }

    @Override
    public void start(Stage primaryStage) throws Exception {
        ClassLoader this_loader = this.getClass().getClassLoader();
        FXMLLoader loader = new FXMLLoader(this_loader.getResource("main.fxml"));
        Pane base = (Pane)loader.load();
        double width = base.getPrefWidth();
        double height = base.getPrefHeight();
        this.scene = new Scene(base, width, height);
        this.scene.getStylesheets().add(this_loader.getResource("main.css").toExternalForm());
        this.controller = (MainController)loader.getController();
        Properties main_props = new Properties();
        main_props.load(this_loader.getResourceAsStream("main.properties"));
        String version = main_props.getProperty("version");
        Stage stage = primaryStage;
        stage.getIcons().add(new Image(this_loader.getResource("icon.png").toExternalForm()));
        stage.setTitle("uScreen v" + version + " - uLaunch's USB screen utility");
        stage.setScene(this.scene);
        stage.setMinWidth(width);
        stage.setMinHeight(height);
        this.controller.prepare(stage);
        stage.show();
        Thread usb_thread = new Thread(){

            @Override
            public void run() {
                UsbInterface usb_intf = MainApplication.this.showUsbFailReconnectDialogFromTask("", true);
                ByteBuffer data = ByteBuffer.allocateDirect(3686408);
                data.order(ByteOrder.LITTLE_ENDIAN);
                while (true) {
                    data.rewind();
                    if (!usb_intf.readByteBuffer(data, data.limit())) {
                        System.out.println("Unable to read data");
                        continue;
                    }
                    int mode = data.getInt();
                    if (mode == UsbMode.RAW_RGBA) {
                        MainApplication.this.controller.updateScreenRgba(data);
                        continue;
                    }
                    if (mode == UsbMode.JPEG) {
                        int jpeg_size = data.getInt();
                        MainApplication.this.showOkDialogFromTask("Invalid mode", "JPEG mode is currently not supported (size: " + jpeg_size + ")", true);
                        continue;
                    }
                    System.out.println("Invalid mode: " + mode);
                }
            }
        };
        usb_thread.setDaemon(true);
        usb_thread.start();
    }

    public static void run(String[] args) {
        Application.launch(args);
    }
}

